/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.api.core.ApiFuture;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.projectmanagement.AndroidAppMetadata;
import com.google.firebase.projectmanagement.AndroidAppService;
import com.google.firebase.projectmanagement.FirebaseProjectManagementException;
import com.google.firebase.projectmanagement.ShaCertificate;
import java.util.List;

public class AndroidApp {
    private final AndroidAppService androidAppService;
    private final String appId;

    AndroidApp(String appId, AndroidAppService androidAppService) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)appId) ? 1 : 0) != 0, (Object)"app ID cannot be null or empty");
        this.appId = appId;
        this.androidAppService = androidAppService;
    }

    String getAppId() {
        return this.appId;
    }

    public AndroidAppMetadata getMetadata() throws Exception {
        return this.androidAppService.getAndroidApp(this.appId);
    }

    public ApiFuture<AndroidAppMetadata> getMetadataAsync() {
        return this.androidAppService.getAndroidAppAsync(this.appId);
    }

    public void setDisplayName(String newDisplayName) throws FirebaseProjectManagementException {
        this.androidAppService.setAndroidDisplayName(this.appId, newDisplayName);
    }

    public ApiFuture<Void> setDisplayNameAsync(String newDisplayName) {
        return this.androidAppService.setAndroidDisplayNameAsync(this.appId, newDisplayName);
    }

    public String getConfig() throws FirebaseProjectManagementException {
        return this.androidAppService.getAndroidConfig(this.appId);
    }

    public ApiFuture<String> getConfigAsync() {
        return this.androidAppService.getAndroidConfigAsync(this.appId);
    }

    public List<ShaCertificate> getShaCertificates() throws FirebaseProjectManagementException {
        return this.androidAppService.getShaCertificates(this.appId);
    }

    public ApiFuture<List<ShaCertificate>> getShaCertificatesAsync() {
        return this.androidAppService.getShaCertificatesAsync(this.appId);
    }

    public ShaCertificate createShaCertificate(ShaCertificate certificateToAdd) throws FirebaseProjectManagementException {
        return this.androidAppService.createShaCertificate(this.appId, certificateToAdd);
    }

    public ApiFuture<ShaCertificate> createShaCertificateAsync(ShaCertificate certificateToAdd) {
        return this.androidAppService.createShaCertificateAsync(this.appId, certificateToAdd);
    }

    public void deleteShaCertificate(ShaCertificate certificateToRemove) throws FirebaseProjectManagementException {
        this.androidAppService.deleteShaCertificate(certificateToRemove.getName());
    }

    public ApiFuture<Void> deleteShaCertificateAsync(ShaCertificate certificateToRemove) {
        return this.androidAppService.deleteShaCertificateAsync(certificateToRemove.getName());
    }
}

