/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class CriticalSound {
    private final Map<String, Object> fields;

    private CriticalSound(Builder builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        ImmutableMap.Builder fields = ImmutableMap.builder().put((Object)"name", (Object)builder.name);
        if (builder.critical) {
            fields.put((Object)"critical", (Object)1);
        }
        if (builder.volume != null) {
            Preconditions.checkArgument((builder.volume >= 0.0 && builder.volume <= 1.0 ? 1 : 0) != 0, (Object)"volume must be in the interval [0,1]");
            fields.put((Object)"volume", (Object)builder.volume);
        }
        this.fields = fields.build();
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean critical;
        private String name;
        private Double volume;

        private Builder() {
        }

        public Builder setCritical(boolean critical) {
            this.critical = critical;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVolume(double volume) {
            this.volume = volume;
            return this;
        }

        public CriticalSound build() {
            return new CriticalSound(this);
        }
    }
}

