/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.charts.ChartComponent;
import org.graalvm.visualvm.lib.charts.ChartConfigurationListener;
import org.graalvm.visualvm.lib.charts.ChartSelectionModel;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.options.TracerOptions;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.ScrollBar;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.Bundle;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.RowBackgroundDecorator;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.RowBoundsDecorator;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.RowForegroundDecorator;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineAxis;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineChart;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineSelectionOverlay;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.XChartSelectionOverlay;
import org.graalvm.visualvm.lib.ui.UIUtils;

final class ChartPanel
extends JPanel {
    private static final Icon ZOOM_IN_ICON = Icons.getIcon((String)"GeneralIcons.ZoomIn");
    private static final Icon ZOOM_OUT_ICON = Icons.getIcon((String)"GeneralIcons.ZoomOut");
    private static final Icon FIXED_SCALE_ICON = Icons.getIcon((String)"GeneralIcons.Zoom");
    private static final Icon SCALE_TO_FIT_ICON = Icons.getIcon((String)"GeneralIcons.ScaleToFit");
    private static final Icon ZMWHEEL_ICON = Icons.getIcon((String)"TracerIcons.MouseWheelZoom");
    private static final Icon HMWHEEL_ICON = Icons.getIcon((String)"TracerIcons.MouseWheelHorizontal");
    private static final Icon VMWHEEL_ICON = Icons.getIcon((String)"TracerIcons.MouseWheelVertical");
    private final TimelineChart chart;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ToggleViewAction toggleViewAction;
    private final JScrollBar hScrollBar;
    private final JScrollBar vScrollBar;
    private final MouseWheelListener defaultWheelHandler;
    private AbstractButton mouseZoom;
    private AbstractButton mouseHScroll;
    private AbstractButton mouseVScroll;

    ChartPanel(TimelineChart chart, TimelineSupport support) {
        this.chart = chart;
        boolean speed = Utils.forceSpeed();
        chart.setBackground(!UIUtils.isDarkResultsBackground() ? Color.WHITE : new Color(70, 70, 70));
        if (speed && TracerOptions.getInstance().isRowsSelectionEnabled()) {
            chart.addPreDecorator(new RowBackgroundDecorator(chart));
        }
        chart.addPreDecorator(new RowBoundsDecorator(chart));
        chart.addPostDecorator(new RowForegroundDecorator(chart, TracerOptions.getInstance().isRowsDecorationEnabled(), !speed && TracerOptions.getInstance().isRowsSelectionEnabled()));
        TimelineSelectionOverlay selectionOverlay = new TimelineSelectionOverlay();
        chart.addOverlayComponent(selectionOverlay);
        selectionOverlay.registerChart(support);
        XChartSelectionOverlay xOverlay = new XChartSelectionOverlay(support);
        xOverlay.setLineMode(false, false, false, false);
        chart.addOverlayComponent(xOverlay);
        xOverlay.registerChart((ChartComponent)chart);
        ChartSelectionModel selectionModel = chart.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.setHoverMode(102);
            selectionModel.setMoveMode(1);
            selectionModel.setDragMode(4);
        }
        TimelineAxis axis = new TimelineAxis(chart, support);
        this.hScrollBar = new ScrollBar(0);
        this.hScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ChartPanel.this.hScrollBar.getValueIsAdjusting()) {
                    ChartPanel.this.chart.updateSelection(false, ChartPanel.this.hScrollBar);
                } else {
                    ChartPanel.this.chart.updateSelection(true, ChartPanel.this.hScrollBar);
                }
            }
        });
        chart.attachHorizontalScrollBar(this.hScrollBar);
        this.vScrollBar = new ScrollBar(1){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = 1;
                return dim;
            }
        };
        this.vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ChartPanel.this.vScrollBar.getValueIsAdjusting()) {
                    ChartPanel.this.chart.updateSelection(false, ChartPanel.this.vScrollBar);
                } else {
                    ChartPanel.this.chart.updateSelection(true, ChartPanel.this.vScrollBar);
                }
            }
        });
        chart.attachVerticalScrollBar(this.vScrollBar);
        this.defaultWheelHandler = chart.getMouseWheelListeners()[0];
        chart.addConfigurationListener((ChartConfigurationListener)new VisibleBoundsListener());
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)axis, "North");
        this.add((Component)((Object)chart), "Center");
        this.add((Component)this.vScrollBar, "East");
        this.add((Component)this.hScrollBar, "South");
        this.resetChart();
    }

    void resetChart() {
        this.chart.setScale(0.02, 1.0);
        this.chart.setOffset(0L, 0L);
    }

    boolean resetSelection() {
        this.chart.getSelectionModel().setSelectionBounds(null);
        return false;
    }

    void updateActions() {
        if (this.zoomInAction != null) {
            this.zoomInAction.updateAction();
        }
        if (this.zoomOutAction != null) {
            this.zoomOutAction.updateAction();
        }
        if (this.toggleViewAction != null) {
            this.toggleViewAction.updateAction();
        }
    }

    Action zoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new ZoomInAction();
        }
        return this.zoomInAction;
    }

    Action zoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new ZoomOutAction();
        }
        return this.zoomOutAction;
    }

    Action toggleViewAction() {
        if (this.toggleViewAction == null) {
            this.toggleViewAction = new ToggleViewAction();
            if (TracerOptions.getInstance().getZoomMode().equals("scale to fit")) {
                this.toggleViewAction.actionPerformed(null);
            }
        }
        return this.toggleViewAction;
    }

    AbstractButton mouseZoom() {
        if (this.mouseZoom == null) {
            this.mouseZoom = new OneWayToggleButton(ZMWHEEL_ICON, Bundle.ACTION_WheelZooms_name()){

                @Override
                protected void performAction() {
                    ChartPanel.this.mouseZoomImpl();
                }
            };
            if (TracerOptions.getInstance().getMouseWheelAction().equals("zoom")) {
                this.mouseZoom.setSelected(true);
                this.mouseZoomImpl();
            }
        }
        return this.mouseZoom;
    }

    AbstractButton mouseHScroll() {
        if (this.mouseHScroll == null) {
            this.mouseHScroll = new OneWayToggleButton(HMWHEEL_ICON, Bundle.ACTION_WheelHScrolls_name()){

                @Override
                protected void performAction() {
                    ChartPanel.this.mouseHScrollImpl();
                }
            };
            if (TracerOptions.getInstance().getMouseWheelAction().equals("horizontal scroll")) {
                this.mouseHScroll.setSelected(true);
                this.mouseHScrollImpl();
            }
        }
        return this.mouseHScroll;
    }

    AbstractButton mouseVScroll() {
        if (this.mouseVScroll == null) {
            this.mouseVScroll = new OneWayToggleButton(VMWHEEL_ICON, Bundle.ACTION_WheelVScrolls_name()){

                @Override
                protected void performAction() {
                    ChartPanel.this.mouseVScrollImpl();
                }
            };
            if (TracerOptions.getInstance().getMouseWheelAction().equals("vertical scroll")) {
                this.mouseVScroll.setSelected(true);
                this.mouseVScrollImpl();
            }
        }
        return this.mouseVScroll;
    }

    void vScroll(MouseWheelEvent e) {
        ChartPanel.scroll(this.vScrollBar, e);
    }

    private void mouseZoomImpl() {
        this.clearWheelHandlers();
        this.chart.setMouseZoomingEnabled(true);
        this.chart.addMouseWheelListener(this.defaultWheelHandler);
    }

    private void mouseHScrollImpl() {
        this.chart.setMouseZoomingEnabled(false);
        this.clearWheelHandlers();
        this.setWheelScrollHandler(this.hScrollBar);
    }

    private void mouseVScrollImpl() {
        this.chart.setMouseZoomingEnabled(false);
        this.clearWheelHandlers();
        this.setWheelScrollHandler(this.vScrollBar);
    }

    private void clearWheelHandlers() {
        MouseWheelListener[] handlers;
        for (MouseWheelListener handler : handlers = this.chart.getMouseWheelListeners()) {
            this.chart.removeMouseWheelListener(handler);
        }
    }

    private void setWheelScrollHandler(final JScrollBar scrollBar) {
        this.chart.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ChartPanel.scroll(scrollBar, e);
            }
        });
    }

    private static void scroll(JScrollBar scrollBar, MouseWheelEvent e) {
        int unitsToScroll;
        if (e.getScrollType() == 0 && (unitsToScroll = e.getUnitsToScroll()) != 0) {
            int direction = unitsToScroll < 0 ? -1 : 1;
            int increment = scrollBar.getUnitIncrement(direction);
            int oldValue = scrollBar.getValue();
            int newValue = oldValue + increment * unitsToScroll;
            if (oldValue != (newValue = Math.max(Math.min(newValue, scrollBar.getMaximum() - scrollBar.getVisibleAmount()), scrollBar.getMinimum()))) {
                scrollBar.setValue(newValue);
            }
        }
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        public void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
            if (ChartPanel.this.zoomInAction != null) {
                ChartPanel.this.zoomInAction.updateAction();
            }
            if (ChartPanel.this.zoomOutAction != null) {
                ChartPanel.this.zoomOutAction.updateAction();
            }
        }

        public void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
            if (ChartPanel.this.zoomInAction != null) {
                ChartPanel.this.zoomInAction.updateAction();
            }
            if (ChartPanel.this.zoomOutAction != null) {
                ChartPanel.this.zoomOutAction.updateAction();
            }
        }
    }

    private static abstract class OneWayToggleButton
    extends JToggleButton {
        private boolean action;

        OneWayToggleButton(Icon icon, String toolTip) {
            super(icon);
            this.setToolTipText(toolTip);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (this.isSelected()) {
                e.consume();
                this.action = false;
            } else {
                this.action = true;
            }
            super.processMouseEvent(e);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (this.isSelected()) {
                e.consume();
                this.action = false;
            } else {
                this.action = true;
            }
            super.processKeyEvent(e);
        }

        @Override
        protected final void fireActionPerformed(ActionEvent e) {
            if (this.action) {
                this.performAction();
            }
        }

        protected abstract void performAction();
    }

    private class ToggleViewAction
    extends AbstractAction {
        private long origOffsetX = -1L;
        private double origScaleX = -1.0;

        ToggleViewAction() {
            this.updateAction();
            ChartPanel.this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        ToggleViewAction.this.actionPerformed(null);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean fitsWidth = ChartPanel.this.chart.fitsWidth();
            if (!fitsWidth) {
                this.origOffsetX = ChartPanel.this.chart.getOffsetX();
                if (ChartPanel.this.chart.tracksDataWidth() && this.origOffsetX == ChartPanel.this.chart.maxOffsetX()) {
                    this.origOffsetX = Long.MAX_VALUE;
                }
                this.origScaleX = ChartPanel.this.chart.getScaleX();
            }
            ChartPanel.this.chart.setFitsWidth(!fitsWidth);
            if (fitsWidth && this.origOffsetX != -1L && this.origScaleX != -1.0) {
                ChartPanel.this.chart.setScale(this.origScaleX, ChartPanel.this.chart.getScaleY());
                ChartPanel.this.chart.setOffset(this.origOffsetX, ChartPanel.this.chart.getOffsetY());
            }
            this.updateAction();
            if (ChartPanel.this.zoomInAction != null) {
                ChartPanel.this.zoomInAction.updateAction();
            }
            if (ChartPanel.this.zoomOutAction != null) {
                ChartPanel.this.zoomOutAction.updateAction();
            }
            ChartPanel.this.chart.repaintDirty();
        }

        private void updateAction() {
            boolean fitsWidth = ChartPanel.this.chart.fitsWidth();
            Icon icon = fitsWidth ? FIXED_SCALE_ICON : SCALE_TO_FIT_ICON;
            String name = fitsWidth ? Bundle.ACTION_FixedScale_name() : Bundle.ACTION_ScaleToFit_name();
            this.putValue("ShortDescription", name);
            this.putValue("SmallIcon", icon);
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        private static final float USED_CHART_WIDTH_THRESHOLD = 0.33f;

        ZoomOutAction() {
            this.putValue("ShortDescription", Bundle.ACTION_ZoomOut_name());
            this.putValue("SmallIcon", ZOOM_OUT_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean followsWidth = ChartPanel.this.chart.currentlyFollowingDataWidth();
            ChartPanel.this.chart.zoom(ChartPanel.this.getWidth() / 2, ChartPanel.this.getHeight() / 2, 0.5);
            if (followsWidth) {
                ChartPanel.this.chart.setOffset(ChartPanel.this.chart.maxOffsetX(), ChartPanel.this.chart.getOffsetY());
            }
            ChartPanel.this.chart.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ChartPanel.this.chart.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 0 && !ChartPanel.this.chart.fitsWidth() && (float)ChartPanel.this.chart.getContentsWidth() > (float)ChartPanel.this.getWidth() * 0.33f);
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private static final int ONE_SECOND_WIDTH_THRESHOLD = 200;

        ZoomInAction() {
            this.putValue("ShortDescription", Bundle.ACTION_ZoomIn_name());
            this.putValue("SmallIcon", ZOOM_IN_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean followsWidth = ChartPanel.this.chart.currentlyFollowingDataWidth();
            ChartPanel.this.chart.zoom(ChartPanel.this.getWidth() / 2, ChartPanel.this.getHeight() / 2, 2.0);
            if (followsWidth) {
                ChartPanel.this.chart.setOffset(ChartPanel.this.chart.maxOffsetX(), ChartPanel.this.chart.getOffsetY());
            }
            ChartPanel.this.chart.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ChartPanel.this.chart.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !ChartPanel.this.chart.fitsWidth() && ChartPanel.this.chart.viewWidth(1000.0) < 200.0);
        }
    }
}

