/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Utils;

public class UploadDialogModel
extends TagEditorModel {
    private static final String CREATED_BY = "created_by";
    public static final String COMMENT = "comment";
    public static final String SOURCE = "source";
    private final String agent = Version.getInstance().getAgentString(false);
    private final boolean hashtags = Config.getPref().getBoolean("upload.changeset.hashtags", true);
    private boolean locked;

    @Override
    public void fireTableDataChanged() {
        if (!this.locked) {
            try {
                String createdBy;
                this.locked = true;
                if (this.hashtags) {
                    this.put("hashtags", this.findHashTags(this.getValue(COMMENT)));
                }
                if ((createdBy = this.getValue(CREATED_BY)).isEmpty()) {
                    this.put(CREATED_BY, this.agent);
                } else if (!createdBy.contains(this.agent)) {
                    this.put(CREATED_BY, createdBy + ";" + this.agent);
                }
                super.fireTableDataChanged();
            }
            finally {
                this.locked = false;
            }
        }
    }

    public String getValue(String key) {
        TagModel tag = this.get(key);
        return tag == null ? "" : tag.getValue();
    }

    String findHashTags(String comment) {
        String foundHashtags = Arrays.stream(comment.split("\\s", -1)).map(s -> Utils.strip(s, ",;")).filter(s -> s.matches("#[a-zA-Z0-9][-_a-zA-Z0-9]+")).distinct().collect(Collectors.joining(";"));
        return foundHashtags.isEmpty() ? null : foundHashtags;
    }

    static String addHashTagsFromDataSet(String comment, DataSet dataSet) {
        String hashtags;
        StringBuilder result;
        StringBuilder stringBuilder = result = comment == null ? new StringBuilder() : new StringBuilder(comment);
        if (dataSet != null && (hashtags = dataSet.getChangeSetTags().get("hashtags")) != null) {
            LinkedHashSet<Object> sanitizedHashtags = new LinkedHashSet<Object>();
            for (String hashtag : hashtags.split(";", -1)) {
                if (comment != null && comment.contains(hashtag)) continue;
                sanitizedHashtags.add(hashtag.startsWith("#") ? hashtag : "#" + hashtag);
            }
            if (!sanitizedHashtags.isEmpty()) {
                result.append(' ').append(String.join((CharSequence)" ", sanitizedHashtags));
            }
        }
        return result.toString();
    }

    private void doPut(String key, String value) {
        List l = this.tags.stream().filter(tm -> tm.getName().equals(key)).collect(Collectors.toList());
        if (!l.isEmpty()) {
            if (value != null) {
                for (TagModel tm2 : l) {
                    tm2.setValue(value);
                }
            } else {
                this.tags.removeIf(tm -> tm.getName().equals(key));
            }
        } else if (value != null) {
            this.tags.add(new TagModel(key, value));
        }
    }

    public void put(String key, String value) {
        this.commitPendingEdit();
        this.doPut(key, value);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void putAll(Map<String, String> map) {
        this.commitPendingEdit();
        map.forEach(this::doPut);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void putAll(DataSet dataSet) {
        if (dataSet != null) {
            this.putAll(dataSet.getChangeSetTags());
            this.put(COMMENT, UploadDialogModel.addHashTagsFromDataSet(this.getValue(COMMENT), dataSet));
        }
    }

    public static boolean isCommentOrSource(String key) {
        return COMMENT.equals(key) || SOURCE.equals(key);
    }
}

