/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.db.BasicDatabase;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class SlaveDatabase
extends BasicDatabase {
    private volatile boolean inReplicationSlaveMode;
    private volatile boolean shutdownInitiated;
    private volatile boolean inBoot;
    private volatile StandardException bootException;
    private String dbname;
    private volatile SlaveFactory slaveFac;

    @Override
    public boolean canSupport(Properties startParams) {
        String repliMode;
        boolean supported = Monitor.isDesiredCreateType(startParams, this.getEngineType());
        if (supported && ((repliMode = startParams.getProperty("replication.slave.mode")) == null || !repliMode.equals("slavemode"))) {
            supported = false;
        }
        return supported;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.inReplicationSlaveMode = true;
        this.inBoot = true;
        this.shutdownInitiated = false;
        this.dbname = startParams.getProperty("replication.slave.dbname");
        SlaveDatabaseBootThread dbBootThread = new SlaveDatabaseBootThread(create, startParams);
        Thread sdbThread = new Thread((Runnable)dbBootThread, "derby.slave.boot-" + this.dbname);
        sdbThread.setDaemon(true);
        sdbThread.start();
        this.verifySuccessfulBoot();
        this.inBoot = false;
        this.active = true;
    }

    @Override
    public void stop() {
        if (this.inReplicationSlaveMode && this.slaveFac != null) {
            try {
                this.slaveFac.stopSlave(true);
            }
            catch (StandardException standardException) {
            }
            finally {
                this.slaveFac = null;
            }
        }
        super.stop();
    }

    @Override
    public boolean isInSlaveMode() {
        return this.inReplicationSlaveMode;
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException((String)"08004.C.7", (Object[])new Object[]{dbname});
        }
        return super.setupConnection(cm, user, drdaID, dbname);
    }

    @Override
    public AuthenticationService getAuthenticationService() throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException((String)"08004.C.7", (Object[])new Object[]{this.dbname});
        }
        return super.getAuthenticationService();
    }

    public void verifyShutdownSlave() throws StandardException {
        if (!this.shutdownInitiated) {
            throw StandardException.newException((String)"XRE43", (Object[])new Object[0]);
        }
        this.pushDbContext(SlaveDatabase.getContextService().getCurrentContextManager());
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        if (this.shutdownInitiated) {
            return;
        }
        if (!this.inReplicationSlaveMode) {
            StandardException se = StandardException.newException((String)"XRE40", (Object[])new Object[0]);
            throw PublicAPI.wrapStandardException((StandardException)se);
        }
        try {
            this.slaveFac.stopSlave(false);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException((StandardException)se);
        }
        this.slaveFac = null;
    }

    @Override
    public void failover(String dbname) throws StandardException {
        if (this.inReplicationSlaveMode) {
            this.slaveFac.failover();
            while (this.inReplicationSlaveMode) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
        } else {
            super.failover(dbname);
        }
    }

    private void verifySuccessfulBoot() throws StandardException {
        while (!this.isSlaveFactorySet() || !this.slaveFac.isStarted()) {
            if (this.bootException != null) {
                throw this.bootException;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                InterruptStatus.setInterrupted();
            }
        }
        if (this.bootException != null) {
            throw this.bootException;
        }
    }

    private boolean isSlaveFactorySet() {
        if (this.slaveFac != null) {
            return true;
        }
        try {
            this.slaveFac = (SlaveFactory)SlaveDatabase.findServiceModule(this, "org.apache.derby.iapi.store.replication.slave.SlaveFactory");
            return true;
        }
        catch (StandardException se) {
            return false;
        }
    }

    private void handleShutdown(StandardException shutdownCause) {
        if (this.inBoot) {
            this.bootException = shutdownCause;
            return;
        }
        try {
            this.shutdownInitiated = true;
            String conStr = "jdbc:derby:" + this.dbname + ";internal_stopslave=true";
            InternalDriver driver = InternalDriver.activeDriver();
            if (driver != null) {
                driver.connect(conStr, null, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bootBasicDatabase(boolean create, Properties params) throws StandardException {
        super.boot(create, params);
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }

    private class SlaveDatabaseBootThread
    implements Runnable {
        private boolean create;
        private Properties params;

        public SlaveDatabaseBootThread(boolean create, Properties startParams) {
            this.create = create;
            this.params = startParams;
        }

        @Override
        public void run() {
            block3: {
                ContextManager bootThreadCm = null;
                try {
                    bootThreadCm = SlaveDatabase.getContextService().newContextManager();
                    SlaveDatabase.getContextService().setCurrentContextManager(bootThreadCm);
                    SlaveDatabase.this.bootBasicDatabase(this.create, this.params);
                    SlaveDatabase.this.inReplicationSlaveMode = false;
                    if (bootThreadCm != null) {
                        SlaveDatabase.getContextService().resetCurrentContextManager(bootThreadCm);
                        bootThreadCm = null;
                    }
                }
                catch (Exception e) {
                    ReplicationLogger rl = new ReplicationLogger(SlaveDatabase.this.dbname);
                    rl.logError("R005", e);
                    if (!(e instanceof StandardException)) break block3;
                    SlaveDatabase.this.handleShutdown((StandardException)((Object)e));
                }
            }
        }
    }
}

