/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInputSourceLocalizedNameGetInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SOURCEPATH;
    public static final int WHICHCOMPONENTS;

    public XrInputSourceLocalizedNameGetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrInputSourceLocalizedNameGetInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInputSourceLocalizedNameGetInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInputSourceLocalizedNameGetInfo.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long sourcePath() {
        return XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address());
    }

    @NativeType(value="XrInputSourceLocalizedNameFlags")
    public long whichComponents() {
        return XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address());
    }

    public XrInputSourceLocalizedNameGetInfo type(@NativeType(value="XrStructureType") int value) {
        XrInputSourceLocalizedNameGetInfo.ntype(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo type$Default() {
        return this.type(63);
    }

    public XrInputSourceLocalizedNameGetInfo next(@NativeType(value="void const *") long value) {
        XrInputSourceLocalizedNameGetInfo.nnext(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo sourcePath(@NativeType(value="XrPath") long value) {
        XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo whichComponents(@NativeType(value="XrInputSourceLocalizedNameFlags") long value) {
        XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo set(int type, long next, long sourcePath, long whichComponents) {
        this.type(type);
        this.next(next);
        this.sourcePath(sourcePath);
        this.whichComponents(whichComponents);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo set(XrInputSourceLocalizedNameGetInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrInputSourceLocalizedNameGetInfo malloc() {
        return (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrInputSourceLocalizedNameGetInfo calloc() {
        return (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrInputSourceLocalizedNameGetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrInputSourceLocalizedNameGetInfo create(long address) {
        return (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)address);
    }

    @Nullable
    public static XrInputSourceLocalizedNameGetInfo createSafe(long address) {
        return address == 0L ? null : (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrInputSourceLocalizedNameGetInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInputSourceLocalizedNameGetInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrInputSourceLocalizedNameGetInfo malloc(MemoryStack stack) {
        return (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrInputSourceLocalizedNameGetInfo calloc(MemoryStack stack) {
        return (XrInputSourceLocalizedNameGetInfo)XrInputSourceLocalizedNameGetInfo.wrap(XrInputSourceLocalizedNameGetInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInputSourceLocalizedNameGetInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nsourcePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SOURCEPATH);
    }

    public static long nwhichComponents(long struct) {
        return UNSAFE.getLong(null, struct + (long)WHICHCOMPONENTS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsourcePath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SOURCEPATH, value);
    }

    public static void nwhichComponents(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)WHICHCOMPONENTS, value);
    }

    static {
        Struct.Layout layout = XrInputSourceLocalizedNameGetInfo.__struct((Struct.Member[])new Struct.Member[]{XrInputSourceLocalizedNameGetInfo.__member((int)4), XrInputSourceLocalizedNameGetInfo.__member((int)POINTER_SIZE), XrInputSourceLocalizedNameGetInfo.__member((int)8), XrInputSourceLocalizedNameGetInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SOURCEPATH = layout.offsetof(2);
        WHICHCOMPONENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrInputSourceLocalizedNameGetInfo, Buffer>
    implements NativeResource {
        private static final XrInputSourceLocalizedNameGetInfo ELEMENT_FACTORY = XrInputSourceLocalizedNameGetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrInputSourceLocalizedNameGetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInputSourceLocalizedNameGetInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInputSourceLocalizedNameGetInfo.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long sourcePath() {
            return XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address());
        }

        @NativeType(value="XrInputSourceLocalizedNameFlags")
        public long whichComponents() {
            return XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInputSourceLocalizedNameGetInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(63);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInputSourceLocalizedNameGetInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer sourcePath(@NativeType(value="XrPath") long value) {
            XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address(), value);
            return this;
        }

        public Buffer whichComponents(@NativeType(value="XrInputSourceLocalizedNameFlags") long value) {
            XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address(), value);
            return this;
        }
    }
}

