/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.command;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.traccar.command.CommandSender;
import org.traccar.config.Keys;
import org.traccar.model.Command;
import org.traccar.model.Device;

@Singleton
public class FindHubCommandSender
implements CommandSender {
    private final Client client;

    @Inject
    public FindHubCommandSender(Client client) throws IOException {
        this.client = client;
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return List.of("positionSingle", "positionPeriodic", "positionStop");
    }

    @Override
    public void sendCommand(Device device, Command command) throws Exception {
        String url = device.getString(Keys.COMMAND_FIND_HUB_URL.getKey());
        String key = device.getString(Keys.COMMAND_FIND_HUB_KEY.getKey());
        if (url == null || key == null) {
            throw new RuntimeException("Missing device URL or API key");
        }
        String commandType = Pattern.compile("(?<=[a-z0-9])(?=[A-Z])").matcher(command.getType()).replaceAll("-").toLowerCase();
        WebTarget target = this.client.target(url).path("devices").path(device.getUniqueId()).path(commandType);
        if ("positionPeriodic".equals(command.getType())) {
            int interval = command.getInteger("frequency");
            target = target.queryParam("interval", new Object[]{interval});
        }
        try (Response response = target.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + key)).post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new RuntimeException("HTTP code " + response.getStatusInfo().getStatusCode());
            }
        }
    }
}

