/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IfValidator
extends BaseKeywordValidator {
    private static final List<String> KEYWORDS = Arrays.asList("if", "then", "else");
    private final Schema ifSchema;
    private final Schema thenSchema;
    private final Schema elseSchema;

    public IfValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.IF_THEN_ELSE, schemaNode, schemaLocation, parentSchema, schemaContext);
        Schema foundIfSchema = null;
        Schema foundThenSchema = null;
        Schema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = parentSchema.getSchemaNode().get(keyword);
            SchemaLocation schemaLocationOfSchema = parentSchema.getSchemaLocation().append(keyword);
            if (keyword.equals("if")) {
                foundIfSchema = schemaContext.newSchema(schemaLocationOfSchema, node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = schemaContext.newSchema(schemaLocationOfSchema, node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = schemaContext.newSchema(schemaLocationOfSchema, node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        boolean ifConditionPassed = false;
        boolean failFast = executionContext.isFailFast();
        List<Error> existingErrors = executionContext.getErrors();
        ArrayList<Error> test = new ArrayList<Error>();
        executionContext.setErrors(test);
        try {
            executionContext.setFailFast(false);
            this.ifSchema.validate(executionContext, node, rootNode, instanceLocation);
            ifConditionPassed = test.isEmpty();
        }
        finally {
            executionContext.setErrors(existingErrors);
            executionContext.setFailFast(failFast);
        }
        if (ifConditionPassed && this.thenSchema != null) {
            executionContext.evaluationPathRemoveLast();
            executionContext.evaluationPathAddLast("then");
            try {
                this.thenSchema.validate(executionContext, node, rootNode, instanceLocation);
            }
            finally {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("if");
            }
        }
        if (!ifConditionPassed && this.elseSchema != null) {
            executionContext.evaluationPathRemoveLast();
            executionContext.evaluationPathAddLast("else");
            try {
                this.elseSchema.validate(executionContext, node, rootNode, instanceLocation);
            }
            finally {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("if");
            }
        }
    }

    @Override
    public void preloadSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        boolean checkCondition = node != null && shouldValidateSchema;
        boolean ifConditionPassed = false;
        boolean failFast = executionContext.isFailFast();
        List<Error> existingErrors = executionContext.getErrors();
        ArrayList<Error> test = new ArrayList<Error>();
        executionContext.setErrors(test);
        try {
            executionContext.setFailFast(false);
            this.ifSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            ifConditionPassed = test.isEmpty();
        }
        finally {
            executionContext.setErrors(existingErrors);
            executionContext.setFailFast(failFast);
        }
        if (!checkCondition) {
            if (this.thenSchema != null) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("then");
                try {
                    this.thenSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationPathAddLast("if");
                }
            }
            if (this.elseSchema != null) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("else");
                try {
                    this.elseSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationPathAddLast("if");
                }
            }
        } else {
            if (this.thenSchema != null && ifConditionPassed) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("then");
                try {
                    this.thenSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationPathAddLast("if");
                }
            }
            if (this.elseSchema != null && !ifConditionPassed) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("else");
                try {
                    this.elseSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationPathAddLast("if");
                }
            }
        }
    }
}

