/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.resource.MapSchemaIdResolver;
import com.networknt.schema.resource.PrefixSchemaIdResolver;
import com.networknt.schema.resource.SchemaIdResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class SchemaIdResolvers
extends ArrayList<SchemaIdResolver> {
    private static final long serialVersionUID = 1L;

    public SchemaIdResolvers() {
    }

    public SchemaIdResolvers(Collection<? extends SchemaIdResolver> c) {
        super(c);
    }

    public SchemaIdResolvers(int initialCapacity) {
        super(initialCapacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SchemaIdResolvers values = new SchemaIdResolvers();

        public Builder() {
        }

        public Builder(Builder copy) {
            this.values.addAll(copy.values);
        }

        public Builder with(Builder builder) {
            if (!builder.values.isEmpty()) {
                this.values.addAll(builder.values);
            }
            return this;
        }

        public Builder values(Consumer<List<SchemaIdResolver>> customizer) {
            customizer.accept(this.values);
            return this;
        }

        public Builder add(SchemaIdResolver schemaIdResolver) {
            this.values.add(schemaIdResolver);
            return this;
        }

        public Builder mapPrefix(String source, String replacement) {
            this.values.add(new PrefixSchemaIdResolver(source, replacement));
            return this;
        }

        public Builder mappings(Map<String, String> mappings) {
            this.values.add(new MapSchemaIdResolver(mappings));
            return this;
        }

        public Builder mappings(Function<String, String> mappings) {
            this.values.add(new MapSchemaIdResolver(mappings));
            return this;
        }

        public Builder mappings(Predicate<String> test, Function<String, String> mappings) {
            this.values.add(new MapSchemaIdResolver(test, mappings));
            return this;
        }

        public SchemaIdResolvers build() {
            return this.values;
        }
    }
}

