/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.stream.Streams;

public class CharSetUtils {
    public static boolean containsAny(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return false;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        for (char c : str2.toCharArray()) {
            if (!chars2.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static int count(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return 0;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        int count2 = 0;
        for (char c : str2.toCharArray()) {
            if (!chars2.contains(c)) continue;
            ++count2;
        }
        return count2;
    }

    private static boolean deepEmpty(String[] strings) {
        return Streams.of(strings).allMatch(StringUtils::isEmpty);
    }

    public static String delete(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return str2;
        }
        return CharSetUtils.modify(str2, set2, false);
    }

    public static String keep(String str2, String ... set2) {
        if (str2 == null) {
            return null;
        }
        if (str2.isEmpty() || CharSetUtils.deepEmpty(set2)) {
            return "";
        }
        return CharSetUtils.modify(str2, set2, true);
    }

    private static String modify(String str2, String[] set2, boolean expect) {
        char[] chrs;
        CharSet chars2 = CharSet.getInstance(set2);
        StringBuilder buffer2 = new StringBuilder(str2.length());
        for (char chr : chrs = str2.toCharArray()) {
            if (chars2.contains(chr) != expect) continue;
            buffer2.append(chr);
        }
        return buffer2.toString();
    }

    public static String squeeze(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return str2;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        StringBuilder buffer2 = new StringBuilder(str2.length());
        char[] chrs = str2.toCharArray();
        int sz = chrs.length;
        char lastChar = chrs[0];
        Character inChars = null;
        Character notInChars = null;
        buffer2.append(lastChar);
        for (int i = 1; i < sz; ++i) {
            char ch = chrs[i];
            if (ch == lastChar) {
                if (inChars != null && ch == inChars.charValue()) continue;
                if (notInChars == null || ch != notInChars.charValue()) {
                    if (chars2.contains(ch)) {
                        inChars = Character.valueOf(ch);
                        continue;
                    }
                    notInChars = Character.valueOf(ch);
                }
            }
            buffer2.append(ch);
            lastChar = ch;
        }
        return buffer2.toString();
    }

    @Deprecated
    public CharSetUtils() {
    }
}

