/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.xml;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.cybergarage.http.HTTPServerList;
import org.cybergarage.upnp.device.Advertiser;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.upnp.ssdp.SSDPSearchSocketList;
import org.cybergarage.upnp.xml.NodeData;
import org.cybergarage.util.Debug;
import org.cybergarage.util.ListenerList;

public class DeviceData
extends NodeData {
    private String descriptionURI = null;
    private File descriptionFile = null;
    private String location = "";
    private String location_ipv6 = "";
    private int leaseTime = 1800;
    private HTTPServerList httpServerList = null;
    private InetAddress[] httpBinds = null;
    private int httpPort = 4004;
    private ListenerList controlActionListenerList = new ListenerList();
    private SSDPSearchSocketList ssdpSearchSocketList = null;
    private String ssdpMulticastIPv4 = "239.255.255.250";
    private String ssdpMulticastIPv6 = SSDP.getIPv6Address();
    private int ssdpPort = 1900;
    private InetAddress[] ssdpBinds = null;
    private SSDPPacket ssdpPacket = null;
    private SSDPPacket ssdpPacket_ipv6 = null;
    private Advertiser advertiser = null;

    public File getDescriptionFile() {
        return this.descriptionFile;
    }

    public String getDescriptionURI() {
        return this.descriptionURI;
    }

    public void setDescriptionFile(File descriptionFile) {
        this.descriptionFile = descriptionFile;
    }

    public void setDescriptionURI(String descriptionURI) {
        this.descriptionURI = descriptionURI;
    }

    public String getLocation() {
        return this.getLocation(false);
    }

    public String getLocation(boolean preferIPv6) {
        if (preferIPv6) {
            if (this.location_ipv6 != null && !this.location_ipv6.isEmpty()) {
                return this.location_ipv6;
            }
            return this.location;
        }
        if (this.location != null && !this.location.isEmpty()) {
            return this.location;
        }
        return this.location_ipv6;
    }

    public void setLocation(String location) {
        if (location != null) {
            try {
                URL url = new URL(location);
                String host = url.getHost();
                if (host != null && host.startsWith("[")) {
                    this.location_ipv6 = location;
                    return;
                }
            }
            catch (MalformedURLException me) {
                Debug.warning("Bad location: " + location, me);
                return;
            }
        }
        this.location = location;
    }

    public int getLeaseTime() {
        return this.leaseTime;
    }

    public void setLeaseTime(int val) {
        this.leaseTime = val;
    }

    public HTTPServerList getHTTPServerList() {
        if (this.httpServerList == null) {
            this.httpServerList = new HTTPServerList(this.httpBinds, this.httpPort);
        }
        return this.httpServerList;
    }

    public void setHTTPBindAddress(InetAddress[] inets) {
        this.httpBinds = inets;
    }

    public InetAddress[] getHTTPBindAddress() {
        return this.httpBinds;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public void setHTTPPort(int port) {
        this.httpPort = port;
    }

    public ListenerList getControlActionListenerList() {
        return this.controlActionListenerList;
    }

    public SSDPSearchSocketList getSSDPSearchSocketList() {
        if (this.ssdpSearchSocketList == null) {
            this.ssdpSearchSocketList = new SSDPSearchSocketList(this.ssdpBinds, this.ssdpPort, this.ssdpMulticastIPv4, this.ssdpMulticastIPv6);
        }
        return this.ssdpSearchSocketList;
    }

    public void setSSDPPort(int port) {
        this.ssdpPort = port;
    }

    public int getSSDPPort() {
        return this.ssdpPort;
    }

    public void setSSDPBindAddress(InetAddress[] inets) {
        this.ssdpBinds = inets;
    }

    public InetAddress[] getSSDPBindAddress() {
        return this.ssdpBinds;
    }

    public void setMulticastIPv4Address(String ip) {
        this.ssdpMulticastIPv4 = ip;
    }

    public String getMulticastIPv4Address() {
        return this.ssdpMulticastIPv4;
    }

    public void setMulticastIPv6Address(String ip) {
        this.ssdpMulticastIPv6 = ip;
    }

    public String getMulticastIPv6Address() {
        return this.ssdpMulticastIPv6;
    }

    public SSDPPacket getSSDPPacket() {
        return this.getSSDPPacket(false);
    }

    public SSDPPacket getSSDPPacket(boolean preferIPv6) {
        if (preferIPv6) {
            if (this.ssdpPacket_ipv6 != null) {
                return this.ssdpPacket_ipv6;
            }
            return this.ssdpPacket;
        }
        if (this.ssdpPacket != null) {
            return this.ssdpPacket;
        }
        return this.ssdpPacket_ipv6;
    }

    public void setSSDPPacket(SSDPPacket packet) {
        String location = packet.getLocation();
        if (location != null) {
            try {
                URL url = new URL(location);
                String host = url.getHost();
                if (host != null && host.startsWith("[")) {
                    this.ssdpPacket_ipv6 = packet;
                    return;
                }
            }
            catch (MalformedURLException me) {
                Debug.warning("Bad location: " + location, me);
                return;
            }
        }
        this.ssdpPacket = packet;
    }

    public void setAdvertiser(Advertiser adv) {
        this.advertiser = adv;
    }

    public Advertiser getAdvertiser() {
        return this.advertiser;
    }
}

