/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;

class DirectLookupJob
extends FloodOnlySearchJob {
    private OutNetMessage _onm;
    private final RouterInfo _oldRI;
    private static final int TIMEOUT = 8000;

    public DirectLookupJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash peer, RouterInfo oldRI, Job onFind, Job onFail) {
        super(ctx, facade, peer, onFind, onFail, 8000);
        this._oldRI = oldRI;
    }

    @Override
    public String getName() {
        return "NetDb direct RI request";
    }

    @Override
    public boolean shouldProcessDSRM() {
        return false;
    }

    @Override
    public void runJob() {
        RouterContext ctx = this.getContext();
        this._onm = ctx.messageRegistry().registerPending(this._replySelector, this._onReply, this._onTimeout);
        DatabaseLookupMessage dlm = new DatabaseLookupMessage(ctx, true);
        dlm.setFrom(ctx.routerHash());
        long exp = ctx.clock().now() + 5000L;
        dlm.setMessageExpiration(exp);
        dlm.setSearchKey(this._key);
        dlm.setSearchType(DatabaseLookupMessage.Type.RI);
        OutNetMessage m = new OutNetMessage(ctx, dlm, exp, 500, this._oldRI);
        ctx.commSystem().processMessage(m);
        this._lookupsRemaining.set(1);
    }

    @Override
    void failed() {
        RouterContext ctx = this.getContext();
        ctx.messageRegistry().unregisterPending(this._onm);
        ctx.profileManager().dbLookupFailed(this._key);
        this._facade.complete(this._key);
        for (Job j : this._onFailed) {
            ctx.jobQueue().addJob(j);
        }
    }

    @Override
    void success() {
        this._facade.complete(this._key);
        RouterContext ctx = this.getContext();
        for (Job j : this._onFind) {
            ctx.jobQueue().addJob(j);
        }
    }
}

