/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.JavaType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.TargetEmbeddable;
import org.hibernate.annotations.Type;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class PropertyContainer {
    private final ClassDetails classDetails;
    private final TypeVariableScope typeAtStake;
    private final org.hibernate.boot.spi.AccessType classLevelAccessType;
    private final List<MemberDetails> attributeMembers;

    public PropertyContainer(ClassDetails classDetails, TypeVariableScope typeAtStake, org.hibernate.boot.spi.AccessType defaultClassLevelAccessType) {
        this.classDetails = classDetails;
        this.typeAtStake = typeAtStake;
        if (defaultClassLevelAccessType == org.hibernate.boot.spi.AccessType.DEFAULT) {
            defaultClassLevelAccessType = org.hibernate.boot.spi.AccessType.PROPERTY;
        }
        org.hibernate.boot.spi.AccessType localClassLevelAccessType = this.determineLocalClassDefinedAccessStrategy();
        assert (localClassLevelAccessType != null);
        org.hibernate.boot.spi.AccessType accessType = this.classLevelAccessType = localClassLevelAccessType != org.hibernate.boot.spi.AccessType.DEFAULT ? localClassLevelAccessType : defaultClassLevelAccessType;
        assert (this.classLevelAccessType == org.hibernate.boot.spi.AccessType.FIELD || this.classLevelAccessType == org.hibernate.boot.spi.AccessType.PROPERTY || this.classLevelAccessType == org.hibernate.boot.spi.AccessType.RECORD);
        this.attributeMembers = PropertyContainer.resolveAttributeMembers(classDetails, typeAtStake, this.classLevelAccessType);
    }

    private static List<MemberDetails> resolveAttributeMembers(ClassDetails classDetails, TypeVariableScope typeAtStake, org.hibernate.boot.spi.AccessType classLevelAccessType) {
        List<FieldDetails> fields = PropertyContainer.collectPotentialAttributeMembers(classDetails.getFields());
        List<MethodDetails> getters = PropertyContainer.collectPotentialAttributeMembers(classDetails.getMethods());
        List<RecordComponentDetails> recordComponents = PropertyContainer.collectPotentialAttributeMembers(classDetails.getRecordComponents());
        Map<String, MemberDetails> attributeMemberMap = PropertyContainer.buildAttributeMemberMap(recordComponents, fields, getters);
        HashMap<String, MethodDetails> persistentAttributesFromGetters = new HashMap<String, MethodDetails>();
        HashMap<String, RecordComponentDetails> persistentAttributesFromComponents = new HashMap<String, RecordComponentDetails>();
        PropertyContainer.collectPersistentAttributesUsingLocalAccessType(classDetails, attributeMemberMap, persistentAttributesFromGetters, persistentAttributesFromComponents, fields, getters, recordComponents);
        PropertyContainer.collectPersistentAttributesUsingClassLevelAccessType(classDetails, classLevelAccessType, attributeMemberMap, persistentAttributesFromGetters, persistentAttributesFromComponents, fields, getters, recordComponents);
        return PropertyContainer.verifyAndInitializePersistentAttributes(classDetails, typeAtStake, attributeMemberMap);
    }

    private static Map<String, MemberDetails> buildAttributeMemberMap(List<RecordComponentDetails> recordComponents, List<FieldDetails> fields, List<MethodDetails> getters) {
        AbstractMap attributeMemberMap = !recordComponents.isEmpty() && recordComponents.size() == fields.size() ? new LinkedHashMap() : new TreeMap<String, MemberDetails>();
        return attributeMemberMap;
    }

    private static <E extends MemberDetails> List<E> collectPotentialAttributeMembers(List<E> source) {
        ArrayList<MemberDetails> results = new ArrayList<MemberDetails>();
        for (int i = 0; i < source.size(); ++i) {
            MemberDetails possible = (MemberDetails)source.get(i);
            if (!possible.isPersistable() || PropertyContainer.mustBeSkipped(possible)) continue;
            results.add(possible);
        }
        return results;
    }

    private static void collectPersistentAttributesUsingLocalAccessType(ClassDetails classDetails, Map<String, MemberDetails> persistentAttributeMap, Map<String, MethodDetails> persistentAttributesFromGetters, Map<String, RecordComponentDetails> persistentAttributesFromComponents, List<FieldDetails> fields, List<MethodDetails> getters, List<RecordComponentDetails> recordComponents) {
        String name;
        Access localAccessAnnotation;
        int i;
        for (i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = fields.get(i);
            localAccessAnnotation = (Access)fieldDetails.getDirectAnnotationUsage(Access.class);
            if (localAccessAnnotation == null || localAccessAnnotation.value() != AccessType.FIELD) continue;
            persistentAttributeMap.put(fieldDetails.getName(), (MemberDetails)fieldDetails);
        }
        for (i = 0; i < getters.size(); ++i) {
            MethodDetails getterDetails = getters.get(i);
            localAccessAnnotation = (Access)getterDetails.getDirectAnnotationUsage(Access.class);
            if (localAccessAnnotation == null || localAccessAnnotation.value() != AccessType.PROPERTY) continue;
            name = getterDetails.resolveAttributeName();
            MethodDetails previous = persistentAttributesFromGetters.get(name);
            if (previous != null) {
                PropertyContainer.throwAmbiguousPropertyException(classDetails, previous, getterDetails);
            }
            persistentAttributeMap.put(name, (MemberDetails)getterDetails);
            persistentAttributesFromGetters.put(name, getterDetails);
        }
        for (i = 0; i < recordComponents.size(); ++i) {
            RecordComponentDetails componentDetails = recordComponents.get(i);
            localAccessAnnotation = (Access)componentDetails.getDirectAnnotationUsage(Access.class);
            if (localAccessAnnotation == null) continue;
            name = componentDetails.getName();
            persistentAttributeMap.put(name, (MemberDetails)componentDetails);
            persistentAttributesFromComponents.put(name, componentDetails);
        }
    }

    private static void throwAmbiguousPropertyException(ClassDetails classDetails, MethodDetails previous, MethodDetails getterDetails) {
        throw new MappingException(String.format("Ambiguous persistent property methods declared by '%s': '%s' and '%s' (mark one '@Transient')", classDetails.getName(), previous.getName(), getterDetails.getName()), new Origin(SourceType.ANNOTATION, classDetails.getName()));
    }

    private static void collectPersistentAttributesUsingClassLevelAccessType(ClassDetails classDetails, org.hibernate.boot.spi.AccessType classLevelAccessType, Map<String, MemberDetails> persistentAttributeMap, Map<String, MethodDetails> persistentAttributesFromGetters, Map<String, RecordComponentDetails> persistentAttributesFromComponents, List<FieldDetails> fields, List<MethodDetails> getters, List<RecordComponentDetails> recordComponents) {
        if (classLevelAccessType == org.hibernate.boot.spi.AccessType.FIELD) {
            for (int i = 0; i < fields.size(); ++i) {
                FieldDetails field = fields.get(i);
                String name = field.getName();
                if (persistentAttributeMap.containsKey(name)) continue;
                persistentAttributeMap.put(name, (MemberDetails)field);
            }
        } else {
            String name;
            int i;
            for (i = 0; i < getters.size(); ++i) {
                MethodDetails getterDetails = getters.get(i);
                name = getterDetails.resolveAttributeName();
                MethodDetails previous = persistentAttributesFromGetters.get(name);
                if (previous != null && getterDetails != previous) {
                    PropertyContainer.throwAmbiguousPropertyException(classDetails, previous, getterDetails);
                }
                if (persistentAttributeMap.containsKey(name)) continue;
                persistentAttributeMap.put(name, (MemberDetails)getterDetails);
                persistentAttributesFromGetters.put(name, getterDetails);
            }
            for (i = 0; i < recordComponents.size(); ++i) {
                RecordComponentDetails componentDetails = recordComponents.get(i);
                name = componentDetails.getName();
                if (persistentAttributeMap.containsKey(name)) continue;
                persistentAttributeMap.put(name, (MemberDetails)componentDetails);
                persistentAttributesFromComponents.put(name, componentDetails);
            }
        }
    }

    public ClassDetails getDeclaringClass() {
        return this.classDetails;
    }

    public TypeVariableScope getTypeAtStake() {
        return this.typeAtStake;
    }

    public org.hibernate.boot.spi.AccessType getClassLevelAccessType() {
        return this.classLevelAccessType;
    }

    public Iterable<MemberDetails> propertyIterator() {
        return this.attributeMembers;
    }

    private static List<MemberDetails> verifyAndInitializePersistentAttributes(ClassDetails classDetails, TypeVariableScope typeAtStake, Map<String, MemberDetails> attributeMemberMap) {
        ArrayList<MemberDetails> output = new ArrayList<MemberDetails>(attributeMemberMap.size());
        for (MemberDetails attributeMemberDetails : attributeMemberMap.values()) {
            TypeDetails memberType = attributeMemberDetails.resolveRelativeType(typeAtStake);
            if (!memberType.isResolved() && !PropertyContainer.discoverTypeWithoutReflection(classDetails, attributeMemberDetails)) {
                String msg = "Property '" + StringHelper.qualify(classDetails.getName(), attributeMemberDetails.getName()) + "' has an unbound type and no explicit target entity (resolve this generics usage issue or set an explicit target attribute with '@OneToMany(target=)' or use an explicit '@Type')";
                throw new AnnotationException(msg);
            }
            output.add(attributeMemberDetails);
        }
        return CollectionHelper.toSmallList(output);
    }

    private org.hibernate.boot.spi.AccessType determineLocalClassDefinedAccessStrategy() {
        org.hibernate.boot.spi.AccessType classDefinedAccessType = org.hibernate.boot.spi.AccessType.DEFAULT;
        Access access = (Access)this.classDetails.getDirectAnnotationUsage(Access.class);
        if (access != null) {
            classDefinedAccessType = org.hibernate.boot.spi.AccessType.getAccessStrategy(access.value());
        }
        return classDefinedAccessType;
    }

    private static boolean discoverTypeWithoutReflection(ClassDetails classDetails, MemberDetails memberDetails) {
        if (memberDetails.hasDirectAnnotationUsage(TargetEmbeddable.class)) {
            return true;
        }
        if (memberDetails.hasDirectAnnotationUsage(Basic.class)) {
            return true;
        }
        if (memberDetails.hasDirectAnnotationUsage(Type.class)) {
            return true;
        }
        if (memberDetails.hasDirectAnnotationUsage(JavaType.class)) {
            return true;
        }
        OneToOne oneToOneAnn = (OneToOne)memberDetails.getDirectAnnotationUsage(OneToOne.class);
        if (oneToOneAnn != null) {
            return oneToOneAnn.targetEntity() != Void.TYPE;
        }
        OneToMany oneToManyAnn = (OneToMany)memberDetails.getDirectAnnotationUsage(OneToMany.class);
        if (oneToManyAnn != null) {
            return oneToManyAnn.targetEntity() != Void.TYPE;
        }
        ManyToOne manyToOneAnn = (ManyToOne)memberDetails.getDirectAnnotationUsage(ManyToOne.class);
        if (manyToOneAnn != null) {
            return manyToOneAnn.targetEntity() != Void.TYPE;
        }
        ManyToMany manyToManyAnn = (ManyToMany)memberDetails.getDirectAnnotationUsage(ManyToMany.class);
        if (manyToManyAnn != null) {
            return manyToManyAnn.targetEntity() != Void.TYPE;
        }
        if (memberDetails.hasDirectAnnotationUsage(Any.class)) {
            return true;
        }
        ManyToAny manToAnyAnn = (ManyToAny)memberDetails.getDirectAnnotationUsage(ManyToAny.class);
        if (manToAnyAnn != null) {
            return true;
        }
        if (memberDetails.hasDirectAnnotationUsage(JdbcTypeCode.class)) {
            return true;
        }
        return memberDetails.getType().determineRawClass().isImplementor(Class.class);
    }

    private static boolean mustBeSkipped(MemberDetails memberDetails) {
        return memberDetails.hasDirectAnnotationUsage(Transient.class) || memberDetails.getType() != null && "net.sf.cglib.transform.impl.InterceptFieldCallback".equals(memberDetails.getType().getName());
    }
}

