/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import org.eclipse.californium.elements.auth.AbstractExtensiblePrincipal;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.JceProviderUtil;

public class RawPublicKeyIdentity
extends AbstractExtensiblePrincipal<RawPublicKeyIdentity> {
    private String niUri;
    private final PublicKey publicKey;

    public RawPublicKeyIdentity(PublicKey key) {
        this(key, null);
    }

    private RawPublicKeyIdentity(PublicKey key, AdditionalInfo additionalInformation) {
        super(additionalInformation);
        if (key == null) {
            throw new NullPointerException("Public key must not be null");
        }
        this.publicKey = key;
        this.createNamedInformationUri(this.publicKey.getEncoded());
    }

    public RawPublicKeyIdentity(byte[] subjectInfo) throws GeneralSecurityException {
        this(subjectInfo, null, null);
    }

    public RawPublicKeyIdentity(byte[] subjectInfo, String keyAlgorithm) throws GeneralSecurityException {
        this(subjectInfo, keyAlgorithm, null);
    }

    private RawPublicKeyIdentity(byte[] subjectInfo, String keyAlgorithm, AdditionalInfo additionalInformation) throws GeneralSecurityException {
        super(additionalInformation);
        if (subjectInfo == null) {
            throw new NullPointerException("SubjectPublicKeyInfo must not be null");
        }
        String specKeyAlgorithm = null;
        try {
            specKeyAlgorithm = Asn1DerDecoder.readSubjectPublicKeyAlgorithm(subjectInfo);
        }
        catch (IllegalArgumentException ex) {
            throw new GeneralSecurityException(ex.getMessage());
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(subjectInfo);
        if (keyAlgorithm != null) {
            if (specKeyAlgorithm == null) {
                specKeyAlgorithm = keyAlgorithm;
            } else if (!JceProviderUtil.equalKeyAlgorithmSynonyms(specKeyAlgorithm, keyAlgorithm)) {
                throw new GeneralSecurityException(String.format("Provided key algorithm %s doesn't match %s!", keyAlgorithm, specKeyAlgorithm));
            }
        } else if (specKeyAlgorithm == null) {
            throw new GeneralSecurityException("Key algorithm could not be determined!");
        }
        KeyFactory factory = Asn1DerDecoder.getKeyFactory(specKeyAlgorithm);
        try {
            this.publicKey = factory.generatePublic(spec);
        }
        catch (RuntimeException ex) {
            throw new GeneralSecurityException(ex.getMessage());
        }
        this.createNamedInformationUri(subjectInfo);
    }

    @Override
    public RawPublicKeyIdentity amend(AdditionalInfo additionalInfo) {
        return new RawPublicKeyIdentity(this.publicKey, additionalInfo);
    }

    private void createNamedInformationUri(byte[] subjectPublicKeyInfo) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(subjectPublicKeyInfo);
            byte[] digest = md.digest();
            String base64urlDigest = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
            StringBuilder b = new StringBuilder("ni:///sha-256;").append(base64urlDigest);
            this.niUri = b.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Override
    public final String getName() {
        return this.niUri;
    }

    public final PublicKey getKey() {
        return this.publicKey;
    }

    public final byte[] getSubjectInfo() {
        return this.publicKey.getEncoded();
    }

    @Override
    public String toString() {
        return "RawPublicKey Identity [" + this.niUri + "]";
    }

    @Override
    public int hashCode() {
        return this.publicKey == null ? 0 : Arrays.hashCode(this.getSubjectInfo());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawPublicKeyIdentity other = (RawPublicKeyIdentity)obj;
        if (this.publicKey == null) {
            return other.publicKey == null;
        }
        return Arrays.equals(this.getSubjectInfo(), other.getSubjectInfo());
    }
}

