/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.profile;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptTransformationService;
import org.openhab.core.automation.module.script.profile.ScriptProfile;
import org.openhab.core.thing.profiles.Profile;
import org.openhab.core.thing.profiles.ProfileCallback;
import org.openhab.core.thing.profiles.ProfileContext;
import org.openhab.core.thing.profiles.ProfileFactory;
import org.openhab.core.thing.profiles.ProfileType;
import org.openhab.core.thing.profiles.ProfileTypeBuilder;
import org.openhab.core.thing.profiles.ProfileTypeProvider;
import org.openhab.core.thing.profiles.ProfileTypeUID;
import org.openhab.core.thing.profiles.StateProfileType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(service={ProfileFactory.class, ProfileTypeProvider.class})
public class ScriptProfileFactory
implements ProfileFactory,
ProfileTypeProvider {
    public static final String PROFILE_CONFIG_URI_PREFIX = "profile:transform:";
    private final Map<String, ServiceRecord> services = new ConcurrentHashMap<String, ServiceRecord>();

    public @Nullable Profile createProfile(ProfileTypeUID profileTypeUID, ProfileCallback callback, ProfileContext profileContext) {
        String serviceId = profileTypeUID.getId();
        ScriptTransformationService transformationService = this.services.get(serviceId).service();
        return new ScriptProfile(profileTypeUID, callback, profileContext, transformationService);
    }

    public Collection<ProfileTypeUID> getSupportedProfileTypeUIDs() {
        return this.services.keySet().stream().map(id -> new ProfileTypeUID("transform", id)).toList();
    }

    public Collection<ProfileType> getProfileTypes(@Nullable Locale locale) {
        return this.getSupportedProfileTypeUIDs().stream().map(uid -> {
            String id = uid.getId();
            String label = this.services.get(id).serviceLabel();
            return (StateProfileType)ProfileTypeBuilder.newState((ProfileTypeUID)uid, (String)label).build();
        }).collect(Collectors.toList());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindScriptTransformationService(ScriptTransformationService service, Map<String, Object> properties) {
        String serviceId = (String)properties.get("openhab.transform");
        String serviceLabel = (String)properties.get("openhab.transform.label");
        if (serviceId != null && serviceLabel != null) {
            this.services.put(serviceId, new ServiceRecord(service, serviceLabel));
        }
    }

    public void unbindScriptTransformationService(ScriptTransformationService service, Map<String, Object> properties) {
        String serviceId = (String)properties.get("openhab.transform");
        this.services.remove(serviceId);
    }

    private record ServiceRecord(ScriptTransformationService service, String serviceLabel) {
    }
}

