/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.coredump.impl;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.coredump.CoreDumpsContainer;
import org.graalvm.visualvm.coredump.impl.CoreDumpConfigurator;
import org.graalvm.visualvm.coredump.impl.CoreDumpProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class AddVMCoredumpAction
extends SingleDataSourceAction<CoreDumpsContainer> {
    private static final String ICON_PATH = "org/graalvm/visualvm/coredump/resources/addCoredump.png";
    private static final Image ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/coredump/resources/addCoredump.png");
    private boolean tracksSelection = false;
    private static AddVMCoredumpAction alwaysEnabled;
    private static AddVMCoredumpAction selectionAware;

    public static synchronized AddVMCoredumpAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new AddVMCoredumpAction();
            alwaysEnabled.putValue("SmallIcon", new ImageIcon(ICON));
            alwaysEnabled.putValue("iconBase", ICON_PATH);
        }
        return alwaysEnabled;
    }

    public static synchronized AddVMCoredumpAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new AddVMCoredumpAction();
            AddVMCoredumpAction.selectionAware.tracksSelection = true;
        }
        return selectionAware;
    }

    public void actionPerformed(CoreDumpsContainer container, ActionEvent e) {
        CoreDumpConfigurator newCoreDumpConfiguration = CoreDumpConfigurator.defineCoreDump();
        if (newCoreDumpConfiguration != null) {
            CoreDumpProvider.createCoreDump(newCoreDumpConfiguration.getCoreDumpFile(), newCoreDumpConfiguration.getDisplayname(), newCoreDumpConfiguration.getJavaHome(), newCoreDumpConfiguration.deleteSourceFile());
        }
    }

    protected boolean isEnabled(CoreDumpsContainer container) {
        return true;
    }

    protected void initialize() {
        if (this.tracksSelection) {
            super.initialize();
        }
    }

    private AddVMCoredumpAction() {
        super(CoreDumpsContainer.class);
        this.putValue("Name", NbBundle.getMessage(AddVMCoredumpAction.class, (String)"LBL_Add_VM_Coredump"));
        this.putValue("ShortDescription", NbBundle.getMessage(AddVMCoredumpAction.class, (String)"ToolTip_Add_VM_Coredump"));
    }
}

