/*
 * Copyright (c) The mlkem-native project authors
 * SPDX-License-Identifier: Apache-2.0 OR ISC OR MIT
 */

/*yaml
  Name: poly_tomont_asm
  Description: Convert polynomial to Montgomery domain
  Signature: void mlk_poly_tomont_asm(int16_t p[256])
  ABI:
    x0:
      type: buffer
      size_bytes: 512
      permissions: read/write
      c_parameter: int16_t p[256]
      description: Input/output polynomial
  Stack:
    bytes: 0
*/

#include "_internal_s2n_bignum.h"

/*
 * WARNING: This file is auto-derived from the mlkem-native source file
 *   dev/aarch64_opt/src/poly_tomont_asm.S using scripts/simpasm. Do not modify it directly.
 */


.text
.balign 4
        S2N_BN_SYM_VISIBILITY_DIRECTIVE(mlkem_poly_tomont_asm)
        S2N_BN_SYM_PRIVACY_DIRECTIVE(mlkem_poly_tomont_asm)
S2N_BN_SYMBOL(mlkem_poly_tomont_asm):

        .cfi_startproc
        mov	w2, #0xd01              // =3329
        dup	v4.8h, w2
        mov	w2, #0x4ebf             // =20159
        dup	v5.8h, w2
        mov	w2, #-0x414             // =-1044
        dup	v2.8h, w2
        mov	w2, #-0x2824            // =-10276
        dup	v3.8h, w2
        mov	x1, #0x8                // =8
        ldr	q26, [x0, #0x30]
        ldr	q23, [x0, #0x10]
        mul	v17.8h, v26.8h, v2.8h
        sqrdmulh	v7.8h, v26.8h, v3.8h
        ldr	q27, [x0, #0x20]
        sub	x1, x1, #0x1

Lpoly_tomont_loop:
        mls	v17.8h, v7.8h, v4.h[0]
        sqrdmulh	v5.8h, v23.8h, v3.8h
        ldr	q7, [x0], #0x40
        stur	q17, [x0, #-0x10]
        sqrdmulh	v29.8h, v27.8h, v3.8h
        sqrdmulh	v19.8h, v7.8h, v3.8h
        mul	v25.8h, v23.8h, v2.8h
        mul	v0.8h, v7.8h, v2.8h
        mul	v26.8h, v27.8h, v2.8h
        ldr	q7, [x0, #0x30]
        mls	v25.8h, v5.8h, v4.h[0]
        ldr	q23, [x0, #0x10]
        mls	v26.8h, v29.8h, v4.h[0]
        mls	v0.8h, v19.8h, v4.h[0]
        stur	q25, [x0, #-0x30]
        mul	v17.8h, v7.8h, v2.8h
        sqrdmulh	v7.8h, v7.8h, v3.8h
        stur	q0, [x0, #-0x40]
        ldr	q27, [x0, #0x20]
        stur	q26, [x0, #-0x20]
        sub	x1, x1, #0x1
        cbnz	x1, Lpoly_tomont_loop
        mls	v17.8h, v7.8h, v4.h[0]
        sqrdmulh	v7.8h, v23.8h, v3.8h
        mul	v26.8h, v23.8h, v2.8h
        sqrdmulh	v25.8h, v27.8h, v3.8h
        ldr	q23, [x0], #0x40
        mul	v27.8h, v27.8h, v2.8h
        mls	v26.8h, v7.8h, v4.h[0]
        sqrdmulh	v7.8h, v23.8h, v3.8h
        mul	v23.8h, v23.8h, v2.8h
        stur	q17, [x0, #-0x10]
        mls	v27.8h, v25.8h, v4.h[0]
        stur	q26, [x0, #-0x30]
        mls	v23.8h, v7.8h, v4.h[0]
        stur	q27, [x0, #-0x20]
        stur	q23, [x0, #-0x40]
        ret
        .cfi_endproc

