/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.IOException;
import java.util.Deque;
import nu.validator.servlet.OutlineBuildingXMLReaderWrapper;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XhtmlOutlineEmitter {
    private static final char[] OUTLINE = "Outline".toCharArray();
    private final Deque<OutlineBuildingXMLReaderWrapper.Section> outline;
    private final XhtmlSaxEmitter emitter;
    private final AttributesImpl attrs = new AttributesImpl();
    boolean hasH1 = false;
    boolean hasH2 = false;
    boolean hasH3 = false;
    boolean hasH4 = false;
    boolean hasH5 = false;
    boolean emittedDummyH1 = false;
    boolean emittedDummyH2 = false;
    boolean emittedDummyH3 = false;
    boolean emittedDummyH4 = false;
    boolean emittedDummyH5 = false;

    public XhtmlOutlineEmitter(ContentHandler contentHandler, Deque<OutlineBuildingXMLReaderWrapper.Section> outline) {
        this.emitter = new XhtmlSaxEmitter(contentHandler);
        this.outline = outline;
    }

    public void emit() throws SAXException {
        this.hasH1 = false;
        this.hasH2 = false;
        this.hasH3 = false;
        this.hasH4 = false;
        this.hasH5 = false;
        this.emittedDummyH1 = false;
        this.emittedDummyH2 = false;
        this.emittedDummyH3 = false;
        this.emittedDummyH4 = false;
        this.emittedDummyH5 = false;
        if (this.outline != null) {
            this.attrs.clear();
            this.attrs.addAttribute("id", "headingoutline");
            this.emitter.startElement("section", this.attrs);
            this.emitter.startElement("h2");
            this.emitter.characters(OUTLINE);
            this.emitter.endElement("h2");
            try {
                this.emitHeadingOutline(this.outline, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.emitter.endElement("section");
        }
    }

    protected void emitOutline(Deque<OutlineBuildingXMLReaderWrapper.Section> outline, int currentDepth) throws IOException, SAXException {
        this.emitter.startElement("ol");
        for (OutlineBuildingXMLReaderWrapper.Section section : outline) {
            Deque<OutlineBuildingXMLReaderWrapper.Section> sections;
            if (!section.getIsMasked()) {
                this.emitter.startElement("li");
                StringBuilder headingText = section.getHeadingTextBuilder();
                if (headingText.length() > 0) {
                    this.emitter.startElementWithClass("span", "heading");
                    this.emitter.characters(headingText.toString().toCharArray());
                    if (section.getSubheadSections() != null) {
                        for (OutlineBuildingXMLReaderWrapper.Section subhead : section.getSubheadSections()) {
                            this.emitter.characters(": ".toCharArray());
                            StringBuilder subheadText = subhead.getHeadingTextBuilder();
                            this.emitter.characters(subheadText.toString().toCharArray());
                        }
                    }
                    this.emitter.endElement("span");
                } else if (section.hasEmptyHeading()) {
                    this.emitter.characters(("[" + section.getElementName() + " element with empty heading]").toCharArray());
                } else if ("h1".equals(section.getElementName()) || "h2".equals(section.getElementName()) || "h3".equals(section.getElementName()) || "h4".equals(section.getElementName()) || "h5".equals(section.getElementName()) || "h6".equals(section.getElementName())) {
                    this.emitter.characters(("[section implied by empty " + section.getElementName() + " element]").toCharArray());
                } else {
                    this.emitter.characters(("[" + section.getElementName() + " element with no heading]").toCharArray());
                }
            }
            if (!(sections = section.sections).isEmpty()) {
                this.emitOutline(sections, currentDepth + 1);
            }
            if (section.getIsMasked()) continue;
            this.emitter.endElement("li");
        }
        this.emitter.endElement("ol");
    }

    protected void emitHeadingOutline(Deque<OutlineBuildingXMLReaderWrapper.Section> outline, int currentDepth) throws IOException, SAXException {
        for (OutlineBuildingXMLReaderWrapper.Section section : outline) {
            Deque<OutlineBuildingXMLReaderWrapper.Section> sections;
            String headingName = section.getHeadingElementName();
            if ("h1".equals(headingName)) {
                this.hasH1 = true;
                this.hasH2 = false;
                this.hasH3 = false;
                this.hasH4 = false;
                this.hasH5 = false;
                this.emittedDummyH2 = false;
                this.emittedDummyH3 = false;
                this.emittedDummyH4 = false;
                this.emittedDummyH5 = false;
            } else if ("h2".equals(headingName)) {
                this.hasH2 = true;
                this.hasH3 = false;
                this.hasH4 = false;
                this.hasH5 = false;
                this.emittedDummyH3 = false;
                this.emittedDummyH4 = false;
                this.emittedDummyH5 = false;
            } else if ("h3".equals(headingName)) {
                this.hasH3 = true;
                this.hasH4 = false;
                this.hasH5 = false;
                this.emittedDummyH4 = false;
                this.emittedDummyH5 = false;
            } else if ("h4".equals(headingName)) {
                this.hasH4 = true;
                this.hasH5 = false;
                this.emittedDummyH5 = false;
            } else if ("h5".equals(headingName)) {
                this.hasH5 = true;
            }
            if ("h1".equals(headingName) || "h2".equals(headingName) || "h3".equals(headingName) || "h4".equals(headingName) || "h5".equals(headingName) || "h6".equals(headingName)) {
                StringBuilder headingText = section.getHeadingTextBuilder();
                if (!("h1".equals(headingName) || this.hasH1 || this.emittedDummyH1)) {
                    this.emitMissingHeading("h1");
                    this.emittedDummyH1 = true;
                }
                if (!("h1".equals(headingName) || "h2".equals(headingName) || this.hasH2 || this.emittedDummyH2)) {
                    this.emitMissingHeading("h2");
                    this.emittedDummyH2 = true;
                }
                if (!("h1".equals(headingName) || "h2".equals(headingName) || "h3".equals(headingName) || this.hasH3 || this.emittedDummyH3)) {
                    this.emitMissingHeading("h3");
                    this.emittedDummyH3 = true;
                }
                if (!("h1".equals(headingName) || "h2".equals(headingName) || "h3".equals(headingName) || "h4".equals(headingName) || this.hasH4 || this.emittedDummyH4)) {
                    this.emitMissingHeading("h4");
                    this.emittedDummyH4 = true;
                }
                if ("h6".equals(headingName) && !this.hasH5 && !this.emittedDummyH5) {
                    this.emitMissingHeading("h5");
                    this.emittedDummyH5 = true;
                }
                this.emitter.startElementWithClass("p", headingName);
                this.emitter.startElementWithClass("span", "headinglevel");
                this.emitter.characters(("<" + headingName + ">").toCharArray());
                this.emitter.endElement("span");
                if (headingText.length() > 0) {
                    this.emitter.characters((" " + headingText.toString()).toCharArray());
                } else {
                    this.emitter.startElementWithClass("span", "missingheading");
                    this.emitter.characters(" [empty]".toCharArray());
                    this.emitter.endElement("span");
                }
                this.emitter.endElement("p");
            }
            if ((sections = section.sections).isEmpty()) continue;
            this.emitHeadingOutline(sections, currentDepth + 1);
        }
    }

    private void emitMissingHeading(String headingName) throws SAXException {
        this.emitter.startElementWithClass("p", headingName);
        this.emitter.startElementWithClass("span", "missingheadinglevel");
        this.emitter.characters(("<" + headingName + ">").toCharArray());
        this.emitter.endElement("span");
        this.emitter.startElementWithClass("span", "missingheading");
        this.emitter.characters(" [missing]".toCharArray());
        this.emitter.endElement("span");
        this.emitter.endElement("p");
    }
}

