//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage

import "time"

// Account - The storage account.
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Properties of the storage account.
	Properties *AccountProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the Kind.
	Kind *Kind `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the SKU.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountCheckNameAvailabilityParameters - The parameters used to check the availability of the storage account name.
type AccountCheckNameAvailabilityParameters struct {
	// REQUIRED; The storage account name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Storage/storageAccounts
	// Field has constant value "Microsoft.Storage/storageAccounts", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters - The parameters used when creating a storage account.
type AccountCreateParameters struct {
	// REQUIRED; Required. Indicates the type of storage account.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo
	// Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource
	// cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Required. Gets or sets the SKU name.
	SKU *SKU `json:"sku,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The parameters used to create the storage account.
	Properties *AccountPropertiesCreateParameters `json:"properties,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than
	// 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountInternetEndpoints - The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via
// a internet routing endpoint.
type AccountInternetEndpoints struct {
	// READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty" azure:"ro"`

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty" azure:"ro"`

	// READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty" azure:"ro"`
}

// AccountKey - An access key for the storage account.
type AccountKey struct {
	// READ-ONLY; Name of the key.
	KeyName *string `json:"keyName,omitempty" azure:"ro"`

	// READ-ONLY; Permissions for the key -- read-only or full permissions.
	Permissions *KeyPermission `json:"permissions,omitempty" azure:"ro"`

	// READ-ONLY; Base 64-encoded value of the key.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// AccountListKeysResult - The response from the ListKeys operation.
type AccountListKeysResult struct {
	// READ-ONLY; Gets the list of storage account keys and their properties for the specified storage account.
	Keys []*AccountKey `json:"keys,omitempty" azure:"ro"`
}

// AccountListResult - The response from the List Storage Accounts operation.
type AccountListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of storage accounts. Returned when total number of requested
	// storage accounts exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the list of storage accounts and their properties.
	Value []*Account `json:"value,omitempty" azure:"ro"`
}

// AccountMicrosoftEndpoints - The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object
// via a microsoft routing endpoint.
type AccountMicrosoftEndpoints struct {
	// READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty" azure:"ro"`

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty" azure:"ro"`

	// READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty" azure:"ro"`

	// READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty" azure:"ro"`
}

// AccountProperties - Properties of the storage account.
type AccountProperties struct {
	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for
	// this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`

	// Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`

	// Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState `json:"largeFileSharesState,omitempty"`

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`

	// READ-ONLY; Required for storage accounts where kind = BlobStorage. The access tier used for billing.
	AccessTier *AccessTier `json:"accessTier,omitempty" azure:"ro"`

	// READ-ONLY; Blob restore status
	BlobRestoreStatus *BlobRestoreStatus `json:"blobRestoreStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets the creation date and time of the storage account in UTC.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the custom domain the user assigned to this storage account.
	CustomDomain *CustomDomain `json:"customDomain,omitempty" azure:"ro"`

	// READ-ONLY; Gets the encryption settings on the account. If unspecified, the account is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty" azure:"ro"`

	// READ-ONLY; If the failover is in progress, the value will be true, otherwise, it will be null.
	FailoverInProgress *bool `json:"failoverInProgress,omitempty" azure:"ro"`

	// READ-ONLY; Geo Replication Stats
	GeoReplicationStats *GeoReplicationStats `json:"geoReplicationStats,omitempty" azure:"ro"`

	// READ-ONLY; Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent
	// timestamp is retained. This element is not returned if there has never been a failover
	// instance. Only available if the accountType is StandardGRS or StandardRAGRS.
	LastGeoFailoverTime *time.Time `json:"lastGeoFailoverTime,omitempty" azure:"ro"`

	// READ-ONLY; Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty" azure:"ro"`

	// READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that StandardZRS
	// and PremiumLRS accounts only return the blob endpoint.
	PrimaryEndpoints *Endpoints `json:"primaryEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; Gets the location of the primary data center for the storage account.
	PrimaryLocation *string `json:"primaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connection associated with the specified storage account
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status of the storage account at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary
	// location of the storage account. Only available if the SKU name is Standard_RAGRS.
	SecondaryEndpoints *Endpoints `json:"secondaryEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType
	// is StandardGRS or StandardRAGRS.
	SecondaryLocation *string `json:"secondaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status indicating whether the primary location of the storage account is available or unavailable.
	StatusOfPrimary *AccountStatus `json:"statusOfPrimary,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status indicating whether the secondary location of the storage account is available or unavailable.
	// Only available if the SKU name is StandardGRS or StandardRAGRS.
	StatusOfSecondary *AccountStatus `json:"statusOfSecondary,omitempty" azure:"ro"`
}

// AccountPropertiesCreateParameters - The parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	// Required for storage accounts where kind = BlobStorage. The access tier used for billing.
	AccessTier *AccessTier `json:"accessTier,omitempty"`

	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for
	// this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`

	// User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage
	// account at this time. To clear the existing custom domain, use an empty string
	// for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`

	// Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`

	// Not applicable. Azure Storage encryption is enabled for all storage accounts and cannot be disabled.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState `json:"largeFileSharesState,omitempty"`

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
}

// AccountPropertiesUpdateParameters - The parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	// Required for storage accounts where kind = BlobStorage. The access tier used for billing.
	AccessTier *AccessTier `json:"accessTier,omitempty"`

	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for
	// this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`

	// Custom domain assigned to the storage account by the user. Name is the CNAME source. Only one custom domain is supported
	// per storage account at this time. To clear the existing custom domain, use an
	// empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`

	// Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`

	// Provides the encryption settings on the account. The default setting is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState `json:"largeFileSharesState,omitempty"`

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
}

// AccountRegenerateKeyParameters - The parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	// REQUIRED; The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1, kerb2.
	KeyName *string `json:"keyName,omitempty"`
}

// AccountSasParameters - The parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	// REQUIRED; The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l),
	// Add (a), Create (c), Update (u) and Process (p).
	Permissions *Permissions `json:"signedPermission,omitempty"`

	// REQUIRED; The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs;
	// Container (c): Access to container-level APIs; Object (o): Access to object-level APIs
	// for blobs, queue messages, table entities, and files.
	ResourceTypes *SignedResourceTypes `json:"signedResourceTypes,omitempty"`

	// REQUIRED; The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t),
	// File (f).
	Services *Services `json:"signedServices,omitempty"`

	// REQUIRED; The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *time.Time `json:"signedExpiry,omitempty"`

	// An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`

	// The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`

	// The protocol permitted for a request made with the account SAS.
	Protocols *HTTPProtocol `json:"signedProtocol,omitempty"`

	// The time at which the SAS becomes valid.
	SharedAccessStartTime *time.Time `json:"signedStart,omitempty"`
}

// AccountUpdateParameters - The parameters that can be provided when updating the storage account properties.
type AccountUpdateParameters struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Optional. Indicates the type of storage account. Currently only StorageV2 value supported by server.
	Kind *Kind `json:"kind,omitempty"`

	// The parameters used when updating a storage account.
	Properties *AccountPropertiesUpdateParameters `json:"properties,omitempty"`

	// Gets or sets the SKU name. Note that the SKU name cannot be updated to StandardZRS, PremiumLRS or Premium_ZRS, nor can
	// accounts of those SKU names be updated to any other value.
	SKU *SKU `json:"sku,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginFailoverOptions contains the optional parameters for the AccountsClient.BeginFailover method.
type AccountsClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginRestoreBlobRangesOptions contains the optional parameters for the AccountsClient.BeginRestoreBlobRanges
// method.
type AccountsClientBeginRestoreBlobRangesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientCheckNameAvailabilityOptions contains the optional parameters for the AccountsClient.CheckNameAvailability
// method.
type AccountsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientDeleteOptions contains the optional parameters for the AccountsClient.Delete method.
type AccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientGetPropertiesOptions contains the optional parameters for the AccountsClient.GetProperties method.
type AccountsClientGetPropertiesOptions struct {
	// May be used to expand the properties within account's properties. By default, data is not included when fetching properties.
	// Currently we only support geoReplicationStats and blobRestoreStatus.
	Expand *StorageAccountExpand
}

// AccountsClientListAccountSASOptions contains the optional parameters for the AccountsClient.ListAccountSAS method.
type AccountsClientListAccountSASOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.NewListByResourceGroupPager
// method.
type AccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListKeysOptions contains the optional parameters for the AccountsClient.ListKeys method.
type AccountsClientListKeysOptions struct {
	// Specifies type of the key to be listed. Possible value is kerb.. Specifying any value will set the value to kerb.
	Expand *string
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.NewListPager method.
type AccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListServiceSASOptions contains the optional parameters for the AccountsClient.ListServiceSAS method.
type AccountsClientListServiceSASOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientRegenerateKeyOptions contains the optional parameters for the AccountsClient.RegenerateKey method.
type AccountsClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientRevokeUserDelegationKeysOptions contains the optional parameters for the AccountsClient.RevokeUserDelegationKeys
// method.
type AccountsClientRevokeUserDelegationKeysOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientUpdateOptions contains the optional parameters for the AccountsClient.Update method.
type AccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActiveDirectoryProperties - Settings properties for Active Directory (AD).
type ActiveDirectoryProperties struct {
	// REQUIRED; Specifies the security identifier (SID) for Azure Storage.
	AzureStorageSid *string `json:"azureStorageSid,omitempty"`

	// REQUIRED; Specifies the domain GUID.
	DomainGUID *string `json:"domainGuid,omitempty"`

	// REQUIRED; Specifies the primary domain that the AD DNS server is authoritative for.
	DomainName *string `json:"domainName,omitempty"`

	// REQUIRED; Specifies the security identifier (SID).
	DomainSid *string `json:"domainSid,omitempty"`

	// REQUIRED; Specifies the Active Directory forest to get.
	ForestName *string `json:"forestName,omitempty"`

	// REQUIRED; Specifies the NetBIOS domain name.
	NetBiosDomainName *string `json:"netBiosDomainName,omitempty"`
}

// AzureFilesIdentityBasedAuthentication - Settings for Azure Files identity based authentication.
type AzureFilesIdentityBasedAuthentication struct {
	// REQUIRED; Indicates the directory service used.
	DirectoryServiceOptions *DirectoryServiceOptions `json:"directoryServiceOptions,omitempty"`

	// Required if choose AD.
	ActiveDirectoryProperties *ActiveDirectoryProperties `json:"activeDirectoryProperties,omitempty"`
}

// BlobInventoryPoliciesClientCreateOrUpdateOptions contains the optional parameters for the BlobInventoryPoliciesClient.CreateOrUpdate
// method.
type BlobInventoryPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientDeleteOptions contains the optional parameters for the BlobInventoryPoliciesClient.Delete method.
type BlobInventoryPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientGetOptions contains the optional parameters for the BlobInventoryPoliciesClient.Get method.
type BlobInventoryPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientListOptions contains the optional parameters for the BlobInventoryPoliciesClient.NewListPager
// method.
type BlobInventoryPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPolicy - The storage account blob inventory policy.
type BlobInventoryPolicy struct {
	// Returns the storage account blob inventory policy rules.
	Properties *BlobInventoryPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BlobInventoryPolicyDefinition - An object that defines the blob inventory rule. Each definition consists of a set of filters.
type BlobInventoryPolicyDefinition struct {
	// REQUIRED; An object that defines the filter set.
	Filters *BlobInventoryPolicyFilter `json:"filters,omitempty"`
}

// BlobInventoryPolicyFilter - An object that defines the blob inventory rule filter conditions.
type BlobInventoryPolicyFilter struct {
	// REQUIRED; An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not
	// support pageBlobs.
	BlobTypes []*string `json:"blobTypes,omitempty"`

	// Includes blob versions in blob inventory when value set to true.
	IncludeBlobVersions *bool `json:"includeBlobVersions,omitempty"`

	// Includes blob snapshots in blob inventory when value set to true.
	IncludeSnapshots *bool `json:"includeSnapshots,omitempty"`

	// An array of strings for blob prefixes to be matched.
	PrefixMatch []*string `json:"prefixMatch,omitempty"`
}

// BlobInventoryPolicyProperties - The storage account blob inventory policy properties.
type BlobInventoryPolicyProperties struct {
	// REQUIRED; The storage account blob inventory policy object. It is composed of policy rules.
	Policy *BlobInventoryPolicySchema `json:"policy,omitempty"`

	// READ-ONLY; Returns the last modified date and time of the blob inventory policy.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// BlobInventoryPolicyRule - An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
type BlobInventoryPolicyRule struct {
	// REQUIRED; An object that defines the blob inventory policy rule.
	Definition *BlobInventoryPolicyDefinition `json:"definition,omitempty"`

	// REQUIRED; Rule is enabled when set to true.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
	// unique within a policy.
	Name *string `json:"name,omitempty"`
}

// BlobInventoryPolicySchema - The storage account blob inventory policy rules.
type BlobInventoryPolicySchema struct {
	// REQUIRED; Container name where blob inventory files are stored. Must be pre-created.
	Destination *string `json:"destination,omitempty"`

	// REQUIRED; Policy is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; The storage account blob inventory policy rules. The rule is applied when it is enabled.
	Rules []*BlobInventoryPolicyRule `json:"rules,omitempty"`

	// REQUIRED; The valid value is Inventory
	Type *InventoryRuleType `json:"type,omitempty"`
}

// BlobRestoreParameters - Blob restore parameters
type BlobRestoreParameters struct {
	// REQUIRED; Blob ranges to restore.
	BlobRanges []*BlobRestoreRange `json:"blobRanges,omitempty"`

	// REQUIRED; Restore blob to the specified time.
	TimeToRestore *time.Time `json:"timeToRestore,omitempty"`
}

// BlobRestoreRange - Blob range
type BlobRestoreRange struct {
	// REQUIRED; Blob end range. This is exclusive. Empty means account end.
	EndRange *string `json:"endRange,omitempty"`

	// REQUIRED; Blob start range. This is inclusive. Empty means account start.
	StartRange *string `json:"startRange,omitempty"`
}

// BlobRestoreStatus - Blob restore status.
type BlobRestoreStatus struct {
	// READ-ONLY; Failure reason when blob restore is failed.
	FailureReason *string `json:"failureReason,omitempty" azure:"ro"`

	// READ-ONLY; Blob restore request parameters.
	Parameters *BlobRestoreParameters `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; Id for tracking blob restore request.
	RestoreID *string `json:"restoreId,omitempty" azure:"ro"`

	// READ-ONLY; The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing.
	// - Complete: Indicates that blob restore has been completed successfully. - Failed:
	// Indicates that blob restore is failed.
	Status *BlobRestoreProgressStatus `json:"status,omitempty" azure:"ro"`
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reason that a storage account name could not be used. The Reason element is only returned if NameAvailable
	// is false.
	Reason *Reason `json:"reason,omitempty" azure:"ro"`
}

// CustomDomain - The custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	// REQUIRED; Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
	Name *string `json:"name,omitempty"`

	// Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
	UseSubDomainName *bool `json:"useSubDomainName,omitempty"`
}

// DateAfterCreation - Object to define the number of days after creation.
type DateAfterCreation struct {
	// REQUIRED; Value indicating the age in days after creation
	DaysAfterCreationGreaterThan *float32 `json:"daysAfterCreationGreaterThan,omitempty"`
}

// DateAfterModification - Object to define the number of days after object last modification Or last access. Properties daysAfterModificationGreaterThan
// and daysAfterLastAccessTimeGreaterThan are mutually exclusive.
type DateAfterModification struct {
	// Value indicating the age in days after last blob access. This property can only be used in conjunction with last access
	// time tracking policy
	DaysAfterLastAccessTimeGreaterThan *float32 `json:"daysAfterLastAccessTimeGreaterThan,omitempty"`

	// Value indicating the age in days after last modification
	DaysAfterModificationGreaterThan *float32 `json:"daysAfterModificationGreaterThan,omitempty"`
}

// Dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Display name of dimension.
	Name *string `json:"name,omitempty"`
}

// Encryption - The encryption settings on the storage account.
type Encryption struct {
	// REQUIRED; The encryption keySource (provider). Possible values (case-insensitive): Microsoft.Storage, Microsoft.Keyvault
	KeySource *KeySource `json:"keySource,omitempty"`

	// Properties provided by key vault.
	KeyVaultProperties *KeyVaultProperties `json:"keyvaultproperties,omitempty"`

	// A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for
	// data at rest.
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`

	// List of services which support encryption.
	Services *EncryptionServices `json:"services,omitempty"`
}

// EncryptionScope - The Encryption Scope resource.
type EncryptionScope struct {
	// Properties of the encryption scope.
	EncryptionScopeProperties *EncryptionScopeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EncryptionScopeKeyVaultProperties - The key vault properties for the encryption scope. This is a required field if encryption
// scope 'source' attribute is set to 'Microsoft.KeyVault'.
type EncryptionScopeKeyVaultProperties struct {
	// The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the
	// identifier to enable customer-managed key support on this encryption scope.
	KeyURI *string `json:"keyUri,omitempty"`
}

// EncryptionScopeListResult - List of encryption scopes requested, and if paging is required, a URL to the next page of encryption
// scopes.
type EncryptionScopeListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of encryption scopes. Returned when total number of requested
	// encryption scopes exceeds the maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of encryption scopes requested.
	Value []*EncryptionScope `json:"value,omitempty" azure:"ro"`
}

// EncryptionScopeProperties - Properties of the encryption scope.
type EncryptionScopeProperties struct {
	// The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set
	// to 'Microsoft.KeyVault'.
	KeyVaultProperties *EncryptionScopeKeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// The provider for the encryption scope. Possible values (case-insensitive): Microsoft.Storage, Microsoft.KeyVault.
	Source *EncryptionScopeSource `json:"source,omitempty"`

	// The state of the encryption scope. Possible values (case-insensitive): Enabled, Disabled.
	State *EncryptionScopeState `json:"state,omitempty"`

	// READ-ONLY; Gets the creation date and time of the encryption scope in UTC.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modification date and time of the encryption scope in UTC.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// EncryptionScopesClientGetOptions contains the optional parameters for the EncryptionScopesClient.Get method.
type EncryptionScopesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EncryptionScopesClientListOptions contains the optional parameters for the EncryptionScopesClient.NewListPager method.
type EncryptionScopesClientListOptions struct {
	// placeholder for future optional parameters
}

// EncryptionScopesClientPatchOptions contains the optional parameters for the EncryptionScopesClient.Patch method.
type EncryptionScopesClientPatchOptions struct {
	// placeholder for future optional parameters
}

// EncryptionScopesClientPutOptions contains the optional parameters for the EncryptionScopesClient.Put method.
type EncryptionScopesClientPutOptions struct {
	// placeholder for future optional parameters
}

// EncryptionService - A service that allows server-side encryption to be used.
type EncryptionService struct {
	// A boolean indicating whether or not the service encrypts the data as it is stored.
	Enabled *bool `json:"enabled,omitempty"`

	// Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption
	// key will be used. 'Service' key type implies that a default service key is used.
	KeyType *KeyType `json:"keyType,omitempty"`

	// READ-ONLY; Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when
	// encryption is enabled. There might be some unencrypted blobs which were written after this
	// time, as it is just a rough estimate.
	LastEnabledTime *time.Time `json:"lastEnabledTime,omitempty" azure:"ro"`
}

// EncryptionServices - A list of services that support encryption.
type EncryptionServices struct {
	// The encryption function of the blob storage service.
	Blob *EncryptionService `json:"blob,omitempty"`

	// The encryption function of the file storage service.
	File *EncryptionService `json:"file,omitempty"`

	// The encryption function of the queue storage service.
	Queue *EncryptionService `json:"queue,omitempty"`

	// The encryption function of the table storage service.
	Table *EncryptionService `json:"table,omitempty"`
}

// Endpoints - The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
type Endpoints struct {
	// Gets the internet routing storage endpoints
	InternetEndpoints *AccountInternetEndpoints `json:"internetEndpoints,omitempty"`

	// Gets the microsoft routing storage endpoints.
	MicrosoftEndpoints *AccountMicrosoftEndpoints `json:"microsoftEndpoints,omitempty"`

	// READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty" azure:"ro"`

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty" azure:"ro"`

	// READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty" azure:"ro"`

	// READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty" azure:"ro"`
}

// ErrorResponse - An error response from the storage resource provider.
type ErrorResponse struct {
	// Azure Storage Resource Provider error response body.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody - Error response body contract.
type ErrorResponseBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// GeoReplicationStats - Statistics related to replication for storage account's Blob, Table, Queue and File services. It
// is only available when geo-redundant replication is enabled for the storage account.
type GeoReplicationStats struct {
	// READ-ONLY; A boolean flag which indicates whether or not account failover is supported for the account.
	CanFailover *bool `json:"canFailover,omitempty" azure:"ro"`

	// READ-ONLY; All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary
	// writes following this point in time may or may not be available for reads. Element may
	// be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
	LastSyncTime *time.Time `json:"lastSyncTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is
	// active and operational. - Bootstrap: Indicates initial synchronization from the primary
	// location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable:
	// Indicates that the secondary location is temporarily unavailable.
	Status *GeoReplicationStatus `json:"status,omitempty" azure:"ro"`
}

// IPRule - IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// REQUIRED; Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`

	// The action of IP ACL rule.
	Action *string `json:"action,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// CONSTANT; The identity type.
	// Field has constant value "SystemAssigned", any specified value is ignored.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KeyVaultProperties - Properties of key vault.
type KeyVaultProperties struct {
	// The name of KeyVault key.
	KeyName *string `json:"keyname,omitempty"`

	// The Uri of KeyVault.
	KeyVaultURI *string `json:"keyvaulturi,omitempty"`

	// The version of KeyVault key.
	KeyVersion *string `json:"keyversion,omitempty"`

	// READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string `json:"currentVersionedKeyIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *time.Time `json:"lastKeyRotationTimestamp,omitempty" azure:"ro"`
}

// ListAccountSasResponse - The List SAS credentials operation response.
type ListAccountSasResponse struct {
	// READ-ONLY; List SAS credentials of storage account.
	AccountSasToken *string `json:"accountSasToken,omitempty" azure:"ro"`
}

// ListBlobInventoryPolicy - List of blob inventory policies returned.
type ListBlobInventoryPolicy struct {
	// READ-ONLY; List of blob inventory policies.
	Value []*BlobInventoryPolicy `json:"value,omitempty" azure:"ro"`
}

// ListServiceSasResponse - The List service SAS credentials operation response.
type ListServiceSasResponse struct {
	// READ-ONLY; List service SAS credentials of specific resource.
	ServiceSasToken *string `json:"serviceSasToken,omitempty" azure:"ro"`
}

// ManagementPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ManagementPoliciesClient.CreateOrUpdate
// method.
type ManagementPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagementPoliciesClientDeleteOptions contains the optional parameters for the ManagementPoliciesClient.Delete method.
type ManagementPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagementPoliciesClientGetOptions contains the optional parameters for the ManagementPoliciesClient.Get method.
type ManagementPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagementPolicy - The Get Storage Account ManagementPolicies operation response.
type ManagementPolicy struct {
	// Returns the Storage Account Data Policies Rules.
	Properties *ManagementPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagementPolicyAction - Actions are applied to the filtered blobs when the execution condition is met.
type ManagementPolicyAction struct {
	// The management policy action for base blob
	BaseBlob *ManagementPolicyBaseBlob `json:"baseBlob,omitempty"`

	// The management policy action for snapshot
	Snapshot *ManagementPolicySnapShot `json:"snapshot,omitempty"`

	// The management policy action for version
	Version *ManagementPolicyVersion `json:"version,omitempty"`
}

// ManagementPolicyBaseBlob - Management policy action for base blob.
type ManagementPolicyBaseBlob struct {
	// The function to delete the blob
	Delete *DateAfterModification `json:"delete,omitempty"`

	// This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
	EnableAutoTierToHotFromCool *bool `json:"enableAutoTierToHotFromCool,omitempty"`

	// The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
	TierToArchive *DateAfterModification `json:"tierToArchive,omitempty"`

	// The function to tier blobs to cool storage. Support blobs currently at Hot tier
	TierToCool *DateAfterModification `json:"tierToCool,omitempty"`
}

// ManagementPolicyDefinition - An object that defines the Lifecycle rule. Each definition is made up with a filters set and
// an actions set.
type ManagementPolicyDefinition struct {
	// REQUIRED; An object that defines the action set.
	Actions *ManagementPolicyAction `json:"actions,omitempty"`

	// An object that defines the filter set.
	Filters *ManagementPolicyFilter `json:"filters,omitempty"`
}

// ManagementPolicyFilter - Filters limit rule actions to a subset of blobs within the storage account. If multiple filters
// are defined, a logical AND is performed on all filters.
type ManagementPolicyFilter struct {
	// REQUIRED; An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete
	// actions are supported for appendBlob.
	BlobTypes []*string `json:"blobTypes,omitempty"`

	// An array of blob index tag based filters, there can be at most 10 tag filters
	BlobIndexMatch []*TagFilter `json:"blobIndexMatch,omitempty"`

	// An array of strings for prefixes to be match.
	PrefixMatch []*string `json:"prefixMatch,omitempty"`
}

// ManagementPolicyProperties - The Storage Account ManagementPolicy properties.
type ManagementPolicyProperties struct {
	// REQUIRED; The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Policy *ManagementPolicySchema `json:"policy,omitempty"`

	// READ-ONLY; Returns the date and time the ManagementPolicies was last modified.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// ManagementPolicyRule - An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
type ManagementPolicyRule struct {
	// REQUIRED; An object that defines the Lifecycle rule.
	Definition *ManagementPolicyDefinition `json:"definition,omitempty"`

	// REQUIRED; A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
	// unique within a policy.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The valid value is Lifecycle
	Type *RuleType `json:"type,omitempty"`

	// Rule is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagementPolicySchema - The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
type ManagementPolicySchema struct {
	// REQUIRED; The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Rules []*ManagementPolicyRule `json:"rules,omitempty"`
}

// ManagementPolicySnapShot - Management policy action for snapshot.
type ManagementPolicySnapShot struct {
	// The function to delete the blob snapshot
	Delete *DateAfterCreation `json:"delete,omitempty"`

	// The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
	TierToArchive *DateAfterCreation `json:"tierToArchive,omitempty"`

	// The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
	TierToCool *DateAfterCreation `json:"tierToCool,omitempty"`
}

// ManagementPolicyVersion - Management policy action for blob version.
type ManagementPolicyVersion struct {
	// The function to delete the blob version
	Delete *DateAfterCreation `json:"delete,omitempty"`

	// The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
	TierToArchive *DateAfterCreation `json:"tierToArchive,omitempty"`

	// The function to tier blob version to cool storage. Support blob version currently at Hot tier
	TierToCool *DateAfterCreation `json:"tierToCool,omitempty"`
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`

	// Dimensions of blobs, including blob type and access tier.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
}

// NetworkRuleSet - Network rule set
type NetworkRuleSet struct {
	// REQUIRED; Specifies the default action of allow or deny when no other rules match.
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices
	// (For example, "Logging, Metrics"), or None to bypass none
	// of those traffics.
	Bypass *Bypass `json:"bypass,omitempty"`

	// Sets the IP ACL rules
	IPRules []*IPRule `json:"ipRules,omitempty"`

	// Sets the virtual network rules
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// ObjectReplicationPolicies - List storage account object replication policies.
type ObjectReplicationPolicies struct {
	// The replication policy between two storage accounts.
	Value []*ObjectReplicationPolicy `json:"value,omitempty"`
}

// ObjectReplicationPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ObjectReplicationPoliciesClient.CreateOrUpdate
// method.
type ObjectReplicationPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPoliciesClientDeleteOptions contains the optional parameters for the ObjectReplicationPoliciesClient.Delete
// method.
type ObjectReplicationPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPoliciesClientGetOptions contains the optional parameters for the ObjectReplicationPoliciesClient.Get
// method.
type ObjectReplicationPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPoliciesClientListOptions contains the optional parameters for the ObjectReplicationPoliciesClient.NewListPager
// method.
type ObjectReplicationPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPolicy - The replication policy between two storage accounts. Multiple rules can be defined in one policy.
type ObjectReplicationPolicy struct {
	// Returns the Storage Account Object Replication Policy.
	Properties *ObjectReplicationPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ObjectReplicationPolicyFilter - Filters limit replication to a subset of blobs within the storage account. A logical OR
// is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all
// filters.
type ObjectReplicationPolicyFilter struct {
	// Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'.
	// Example: 2020-02-19T16:05:00Z
	MinCreationTime *string `json:"minCreationTime,omitempty"`

	// Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
	PrefixMatch []*string `json:"prefixMatch,omitempty"`
}

// ObjectReplicationPolicyProperties - The Storage Account ObjectReplicationPolicy properties.
type ObjectReplicationPolicyProperties struct {
	// REQUIRED; Required. Destination account name.
	DestinationAccount *string `json:"destinationAccount,omitempty"`

	// REQUIRED; Required. Source account name.
	SourceAccount *string `json:"sourceAccount,omitempty"`

	// The storage account object replication rules.
	Rules []*ObjectReplicationPolicyRule `json:"rules,omitempty"`

	// READ-ONLY; Indicates when the policy is enabled on the source account.
	EnabledTime *time.Time `json:"enabledTime,omitempty" azure:"ro"`

	// READ-ONLY; A unique id for object replication policy.
	PolicyID *string `json:"policyId,omitempty" azure:"ro"`
}

// ObjectReplicationPolicyRule - The replication policy rule between two containers.
type ObjectReplicationPolicyRule struct {
	// REQUIRED; Required. Destination container name.
	DestinationContainer *string `json:"destinationContainer,omitempty"`

	// REQUIRED; Required. Source container name.
	SourceContainer *string `json:"sourceContainer,omitempty"`

	// Optional. An object that defines the filter set.
	Filters *ObjectReplicationPolicyFilter `json:"filters,omitempty"`

	// Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
	RuleID *string `json:"ruleId,omitempty"`
}

// Operation - Storage REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties `json:"properties,omitempty"`

	// The origin of operations.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Storage.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Storage operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Delete
// method.
type PrivateEndpointConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.NewListPager
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientPutOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Put
// method.
type PrivateEndpointConnectionsClientPutOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByStorageAccountOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByStorageAccount
// method.
type PrivateLinkResourcesClientListByStorageAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionRequired *string `json:"actionRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Restriction - The restriction because of which SKU cannot be used.
type Restriction struct {
	// The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when
	// the SKU has requiredQuotas parameter as the subscription does not belong to that
	// quota. The "NotAvailableForSubscription" is related to capacity at DC.
	ReasonCode *ReasonCode `json:"reasonCode,omitempty"`

	// READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// RoutingPreference - Routing preference defines the type of network, either microsoft or internet routing to be used to
// deliver the user data, the default option is microsoft routing
type RoutingPreference struct {
	// A boolean flag which indicates whether internet routing storage endpoints are to be published
	PublishInternetEndpoints *bool `json:"publishInternetEndpoints,omitempty"`

	// A boolean flag which indicates whether microsoft routing storage endpoints are to be published
	PublishMicrosoftEndpoints *bool `json:"publishMicrosoftEndpoints,omitempty"`

	// Routing Choice defines the kind of network routing opted by the user.
	RoutingChoice *RoutingChoice `json:"routingChoice,omitempty"`
}

// SKU - The SKU of the storage account.
type SKU struct {
	// REQUIRED; The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called
	// accountType.
	Name *SKUName `json:"name,omitempty"`

	// READ-ONLY; The SKU tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// SKUCapability - The capability information in the specified SKU, including file encryption, network ACLs, change notification,
// etc.
type SKUCapability struct {
	// READ-ONLY; The name of capability, The capability information in the specified SKU, including file encryption, network
	// ACLs, change notification, etc.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; A string value to indicate states of given capability. Possibly 'true' or 'false'.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// SKUInformation - Storage SKU and its properties
type SKUInformation struct {
	// REQUIRED; The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called
	// accountType.
	Name *SKUName `json:"name,omitempty"`

	// The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*Restriction `json:"restrictions,omitempty"`

	// READ-ONLY; The capability information in the specified SKU, including file encryption, network ACLs, change notification,
	// etc.
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Indicates the type of storage account.
	Kind *Kind `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g.
	// West US, East US, Southeast Asia, etc.).
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource, usually it is 'storageAccounts'.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The SKU tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// SKUListResult - The response from the List Storage SKUs operation.
type SKUListResult struct {
	// READ-ONLY; Get the list result of storage SKUs and their properties.
	Value []*SKUInformation `json:"value,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.NewListPager method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceSasParameters - The parameters to list service SAS credentials of a specific resource.
type ServiceSasParameters struct {
	// REQUIRED; The canonical path to the signed resource.
	CanonicalizedResource *string `json:"canonicalizedResource,omitempty"`

	// The response header override for cache control.
	CacheControl *string `json:"rscc,omitempty"`

	// The response header override for content disposition.
	ContentDisposition *string `json:"rscd,omitempty"`

	// The response header override for content encoding.
	ContentEncoding *string `json:"rsce,omitempty"`

	// The response header override for content language.
	ContentLanguage *string `json:"rscl,omitempty"`

	// The response header override for content type.
	ContentType *string `json:"rsct,omitempty"`

	// An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`

	// A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or
	// table.
	Identifier *string `json:"signedIdentifier,omitempty"`

	// The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`

	// The end of partition key.
	PartitionKeyEnd *string `json:"endPk,omitempty"`

	// The start of partition key.
	PartitionKeyStart *string `json:"startPk,omitempty"`

	// The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a),
	// Create (c), Update (u) and Process (p).
	Permissions *Permissions `json:"signedPermission,omitempty"`

	// The protocol permitted for a request made with the account SAS.
	Protocols *HTTPProtocol `json:"signedProtocol,omitempty"`

	// The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share
	// (s).
	Resource *SignedResource `json:"signedResource,omitempty"`

	// The end of row key.
	RowKeyEnd *string `json:"endRk,omitempty"`

	// The start of row key.
	RowKeyStart *string `json:"startRk,omitempty"`

	// The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *time.Time `json:"signedExpiry,omitempty"`

	// The time at which the SAS becomes valid.
	SharedAccessStartTime *time.Time `json:"signedStart,omitempty"`
}

// ServiceSpecification - One property of operation, include metric specifications.
type ServiceSpecification struct {
	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagFilter - Blob index tag based filtering for blob objects
type TagFilter struct {
	// REQUIRED; This is the filter tag name, it can have 1 - 128 characters
	Name *string `json:"name,omitempty"`

	// REQUIRED; This is the comparison operator which is used for object comparison and filtering. Only == (equality operator)
	// is currently supported
	Op *string `json:"op,omitempty"`

	// REQUIRED; This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
	Value *string `json:"value,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Usage - Describes Storage Resource Usage.
type Usage struct {
	// READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the type of usage.
	Name *UsageName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the unit of measurement.
	Unit *UsageUnit `json:"unit,omitempty" azure:"ro"`
}

// UsageListResult - The response from the List Usages operation.
type UsageListResult struct {
	// Gets or sets the list of Storage Resource Usages.
	Value []*Usage `json:"value,omitempty"`
}

// UsageName - The usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	// READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; Gets a string describing the resource name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// UsagesClientListByLocationOptions contains the optional parameters for the UsagesClient.NewListByLocationPager method.
type UsagesClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkRule - Virtual Network rule.
type VirtualNetworkRule struct {
	// REQUIRED; Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`

	// The action of virtual network rule.
	Action *string `json:"action,omitempty"`

	// Gets the state of virtual network rule.
	State *State `json:"state,omitempty"`
}
