//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armchangeanalysis

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
	"time"
)

// ChangesClient contains the methods for the Changes group.
// Don't use this type directly, use NewChangesClient() instead.
type ChangesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewChangesClient creates a new instance of ChangesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewChangesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ChangesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ChangesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListChangesByResourceGroupPager - List the changes of a resource group within the specified time range. Customer data
// will always be masked.
//
// Generated from API version 2021-04-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - startTime - Specifies the start time of the changes request.
//   - endTime - Specifies the end time of the changes request.
//   - options - ChangesClientListChangesByResourceGroupOptions contains the optional parameters for the ChangesClient.NewListChangesByResourceGroupPager
//     method.
func (client *ChangesClient) NewListChangesByResourceGroupPager(resourceGroupName string, startTime time.Time, endTime time.Time, options *ChangesClientListChangesByResourceGroupOptions) *runtime.Pager[ChangesClientListChangesByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ChangesClientListChangesByResourceGroupResponse]{
		More: func(page ChangesClientListChangesByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ChangesClientListChangesByResourceGroupResponse) (ChangesClientListChangesByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ChangesClient.NewListChangesByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listChangesByResourceGroupCreateRequest(ctx, resourceGroupName, startTime, endTime, options)
			}, nil)
			if err != nil {
				return ChangesClientListChangesByResourceGroupResponse{}, err
			}
			return client.listChangesByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listChangesByResourceGroupCreateRequest creates the ListChangesByResourceGroup request.
func (client *ChangesClient) listChangesByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, startTime time.Time, endTime time.Time, options *ChangesClientListChangesByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ChangeAnalysis/changes"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-04-01")
	reqQP.Set("$startTime", startTime.Format(time.RFC3339Nano))
	reqQP.Set("$endTime", endTime.Format(time.RFC3339Nano))
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listChangesByResourceGroupHandleResponse handles the ListChangesByResourceGroup response.
func (client *ChangesClient) listChangesByResourceGroupHandleResponse(resp *http.Response) (ChangesClientListChangesByResourceGroupResponse, error) {
	result := ChangesClientListChangesByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChangeList); err != nil {
		return ChangesClientListChangesByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListChangesBySubscriptionPager - List the changes of a subscription within the specified time range. Customer data will
// always be masked.
//
// Generated from API version 2021-04-01
//   - startTime - Specifies the start time of the changes request.
//   - endTime - Specifies the end time of the changes request.
//   - options - ChangesClientListChangesBySubscriptionOptions contains the optional parameters for the ChangesClient.NewListChangesBySubscriptionPager
//     method.
func (client *ChangesClient) NewListChangesBySubscriptionPager(startTime time.Time, endTime time.Time, options *ChangesClientListChangesBySubscriptionOptions) *runtime.Pager[ChangesClientListChangesBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ChangesClientListChangesBySubscriptionResponse]{
		More: func(page ChangesClientListChangesBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ChangesClientListChangesBySubscriptionResponse) (ChangesClientListChangesBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ChangesClient.NewListChangesBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listChangesBySubscriptionCreateRequest(ctx, startTime, endTime, options)
			}, nil)
			if err != nil {
				return ChangesClientListChangesBySubscriptionResponse{}, err
			}
			return client.listChangesBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listChangesBySubscriptionCreateRequest creates the ListChangesBySubscription request.
func (client *ChangesClient) listChangesBySubscriptionCreateRequest(ctx context.Context, startTime time.Time, endTime time.Time, options *ChangesClientListChangesBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ChangeAnalysis/changes"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-04-01")
	reqQP.Set("$startTime", startTime.Format(time.RFC3339Nano))
	reqQP.Set("$endTime", endTime.Format(time.RFC3339Nano))
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listChangesBySubscriptionHandleResponse handles the ListChangesBySubscription response.
func (client *ChangesClient) listChangesBySubscriptionHandleResponse(resp *http.Response) (ChangesClientListChangesBySubscriptionResponse, error) {
	result := ChangesClientListChangesBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChangeList); err != nil {
		return ChangesClientListChangesBySubscriptionResponse{}, err
	}
	return result, nil
}
