/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.spi.htmlreport;

import org.apiguardian.api.API;
import org.immutables.value.Value.Immutable;

import java.util.List;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * A block of labels to be rendered in the HTML report.
 *
 * @since 0.2.0
 */
@Immutable
@API(status = EXPERIMENTAL, since = "0.2.0")
public interface Labels extends Block<List<String>> {

	/**
	 * Builder for {@link Labels}.
	 */
	class Builder extends ImmutableLabels.Builder {
		Builder() {
		}
	}

	/**
	 * {@return a new builder for {@link Labels}}
	 */
	static Builder builder() {
		return new Builder();
	}

}
