/* SPDX-License-Identifier: GPL-2.0-or-later */
/* This file was generated by: ./scripts/crypto/gen-hash-testvecs.py polyval */

static const struct {
	size_t data_len;
	u8 digest[POLYVAL_DIGEST_SIZE];
} hash_testvecs[] = {
	{
		.data_len = 0,
		.digest = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		},
	},
	{
		.data_len = 1,
		.digest = {
			0xb5, 0x51, 0x69, 0x89, 0xd4, 0x3c, 0x59, 0xca,
			0x6a, 0x1c, 0x2a, 0xe9, 0xa1, 0x9c, 0x6c, 0x83,
		},
	},
	{
		.data_len = 2,
		.digest = {
			0xf4, 0x50, 0xaf, 0x07, 0xda, 0x42, 0xa7, 0x41,
			0x4d, 0x24, 0x88, 0x87, 0xe3, 0x40, 0x73, 0x7c,
		},
	},
	{
		.data_len = 3,
		.digest = {
			0x9e, 0x88, 0x78, 0x71, 0x4c, 0x55, 0x87, 0xe8,
			0xb4, 0x96, 0x3d, 0x56, 0xc8, 0xb2, 0xe1, 0x68,
		},
	},
	{
		.data_len = 16,
		.digest = {
			0x9e, 0x81, 0x37, 0x8f, 0x49, 0xf7, 0xa2, 0xe4,
			0x04, 0x45, 0x12, 0x78, 0x45, 0x42, 0x27, 0xad,
		},
	},
	{
		.data_len = 32,
		.digest = {
			0x60, 0x19, 0xd0, 0xa4, 0xf0, 0xde, 0x9e, 0xe7,
			0x6a, 0x89, 0x1a, 0xea, 0x80, 0x14, 0xa9, 0xa3,
		},
	},
	{
		.data_len = 48,
		.digest = {
			0x0c, 0xa2, 0x70, 0x4d, 0x7c, 0x89, 0xac, 0x41,
			0xc2, 0x9e, 0x0d, 0x07, 0x07, 0x6a, 0x7f, 0xd5,
		},
	},
	{
		.data_len = 49,
		.digest = {
			0x91, 0xd3, 0xa9, 0x5c, 0x79, 0x3d, 0x6b, 0x84,
			0x99, 0x54, 0xa7, 0xb4, 0x06, 0x66, 0xfd, 0x1c,
		},
	},
	{
		.data_len = 63,
		.digest = {
			0x29, 0x37, 0xb8, 0xe5, 0xd8, 0x27, 0x4d, 0xfb,
			0x83, 0x4f, 0x67, 0xf7, 0xf9, 0xc1, 0x0a, 0x9d,
		},
	},
	{
		.data_len = 64,
		.digest = {
			0x17, 0xa9, 0x06, 0x2c, 0xf3, 0xe8, 0x2e, 0xa6,
			0x6b, 0xb2, 0x1f, 0x5d, 0x94, 0x3c, 0x02, 0xa2,
		},
	},
	{
		.data_len = 65,
		.digest = {
			0x7c, 0x80, 0x74, 0xd7, 0xa1, 0x37, 0x30, 0x64,
			0x3b, 0xa4, 0xa3, 0x98, 0xde, 0x47, 0x10, 0x23,
		},
	},
	{
		.data_len = 127,
		.digest = {
			0x27, 0x3a, 0xcf, 0xf5, 0xaf, 0x9f, 0xd8, 0xd8,
			0x2d, 0x6a, 0x91, 0xfb, 0xb8, 0xfa, 0xbe, 0x0c,
		},
	},
	{
		.data_len = 128,
		.digest = {
			0x97, 0x6e, 0xc4, 0xbe, 0x6b, 0x15, 0xa6, 0x7c,
			0xc4, 0xa2, 0xb8, 0x0a, 0x0e, 0x9c, 0xc7, 0x3a,
		},
	},
	{
		.data_len = 129,
		.digest = {
			0x2b, 0xc3, 0x98, 0xba, 0x6e, 0x42, 0xf8, 0x18,
			0x85, 0x69, 0x15, 0x37, 0x10, 0x60, 0xe6, 0xac,
		},
	},
	{
		.data_len = 256,
		.digest = {
			0x88, 0x21, 0x77, 0x89, 0xd7, 0x93, 0x90, 0xfc,
			0xf3, 0xb0, 0xe3, 0xfb, 0x14, 0xe2, 0xcf, 0x74,
		},
	},
	{
		.data_len = 511,
		.digest = {
			0x66, 0x3d, 0x3e, 0x08, 0xa0, 0x49, 0x81, 0x68,
			0x3e, 0x3b, 0xc8, 0x80, 0x55, 0xd4, 0x15, 0xe9,
		},
	},
	{
		.data_len = 513,
		.digest = {
			0x05, 0xf5, 0x06, 0x66, 0xe7, 0x11, 0x08, 0x84,
			0xff, 0x94, 0x50, 0x85, 0x65, 0x95, 0x2a, 0x20,
		},
	},
	{
		.data_len = 1000,
		.digest = {
			0xd3, 0xa0, 0x51, 0x69, 0xb5, 0x38, 0xae, 0x1b,
			0xe1, 0xa2, 0x89, 0xc6, 0x8d, 0x2b, 0x62, 0x37,
		},
	},
	{
		.data_len = 3333,
		.digest = {
			0x37, 0x6d, 0x6a, 0x14, 0xdc, 0xa5, 0x37, 0xfc,
			0xfe, 0x67, 0x76, 0xb2, 0x64, 0x68, 0x64, 0x05,
		},
	},
	{
		.data_len = 4096,
		.digest = {
			0xe3, 0x12, 0x0c, 0x58, 0x46, 0x45, 0x27, 0x7a,
			0x0e, 0xa2, 0xfa, 0x2c, 0x35, 0x73, 0x6c, 0x94,
		},
	},
	{
		.data_len = 4128,
		.digest = {
			0x63, 0x0d, 0xa1, 0xbc, 0x6e, 0x3e, 0xd3, 0x1d,
			0x28, 0x52, 0xd2, 0xf4, 0x30, 0x2d, 0xff, 0xc4,
		},
	},
	{
		.data_len = 4160,
		.digest = {
			0xb2, 0x91, 0x49, 0xe2, 0x02, 0x98, 0x00, 0x79,
			0x71, 0xb9, 0xd7, 0xd4, 0xb5, 0x94, 0x6d, 0x7d,
		},
	},
	{
		.data_len = 4224,
		.digest = {
			0x58, 0x96, 0x48, 0x69, 0x05, 0x17, 0xe1, 0x6d,
			0xbc, 0xf2, 0x3d, 0x10, 0x96, 0x00, 0x74, 0x58,
		},
	},
	{
		.data_len = 16384,
		.digest = {
			0x99, 0x3c, 0xcb, 0x4d, 0x64, 0xc9, 0xa9, 0x41,
			0x52, 0x93, 0xfd, 0x65, 0xc4, 0xcc, 0xa5, 0xe5,
		},
	},
};

static const u8 hash_testvec_consolidated[POLYVAL_DIGEST_SIZE] = {
	0xdf, 0x68, 0x52, 0x99, 0x92, 0xc3, 0xe8, 0x88,
	0x29, 0x13, 0xc8, 0x35, 0x67, 0xa3, 0xd3, 0xad,
};

static const u8 polyval_allones_hashofhashes[POLYVAL_DIGEST_SIZE] = {
	0xd5, 0xf7, 0xfd, 0xb2, 0xa6, 0xef, 0x0b, 0x85,
	0x0d, 0x0a, 0x06, 0x10, 0xbc, 0x64, 0x94, 0x73,
};
