/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __I_LINE_PROVIDER__H__
#define __I_LINE_PROVIDER__H__

#include <string>

using namespace std;

/* Line providers are sources for data into logserver. This class providers the
 * interface and is implemented by file readers, pipe readers, etc.
 */
class ILineProvider {
public:
	virtual void start() = 0;
	virtual string get_line(size_t pos) = 0;
	virtual ~ILineProvider() {}
};

#endif // __I_LINE_PROVIDER__H__
