
# Create LAMMPS input files this way:
cd moltemplate_files

  # run moltemplate

  moltemplate.sh  system.lt

  # --- OPTIONAL: ---
  # You can also check for missing angle,dihedral params this way:
  #    moltemplate.sh -checkff system.lt 
  #
  # You can also check for alternative possible OPLSAA parameters this way:
  #    moltemplate.sh  system.lt  -report-duplicates bytype __
  # This will check to make sure that there was no ambiguity in the OPLSAA
  # force-field parameters.  Unfortunately, if you do that, moltemplate
  # will create a "warning_duplicate_dihedrals.txt" which often contains
  # more spurious warnings than you could possibly hope to read.  Most
  # OPLSAA molecule builder programs do not warn you about these ambiguities.
  # Moltemplate does warn you, but in my experience, it's often not worth the
  # trouble to worry about them (at least initially).  Most users don't.
  # --- OPTIONAL: ---
  # --- OPTIONAL: ---
  # You can also check for missing angle,dihedral params this way:
  # moltemplate.sh -checkff system.lt 
  #
  # You can also check for alternative possible OPLSAA parameters this way:
  # moltemplate.sh  system.lt  -report-duplicates bytype __
  #
  # The optional "-report-duplicates bytype __" arguments check to make
  # sure that there was no ambiguity in the chosen dihedrals parameters
  # Often moltemplate.sh will create a "warning_duplicate_dihedrals.txt"
  # file containing more warnings than you could possibly hope to read.  Most
  # OPLSAA molecule builder programs do not warn you about these ambiguities.
  # Moltemplate does warn you, but in my experience, it's not worth the
  # trouble to worry about them.  Just use: "moltemplate.sh system.lt"
  # --- OPTIONAL: ---

  
  # Moltemplate generates various files with names ending in *.in* and *.data.
  # Move them to the directory where you plan to run LAMMPS (in this case "../")
  mv -f system.data system.in* ../

  # Optional:
  # The "./output_ttree/" directory is full of temporary files generated by
  # moltemplate.  They can be useful for debugging, but are usually thrown away.
  rm -rf output_ttree/

  # Optional:
  rm -f run.in.EXAMPLE  # not needed.  We have several run.in... files already.

  # Optional:
  # If any warnings or log files were generated, move them to the parent folder
  # (so they get noticed).
  mv -f warning*.txt ../ 2> /dev/null
  mv -f log.* ../ 2> /dev/null

cd ../




# Optional:
# Note: The system.data and system.in.settings files contain extra information
# for atoms defined in OPLSAA which you are not using in this simulation.
# This is harmless, but if you to delete this information from your
# system.in.settings and system.in.data files, run this script:
#
# cleanup_moltemplate.sh
