use Test2::V0;
use Test2::Tools::Command;

plan 4;

local @Test2::Tools::Command::command = ( $ENV{'OXRQ'} || 'oxrq' );

subtest 'help option' => sub {
	command {
		args   => ['--help'],
		stdout => qr{\n\QUsage: oxrq [OPTIONS] [QUERY] [FILE]...},
	};
};

subtest 'version option' => sub {
	command {
		args   => ['--version'],
		stdout => qr{^oxrq},
	};
};

subtest 'Insert when matching in named graph from file' => sub {
	command {
		args  => ['insert { ?item :name "Item One" } where { ?item :name "Item 1" }', 'test/resources/file1.ttl'],
		stdout => qr{\n<item/1> :name "Item One" .\n},
	};
};

subtest 'Query from file' => sub {
	command {
		args  => [qw(-f test/resources/query1.rq test/resources/file1.ttl)],
		stdout => qr{\n"Item 1"\t<http://example.org/ns#name>\t<http://example.org/item/1>\n},
	};
};

done_testing;
