%define PERSALYS_PhysicalModel_doc
"Physical model base class.

Notes
-----
Can only be used through its derived classes.
See :class:`~persalys.SymbolicPhysicalModel`, :class:`~persalys.PythonPhysicalModel`"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation
PERSALYS_PhysicalModel_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getOutputNames_doc
"Output variable names accessor.

Returns
-------
names : :py:class:`openturns.Description`
    Output variable names"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getOutputNames
PERSALYS_PhysicalModel_getOutputNames_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_addInput_doc
"Add an input variable.

Parameters
----------
input : :class:`~persalys.Input`
    New variable"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::addInput
PERSALYS_PhysicalModel_addInput_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_addOutput_doc
"Add an output variable.

Parameters
----------
output : :class:`~persalys.Output`
    New variable"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::addOutput
PERSALYS_PhysicalModel_addOutput_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_removeInput_doc
"Remove an input variable.

Parameters
----------
name : str
    Variable name"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::removeInput
PERSALYS_PhysicalModel_removeInput_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_removeOutput_doc
"Remove an output variable.

Parameters
----------
name : str
    Variable name"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::removeOutput
PERSALYS_PhysicalModel_removeOutput_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getFunction_doc
"Accessor to the underlying function.

Parameters
----------
outputNames : sequence of str
    Names of the outputs to be evaluated (optional)

Returns
-------
function : :py:class:`openturns.Function`
    Function evaluating the outputs"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getFunction
PERSALYS_PhysicalModel_getFunction_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getPointToFieldFunction_doc
"Accessor to the underlying function.

Parameters
----------
outputNames : sequence of str
    Names of the outputs to be evaluated (optional)

Returns
-------
function : :py:class:`openturns.PointToFieldFunction`
    Function evaluating the outputs along the mesh nodes"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getPointToFieldFunction
PERSALYS_PhysicalModel_getPointToFieldFunction_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getPythonScript_doc
"Python script accessor.

Returns
-------
script : str
    Python script to replay the model"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getPythonScript
PERSALYS_PhysicalModel_getPythonScript_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_exportStandalonePythonScript_doc
"Export the model into a Python script.

In the case of metamodels the script only depends on OpenTURNS
and is meant to be used out of Persalys.

Parameters
----------
fileName : str
    Path of the exported script"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::exportStandalonePythonScript
PERSALYS_PhysicalModel_exportStandalonePythonScript_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setCopula_doc
"Copula accessor.

Parameters
----------
copula : :py:class:`openturns.Copula`
    The copula"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setCopula
PERSALYS_PhysicalModel_setCopula_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getDistribution_doc
"Distribution accessor.

Parameters
----------
Distribution : :py:class:`openturns.JointDistribution`
    The composed distribution (marginals and dependence)"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getDistribution
PERSALYS_PhysicalModel_getDistribution_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getCopula_doc
"Copula accessor.

Parameters
----------
copula : :py:class:`openturns.Copula`
    The copula"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getCopula
PERSALYS_PhysicalModel_getCopula_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setInputDescription_doc
"Input description accessor.

Parameters
----------
name : str
    Variable name
description : str
    Description text"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setInputDescription
PERSALYS_PhysicalModel_setInputDescription_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setOutputDescription_doc
"Output description accessor.

Parameters
----------
name : str
    Variable name
description : str
    Description text"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setOutputDescription
PERSALYS_PhysicalModel_setOutputDescription_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setInputs_doc
"Input variables accessor.

Parameters
----------
inputs : sequence of :class:`~persalys.Input`
    Input variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setInputs
PERSALYS_PhysicalModel_setInputs_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getInputs_doc
"Input variables accessor.

Returns
-------
inputs : sequence of :class:`~persalys.Input`
    Input variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getInputs
PERSALYS_PhysicalModel_getInputs_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setOutputs_doc
"Output variables accessor.

Parameters
----------
outputs : sequence of :class:`~persalys.Output`
    Output variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setOutputs
PERSALYS_PhysicalModel_setOutputs_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getOutputs_doc
"Output variables accessor.

Returns
-------
outputs : sequence of :class:`~persalys.Output`
    Output variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getOutputs
PERSALYS_PhysicalModel_getOutputs_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getInputByName_doc
"Input variable accessor.

Parameters
----------
name : str
    Variable name

Returns
-------
input : :class:`~persalys.Input`
    Input variable"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getInputByName
PERSALYS_PhysicalModel_getInputByName_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getOutputByName_doc
"Output variable accessor.

Parameters
----------
name : str
    Variable name

Returns
-------
input : :class:`~persalys.Output`
    Output variable"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getOutputByName
PERSALYS_PhysicalModel_getOutputByName_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getInputDimension_doc
"Number of input variables accessor.

Returns
-------
dimension : int
    Number of input variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getInputDimension
PERSALYS_PhysicalModel_getInputDimension_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getOutputDimension_doc
"Number of output variables accessor.

Returns
-------
dimension : int
    Number of output variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getOutputDimension
PERSALYS_PhysicalModel_getOutputDimension_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getInputNames_doc
"Input variable names accessor.

Returns
-------
names : :py:class:`openturns.Description`
    Input variable names"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getInputNames
PERSALYS_PhysicalModel_getInputNames_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getStochasticInputNames_doc
"Accessor to the names of the stochastic input variables.

Returns
-------
names : :py:class:`openturns.Description`
    Names of the stochastic input variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getStochasticInputNames
PERSALYS_PhysicalModel_getStochasticInputNames_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getInputRandomVector_doc
"Input random vector accessor.

Returns
-------
names : :py:class:`openturns.RandomVector`
    Input random vector"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getInputRandomVector
PERSALYS_PhysicalModel_getInputRandomVector_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getOutputRandomVector_doc
"Output random vector accessor.

Returns
-------
names : :py:class:`openturns.RandomVector`
    Output random vector"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getOutputRandomVector
PERSALYS_PhysicalModel_getOutputRandomVector_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setInputName_doc
"Input variable name accessor.

Parameters
----------
name : str
    Variable name
newName : str
    New name"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setInputName
PERSALYS_PhysicalModel_setInputName_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setOutputName_doc
"Output variable name accessor.

Parameters
----------
name : str
    Variable name
newName : str
    New name"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setOutputName
PERSALYS_PhysicalModel_setOutputName_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setInputValue_doc
"Input variable value accessor.

Parameters
----------
name : str
    Variable name
value : float
    New value"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setInputValue
PERSALYS_PhysicalModel_setInputValue_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setOutputValue_doc
"Output variable name accessor.

Parameters
----------
name : str
    Variable name
value : float
    New value"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setOutputValue
PERSALYS_PhysicalModel_setOutputValue_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_hasInputNamed_doc
"Check if an input has the given name.

Parameters
----------
name : str
    Variable name

Returns
-------
has : bool
    Whether an input has the given name"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::hasInputNamed
PERSALYS_PhysicalModel_hasInputNamed_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_hasOutputNamed_doc
"Check if an output has the given name.

Parameters
----------
name : str
    Variable name

Returns
-------
has : bool
    Whether an output has the given name"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::hasOutputNamed
PERSALYS_PhysicalModel_hasOutputNamed_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_hasStochasticInputs_doc
"Whether it contains stochastic variables.

Returns
-------
has : bool
    Whether it contains stochastic variables"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::hasStochasticInputs
PERSALYS_PhysicalModel_hasStochasticInputs_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_isValid_doc
"Whether it is valid.

Returns
-------
isValid : bool
    Whether it is valid"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::isValid
PERSALYS_PhysicalModel_isValid_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setDistribution_doc
"Input distribution accessor.

Parameters
----------
name : str
    Variable name
distribution : :py:class:`openturns.Distribution`
    Variable distribution"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setDistribution
PERSALYS_PhysicalModel_setDistribution_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setInputStochastic_doc
"Whether the input variable is stochastic.

Parameters
----------
name : str
    Variable name
isStochastic : bool
    Whether the input variable is stochastic"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setInputStochastic
PERSALYS_PhysicalModel_setInputStochastic_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setDistributionParametersType_doc
"Input distribution parameter type accessor.

Parameters
----------
name : str
    Variable name
parametersType : int
    Distribution parameter type accessor"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setDistributionParametersType
PERSALYS_PhysicalModel_setDistributionParametersType_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setFiniteDifferenceStep_doc
"Finite difference step accessor.

Parameters
----------
name : str
    Variable name
step : float
    Finite difference step used to define the gradient of the model's function"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setFiniteDifferenceStep
PERSALYS_PhysicalModel_setFiniteDifferenceStep_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getRestrictedFunction_doc
"Accessor to the function restricted to its stochastic inputs.

Parameters
----------
outputNames : sequence of str
    Output variables (optional)

Returns
-------
restricted : :py:class:`openturns.Function`
    Stochastic function"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getRestrictedFunction
PERSALYS_PhysicalModel_getRestrictedFunction_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getRestrictedPointToFieldFunction_doc
"Accessor to the field function restricted to its stochastic inputs.

Parameters
----------
outputNames : sequence of str
    Output variables (optional)

Returns
-------
restricted : :py:class:`openturns.PointToFieldFunction`
    Stochastic field function (for model with mesh)"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getRestrictedPointToFieldFunction
PERSALYS_PhysicalModel_getRestrictedPointToFieldFunction_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getSelectedOutputsNames_doc
"Accessor to the selected outputs names.

Returns
-------
names : :py:class:`openturns.Description`
    Selected outputs names"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getSelectedOutputsNames
PERSALYS_PhysicalModel_getSelectedOutputsNames_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_selectOutput_doc
"Select output.

Parameters
----------
name : str
    Output name
isSelected : bool
    Whether it is selected"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::selectOutput
PERSALYS_PhysicalModel_selectOutput_doc

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::PhysicalModelImplementation::clearInputs
"Remove all the input variables."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::PhysicalModelImplementation::clearOutputs
"Remove all the output variables."

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_isParallel_doc
"Whether the evaluations of the model are parallelized.

Returns
-------
isParallel : bool
    Whether the evaluations of the model are parallelized (available only for the Python model)"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::isParallel
PERSALYS_PhysicalModel_isParallel_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setParallel_doc
"Whether the evaluations of the model are parallelized.

Parameters
----------
isParallel : bool
    Whether the evaluations of the model are parallelized

Notes
-----
This is only implemented for the Python model.
Also, on Windows platforms, ProcessPoolExecutor startup time being much higher,
you may want to evaluate enough points in batch rather than many small blocks.
Refer to the *setBlockSize* method of the various algorithms.
"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setParallel
PERSALYS_PhysicalModel_setParallel_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getProcessNumber_doc
"Number of concurrent processes.

Returns
-------
process_number : int
    Maximum number of processes"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getProcessNumber
PERSALYS_PhysicalModel_getProcessNumber_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setProcessNumber_doc
"Number of concurrent processes.

Parameters
----------
process_number : int
    Maximum number of processes"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setProcessNumber
PERSALYS_PhysicalModel_setProcessNumber_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_hasMesh_doc
"Whether the model has a mesh.

Returns
-------
hasMesh : bool
    Whether the model has a mesh"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::hasMesh
PERSALYS_PhysicalModel_hasMesh_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setMeshModel_doc
"Mesh model accessor.

Parameters
----------
mesh : :class:`~persalys.MeshModel`
    Mesh model"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setMeshModel
PERSALYS_PhysicalModel_setMeshModel_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getMeshModel_doc
"Mesh model accessor.

Returns
-------
mesh : :class:`~persalys.MeshModel`
    Mesh model"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getMeshModel
PERSALYS_PhysicalModel_getMeshModel_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_setEvalTime_doc
"Evaluation time accessor.

Parameters
----------
evalTime : float
    Evaluation time"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::setEvalTime
PERSALYS_PhysicalModel_setEvalTime_doc

// ---------------------------------------------------------------------

%define PERSALYS_PhysicalModel_getEvalTime_doc
"Evaluation time accessor.

Returns
-------
evalTime : float
    Evaluation time"
%enddef
%feature("docstring") PERSALYS::PhysicalModelImplementation::getEvalTime
PERSALYS_PhysicalModel_getEvalTime_doc
