/*-------------------------------------------------------------------------
 *
 * unicode_norm_hashfunc.h
 *	  Perfect hash functions used for Unicode normalization
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_norm_hashfunc.h
 *
 *-------------------------------------------------------------------------
 */

/*
 * File auto-generated by src/common/unicode/generate-unicode_norm_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_NORM_HASHFUNC_H
 * here.
 */

#include "common/unicode_norm_table.h"

/* Typedef for perfect hash functions */
typedef int (*cp_hash_func) (const void *key);

/* Information for lookups with perfect hash functions */
typedef struct
{
	const pg_unicode_decomposition *decomps;
	cp_hash_func	hash;
	int		num_decomps;
} pg_unicode_decompinfo;

typedef struct
{
	const uint16	*inverse_lookup;
	cp_hash_func	hash;
	int		num_recomps;
} pg_unicode_recompinfo;

/* Perfect hash function for decomposition */
static int
Decomp_hash_func(const void *key)
{
	static const int16 h[13687] = {
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 0,
		0,     0,     0,     32767, 0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     32767, 0,     32767, 0,     32767,
		0,     32767, 0,     32767, 0,     32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		32767, 32767, 0,     32767, 32767, 0,     0,     0,
		0,     32767, 32767, 32767, 0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1,     32767, 2,     32767, 32767, 32767, 32767, 2792,
		32767, 32767, 4,     5,     6,     7,     32767, 32767,
		8,     9,     10,    32767, 11,    12,    13,    1734,
		14,    -822,  -822,  17,    18,    3020,  1739,  3021,
		3022,  3023,  1110,  24,    3024,  3025,  27,    -3019,
		32767, 29,    30,    3026,  3027,  33,    34,    5016,
		1754,  -4252, 36,    37,    -4254, -4254, -4254, 32767,
		40,    41,    42,    43,    44,    45,    1912,  46,
		47,    48,    49,    50,    51,    52,    53,    54,
		1770,  55,    606,   57,    58,    59,    60,    1776,
		1777,  61,    62,    63,    64,    65,    32767, 66,
		32767, -1290, 6662,  3534,  3534,  3534,  -172,  3322,
		-170,  -169,  -168,  -167,  3331,  1788,  0,     1790,
		1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,
		1799,  3354,  1801,  1802,  -964,  -964,  -964,  -964,
		1807,  4976,  4976,  4976,  4976,  4976,  4976,  1814,
		1815,  4974,  2192,  11244, 2194,  11245, 0,     0,
		1605,  11251, 0,     11252, 0,     0,     3571,  3571,
		-47,   -47,   0,     0,     -124,  -123,  -122,  -4877,
		-4877, -119,  32767, 32767, -118,  0,     -116,  -11032,
		-114,  -113,  -112,  32767, 32767, -887,  -110,  -109,
		-885,  -107,  5320,  32767, 32767, -105,  -882,  5328,
		-102,  -101,  -100,  -99,   -4221, -4221, -4221, -95,
		-94,   -93,   -92,   -4221, -4221, -4221, -4221, 32767,
		32767, -4223, -4223, -4223, -4223, -4223, -4223, -4223,
		-4223, -5481, -4223, -4223, -4223, -4223, -4223, -4223,
		-4223, -4223, -4223, -4223, -4223, -4223, -4223, -4223,
		-5495, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 1839,  1840,  1841,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4663,  4664,  32767,
		32767, -4255, -4255, 32767, 0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-4268, -4268, 5881,  5882,  4722,  5884,  5885,  5886,
		5887,  32767, 5888,  5889,  5890,  5891,  5892,  5893,
		5894,  5895,  5896,  5897,  5898,  185,   186,   -3976,
		-3976, -3976, -3976, 6000,  6001,  6002,  6003,  6004,
		6005,  6006,  198,   5911,  -3968, -3968, -826,  -3968,
		-3968, -3968, -3968, -3968, 208,   209,   32767, -3967,
		-3967, -3032, -3967, -3967, -3030, 5922,  5923,  -813,
		5925,  5926,  219,   220,   5929,  5930,  5931,  224,
		-4290, -4290, -4290, -4290, -4290, -4290, -4290, 5940,
		5941,  -4292, -4292, -4292, -4292, -4292, -4292, -4292,
		-4292, 5950,  5951,  0,     0,     0,     0,     245,
		0,     0,     0,     0,     0,     0,     0,     253,
		254,   255,   256,   -635,  258,   259,   260,   261,
		262,   263,   0,     265,   266,   267,   0,     0,
		268,   269,   32767, 32767, 32767, 32767, 32767, 32767,
		270,   271,   272,   273,   274,   275,   276,   277,
		278,   279,   280,   281,   282,   283,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 5981,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 2763,
		975,   32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     289,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     4382,  4382,  4382,  0,     7408,
		4383,  4383,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-4027, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -1642, -1641, -1640, -1639,
		-1638, 3694,  -1636, 3697,  3698,  3699,  0,     0,
		-1627, 0,     0,     -1622, -1621, 0,     6198,  -1616,
		-1615, -1614, -1613, 0,     -1610, -1609, -1608, 0,
		0,     0,     0,     0,     0,     9558,  -10546,0,
		6270,  6271,  6272,  6273,  6274,  6275,  -3369, 6277,
		6545,  6279,  9583,  6281,  -1402, -1402, 6284,  6285,
		304,   1947,  1947,  1947,  1947,  1947,  -3384, 1947,
		-3385, -3385, -3385, 315,   316,   1944,  318,   319,
		1942,  1942,  322,   -5875, 1940,  1940,  1940,  1940,
		328,   1939,  1939,  1939,  332,   333,   334,   335,
		336,   337,   -9220, 10885, 340,   -5929, -5929, -5929,
		-5929, -5929, -5929, 3716,  -5929, -6196, -5929, -9232,
		-5929, 1755,  1756,  -5929, -5929, 53,    -1589, -1588,
		-1587, -1586, -1585, 3747,  -1583, 3750,  3751,  3752,
		53,    53,    -1574, 53,    53,    -1569, -1568, 53,
		6251,  -1563, -1562, -1561, -1560, 53,    -1557, 5101,
		-1556, 52,    52,    52,    52,    52,    52,    9610,
		-10494,52,    6322,  6323,  6324,  6325,  6326,  6327,
		-3317, 6329,  6597,  6331,  9635,  6333,  -1350, -1350,
		6336,  6337,  356,   1999,  1999,  1999,  1999,  1999,
		0,     0,     -2173, -3888, -3337, -5616, 0,     0,
		432,   -2164, 1985,  0,     0,     0,     1980,  0,
		0,     0,     0,     -1319, -4683, 1975,  368,   369,
		370,   371,   372,   0,     -9185, 0,     374,   -5895,
		-5895, 0,     0,     0,     0,     864,   437,   -16,
		-16,   440,   32767, 441,   442,   443,   -13,   445,
		446,   447,   32767, 32767, 32767, 32767, 32767, 6042,
		6043,  6044,  6045,  430,   431,   0,     2597,  -1551,
		435,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 448,   449,   450,   32767, 451,
		452,   32767, 32767, 32767, 453,   0,     0,     0,
		0,     0,     -428,  0,     454,   455,   0,     456,
		0,     0,     0,     457,   0,     0,     0,     0,
		458,   459,   460,   0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		3733,  3734,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     462,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     463,   464,   0,     465,
		0,     0,     0,     466,   0,     0,     0,     0,
		467,   0,     469,   0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     5493,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		5530,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -4339, -4339, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -7353, -7353, -7353, -5439,
		0,     0,     -7353, -4354, 0,     0,     485,   486,
		487,   488,   489,   490,   0,     0,     491,   492,
		493,   494,   -2541, -5542, 0,     0,     -5544, -5544,
		-3630, -2543, -5542, -5542, -2543, 504,   -2543, -2543,
		-2543, -5538, 0,     0,     -2545, -2545, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3448,
		3448,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -3213, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 2540,  2540,
		2540,  2540,  2540,  0,     4830,  4831,  -307,  -307,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     4166,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -31,   0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -796,  -795,
		-794,  -793,  -792,  -791,  1061,  1062,  1063,  1064,
		1065,  0,     0,     0,     0,     0,     0,     0,
		-785,  -784,  -783,  -782,  -4016, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -1097, -1096, -1095, -5270, -5270, -1094, -1093,
		-1092, -2026, -1090, -1089, -2025, -2024, -765,  -4241,
		-10978,-10978,-5270, -5270, -10978,-10978,0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     3849,  0,
		0,     0,     0,     3854,  2311,  523,   2313,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 5994,  4146,  4146,  5997,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		2970,  32767, 32767, 32767, 32767, 1264,  1264,  1264,
		2215,  2216,  2217,  2218,  2219,  2220,  2221,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 5792,  32767,
		362,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -3774, 32767, 32767, -3776, -3776, -3776, -3776,
		-5034, -3776, -3776, 32767, 32767, -3778, -3778, -3778,
		-3778, -3778, -3778, 32767, 32767, -3780, -3780, 32767,
		-5053, -3781, -3781, -3781, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -157,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		627,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4695,  32767,
		32767, 2985,  2986,  32767, 32767, 32767, 32767, 628,
		629,   630,   631,   632,   633,   -5911, 635,   636,
		637,   638,   639,   640,   641,   642,   643,   644,
		645,   646,   647,   648,   649,   650,   651,   652,
		653,   654,   32767, 32767, 32767, 32767, 32767, 32767,
		-2208, 32767, 8339,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4699,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4700,
		4701,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 5998,  0,     32767,
		32767, 32767, 32767, 0,     0,     32767, 32767, 32767,
		32767, 0,     2987,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -1459,
		-1459, -1459, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -1496, -2931, 32767,
		32767, 32767, 655,   656,   657,   658,   659,   660,
		661,   662,   663,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 664,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4743,  32767, 32767, 32767, -3717, -3716,
		667,   -6740, 32767, -3714, 670,   671,   672,   673,
		674,   675,   676,   677,   32767, 678,   679,   680,
		32767, 681,   4709,  683,   684,   685,   2990,  32767,
		32767, 32767, 2991,  2992,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 538,   32767, 32767, 32767, 32767, -1583, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 686,   -5583, -5583, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -1622,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4710,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		4679,  4711,  4681,  4682,  4683,  4684,  4685,  4686,
		4687,  4688,  4689,  0,     0,     32767, 0,     32767,
		32767, 32767, 0,     5257,  32767, 32767, 32767, 6885,
		6619,  9923,  6621,  -1062, -1062, 6624,  6625,  644,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 1637,  32767, 1637,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 4690,  4691,  4692,  4693,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4015,  -5630, -5897, -5630, -8933, -5630,
		2054,  2055,  -5630, -5630, 352,   -1290, -1289, -1288,
		-1287, -1286, 714,   715,   2889,  4605,  4055,  6335,
		720,   721,   32767, 2886,  -1262, 724,   725,   726,
		-1253, 728,   729,   730,   731,   2051,  5416,  -1241,
		367,   367,   367,   367,   367,   740,   9926,  742,
		369,   6639,  6640,  746,   747,   748,   749,   -114,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -8006, -8006, -2024, -3666, -3665,
		-3664, -3663, -3662, 1670,  -3660, 1673,  1674,  1675,
		-2024, -2024, -3651, -2024, -2024, 32767, 32767, 32767,
		32767, 32767, -2866, 32767, 32767, -2865, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -2866, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -2866, 32767,
		32767, 32767, -4485, -4485, 758,   759,   32767, 32767,
		32767, 760,   -2863, -2862, -2861, -2860, -2859, -2858,
		-2857, 32767, 32767, 32767, 32767, 32767, 32767, 3014,
		3015,  3016,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     32767, 32767, 32767, 32767, 3017,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 2180,  2180,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 768,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 769,   770,   771,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 32767, 772,   773,   32767,
		774,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3018,
		32767, 32767, 0,     32767, 4716,  4717,  32767, 32767,
		32767, 32767, 32767, 32767, 3019,  0,     3919,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 3643,
		32767, 32767, 3641,  32767, 32767, 0,     0,     -3355,
		0,     0,     0,     0,     1998,  0,     0,     0,
		0,     0,     0,     -3366, -3366, -3366, 0,     0,
		-3368, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     3365,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     676,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     677,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     13799, 0,     0,     0,     9279,  2994,  32767,
		8461,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1755,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 3196,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -4700,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -3816,
		360,   361,   362,   -572,  364,   365,   -571,  -570,
		689,   -2787, -9524, -9524, -3816, -3816, -9524, -9524,
		-9524, -3816, 699,   700,   701,   702,   703,   704,
		705,   706,   707,   8659,  5531,  5531,  5531,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 4746,  4747,  32767,
		4748,  32767, 32767, 32767, 4749,  -507,  -507,  -507,
		-507,  -507,  -507,  -507,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -872,
		32767, 32767, 3030,  3031,  3032,  3033,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, -3585, -3585, -3585,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -10784,-5076, -561,
		-560,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		2304,  2304,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -3368, -3368,
		798,   32767, -372,  -372,  -372,  -372,  -372,  -372,
		0,     1160,  0,     0,     0,     0,     0,     0,
		1161,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     5714,  5714,  9877,  9878,  9879,  9880,  0,
		0,     -97,   -97,   -97,   -97,   -97,   5712,  0,
		0,     9880,  6739,  0,     9882,  9883,  9884,  9885,
		5710,  0,     3820,  679,   0,     0,     9886,  9887,
		8951,  0,     0,     6737,  0,     0,     5708,  5708,
		0,     0,     0,     5708,  10223, 10224, 10225, 10226,
		10227, 10228, 10229, 0,     0,     10234, 10235, 10236,
		10237, 10238, 10239, 10240, 10241, 0,     0,     5952,
		5953,  5954,  5955,  5711,  5957,  5958,  5959,  5960,
		5961,  5962,  5963,  5711,  5711,  5711,  5711,  6603,
		5711,  5711,  5711,  5711,  5711,  5711,  5975,  5711,
		5711,  5711,  5979,  5980,  32767, 32767, 32767, 32767,
		803,   32767, 32767, 32767, 804,   32767, 32767, 32767,
		32767, 32767, 32767, 805,   806,   32767, 807,   808,
		32767, 809,   0,     5999,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 1389,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 840,   841,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		842,   32767, 843,   32767, 844,   32767, 32767, 32767,
		32767, 32767, 0,     0,     10606, 0,     845,   5378,
		0,     0,     0,     0,     1113,  1113,  1113,  1113,
		1113,  1113,  1113,  1113,  1113,  -6838, -3709, -3708,
		-3707, 0,     -3493, 0,     0,     0,     0,     -3497,
		-1953, -164,  -1953, -1953, 5407,  5408,  -1955, -1955,
		-1955, -1955, -1955, -1955, -3509, -1955, -1955, 812,
		813,   814,   815,   -1955, -5123, -5122, -5121, -5120,
		-5119, -5118, -14675,5430,  -5115, -2332, -11383,-2332,
		-11382,-136,  -135,  -1739, -11384,-11651,-11384,-131,
		-130,  -3700, -3699, -80,   5447,  -126,  -125,  0,
		0,     0,     4756,  4757,  0,     5456,  -1715, 0,
		-117,  0,     10917, 0,     0,     0,     5465,  5466,
		776,   0,     0,     777,   0,     -5426, 5473,  5474,
		0,     778,   -5431, 0,     0,     0,     0,     4123,
		4124,  4125,  0,     0,     0,     0,     4130,  4131,
		4132,  4133,  4134,  4135,  4136,  4137,  4138,  4139,
		4140,  4141,  4142,  4143,  5402,  4145,  4146,  4147,
		4148,  4149,  4150,  4151,  4152,  4153,  4154,  4155,
		4156,  4157,  4158,  5431,  5432,  4161,  4162,  4163,
		4164,  4165,  4166,  4167,  4168,  4169,  4170,  4171,
		4172,  4173,  4174,  4175,  4176,  4177,  4178,  4179,
		32767, 32767, 4180,  4181,  4182,  4183,  4184,  4185,
		4186,  4187,  4188,  4189,  4190,  4191,  4192,  6044,
		6045,  6046,  6047,  6048,  4198,  4199,  4200,  4201,
		4202,  4203,  4204,  4205,  4206,  4207,  4208,  974,
		4210,  11136, 3906,  3907,  3908,  3909,  3910,  3911,
		3912,  3913,  3914,  3915,  3916,  3917,  5988,  5989,
		0,     0,     3919,  3920,  3921,  3922,  -6053, -6053,
		-6053, -6053, -6053, -6053, -6053, -244,  -5956, 3924,
		3925,  784,   3927,  3928,  3929,  3930,  3931,  -244,
		-244,  3932,  3933,  3934,  3000,  3936,  3937,  3001,
		3002,  4261,  785,   -5952, -5952, -244,  -244,  -5952,
		-5952, -5952, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -5739, -408,
		-408,  -408,  32767, 32767, 32767, 32767, 3724,  823,
		824,   32767, 32767, 32767, 32767, 32767, 32767, -421,
		-2028, -2027, -2026, -2025, -2024, 517,   -4312, -4312,
		827,   828,   522,   523,   524,   525,   526,   527,
		528,   529,   530,   531,   532,   533,   534,   535,
		536,   537,   538,   539,   540,   541,   542,   543,
		544,   545,   546,   547,   548,   -3617, 550,   551,
		552,   553,   554,   555,   556,   32767, 557,   32767,
		558,   559,   32767, 560,   561,   32767, 562,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -1191, -1191,
		-1191, -2792, 0,     0,     0,     0,     -2791, -2790,
		-4408, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -2791, -2790,
		-2789, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     837,   838,   0,     0,     -3001, 3038,
		-3001, -3001, -3001, -1087, 0,     -2999, -2999, 0,
		3047,  0,     0,     0,     -2995, -2995, 0,     0,
		0,     0,     4287,  0,     0,     4292,  4293,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -550,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     3918,  0,     0,     0,     0,     9976,  0,
		0,     0,     0,     -6065, -6065, 0,     0,     0,
		0,     3142,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     935,   0,     0,     937,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     9645,  0,     -267,  0,     -3303, 0,
		7684,  7685,  0,     0,     5982,  4340,  4341,  4342,
		4343,  4344,  9676,  4346,  4347,  9679,  9680,  4350,
		4351,  4352,  4353,  4354,  4355,  4356,  4357,  4358,
		4359,  4360,  4361,  4362,  4363,  4364,  4365,  4366,
		5974,  5974,  5974,  5974,  5974,  5974,  15532, -4572,
		5974,  3192,  12244, 3194,  12245, 12246, 12247, 2603,
		12249, 12517, 12251, 999,   12252, 4569,  4569,  12255,
		12256, 6275,  7918,  7918,  7918,  7918,  7918,  2587,
		7918,  2586,  2586,  2586,  6286,  6287,  7915,  6289,
		6290,  7913,  7913,  6293,  96,    7911,  7911,  7911,
		7911,  6299,  7910,  1253,  7911,  6304,  6305,  6306,
		6307,  6308,  6309,  -3248, 16857, 6312,  43,    43,
		43,    43,    43,    43,    9688,  43,    -224,  43,
		-3260, 43,    7727,  7728,  43,    43,    6025,  1253,
		6234,  1253,  6384,  6385,  10526, -3272, 1253,  6388,
		10531, 1253,  1253,  1253,  1253,  6392,  6393,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     6053,  6054,  6055,
		6056,  6057,  6058,  32767, 6059,  6060,  6061,  6062,
		32767, 6063,  32767, 6064,  32767, 32767, 32767, 4761,
		32767, 32767, 6065,  32767, 4762,  4763,  32767, 9404,
		32767, 6067,  4764,  6068,  32767, 6069,  6070,  6071,
		32767, 6072,  6073,  32767, 6074,  32767, 32767, 6075,
		32767, 6076,  32767, 6077,  32767, 6078,  32767, 6079,
		32767, 4374,  4374,  32767, 4373,  32767, 32767, 5324,
		5325,  5326,  5327,  32767, 6087,  6088,  6089,  6090,
		6091,  3057,  6093,  32767, 6094,  4376,  -4013, 4376,
		32767, 4375,  4375,  4375,  4375,  32767, 4374,  32767,
		4373,  6104,  6105,  6106,  6107,  6108,  6109,  6110,
		6111,  -3652, 881,   -645,  -645,  -1903, 6116,  6117,
		6118,  4399,  4400,  4401,  6122,  6123,  3567,  3567,
		4406,  6127,  7410,  6129,  32767, 32767, 32767, 32767,
		32767, 7409,  7410,  4412,  32767, 6133,  4414,  4415,
		6136,  6137,  32767, 4420,  9402,  6140,  134,   134,
		13933, 134,   134,   134,   9413,  4429,  6149,  4432,
		6151,  4435,  6153,  6304,  6305,  6306,  6307,  6308,
		6309,  6310,  6311,  6312,  6313,  6314,  1068,  6316,
		5378,  6318,  5379,  6320,  803,   6322,  -2232, 6324,
		6325,  6326,  1074,  6328,  6329,  6330,  6331,  6332,
		6333,  6334,  6335,  6336,  6337,  6338,  6339,  6340,
		6341,  6342,  6343,  6344,  6345,  6346,  6347,  6348,
		6349,  6350,  6351,  6352,  6353,  6354,  6355,  6356,
		6357,  6358,  6359,  6360,  5417,  6362,  6363,  6364,
		6365,  6366,  6367,  5423,  6369,  5424,  6371,  6372,
		5426,  5426,  6375,  5427,  5427,  6378,  6379,  6380,
		6381,  6382,  6383,  6384,  6385,  6386,  6387,  6388,
		6389,  6390,  6391,  6392,  6393,  6394,  6395,  6396,
		6397,  6398,  6399,  6400,  6401,  6402,  6403,  6404,
		6405,  6406,  6407,  6408,  6409,  6410,  6411,  6412,
		6413,  6414,  6415,  6416,  6417,  6418,  6419,  6420,
		6421,  6422,  7182,  5465,  6425,  6426,  6427,  6428,
		6429,  6430,  6431,  6432,  6433,  6434,  6435,  6436,
		6437,  6438,  6439,  6440,  6441,  6442,  6443,  6444,
		6445,  6446,  6447,  6448,  6449,  6450,  6451,  6452,
		6453,  6454,  6455,  6456,  6457,  6458,  6459,  6460,
		6461,  6462,  6463,  6464,  6465,  6466,  6467,  6468,
		6469,  6470,  6471,  6472,  6473,  6474,  6475,  6476,
		6477,  6478,  5519,  5519,  6481,  6482,  6483,  6484,
		6485,  6486,  6487,  6488,  6489,  6490,  6491,  6492,
		6493,  6494,  6495,  6496,  6497,  6498,  6499,  6500,
		6501,  6502,  6503,  6504,  6505,  6506,  6507,  6508,
		6509,  6510,  6511,  6512,  6513,  6514,  6515,  6516,
		6517,  6518,  6519,  6520,  6521,  6522,  6523,  6524,
		6525,  6526,  6527,  6528,  6529,  6530,  6531,  6532,
		6533,  1330,  6535,  6536,  6537,  6538,  5577,  6540,
		6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,
		6549,  6550,  5588,  5588,  6553,  6554,  6555,  6556,
		32767, 6557,  1728,  1728,  6867,  6868,  6562,  6563,
		6564,  6565,  6566,  6567,  6568,  6569,  6570,  6571,
		6572,  6573,  6574,  6575,  6576,  6577,  6578,  6579,
		6580,  6581,  6582,  6583,  6584,  6585,  6586,  6587,
		6588,  2423,  6590,  6591,  6592,  6593,  6594,  6595,
		6596,  6597,  6598,  6599,  6600,  6601,  6602,  6603,
		6604,  6605,  6606,  6607,  6608,  6609,  6610,  6611,
		6612,  6613,  6614,  6615,  6616,  6617,  6618,  6619,
		6620,  6621,  6622,  6623,  6624,  6625,  6626,  6627,
		6628,  6629,  6630,  6631,  6632,  6633,  6634,  6635,
		6636,  6637,  6638,  6639,  6640,  6641,  6642,  6643,
		6644,  6645,  6646,  6647,  6648,  6649,  6650,  6651,
		6652,  6653,  6654,  6655,  6656,  6657,  6658,  6659,
		6660,  6661,  6693,  6663,  6664,  6665,  6666,  6667,
		6668,  6669,  6670,  6671,  6672,  6673,  6674,  6675,
		6676,  6677,  6678,  6679,  7476,  7476,  7476,  7476,
		7476,  7476,  5625,  5625,  5625,  5625,  5625,  6691,
		6692,  6693,  6694,  6695,  6696,  6697,  7483,  7483,
		7483,  7483,  10718, 6703,  6704,  6705,  6706,  6707,
		6708,  6709,  6710,  6711,  6712,  6713,  6714,  6715,
		6716,  6717,  6718,  6719,  6720,  6721,  6722,  6723,
		6724,  6725,  6726,  6727,  6728,  6729,  6730,  6731,
		6732,  6733,  6734,  6735,  6736,  6737,  6738,  7836,
		7836,  7836,  12012, 12013, 7838,  7838,  7838,  8773,
		7838,  7838,  8775,  8775,  7517,  10994, 17732, 17733,
		12026, 12027, 17736, 17737, 6760,  6761,  6762,  6763,
		6764,  6765,  6766,  6767,  6768,  6769,  6770,  6771,
		6772,  6773,  6774,  6775,  2927,  6777,  6778,  6779,
		6780,  2927,  4471,  6260,  4471,  6785,  6786,  6787,
		6788,  6789,  6790,  6791,  6792,  6793,  6794,  6795,
		6796,  6797,  6798,  6799,  6800,  6801,  6802,  6803,
		6804,  6805,  6806,  6807,  6808,  6809,  6810,  6811,
		6812,  32767, 3411,  5540,  5541,  3411,  12221, 3411,
		3411,  3411,  3411,  5548,  5549,  5550,  5551,  5552,
		5553,  5554,  5555,  5556,  5557,  5558,  5559,  5560,
		5561,  5562,  5563,  5564,  5565,  5566,  5567,  5568,
		32767, 32767, 32767, 32767, 32767, 32767, 3915,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 6155,  6156,  6157,  6158,  6159,
		6160,  6161,  6162,  6163,  6164,  6165,  32767, 32767,
		32767, 32767, 32767, 6166,  6167,  6168,  6169,  6170,
		6171,  6172,  6173,  6174,  6175,  6176,  6177,  6178,
		6179,  6180,  4615,  4616,  4617,  4618,  4619,  6186,
		6187,  6188,  6189,  6190,  6191,  6192,  6193,  6194,
		6195,  6196,  32767, 6197,  6198,  6199,  6200,  6201,
		7637,  4495,  4495,  6205,  4052,  4052,  6208,  6209,
		6210,  6211,  6212,  6213,  6214,  6215,  6216,  6217,
		6218,  6219,  6220,  6221,  6222,  6223,  6224,  6225,
		6226,  6227,  6228,  32767, 32767, 0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 6229,  6230,  6231,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 6232,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		884,   885,   886,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 5994,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 6233,  6234,  6235,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 6236,  6237,  6238,  6239,
		6240,  6241,  6242,  6243,  6244,  6245,  6246,  6247,
		6248,  6249,  6250,  6251,  6252,  6253,  6254,  6255,
		6256,  6257,  6258,  6259,  6260,  6261,  6262,  6263,
		6264,  6265,  6266,  6267,  6268,  6269,  6270,  6271,
		6272,  6273,  6274,  6275,  6276,  6277,  6278,  6279,
		32767, 32767, 32767, 32767, 6280,  6281,  6282,  6283,
		6284,  6285,  6286,  6287,  6288,  4770,  32767, 4771,
		4772,  32767, 32767, 32767, 6289,  6290,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -5160, 2071,
		2071,  2071,  2071,  32767, 2070,  2070,  2070,  2070,
		2070,  2070,  2070,  0,     0,     6236,  6237,  2075,
		2075,  2075,  2075,  12051, 12052, 12053, 12054, 12055,
		12056, 12057, 6249,  11962, 2083,  2083,  5225,  2083,
		2083,  2083,  2083,  2083,  6259,  6260,  2085,  2085,
		2085,  3020,  2085,  2085,  3022,  3022,  32767, 5240,
		11978, 11979, 6272,  6273,  11982, 11983, 11984, 6277,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4773,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 415,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -2468, -2468,
		-2468, -2468, -2468, -2468, -2468, -2468, -2468, -2468,
		-2468, -2468, -2468, -2468, -2468, -2468, -2468, -2468,
		2089,  2090,  2091,  -2465, -2465, -2465, -2465, -2465,
		-2465, 2098,  2099,  -2463, -2463, -2463, -2463, -2463,
		-2463, 2106,  2107,  -2461, -2461, -2461, -2461, -2461,
		-2461, 0,     0,     -2459, -2459, -2459, 2119,  2120,
		2121,  -2456, 2123,  2124,  2125,  2126,  2127,  2128,
		0,     0,     2131,  -6678, 2133,  2134,  2135,  2136,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     2158,  2159,  2160,
		2161,  2162,  2163,  2164,  2165,  2166,  2167,  2168,
		2169,  2170,  2171,  2172,  2173,  2174,  2175,  2176,
		2177,  2178,  2179,  2180,  2181,  -2412, -2412, -2412,
		-2412, -2412, 2187,  2188,  2025,  2190,  2191,  2192,
		2193,  2194,  2195,  2196,  2197,  2198,  2199,  2200,
		2201,  2202,  2203,  2204,  2205,  2206,  2207,  2208,
		2209,  2210,  2211,  2212,  2213,  2214,  2215,  2216,
		2217,  2218,  2219,  2220,  2221,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     1566,  1566,
		1566,  1566,  1566,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 0,
		0,     0,     0,     0,     -1435, 1708,  1709,  0,
		2154,  2155,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     0,     32767, 32767, 4774,  4775,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     -2552, 0,     0,     32767,
		0,     32767, 32767, 32767, 1551,  293,   3770,  32767,
		32767, 32767, 32767, 0,     32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 0,
		0,     32767, 0,     0,     32767, 32767, 32767, 32767,
		0,     32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -4309, -4309, 0,     32767,
		0,     -4310, -4577, -4310, -7613, -4310, 3374,  3375,
		-4310, -4310, 1672,  -3100, 1881,  -3100, 2031,  2032,
		6173,  -7625, -3100, 2035,  6178,  -3100, -3100, -3100,
		-3100, 2039,  2040,  32767, 0,     -4353, -4353, 0,
		-4352, 0,     0,     -4350, 0,     -4349, -4349, -4349,
		-4349, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 0,     0,     32767, 0,     0,
		32767, 0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     951,   952,   953,   954,   955,   956,   957,
		1717,  0,     32767, 32767, 32767, -1317, 32767, 32767,
		32767, 0,     -8389, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 887,   888,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     32767, -5009, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 5520,  32767, 32767, 32767, 32767,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 5990,  5991,  5992,  5993,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 890,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 891,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 799,   32767, 32767, 32767,
		32767, 800,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 801,   802,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     0,     0,     6545,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     32767, 0,     0,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		-5711, 241,   242,   243,   244,   0,     246,   247,
		248,   249,   250,   251,   252,   0,     0,     0,
		0,     892,   0,     0,     0,     0,     0,     0,
		264,   0,     0,     0,     32767, 32767, 0,     0,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 893,   -266,  895,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		284,   285,   286,   287,   288,   0,     290,   291,
		292,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		293,   294,   295,   296,   297,   298,   32767, 32767,
		299,   -4082, -4081, -4080, 303,   0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 0,     0,     0,     0,
		0,     32767, 0,     32767, 0,     0,     32767, 0,
		0,     32767, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -4245, -4245, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, -689,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -706,
		-706,  -706,  -706,  -706,  -706,  -706,  -706,  32767,
		32767, -7551, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -4377, -4377, -8024, -8023, -4377, -4377,
		-3916, -4377, -4377, -4377, -4377, -4377, -4377, -4377,
		32767, -4378, -4378, -4378, -4378, -4378, -4378, -4378,
		-4378, -4378, -4378, -4378, -4378, -4378, -4378, -4378,
		-4378, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 150,   1867,  150,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     5247,  0,     939,   0,     940,   0,     5518,
		0,     8555,  0,     0,     0,     5253,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     944,
		0,     0,     0,     0,     0,     0,     945,   0,
		946,   0,     0,     947,   948,   0,     949,   950,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -759,  959,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     960,   961,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     5204,  0,     0,     0,
		0,     962,   0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     963,   964,   0,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 5186,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     32767,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 5256,  -4973, -4973, 32767,
		5261,  5262,  5263,  5264,  5265,  5266,  5267,  -4974,
		-4974, 978,   979,   980,   981,   32767, 982,   983,
		984,   985,   986,   987,   988,   32767, 32767, 32767,
		32767, 1624,  32767, 32767, 32767, 32767, 32767, 32767,
		990,   32767, 32767, 0,     991,   992,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4759,
		4760,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -723,  -722,  -2974, 32767, 996,   -719,  -168,
		-717,  -716,  -715,  1002,  1003,  1004,  -712,  -711,
		32767, -710,  1008,  1009,  1010,  1011,  -2060, 5892,
		2764,  2764,  2764,  1017,  1018,  1019,  1020,  1021,
		1022,  2567,  1024,  32767, 1025,  1026,  1027,  1028,
		1029,  1030,  1031,  1032,  1033,  1034,  2589,  1036,
		1037,  -1729, -1729, -1729, -1729, 1042,  4211,  4211,
		4211,  4211,  4211,  4211,  1049,  1050,  4209,  1427,
		32767, 32767, 32767, 0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -825,  32767, 32767,
		32767, 32767, 32767, 4718,  4719,  4720,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4721,  4722,
		4723,  4724,  4725,  4726,  4727,  6291,  6292,  6293,
		4728,  4729,  4730,  4731,  4732,  6299,  6300,  -4992,
		1070,  1071,  1072,  1073,  1074,  1075,  1076,  1077,
		1078,  1079,  1080,  4733,  1082,  4734,  1084,  1085,
		1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,
		1094,  1095,  1096,  1097,  1098,  1099,  1100,  1101,
		1102,  1103,  1104,  1105,  1106,  1107,  1108,  1109,
		1110,  1111,  1112,  1113,  1114,  1115,  1116,  1117,
		1118,  1119,  1120,  1121,  1122,  1123,  1124,  1125,
		1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,
		1134,  1135,  1136,  1137,  1138,  1139,  1140,  1141,
		1142,  1143,  1144,  1145,  1146,  4737,  1148,  4738,
		4739,  1151,  1152,  1153,  1154,  32767, 4740,  4741,
		4742,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
		1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,
		1173,  1174,  1175,  1176,  1177,  1178,  1179,  1180,
		1181,  1182,  1183,  1184,  1185,  1186,  1187,  1188,
		1189,  1190,  1191,  1192,  1193,  1194,  11979, 6272,
		1758,  1758,  1199,  1200,  1201,  1202,  1203,  1204,
		1205,  1206,  1207,  1208,  1209,  1210,  1211,  1212,
		1213,  1214,  1215,  1216,  1217,  1218,  1219,  1220,
		1221,  1222,  1223,  1224,  1225,  1226,  1227,  1228,
		1229,  -1074, -1073, 1232,  1233,  1234,  1235,  1236,
		1237,  1238,  1239,  1240,  1241,  1242,  1243,  1244,
		1245,  1246,  1247,  1248,  1249,  1250,  1251,  1252,
		1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,
		1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,
		1269,  1270,  1271,  1272,  1273,  1274,  1275,  1276,
		1277,  1278,  1279,  1280,  1281,  1282,  1283,  1284,
		1285,  1286,  1287,  1288,  1289,  1290,  1291,  1292,
		1293,  1294,  1295,  1296,  1297,  1298,  1299,  1300,
		1301,  1302,  1303,  1304,  1305,  1306,  1307,  4676,
		4677,  512,   32767, 32767, 32767, 32767, 1683,  1684,
		1685,  1314,  155,   1316,  1317,  1318,  1319,  1320,
		1321,  161,   1323,  1324,  1325,  1326,  1327,  1328,
		1329,  1330,  1331,  1332,  1333,  1334,  1335,  1336,
		1337,  1338,  -4375, -4374, -8536, -8536, -8536, -8536,
		1345,  1346,  1444,  1445,  1446,  1447,  1448,  -4360,
		1353,  1354,  -8525, -5383, 1357,  -8524, -8524, -8524,
		-8524, -4348, 1363,  -2456, 686,   1366,  1367,  -8518,
		-8518, -7581, 1371,  1372,  -5364, 1374,  1375,  -4332,
		-4331, 1378,  1379,  1380,  -4327, -8841, -8841, -8841,
		-8841, -8841, -8841, -8841, 1389,  1390,  -8843, -8843,
		-8843, -8843, -8843, -8843, -8843, -8843, 1399,  1400,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 5957,
		2655,  -5028, -5028, 2658,  2659,  -3322, -1679, -1679,
		-1679, -1679, -1679, -7010, -1679, -1679, -7010, -7010,
		-1679, -1679, -1679, -1679, -1679, 32767, 32767, -1681,
		-1681, -1681, -1681, -1681, -1681, 32767, 32767, -1683,
		-1683, -3290, -3289, -3288, -3287, -3286, -3285, -12842,
		7263,  -3282, -499,  -9550, -499,  -9549, -9549, -9549,
		96,    -9549, -9816, -9549, 1704,  -9548, -1864, -1863,
		-9548, -9548, -3566, -5208, -5207, -5206, -5205, -5204,
		128,   -5202, 131,   132,   133,   32767, 32767, -5195,
		-3568, -3568, -5190, -5189, -3568, 32767, 32767, -5185,
		-5184, -5183, -3570, -5180, 1478,  -5179, -3571, 32767,
		-3572, 32767, -3573, 32767, 5984,  32767, -3575, 2695,
		2696,  2697,  2698,  2699,  2700,  -6944, 2702,  2970,
		2704,  6008,  2706,  -4977, -4977, 2709,  2710,  -3271,
		1502,  -3478, 1504,  -3626, -3626, -7766, 6033,  1509,
		-3625, -7767, 1512,  1513,  1514,  32767, 32767, -3625,
		-3625, -3625, -3625, -3625, -3625, -3625, 1522,  -3624,
		1524,  1525,  1526,  1527,  1528,  1529,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     3128,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     1581,  -673,  0,     784,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     3025,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     -6843,
		-6843, 0,     0,     0,     1619,  1620,  1621,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -2788, 32767, 32767,
		1634,  1635,  1636,  1637,  1638,  1639,  1640,  1641,
		4194,  1643,  1644,  32767, 32767, 32767, 32767, 32767,
		32767, 1352,  32767, 32767, 32767, 32767, 32767, 1646,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1647,  1648,  1649,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 1650,
		32767, 32767, 32767, 1651,  1652,  32767, 1653,  1654,
		32767, 32767, 32767, 32767, 1655,  32767, 1656,  32767,
		32767, 32767, 32767, 399,   399,   32767, 32767, 1657,
		1658,  1659,  32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     32767, 32767, 32767, 1660,
		32767, 32767, 32767, 32767, 32767, 6619,  32767, 1661,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		5971,  5972,  5973,  5974,  1664,  5975,  6243,  5977,
		9281,  5979,  -1704, -1704, 5982,  5983,  2,     4775,
		-205,  4777,  -353,  -353,  -4493, 9306,  4782,  -352,
		-4494, 4785,  4786,  4787,  4788,  -350,  -350,  6044,
		1691,  6045,  6046,  1694,  6047,  1696,  1697,  6048,
		1699,  6049,  6050,  6051,  6052,  0,     0,     0,
		0,     0,     0,     32767, 0,     0,     0,     0,
		1704,  0,     32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, -3338, -3338,
		-3338, 0,     32767, 0,     32767, 0,     0,     0,
		32767, 0,     0,     32767, 0,     32767, 32767, 0,
		0,     0,     0,     0,     32767, 0,     32767, 0,
		1705,  1706,  1707,  1708,  1709,  759,   759,   759,
		759,   759,   759,   759,   0,     0,     0,     0,
		0,     3035,  0,     32767, 0,     1719,  10109, 1721,
		1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
		1730,  0,     0,     0,     0,     0,     0,     0,
		0,     9764,  6757,  6758,  6759,  8018,  0,     0,
		0,     1720,  1720,  1720,  0,     0,     2557,  2558,
		1720,  0,     -1282, 0,     -1281, -1281, -1281, 633,
		1720,  -1279, -1279, 1720,  4767,  0,     1720,  1720,
		0,     0,     1718,  1718,  -3263, 0,     6007,  6008,
		-7790, 6010,  6011,  6012,  -3266, 1719,  0,     1718,
		0,     1717,  0,     -150,  1717,  1717,  1717,  32767,
		1716,  1716,  1716,  3969,  1715,  0,     1716,  1166,
		1716,  1716,  1716,  0,     0,     0,     1717,  1717,
		1717,  1717,  0,     0,     0,     0,     3072,  -4879,
		-1750, -1749, -1748, 0,     0,     0,     0,     0,
		0,     -1544, 0,     1789,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -1554, 0,
		0,     2767,  2768,  2769,  2770,  0,     -3168, -3167,
		-3166, -3165, -3164, -3163, 0,     0,     -3158, -375,
		-9426, -375,  -9425, 1821,  1822,  218,   -9427, 1825,
		-9426, 1827,  1828,  -1742, -1741, 1878,  1879,  1833,
		1834,  32767, 32767, 32767, 32767, 2642,  -4765, -1739,
		-1738, 32767, 1835,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 2718,  -3491, 3174,  3174,  3174,
		-3669, -3669, -3669, -3669, -3669, -5232, -5232, -5232,
		-3666, -3666, -3666, -3666, -3666, -5232, -5232, 6061,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -3652, 0,     -3651, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -3590, 0,     -3589,
		-3589, 0,     0,     0,     0,     32767, 1842,  32767,
		32767, 32767, 32767, 1843,  32767, 32767, 1844,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1845,  32767,
		1846,  32767, 32767, 32767, 32767, 32767, 1847,  1848,
		0,     1849,  1850,  0,     32767, 32767, 0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 1851,  32767, 32767, 1852,  32767,
		32767, 1853,  32767, 1854,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -4903, 32767, -6162, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 137,
		1858,  3141,  1860,  3142,  32767, 32767, 1229,  143,
		32767, 32767, 144,   -2902, 0,     0,     32767, 32767,
		32767, 32767, 148,   5130,  0,     0,     -4140, 9659,
		32767, 0,     -4142, 5137,  5138,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     32767,
		0,     5148,  5149,  5150,  5151,  5152,  5153,  4782,
		3623,  3623,  3623,  3623,  3623,  3623,  3623,  3623,
		3623,  3623,  3623,  3623,  3623,  3623,  6751,  3623,
		3623,  3623,  3623,  3623,  3623,  3623,  3623,  3623,
		3623,  3623,  3623,  3623,  32767, 3622,  3622,  3622,
		3622,  32767, 3621,  3621,  3621,  0,     3622,  32767,
		3621,  32767, 32767, 32767, 3618,  3618,  3618,  3618,
		3618,  3618,  3618,  32767, 2944,  0,     4402,  3618,
		3618,  3618,  3618,  3618,  3618,  3618,  3618,  3618,
		3618,  3618,  3618,  3618,  0,     0,     3620,  3620,
		3620,  3620,  3620,  3620,  -762,  6646,  3621,  3621,
		3621,  3621,  3621,  3621,  3621,  3621,  3621,  3621,
		-3222, -3222, 3621,  3621,  3621,  5240,  5241,  5242,
		0,     0,     3623,  3623,  3623,  0,     3624,  3624,
		3624,  3624,  3624,  3624,  3624,  3624,  836,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -3647, -3646, 0,     0,
		461,   0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     468,   0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     32767, 0,     470,   471,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 472,   473,   474,   475,   476,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 775,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4803,  4804,  7596,  7596,  7596,
		4808,  4809,  4810,  4811,  4812,  4813,  4814,  4815,
		4816,  4817,  4818,  4819,  4820,  4821,  4822,  4823,
		4824,  3988,  3988,  4827,  4828,  7830,  1792,  7832,
		7833,  7834,  5921,  4835,  7835,  7836,  4838,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     3036,  6038,  0,
		6040,  6041,  6042,  4129,  3043,  6043,  6044,  3046,
		0,     3048,  3049,  3050,  6046,  6047,  3053,  3054,
		3055,  3056,  -1230, 3058,  3059,  -1232, -1232, 3062,
		3063,  3064,  3065,  3066,  3067,  3068,  3069,  3070,
		3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,
		3079,  3080,  3081,  3632,  3083,  3084,  3085,  3086,
		3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,
		3095,  3096,  3097,  3098,  3099,  3100,  3101,  3102,
		3103,  -814,  3105,  3106,  3107,  3108,  -6867, 3110,
		3111,  3112,  3113,  9179,  9180,  3116,  3117,  3118,
		3119,  -22,   3121,  3122,  3123,  3124,  3125,  3126,
		3127,  3128,  3129,  3130,  2196,  3132,  3133,  2197,
		3135,  3136,  3137,  3138,  3139,  3140,  3141,  3142,
		3143,  3144,  -6500, 3146,  3414,  3148,  6452,  3150,
		-4533, -4533, 3153,  3154,  -2827, -1184, -1184, -1184,
		-1184, -1184, -6515, -1184, -1184, -6515, -6515, -1184,
		-1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
		-1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
		-2791, -2790, -2789, -2788, -2787, -2786, -12343,7762,
		-2783, 0,     -9051, 0,     -9050, -9050, -9050, 595,
		-9050, -9317, -9050, 2203,  -9049, -1365, -1364, -9049,
		-9049, -3067, -4709, -4708, -4707, -4706, -4705, 627,
		-4703, 630,   631,   632,   -3067, -3067, -4694, -3067,
		-3067, -4689, -4688, -3067, 3131,  -4683, -4682, -4681,
		-4680, -3067, -4677, 1981,  -4676, -3068, -3068, -3068,
		-3068, -3068, -3068, 6490,  -13614,-3068, 3202,  3203,
		3204,  3205,  3206,  3207,  -6437, 3209,  3477,  3211,
		6515,  3213,  -4470, -4470, 3216,  3217,  -2764, 2009,
		-2971, 2011,  -3119, -3119, -7259, 6540,  2016,  -3118,
		-7260, 2019,  2020,  2021,  2022,  -3116, -3116, 3278,
		3279,  3280,  3281,  3282,  3283,  3284,  3285,  3286,
		3287,  3288,  3289,  3290,  3291,  32767, 3292,  3293,
		-869,  -869,  -869,  -869,  9107,  9108,  9109,  9110,
		9111,  9112,  9113,  3305,  32767, 32767, -863,  32767,
		-864,  32767, 32767, -866,  -866,  3310,  3311,  -864,
		-864,  -864,  71,    -864,  -864,  32767, 72,    32767,
		2290,  32767, 32767, 3320,  3321,  32767, 32767, 32767,
		3322,  -1192, -1192, -1192, -1192, -1192, -1192, -1192,
		-1192, -1192, -1192, -1192, -1192, -1192, -1192, -1192,
		-1192, -1192, -1192, -1192, -1192, -1192, -1192, -1192,
		-1192, -1192, -1192, -1192, -1192, -1192, -1192, -1192,
		-1192, -1192, -1192, -1192, -1192, -1192, -1192, -1192,
		-1192, -1192, -1192, 3365,  3366,  3367,  -1189, -1189,
		-1189, -1189, -1189, -1189, 3374,  3375,  -1187, -1187,
		-1187, -1187, -1187, -1187, 3382,  3383,  -1185, -1185,
		-1185, -1185, -1185, -1185, 32767, 32767, -1185, -1185,
		-1185, 3393,  3394,  3395,  -1182, 3397,  3398,  3399,
		3400,  3401,  3402,  1274,  1274,  3405,  -5404, 3407,
		3408,  3409,  3410,  1274,  1274,  1274,  1274,  1274,
		1274,  1274,  1274,  1274,  1274,  1274,  1274,  1274,
		1274,  1274,  1274,  1274,  1274,  1274,  1274,  1274,
		3432,  3433,  3434,  3435,  3436,  3437,  3438,  3439,
		3440,  3441,  3442,  3443,  3444,  3445,  3446,  3447,
		3448,  3449,  3450,  3451,  3452,  3453,  3454,  3455,
		-1138, -1138, -1138, -1138, -1138, 3461,  3462,  3299,
		3464,  3465,  3466,  3467,  3468,  3469,  3470,  3471,
		3472,  3473,  3474,  3475,  3476,  3477,  3478,  3479,
		3480,  3481,  3482,  3483,  3484,  3485,  3486,  3487,
		3488,  3489,  3490,  3491,  3492,  3493,  3494,  3495,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3496,
		3497,  3498,  3499,  3500,  3501,  3502,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3503,  3211,  3211,  3211,  3211,  32767,
		32767, 32767, 32767, 32767, 7590,  7590,  7590,  3208,
		3512,  3513,  3514,  3515,  3516,  3517,  3518,  3519,
		3520,  3521,  3522,  3523,  3524,  3525,  3526,  3527,
		3528,  3529,  3530,  3531,  3532,  3533,  32767, 3534,
		3535,  3536,  3537,  3538,  32767, 3539,  32767, 3540,
		3541,  32767, 3542,  3543,  32767, 3544,  3545,  3546,
		3547,  3548,  3549,  3550,  3551,  3552,  3553,  3554,
		3555,  3556,  3557,  3558,  3559,  3560,  3561,  3562,
		3563,  3564,  3565,  3566,  3567,  3568,  3569,  3570,
		3571,  3572,  3573,  3574,  3575,  3576,  3577,  3578,
		3579,  3580,  3581,  3582,  3583,  3584,  3585,  3586,
		3587,  3588,  3589,  3590,  3591,  3592,  3593,  3594,
		3595,  3596,  3597,  3598,  3599,  3600,  3601,  3602,
		3603,  3604,  3605,  3606,  3607,  3608,  3609,  3610,
		3611,  3612,  3613,  3614,  3615,  3616,  3617,  3618,
		3619,  3620,  3621,  3622,  3623,  3624,  3625,  3626,
		3627,  3628,  3629,  3630,  3631,  3632,  3633,  3634,
		3635,  3636,  3637,  3638,  3639,  3640,  3641,  3642,
		3643,  3644,  3645,  3646,  3647,  3648,  3649,  3650,
		3651,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3652,  3653,  3654,  3655,  3656,  3657,
		3658,  3659,  3660,  3661,  3662,  3663,  3664,  3665,
		3666,  3667,  3668,  3669,  3670,  3671,  3672,  3673,
		3674,  3675,  3676,  3677,  3678,  3679,  3680,  3681,
		3682,  3683,  3684,  3685,  3686,  3687,  3688,  3689,
		3690,  3691,  3692,  3693,  3694,  3695,  3696,  32767,
		3244,  3698,  3699,  3700,  3701,  3702,  4131,  3704,
		3251,  3251,  3707,  3252,  3709,  3710,  3711,  3255,
		3713,  3714,  3715,  3716,  3259,  3259,  3259,  3720,
		3721,  3722,  3723,  3724,  3725,  3726,  3727,  3728,
		3729,  3730,  3731,  3732,  0,     0,     3735,  3736,
		3737,  3738,  3739,  3740,  3741,  3742,  3743,  3744,
		3745,  3746,  3747,  3748,  3749,  3750,  3751,  3752,
		3753,  3754,  3755,  3756,  3757,  3758,  3759,  3760,
		3761,  3300,  3763,  3764,  3765,  3766,  3767,  3768,
		3769,  3770,  3771,  3772,  3773,  3774,  3775,  3776,
		3777,  3778,  3779,  3780,  3781,  3782,  3783,  3784,
		3322,  3322,  3787,  3323,  3789,  3790,  3791,  3326,
		3793,  3794,  3795,  3796,  3330,  3798,  3330,  3800,
		3801,  3802,  3803,  3804,  3805,  3806,  3807,  3808,
		3809,  3810,  3811,  3812,  3813,  3814,  3815,  3816,
		3817,  3818,  3819,  3820,  3821,  3822,  3823,  3824,
		3825,  -1667, 3827,  3828,  3829,  3830,  3831,  3832,
		3833,  3834,  3835,  3836,  3837,  3838,  3839,  3840,
		3841,  3842,  3843,  3844,  -1685, 3846,  3847,  3848,
		3849,  3850,  3851,  3852,  3853,  3854,  3855,  3856,
		3857,  3858,  3859,  3860,  3861,  3862,  3863,  3864,
		3865,  3866,  3867,  3868,  3869,  3870,  3871,  3872,
		3873,  3874,  3875,  3876,  3877,  3878,  3879,  3880,
		3881,  3882,  3883,  3884,  3885,  3886,  3887,  3888,
		3889,  3890,  3891,  3892,  3893,  3894,  3895,  3896,
		3897,  8237,  8238,  3900,  3901,  3902,  3903,  3904,
		3905,  3906,  3907,  3908,  3909,  3910,  3911,  3912,
		11266, 11267, 11268, 9355,  3917,  3918,  11272, 8274,
		3921,  3922,  3438,  3438,  3438,  3438,  3438,  3438,
		3929,  3930,  3440,  3440,  3440,  3440,  6476,  9478,
		3937,  3938,  9483,  9484,  7571,  6485,  9485,  9486,
		6488,  3442,  6490,  6491,  6492,  9488,  3951,  3952,
		32767, -866,  -866,  -866,  -866,  -866,  -866,  -29,
		-28,   -866,  -866,  -3867, 2172,  -3867, -3867, -3867,
		-1953, -866,  -3865, -3865, -866,  3973,  3974,  3975,
		3976,  3977,  3978,  3979,  3980,  3981,  3982,  3983,
		3984,  3985,  3986,  951,   -2050, 3989,  -2050, -2050,
		-2050, -136,  951,   -2048, -2048, 951,   3998,  951,
		951,   951,   -2044, -2044, 951,   951,   951,   951,
		5238,  951,   951,   5243,  5244,  951,   951,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 383,   933,   933,   933,   933,   933,   933,
		933,   933,   933,   933,   933,   933,   933,   933,
		933,   933,   933,   933,   933,   933,   933,   4851,
		933,   933,   933,   933,   10909, 933,   933,   933,
		933,   -5132, -5132, 933,   933,   933,   933,   4075,
		933,   933,   933,   933,   933,   933,   933,   933,
		933,   933,   1868,  933,   933,   1870,  933,   933,
		933,   933,   933,   933,   933,   933,   933,   933,
		10578, 0,     32767, 931,   -2372, 931,   8615,  8616,
		931,   931,   6913,  5271,  5272,  5273,  5274,  5275,
		10607, 5277,  5278,  10610, 10611, 5281,  5282,  5283,
		5284,  5285,  5286,  5287,  5288,  5289,  5290,  5291,
		5292,  5293,  5294,  5295,  5296,  5297,  6905,  6905,
		6905,  6905,  6905,  6905,  16463, -3641, 6905,  4123,
		13175, 4125,  13176, 13177, 13178, 3534,  13180, 13448,
		13182, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -2357, 17748, 7203,  934,   934,   934,   934,
		934,   934,   10579, 934,   667,   934,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4146,  4147,  4148,  4149,  4150,  4151,
		4152,  4153,  4154,  4155,  32767, 32767, 32767, 32767,
		32767, 32767, 4156,  4157,  4158,  4159,  4160,  4161,
		4162,  4163,  4164,  4165,  4166,  4167,  4168,  4169,
		4170,  4171,  4172,  4173,  4174,  4175,  4176,  4177,
		4178,  4179,  4180,  4181,  4182,  5374,  5375,  5376,
		6978,  4187,  4188,  4189,  4190,  6982,  6982,  32767,
		32767, 4193,  4194,  4195,  4196,  4197,  4198,  4199,
		4200,  4201,  4202,  4203,  4204,  32767, 6995,  6995,
		4207,  4208,  4209,  4210,  4211,  4212,  4213,  4214,
		4215,  4216,  4217,  4218,  4219,  4220,  4221,  4222,
		4223,  32767, 3386,  4225,  4226,  7228,  32767, 32767,
		32767, 32767, 5315,  4229,  7229,  32767, 4231,  32767,
		4232,  4233,  4234,  7230,  7231,  4237,  4238,  4239,
		4240,  -46,   4242,  4243,  -48,   -48,   4246,  4247,
		4248,  4249,  4250,  4251,  4252,  4253,  4254,  4255,
		4256,  4257,  4258,  4259,  4260,  4261,  4262,  4263,
		4264,  4265,  4816,  4267,  4268,  4269,  4270,  4271,
		4272,  4273,  4274,  4275,  4276,  4277,  4278,  4279,
		4280,  4281,  4282,  4283,  4284,  4285,  4286,  4287,
		370,   4289,  4290,  4291,  4292,  -5683, 4294,  4295,
		4296,  4297,  10363, 10364, 4300,  4301,  4302,  4303,
		1162,  4305,  4306,  4307,  4308,  4309,  4310,  4311,
		4312,  4313,  4314,  3380,  4316,  4317,  3381,  4319,
		4320,  4321,  4322,  4323,  4324,  4325,  4326,  4327,
		4328,  -5316, 4330,  4598,  4332,  7636,  4334,  -3349,
		-3349, 4337,  4338,  -1643, 0,     0,     0,     0,
		0,     -5331, 0,     0,     -5331, -5331, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     4126,
		4127,  4128,  4129,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -1258, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-1272, -1272, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -1851, -1851, -1851, -1851,
		-1851, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     3235,  0,     -6925, 306,
		306,   306,   306,   306,   306,   306,   306,   306,
		306,   306,   306,   -1764, -1764, 4472,  4473,  311,
		311,   311,   311,   10287, 10288, 10289, 10290, 10291,
		10292, 10293, 4485,  10198, 319,   319,   3461,  319,
		319,   319,   319,   319,   4495,  4496,  321,   321,
		321,   1256,  321,   321,   1258,  1258,  0,     3477,
		10215, 10216, 4509,  4510,  10219, 10220, 10221, 4514,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     4579,  4580,  4581,  4582,
		4583,  4584,  32767, 2455,  4586,  -4223, 4588,  4589,
		4590,  4591,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4885,  4886,  4887,
		4888,  4889,  4890,  4891,  4892,  4893,  4894,  4895,
		4896,  4897,  4898,  4899,  4900,  4901,  4902,  4903,
		4904,  4616,  4906,  4907,  4908,  4909,  4910,  4911,
		4912,  4913,  4914,  4915,  4916,  4917,  4918,  4919,
		4920,  4921,  4922,  4923,  4924,  4925,  4926,  4927,
		4928,  4929,  4930,  4931,  4932,  4933,  4934,  4935,
		4936,  4937,  4938,  4939,  4940,  4941,  4942,  4943,
		4944,  4945,  4946,  4947,  4948,  567,   568,   569,
		4952,  -2455, 571,   572,   4956,  4957,  4958,  4959,
		4960,  4961,  4962,  4963,  4964,  4965,  4966,  4967,
		4968,  4969,  32767, 4970,  4971,  4972,  4973,  4974,
		4975,  4976,  4977,  4978,  4979,  4980,  6623,  6623,
		6623,  6623,  6623,  1292,  6623,  1291,  1291,  1291,
		4991,  4992,  6620,  4994,  4995,  6618,  6618,  4998,
		-1199, 6616,  6616,  6616,  6616,  5004,  6615,  6615,
		6615,  5008,  5009,  5010,  5011,  5012,  5013,  -4544,
		15561, 5016,  -1253, -1253, -1253, -1253, -1253, -1253,
		8392,  -1253, -1520, -1253, -4556, -1253, 6431,  6432,
		-1253, -1253, 4729,  3087,  3088,  3089,  3090,  3091,
		8423,  3093,  3094,  8426,  8427,  3097,  3098,  3099,
		3100,  3101,  3102,  3103,  3104,  3105,  3106,  3107,
		3108,  3109,  3110,  3111,  3112,  3113,  4721,  4721,
		4721,  4721,  4721,  4721,  14279, -5825, 4721,  1939,
		10991, 1941,  10992, 10993, 10994, 1350,  10996, 11264,
		10998, -254,  10999, 3316,  3316,  11002, 11003, 5022,
		6665,  6665,  6665,  6665,  6665,  1334,  6665,  1333,
		1333,  1333,  5033,  5034,  6662,  5036,  5037,  6660,
		6660,  5040,  -1157, 6658,  6658,  6658,  6658,  5046,
		6657,  0,     6658,  5051,  5052,  5053,  5054,  5055,
		5056,  -4501, 15604, 5059,  -1210, -1210, -1210, -1210,
		-1210, -1210, 8435,  -1210, -1477, -1210, -4513, -1210,
		6474,  6475,  -1210, -1210, 4772,  0,     4981,  0,
		5131,  5132,  9273,  -4525, 0,     5135,  9278,  0,
		0,     0,     0,     5139,  5140,  5141,  5142,  5143,
		5144,  5145,  5146,  0,     5147,  0,     0,     0,
		0,     0,     0,     1530,  1531,  1532,  1533,  1534,
		1535,  1536,  1537,  1538,  1539,  1540,  1541,  1542,
		1543,  1544,  -1583, 1546,  1547,  1548,  1549,  1550,
		1551,  1552,  1553,  1554,  1555,  1556,  1557,  1558,
		1559,  1560,  1561,  1562,  1563,  1564,  1565,  1566,
		1567,  5189,  1568,  1569,  1570,  1571,  1572,  1573,
		1574,  1575,  1576,  1577,  1578,  1579,  1580,  0,
		2255,  5200,  799,   1584,  1585,  1586,  1587,  1588,
		1589,  1590,  1591,  1592,  1593,  1594,  1595,  1596,
		5215,  5216,  1597,  1598,  1599,  1600,  1601,  1602,
		5985,  -1422, 1604,  1605,  1606,  1607,  1608,  1609,
		1610,  1611,  1612,  1613,  8457,  8458,  1616,  1617,
		1618,  0,     0,     0,     5243,  5244,  1622,  1623,
		1624,  5248,  1625,  1626,  1627,  1628,  1629,  1630,
		1631,  1632,  4421,  5258,  5259,  5260,  5261,  5262,
		5263,  5264,  5265,  5266,  5267,  5268,  5269,  5270,
		5271,  5272,  5273,  5274,  5275,  5276,  5277,  5278,
		5279,  5280,  5281,  5282,  5283,  5284,  5285,  5286,
		8934,  8934,  5289,  5290,  4830,  5292,  5293,  5294,
		5295,  5296,  5297,  5298,  5299,  5300,  5301,  5302,
		5303,  5304,  5305,  5306,  5307,  5308,  5309,  5310,
		5311,  5312,  5313,  5314,  5315,  5316,  5317,  5318,
		5319,  5320,  5321,  5322,  5323,  5324,  5325,  5326,
		5327,  5328,  5329,  5330,  5331,  5332,  5333,  5334,
		5335,  5336,  5337,  5338,  5339,  5340,  5341,  5342,
		5343,  5344,  5345,  5346,  5347,  5348,  5349,  5350,
		5351,  5352,  5353,  5354,  5355,  5356,  5357,  5358,
		4891,  5360,  5361,  5362,  5363,  5364,  5365,  5366,
		5367,  5368,  5369,  5370,  5371,  5372,  32767, 5373,
		5374,  -5231, 5376,  4532,  0,     5379,  5380,  5381,
		5382,  4270,  4271,  4272,  4273,  4274,  4275,  4276,
		4277,  4278,  12230, 9102,  9102,  9102,  5396,  8890,
		5398,  5399,  5400,  5401,  8899,  7356,  5568,  7358,
		7359,  0,     0,     7364,  7365,  7366,  7367,  7368,
		7369,  8924,  7371,  7372,  4606,  4606,  4606,  4606,
		7377,  10546, 10546, 10546, 10546, 10546, 10546, 20104,
		0,     10546, 7764,  16816, 7766,  16817, 5572,  5572,
		7177,  16823, 17091, 16825, 5573,  5573,  9144,  9144,
		5526,  0,     5574,  5574,  5450,  5451,  5452,  697,
		697,   5455,  0,     7172,  5458,  5576,  5460,  -5456,
		5462,  5463,  5464,  0,     0,     4691,  5468,  5469,
		4693,  5471,  10898, 0,     0,     5475,  4698,  10908,
		5478,  5479,  5480,  5481,  1359,  1359,  1359,  5485,
		5486,  5487,  5488,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
		1359,  101,   1359,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
		87,    87,    1359,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  -492,  -492,  -492,  -492,
		-492,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
		1359,  1359,  1359,  1359,  4594,  1359,  -5566, 1665,
		1665,  1665,  1665,  1665,  1665,  1665,  1665,  1665,
		1665,  1665,  1665,  -405,  -405,  5585,  5586,  1668,
		1668,  1668,  1668,  11644, 11645, 11646, 11647, 11648,
		11649, 11650, 5842,  11555, 1676,  1676,  4818,  1676,
		1676,  1676,  1676,  1676,  5852,  5853,  1678,  1678,
		1678,  2613,  1678,  1678,  2615,  2615,  1357,  4834,
		11572, 11573, 5866,  5867,  11576, 11577, 11578, 5871,
		1357,  1357,  1357,  1357,  1357,  1357,  1357,  1357,
		1357,  -6594, -3465, -3464, -3463, 244,   -3249, 244,
		244,   244,   244,   -3253, -1709, 80,    -1709, -1709,
		5651,  5652,  -1711, -1711, -1711, -1711, -1711, -1711,
		-3265, -1711, -1711, 1056,  1057,  1058,  1059,  -1711,
		-4879, -4878, -4877, -4876, -4875, -4874, -14431,5674,
		-4871, -2088, -11139,-2088, -11138,108,   109,   -1495,
		-11140,-11407,-11140,113,   114,   -3456, -3455, 164,
		5691,  118,   119,   244,   244,   244,   5000,  5001,
		244,   5700,  -1471, 244,   127,   244,   11161, 244,
		244,   244,   5709,  5710,  1020,  244,   244,   1021,
		244,   -5182, 5717,  5718,  244,   1022,  -5187, 244,
		244,   244,   244,   4367,  4368,  4369,  244,   244,
		244,   244,   4374,  4375,  4376,  4377,  4378,  4379,
		4380,  4381,  4382,  4383,  4384,  4385,  4386,  4387,
		5646,  4389,  4390,  4391,  4392,  4393,  4394,  4395,
		4396,  4397,  4398,  4399,  4400,  4401,  4402,  5675,
		5676,  4405,  4406,  4407,  4408,  4409,  4410,  4411,
		4412,  4413,  4414,  4415,  4416,  4417,  4418,  4419,
		4420,  4421,  4422,  4423,  4424,  4425,  4426,  4427,
		4428,  4429,  4430,  4431,  4432,  4433,  4434,  4435,
		4436,  4437,  4438,  6290,  6291,  6292,  6293,  6294,
		4444,  4445,  4446,  4447,  4448,  4449,  4450,  4451,
		4452,  4453,  4454,  1220,  4456,  11382, 4152,  4153,
		4154,  4155,  4156,  4157,  4158,  4159,  4160,  4161,
		4162,  4163,  6234,  6235,  0,     0,     4163,  4164,
		4165,  4166,  -5809, -5809, -5809, -5809, -5809, -5809,
		-5809, 0,     -5712, 4168,  4169,  1028,  4171,  4172,
		4173,  4174,  4175,  0,     0,     4176,  4177,  4178,
		3244,  4180,  4181,  3245,  3246,  4505,  1029,  -5708,
		-5708, 0,     0,     -5708, -5708, -5708, 0,     4515,
		4516,  4517,  4518,  4519,  4520,  4521,  4522,  4523,
		4524,  4525,  4526,  4527,  4528,  4529,  4530,  4531,
		4532,  4533,  4534,  4535,  4536,  4537,  4538,  4539,
		4540,  4541,  4542,  4543,  4544,  4545,  4546,  4547,
		4548,  4549,  4550,  4551,  4552,  4553,  4554,  4555,
		4556,  0,     0,     0,     4557,  4558,  4559,  4560,
		4561,  4562,  0,     0,     4563,  4564,  4565,  4566,
		4567,  4568,  0,     0,     4569,  4570,  4571,  4572,
		4573,  4574,  2114,  2115,  4575,  4576,  4577,  0,
		0,     0,     4578,  0,     0,     0,     0,     0,
		0,     2129,  2130,  0,     8810,  0,     0,     0,
		0,     2137,  2138,  2139,  2140,  2141,  2142,  2143,
		2144,  2145,  2146,  2147,  2148,  2149,  2150,  2151,
		2152,  2153,  2154,  2155,  2156,  2157,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     4594,  4595,
		4596,  4597,  4598,  0,     0,     164,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     2222,  2223,
		2224,  2225,  2226,  2227,  2228,  2229,  2230,  2231,
		2232,  2233,  2234,  2235,  2236,  2237,  2238,  2239,
		2240,  2241,  2242,  2243,  2244,  2245,  2246,  2247,
		2248,  2249,  2250,  2251,  2252,  2253,  2254,  2255,
		2256,  2257,  2258,  2259,  2260,  2261,  2262,  2263,
		2264,  2265,  2266,  2267,  2268,  2269,  2270,  705,
		706,   707,   708,   709,   2276,  2277,  2278,  2279,
		2280,  2281,  2282,  2283,  2284,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		2285,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 2286,  2287,  2288,  2289,  2290,  2291,
		32767, 32767, 32767, 32767, 32767, 32767, 2292,  32767,
		2293,  2294,  2295,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2296,  32767, 2297,  32767,
		2298,  32767, 2299,  32767, 2300,  32767, 2301,  32767,
		2302,  32767, 2303,  32767, 2304,  32767, 2305,  32767,
		2306,  32767, 2307,  32767, 32767, 2308,  32767, 2309,
		32767, 2310,  32767, 32767, 32767, 32767, 32767, 32767,
		2311,  2312,  32767, 2313,  2314,  32767, 2315,  2316,
		32767, 2317,  2318,  32767, 2319,  2320,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2321,  32767, 32767, 32767,
		32767, 2322,  2323,  2324,  2325,  32767, 2326,  2327,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2328,  32767, 2329,  32767,
		2330,  32767, 2331,  32767, 2332,  32767, 2333,  32767,
		2334,  32767, 2335,  32767, 2336,  32767, 2337,  32767,
		2338,  32767, 2339,  32767, 32767, 2340,  32767, 2341,
		32767, 2342,  32767, 32767, 32767, 32767, 32767, 32767,
		2343,  2344,  32767, 2345,  2346,  32767, 2347,  2348,
		32767, 2349,  2350,  32767, 2351,  2352,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2353,  32767, 32767, 2354,
		2355,  2356,  2357,  32767, 32767, 32767, 2358,  2359,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 2360,  2361,  2362,  2363,  2364,  2365,
		2366,  2367,  2368,  2369,  2370,  2371,  2372,  2373,
		2374,  -753,  2376,  2377,  2378,  2379,  2380,  2381,
		2382,  2383,  2384,  2385,  2386,  2387,  2388,  2389,
		2390,  2391,  2392,  2393,  2394,  2395,  2396,  2397,
		2398,  2399,  2400,  2401,  2402,  2403,  2404,  2405,
		2406,  2407,  2408,  2409,  2410,  2411,  831,   3086,
		2414,  1631,  2416,  2417,  2418,  2419,  2420,  2421,
		2422,  2423,  2424,  2425,  2426,  2427,  2428,  2429,
		2430,  2431,  2432,  2433,  2434,  2435,  2436,  2437,
		-587,  2439,  2440,  2441,  2442,  2443,  2444,  2445,
		2446,  2447,  2448,  9292,  9293,  2451,  2452,  2453,
		32767, 32767, 32767, 2454,  2455,  2456,  2457,  2458,
		2459,  2460,  2461,  2462,  2463,  2464,  2465,  2466,
		2467,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4599,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4600,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 2468,  -1450, 2470,  2471,  2472,  2473,
		2474,  2475,  2476,  2477,  2478,  2479,  2480,  2481,
		2482,  2483,  2484,  2485,  2486,  2487,  2488,  2489,
		2490,  2491,  2492,  2493,  2494,  2495,  2496,  2497,
		2498,  32767, 2499,  2500,  2501,  2502,  2503,  2504,
		2505,  2506,  2507,  2508,  2509,  2510,  2511,  2512,
		2513,  2514,  2515,  2516,  2517,  2518,  2519,  2520,
		2521,  2522,  2523,  2524,  2525,  2526,  2527,  2528,
		2529,  2530,  2531,  2532,  2533,  2534,  2535,  2536,
		2537,  2538,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 2539,  2540,  5896,  2542,  2543,  2544,
		2545,  548,   2547,  2548,  2549,  2550,  2551,  2552,
		5919,  5920,  5921,  2556,  2557,  5926,  2559,  2560,
		2561,  2562,  2563,  2564,  2565,  2566,  2567,  2568,
		2569,  2570,  2571,  2572,  2573,  2574,  2575,  2576,
		2577,  2578,  2579,  2580,  2581,  2582,  2583,  2584,
		2585,  32767, 2586,  2587,  2588,  2589,  2590,  2591,
		2592,  2593,  2594,  2595,  2596,  2597,  2598,  2599,
		2600,  2601,  2602,  2603,  2604,  2605,  2606,  2607,
		2608,  2609,  2610,  2611,  2612,  2613,  2614,  2615,
		2616,  2617,  2618,  2619,  2620,  2621,  2622,  2623,
		2624,  2625,  2626,  2627,  2628,  2629,  2630,  2631,
		2632,  2633,  2634,  2635,  2636,  2637,  2638,  2639,
		2640,  2641,  2642,  2643,  2644,  2645,  2646,  2647,
		2648,  2649,  2650,  2651,  2652,  2653,  2654,  2655,
		2656,  2657,  2658,  2659,  2660,  2661,  -703,  2663,
		2664,  2665,  2666,  2667,  2668,  2669,  2670,  2671,
		2672,  2673,  2674,  1999,  2676,  2677,  2678,  2679,
		2680,  2681,  2682,  2683,  2684,  2685,  2686,  2687,
		2688,  2689,  2690,  2014,  2692,  2693,  2694,  2695,
		2696,  2697,  2698,  2699,  2700,  2701,  2702,  2703,
		2704,  2705,  2706,  2707,  2708,  2709,  -11089,2711,
		2712,  2713,  32767, 2714,  2715,  2716,  2717,  2718,
		8050,  2720,  2721,  8053,  8054,  2724,  2725,  2726,
		2727,  2728,  2729,  2730,  2731,  2732,  2733,  2734,
		2735,  2736,  2737,  2738,  2739,  2740,  2741,  2742,
		2743,  2744,  2745,  2746,  2747,  2748,  -1377, -1377,
		-1377, -1377, 2753,  2754,  2755,  2756,  2757,  2758,
		2759,  2760,  2761,  2762,  2763,  2764,  2765,  2766,
		4025,  2768,  2769,  2770,  2771,  2772,  2773,  2774,
		2775,  2776,  2777,  2778,  2779,  2780,  2781,  4054,
		4055,  2784,  2785,  2786,  2787,  2788,  2789,  2790,
		2791,  2792,  2793,  2794,  2795,  2796,  2797,  2798,
		2799,  2800,  2801,  2802,  2803,  2804,  2805,  2806,
		2807,  2808,  2809,  2810,  2811,  2812,  2813,  2814,
		2815,  2816,  2817,  4669,  4670,  4671,  4672,  4673,
		2823,  2824,  2825,  2826,  2827,  2828,  2829,  2830,
		2831,  2832,  2833,  -401,  2835,  9761,  2531,  2532,
		2533,  2534,  2535,  2536,  2537,  2538,  2539,  2540,
		2541,  2542,  4613,  4614,  -1621, -1621, 2542,  2543,
		2544,  2545,  -7430, -7430, -7430, -7430, -7430, -7430,
		-7430, -1621, -7333, 2547,  2548,  -593,  2550,  2551,
		2552,  2553,  2554,  -1621, -1621, 2555,  2556,  2557,
		1623,  2559,  2560,  1624,  1625,  2884,  -592,  -7329,
		-7329, -1621, -1621, -7329, -7329, -7329, -1621, 2894,
		2895,  2896,  2897,  2898,  2899,  2900,  2901,  2902,
		2903,  2904,  2905,  2906,  2907,  2908,  2909,  2910,
		2911,  2912,  2913,  2914,  2915,  2916,  2917,  2918,
		2919,  2920,  2921,  2922,  2923,  2924,  2925,  2926,
		2927,  2928,  2929,  2930,  2931,  2932,  2933,  2934,
		2935,  2936,  2937,  2938,  2939,  2940,  2941,  2942,
		2943,  2944,  2945,  2946,  2947,  2948,  2949,  2950,
		2951,  2952,  2953,  2954,  2955,  2956,  2957,  2958,
		2959,  2960,  2961,  2962,  2963,  2964,  2965,  2966,
		2967,  2968,  2969,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 0,     0,     0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 32767, 0,     32767, 0,     32767, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     32767,
		0,     0,     32767, 0,     0,     32767, 0,     0,
		32767, 0,     0,     32767, 32767, 32767, 32767
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 4;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 8191 + c;
	}
	return h[a % 13687] + h[b % 13687];
}

/* Hash lookup information for decomposition */
static const pg_unicode_decompinfo UnicodeDecompInfo =
{
	UnicodeDecompMain,
	Decomp_hash_func,
	6843
};

/* Inverse lookup array -- contains indexes into UnicodeDecompMain[] */
static const uint16 RecompInverseLookup[961] =
{
	/* U+003C+0338 -> U+226E */ 1858,
	/* U+003D+0338 -> U+2260 */ 1855,
	/* U+003E+0338 -> U+226F */ 1859,
	/* U+0041+0300 -> U+00C0 */ 14,
	/* U+0041+0301 -> U+00C1 */ 15,
	/* U+0041+0302 -> U+00C2 */ 16,
	/* U+0041+0303 -> U+00C3 */ 17,
	/* U+0041+0304 -> U+0100 */ 67,
	/* U+0041+0306 -> U+0102 */ 69,
	/* U+0041+0307 -> U+0226 */ 270,
	/* U+0041+0308 -> U+00C4 */ 18,
	/* U+0041+0309 -> U+1EA2 */ 1313,
	/* U+0041+030A -> U+00C5 */ 19,
	/* U+0041+030C -> U+01CD */ 194,
	/* U+0041+030F -> U+0200 */ 240,
	/* U+0041+0311 -> U+0202 */ 242,
	/* U+0041+0323 -> U+1EA0 */ 1311,
	/* U+0041+0325 -> U+1E00 */ 1155,
	/* U+0041+0328 -> U+0104 */ 71,
	/* U+0042+0307 -> U+1E02 */ 1157,
	/* U+0042+0323 -> U+1E04 */ 1159,
	/* U+0042+0331 -> U+1E06 */ 1161,
	/* U+0043+0301 -> U+0106 */ 73,
	/* U+0043+0302 -> U+0108 */ 75,
	/* U+0043+0307 -> U+010A */ 77,
	/* U+0043+030C -> U+010C */ 79,
	/* U+0043+0327 -> U+00C7 */ 20,
	/* U+0044+0307 -> U+1E0A */ 1165,
	/* U+0044+030C -> U+010E */ 81,
	/* U+0044+0323 -> U+1E0C */ 1167,
	/* U+0044+0327 -> U+1E10 */ 1171,
	/* U+0044+032D -> U+1E12 */ 1173,
	/* U+0044+0331 -> U+1E0E */ 1169,
	/* U+0045+0300 -> U+00C8 */ 21,
	/* U+0045+0301 -> U+00C9 */ 22,
	/* U+0045+0302 -> U+00CA */ 23,
	/* U+0045+0303 -> U+1EBC */ 1339,
	/* U+0045+0304 -> U+0112 */ 83,
	/* U+0045+0306 -> U+0114 */ 85,
	/* U+0045+0307 -> U+0116 */ 87,
	/* U+0045+0308 -> U+00CB */ 24,
	/* U+0045+0309 -> U+1EBA */ 1337,
	/* U+0045+030C -> U+011A */ 91,
	/* U+0045+030F -> U+0204 */ 244,
	/* U+0045+0311 -> U+0206 */ 246,
	/* U+0045+0323 -> U+1EB8 */ 1335,
	/* U+0045+0327 -> U+0228 */ 272,
	/* U+0045+0328 -> U+0118 */ 89,
	/* U+0045+032D -> U+1E18 */ 1179,
	/* U+0045+0330 -> U+1E1A */ 1181,
	/* U+0046+0307 -> U+1E1E */ 1185,
	/* U+0047+0301 -> U+01F4 */ 230,
	/* U+0047+0302 -> U+011C */ 93,
	/* U+0047+0304 -> U+1E20 */ 1187,
	/* U+0047+0306 -> U+011E */ 95,
	/* U+0047+0307 -> U+0120 */ 97,
	/* U+0047+030C -> U+01E6 */ 216,
	/* U+0047+0327 -> U+0122 */ 99,
	/* U+0048+0302 -> U+0124 */ 101,
	/* U+0048+0307 -> U+1E22 */ 1189,
	/* U+0048+0308 -> U+1E26 */ 1193,
	/* U+0048+030C -> U+021E */ 268,
	/* U+0048+0323 -> U+1E24 */ 1191,
	/* U+0048+0327 -> U+1E28 */ 1195,
	/* U+0048+032E -> U+1E2A */ 1197,
	/* U+0049+0300 -> U+00CC */ 25,
	/* U+0049+0301 -> U+00CD */ 26,
	/* U+0049+0302 -> U+00CE */ 27,
	/* U+0049+0303 -> U+0128 */ 103,
	/* U+0049+0304 -> U+012A */ 105,
	/* U+0049+0306 -> U+012C */ 107,
	/* U+0049+0307 -> U+0130 */ 111,
	/* U+0049+0308 -> U+00CF */ 28,
	/* U+0049+0309 -> U+1EC8 */ 1351,
	/* U+0049+030C -> U+01CF */ 196,
	/* U+0049+030F -> U+0208 */ 248,
	/* U+0049+0311 -> U+020A */ 250,
	/* U+0049+0323 -> U+1ECA */ 1353,
	/* U+0049+0328 -> U+012E */ 109,
	/* U+0049+0330 -> U+1E2C */ 1199,
	/* U+004A+0302 -> U+0134 */ 114,
	/* U+004B+0301 -> U+1E30 */ 1203,
	/* U+004B+030C -> U+01E8 */ 218,
	/* U+004B+0323 -> U+1E32 */ 1205,
	/* U+004B+0327 -> U+0136 */ 116,
	/* U+004B+0331 -> U+1E34 */ 1207,
	/* U+004C+0301 -> U+0139 */ 118,
	/* U+004C+030C -> U+013D */ 122,
	/* U+004C+0323 -> U+1E36 */ 1209,
	/* U+004C+0327 -> U+013B */ 120,
	/* U+004C+032D -> U+1E3C */ 1215,
	/* U+004C+0331 -> U+1E3A */ 1213,
	/* U+004D+0301 -> U+1E3E */ 1217,
	/* U+004D+0307 -> U+1E40 */ 1219,
	/* U+004D+0323 -> U+1E42 */ 1221,
	/* U+004E+0300 -> U+01F8 */ 232,
	/* U+004E+0301 -> U+0143 */ 126,
	/* U+004E+0303 -> U+00D1 */ 29,
	/* U+004E+0307 -> U+1E44 */ 1223,
	/* U+004E+030C -> U+0147 */ 130,
	/* U+004E+0323 -> U+1E46 */ 1225,
	/* U+004E+0327 -> U+0145 */ 128,
	/* U+004E+032D -> U+1E4A */ 1229,
	/* U+004E+0331 -> U+1E48 */ 1227,
	/* U+004F+0300 -> U+00D2 */ 30,
	/* U+004F+0301 -> U+00D3 */ 31,
	/* U+004F+0302 -> U+00D4 */ 32,
	/* U+004F+0303 -> U+00D5 */ 33,
	/* U+004F+0304 -> U+014C */ 133,
	/* U+004F+0306 -> U+014E */ 135,
	/* U+004F+0307 -> U+022E */ 278,
	/* U+004F+0308 -> U+00D6 */ 34,
	/* U+004F+0309 -> U+1ECE */ 1357,
	/* U+004F+030B -> U+0150 */ 137,
	/* U+004F+030C -> U+01D1 */ 198,
	/* U+004F+030F -> U+020C */ 252,
	/* U+004F+0311 -> U+020E */ 254,
	/* U+004F+031B -> U+01A0 */ 181,
	/* U+004F+0323 -> U+1ECC */ 1355,
	/* U+004F+0328 -> U+01EA */ 220,
	/* U+0050+0301 -> U+1E54 */ 1239,
	/* U+0050+0307 -> U+1E56 */ 1241,
	/* U+0052+0301 -> U+0154 */ 139,
	/* U+0052+0307 -> U+1E58 */ 1243,
	/* U+0052+030C -> U+0158 */ 143,
	/* U+0052+030F -> U+0210 */ 256,
	/* U+0052+0311 -> U+0212 */ 258,
	/* U+0052+0323 -> U+1E5A */ 1245,
	/* U+0052+0327 -> U+0156 */ 141,
	/* U+0052+0331 -> U+1E5E */ 1249,
	/* U+0053+0301 -> U+015A */ 145,
	/* U+0053+0302 -> U+015C */ 147,
	/* U+0053+0307 -> U+1E60 */ 1251,
	/* U+0053+030C -> U+0160 */ 151,
	/* U+0053+0323 -> U+1E62 */ 1253,
	/* U+0053+0326 -> U+0218 */ 264,
	/* U+0053+0327 -> U+015E */ 149,
	/* U+0054+0307 -> U+1E6A */ 1261,
	/* U+0054+030C -> U+0164 */ 155,
	/* U+0054+0323 -> U+1E6C */ 1263,
	/* U+0054+0326 -> U+021A */ 266,
	/* U+0054+0327 -> U+0162 */ 153,
	/* U+0054+032D -> U+1E70 */ 1267,
	/* U+0054+0331 -> U+1E6E */ 1265,
	/* U+0055+0300 -> U+00D9 */ 35,
	/* U+0055+0301 -> U+00DA */ 36,
	/* U+0055+0302 -> U+00DB */ 37,
	/* U+0055+0303 -> U+0168 */ 157,
	/* U+0055+0304 -> U+016A */ 159,
	/* U+0055+0306 -> U+016C */ 161,
	/* U+0055+0308 -> U+00DC */ 38,
	/* U+0055+0309 -> U+1EE6 */ 1381,
	/* U+0055+030A -> U+016E */ 163,
	/* U+0055+030B -> U+0170 */ 165,
	/* U+0055+030C -> U+01D3 */ 200,
	/* U+0055+030F -> U+0214 */ 260,
	/* U+0055+0311 -> U+0216 */ 262,
	/* U+0055+031B -> U+01AF */ 183,
	/* U+0055+0323 -> U+1EE4 */ 1379,
	/* U+0055+0324 -> U+1E72 */ 1269,
	/* U+0055+0328 -> U+0172 */ 167,
	/* U+0055+032D -> U+1E76 */ 1273,
	/* U+0055+0330 -> U+1E74 */ 1271,
	/* U+0056+0303 -> U+1E7C */ 1279,
	/* U+0056+0323 -> U+1E7E */ 1281,
	/* U+0057+0300 -> U+1E80 */ 1283,
	/* U+0057+0301 -> U+1E82 */ 1285,
	/* U+0057+0302 -> U+0174 */ 169,
	/* U+0057+0307 -> U+1E86 */ 1289,
	/* U+0057+0308 -> U+1E84 */ 1287,
	/* U+0057+0323 -> U+1E88 */ 1291,
	/* U+0058+0307 -> U+1E8A */ 1293,
	/* U+0058+0308 -> U+1E8C */ 1295,
	/* U+0059+0300 -> U+1EF2 */ 1393,
	/* U+0059+0301 -> U+00DD */ 39,
	/* U+0059+0302 -> U+0176 */ 171,
	/* U+0059+0303 -> U+1EF8 */ 1399,
	/* U+0059+0304 -> U+0232 */ 282,
	/* U+0059+0307 -> U+1E8E */ 1297,
	/* U+0059+0308 -> U+0178 */ 173,
	/* U+0059+0309 -> U+1EF6 */ 1397,
	/* U+0059+0323 -> U+1EF4 */ 1395,
	/* U+005A+0301 -> U+0179 */ 174,
	/* U+005A+0302 -> U+1E90 */ 1299,
	/* U+005A+0307 -> U+017B */ 176,
	/* U+005A+030C -> U+017D */ 178,
	/* U+005A+0323 -> U+1E92 */ 1301,
	/* U+005A+0331 -> U+1E94 */ 1303,
	/* U+0061+0300 -> U+00E0 */ 40,
	/* U+0061+0301 -> U+00E1 */ 41,
	/* U+0061+0302 -> U+00E2 */ 42,
	/* U+0061+0303 -> U+00E3 */ 43,
	/* U+0061+0304 -> U+0101 */ 68,
	/* U+0061+0306 -> U+0103 */ 70,
	/* U+0061+0307 -> U+0227 */ 271,
	/* U+0061+0308 -> U+00E4 */ 44,
	/* U+0061+0309 -> U+1EA3 */ 1314,
	/* U+0061+030A -> U+00E5 */ 45,
	/* U+0061+030C -> U+01CE */ 195,
	/* U+0061+030F -> U+0201 */ 241,
	/* U+0061+0311 -> U+0203 */ 243,
	/* U+0061+0323 -> U+1EA1 */ 1312,
	/* U+0061+0325 -> U+1E01 */ 1156,
	/* U+0061+0328 -> U+0105 */ 72,
	/* U+0062+0307 -> U+1E03 */ 1158,
	/* U+0062+0323 -> U+1E05 */ 1160,
	/* U+0062+0331 -> U+1E07 */ 1162,
	/* U+0063+0301 -> U+0107 */ 74,
	/* U+0063+0302 -> U+0109 */ 76,
	/* U+0063+0307 -> U+010B */ 78,
	/* U+0063+030C -> U+010D */ 80,
	/* U+0063+0327 -> U+00E7 */ 46,
	/* U+0064+0307 -> U+1E0B */ 1166,
	/* U+0064+030C -> U+010F */ 82,
	/* U+0064+0323 -> U+1E0D */ 1168,
	/* U+0064+0327 -> U+1E11 */ 1172,
	/* U+0064+032D -> U+1E13 */ 1174,
	/* U+0064+0331 -> U+1E0F */ 1170,
	/* U+0065+0300 -> U+00E8 */ 47,
	/* U+0065+0301 -> U+00E9 */ 48,
	/* U+0065+0302 -> U+00EA */ 49,
	/* U+0065+0303 -> U+1EBD */ 1340,
	/* U+0065+0304 -> U+0113 */ 84,
	/* U+0065+0306 -> U+0115 */ 86,
	/* U+0065+0307 -> U+0117 */ 88,
	/* U+0065+0308 -> U+00EB */ 50,
	/* U+0065+0309 -> U+1EBB */ 1338,
	/* U+0065+030C -> U+011B */ 92,
	/* U+0065+030F -> U+0205 */ 245,
	/* U+0065+0311 -> U+0207 */ 247,
	/* U+0065+0323 -> U+1EB9 */ 1336,
	/* U+0065+0327 -> U+0229 */ 273,
	/* U+0065+0328 -> U+0119 */ 90,
	/* U+0065+032D -> U+1E19 */ 1180,
	/* U+0065+0330 -> U+1E1B */ 1182,
	/* U+0066+0307 -> U+1E1F */ 1186,
	/* U+0067+0301 -> U+01F5 */ 231,
	/* U+0067+0302 -> U+011D */ 94,
	/* U+0067+0304 -> U+1E21 */ 1188,
	/* U+0067+0306 -> U+011F */ 96,
	/* U+0067+0307 -> U+0121 */ 98,
	/* U+0067+030C -> U+01E7 */ 217,
	/* U+0067+0327 -> U+0123 */ 100,
	/* U+0068+0302 -> U+0125 */ 102,
	/* U+0068+0307 -> U+1E23 */ 1190,
	/* U+0068+0308 -> U+1E27 */ 1194,
	/* U+0068+030C -> U+021F */ 269,
	/* U+0068+0323 -> U+1E25 */ 1192,
	/* U+0068+0327 -> U+1E29 */ 1196,
	/* U+0068+032E -> U+1E2B */ 1198,
	/* U+0068+0331 -> U+1E96 */ 1305,
	/* U+0069+0300 -> U+00EC */ 51,
	/* U+0069+0301 -> U+00ED */ 52,
	/* U+0069+0302 -> U+00EE */ 53,
	/* U+0069+0303 -> U+0129 */ 104,
	/* U+0069+0304 -> U+012B */ 106,
	/* U+0069+0306 -> U+012D */ 108,
	/* U+0069+0308 -> U+00EF */ 54,
	/* U+0069+0309 -> U+1EC9 */ 1352,
	/* U+0069+030C -> U+01D0 */ 197,
	/* U+0069+030F -> U+0209 */ 249,
	/* U+0069+0311 -> U+020B */ 251,
	/* U+0069+0323 -> U+1ECB */ 1354,
	/* U+0069+0328 -> U+012F */ 110,
	/* U+0069+0330 -> U+1E2D */ 1200,
	/* U+006A+0302 -> U+0135 */ 115,
	/* U+006A+030C -> U+01F0 */ 226,
	/* U+006B+0301 -> U+1E31 */ 1204,
	/* U+006B+030C -> U+01E9 */ 219,
	/* U+006B+0323 -> U+1E33 */ 1206,
	/* U+006B+0327 -> U+0137 */ 117,
	/* U+006B+0331 -> U+1E35 */ 1208,
	/* U+006C+0301 -> U+013A */ 119,
	/* U+006C+030C -> U+013E */ 123,
	/* U+006C+0323 -> U+1E37 */ 1210,
	/* U+006C+0327 -> U+013C */ 121,
	/* U+006C+032D -> U+1E3D */ 1216,
	/* U+006C+0331 -> U+1E3B */ 1214,
	/* U+006D+0301 -> U+1E3F */ 1218,
	/* U+006D+0307 -> U+1E41 */ 1220,
	/* U+006D+0323 -> U+1E43 */ 1222,
	/* U+006E+0300 -> U+01F9 */ 233,
	/* U+006E+0301 -> U+0144 */ 127,
	/* U+006E+0303 -> U+00F1 */ 55,
	/* U+006E+0307 -> U+1E45 */ 1224,
	/* U+006E+030C -> U+0148 */ 131,
	/* U+006E+0323 -> U+1E47 */ 1226,
	/* U+006E+0327 -> U+0146 */ 129,
	/* U+006E+032D -> U+1E4B */ 1230,
	/* U+006E+0331 -> U+1E49 */ 1228,
	/* U+006F+0300 -> U+00F2 */ 56,
	/* U+006F+0301 -> U+00F3 */ 57,
	/* U+006F+0302 -> U+00F4 */ 58,
	/* U+006F+0303 -> U+00F5 */ 59,
	/* U+006F+0304 -> U+014D */ 134,
	/* U+006F+0306 -> U+014F */ 136,
	/* U+006F+0307 -> U+022F */ 279,
	/* U+006F+0308 -> U+00F6 */ 60,
	/* U+006F+0309 -> U+1ECF */ 1358,
	/* U+006F+030B -> U+0151 */ 138,
	/* U+006F+030C -> U+01D2 */ 199,
	/* U+006F+030F -> U+020D */ 253,
	/* U+006F+0311 -> U+020F */ 255,
	/* U+006F+031B -> U+01A1 */ 182,
	/* U+006F+0323 -> U+1ECD */ 1356,
	/* U+006F+0328 -> U+01EB */ 221,
	/* U+0070+0301 -> U+1E55 */ 1240,
	/* U+0070+0307 -> U+1E57 */ 1242,
	/* U+0072+0301 -> U+0155 */ 140,
	/* U+0072+0307 -> U+1E59 */ 1244,
	/* U+0072+030C -> U+0159 */ 144,
	/* U+0072+030F -> U+0211 */ 257,
	/* U+0072+0311 -> U+0213 */ 259,
	/* U+0072+0323 -> U+1E5B */ 1246,
	/* U+0072+0327 -> U+0157 */ 142,
	/* U+0072+0331 -> U+1E5F */ 1250,
	/* U+0073+0301 -> U+015B */ 146,
	/* U+0073+0302 -> U+015D */ 148,
	/* U+0073+0307 -> U+1E61 */ 1252,
	/* U+0073+030C -> U+0161 */ 152,
	/* U+0073+0323 -> U+1E63 */ 1254,
	/* U+0073+0326 -> U+0219 */ 265,
	/* U+0073+0327 -> U+015F */ 150,
	/* U+0074+0307 -> U+1E6B */ 1262,
	/* U+0074+0308 -> U+1E97 */ 1306,
	/* U+0074+030C -> U+0165 */ 156,
	/* U+0074+0323 -> U+1E6D */ 1264,
	/* U+0074+0326 -> U+021B */ 267,
	/* U+0074+0327 -> U+0163 */ 154,
	/* U+0074+032D -> U+1E71 */ 1268,
	/* U+0074+0331 -> U+1E6F */ 1266,
	/* U+0075+0300 -> U+00F9 */ 61,
	/* U+0075+0301 -> U+00FA */ 62,
	/* U+0075+0302 -> U+00FB */ 63,
	/* U+0075+0303 -> U+0169 */ 158,
	/* U+0075+0304 -> U+016B */ 160,
	/* U+0075+0306 -> U+016D */ 162,
	/* U+0075+0308 -> U+00FC */ 64,
	/* U+0075+0309 -> U+1EE7 */ 1382,
	/* U+0075+030A -> U+016F */ 164,
	/* U+0075+030B -> U+0171 */ 166,
	/* U+0075+030C -> U+01D4 */ 201,
	/* U+0075+030F -> U+0215 */ 261,
	/* U+0075+0311 -> U+0217 */ 263,
	/* U+0075+031B -> U+01B0 */ 184,
	/* U+0075+0323 -> U+1EE5 */ 1380,
	/* U+0075+0324 -> U+1E73 */ 1270,
	/* U+0075+0328 -> U+0173 */ 168,
	/* U+0075+032D -> U+1E77 */ 1274,
	/* U+0075+0330 -> U+1E75 */ 1272,
	/* U+0076+0303 -> U+1E7D */ 1280,
	/* U+0076+0323 -> U+1E7F */ 1282,
	/* U+0077+0300 -> U+1E81 */ 1284,
	/* U+0077+0301 -> U+1E83 */ 1286,
	/* U+0077+0302 -> U+0175 */ 170,
	/* U+0077+0307 -> U+1E87 */ 1290,
	/* U+0077+0308 -> U+1E85 */ 1288,
	/* U+0077+030A -> U+1E98 */ 1307,
	/* U+0077+0323 -> U+1E89 */ 1292,
	/* U+0078+0307 -> U+1E8B */ 1294,
	/* U+0078+0308 -> U+1E8D */ 1296,
	/* U+0079+0300 -> U+1EF3 */ 1394,
	/* U+0079+0301 -> U+00FD */ 65,
	/* U+0079+0302 -> U+0177 */ 172,
	/* U+0079+0303 -> U+1EF9 */ 1400,
	/* U+0079+0304 -> U+0233 */ 283,
	/* U+0079+0307 -> U+1E8F */ 1298,
	/* U+0079+0308 -> U+00FF */ 66,
	/* U+0079+0309 -> U+1EF7 */ 1398,
	/* U+0079+030A -> U+1E99 */ 1308,
	/* U+0079+0323 -> U+1EF5 */ 1396,
	/* U+007A+0301 -> U+017A */ 175,
	/* U+007A+0302 -> U+1E91 */ 1300,
	/* U+007A+0307 -> U+017C */ 177,
	/* U+007A+030C -> U+017E */ 179,
	/* U+007A+0323 -> U+1E93 */ 1302,
	/* U+007A+0331 -> U+1E95 */ 1304,
	/* U+00A8+0300 -> U+1FED */ 1619,
	/* U+00A8+0301 -> U+0385 */ 419,
	/* U+00A8+0342 -> U+1FC1 */ 1579,
	/* U+00C2+0300 -> U+1EA6 */ 1317,
	/* U+00C2+0301 -> U+1EA4 */ 1315,
	/* U+00C2+0303 -> U+1EAA */ 1321,
	/* U+00C2+0309 -> U+1EA8 */ 1319,
	/* U+00C4+0304 -> U+01DE */ 210,
	/* U+00C5+0301 -> U+01FA */ 234,
	/* U+00C6+0301 -> U+01FC */ 236,
	/* U+00C6+0304 -> U+01E2 */ 214,
	/* U+00C7+0301 -> U+1E08 */ 1163,
	/* U+00CA+0300 -> U+1EC0 */ 1343,
	/* U+00CA+0301 -> U+1EBE */ 1341,
	/* U+00CA+0303 -> U+1EC4 */ 1347,
	/* U+00CA+0309 -> U+1EC2 */ 1345,
	/* U+00CF+0301 -> U+1E2E */ 1201,
	/* U+00D4+0300 -> U+1ED2 */ 1361,
	/* U+00D4+0301 -> U+1ED0 */ 1359,
	/* U+00D4+0303 -> U+1ED6 */ 1365,
	/* U+00D4+0309 -> U+1ED4 */ 1363,
	/* U+00D5+0301 -> U+1E4C */ 1231,
	/* U+00D5+0304 -> U+022C */ 276,
	/* U+00D5+0308 -> U+1E4E */ 1233,
	/* U+00D6+0304 -> U+022A */ 274,
	/* U+00D8+0301 -> U+01FE */ 238,
	/* U+00DC+0300 -> U+01DB */ 208,
	/* U+00DC+0301 -> U+01D7 */ 204,
	/* U+00DC+0304 -> U+01D5 */ 202,
	/* U+00DC+030C -> U+01D9 */ 206,
	/* U+00E2+0300 -> U+1EA7 */ 1318,
	/* U+00E2+0301 -> U+1EA5 */ 1316,
	/* U+00E2+0303 -> U+1EAB */ 1322,
	/* U+00E2+0309 -> U+1EA9 */ 1320,
	/* U+00E4+0304 -> U+01DF */ 211,
	/* U+00E5+0301 -> U+01FB */ 235,
	/* U+00E6+0301 -> U+01FD */ 237,
	/* U+00E6+0304 -> U+01E3 */ 215,
	/* U+00E7+0301 -> U+1E09 */ 1164,
	/* U+00EA+0300 -> U+1EC1 */ 1344,
	/* U+00EA+0301 -> U+1EBF */ 1342,
	/* U+00EA+0303 -> U+1EC5 */ 1348,
	/* U+00EA+0309 -> U+1EC3 */ 1346,
	/* U+00EF+0301 -> U+1E2F */ 1202,
	/* U+00F4+0300 -> U+1ED3 */ 1362,
	/* U+00F4+0301 -> U+1ED1 */ 1360,
	/* U+00F4+0303 -> U+1ED7 */ 1366,
	/* U+00F4+0309 -> U+1ED5 */ 1364,
	/* U+00F5+0301 -> U+1E4D */ 1232,
	/* U+00F5+0304 -> U+022D */ 277,
	/* U+00F5+0308 -> U+1E4F */ 1234,
	/* U+00F6+0304 -> U+022B */ 275,
	/* U+00F8+0301 -> U+01FF */ 239,
	/* U+00FC+0300 -> U+01DC */ 209,
	/* U+00FC+0301 -> U+01D8 */ 205,
	/* U+00FC+0304 -> U+01D6 */ 203,
	/* U+00FC+030C -> U+01DA */ 207,
	/* U+0102+0300 -> U+1EB0 */ 1327,
	/* U+0102+0301 -> U+1EAE */ 1325,
	/* U+0102+0303 -> U+1EB4 */ 1331,
	/* U+0102+0309 -> U+1EB2 */ 1329,
	/* U+0103+0300 -> U+1EB1 */ 1328,
	/* U+0103+0301 -> U+1EAF */ 1326,
	/* U+0103+0303 -> U+1EB5 */ 1332,
	/* U+0103+0309 -> U+1EB3 */ 1330,
	/* U+0112+0300 -> U+1E14 */ 1175,
	/* U+0112+0301 -> U+1E16 */ 1177,
	/* U+0113+0300 -> U+1E15 */ 1176,
	/* U+0113+0301 -> U+1E17 */ 1178,
	/* U+014C+0300 -> U+1E50 */ 1235,
	/* U+014C+0301 -> U+1E52 */ 1237,
	/* U+014D+0300 -> U+1E51 */ 1236,
	/* U+014D+0301 -> U+1E53 */ 1238,
	/* U+015A+0307 -> U+1E64 */ 1255,
	/* U+015B+0307 -> U+1E65 */ 1256,
	/* U+0160+0307 -> U+1E66 */ 1257,
	/* U+0161+0307 -> U+1E67 */ 1258,
	/* U+0168+0301 -> U+1E78 */ 1275,
	/* U+0169+0301 -> U+1E79 */ 1276,
	/* U+016A+0308 -> U+1E7A */ 1277,
	/* U+016B+0308 -> U+1E7B */ 1278,
	/* U+017F+0307 -> U+1E9B */ 1310,
	/* U+01A0+0300 -> U+1EDC */ 1371,
	/* U+01A0+0301 -> U+1EDA */ 1369,
	/* U+01A0+0303 -> U+1EE0 */ 1375,
	/* U+01A0+0309 -> U+1EDE */ 1373,
	/* U+01A0+0323 -> U+1EE2 */ 1377,
	/* U+01A1+0300 -> U+1EDD */ 1372,
	/* U+01A1+0301 -> U+1EDB */ 1370,
	/* U+01A1+0303 -> U+1EE1 */ 1376,
	/* U+01A1+0309 -> U+1EDF */ 1374,
	/* U+01A1+0323 -> U+1EE3 */ 1378,
	/* U+01AF+0300 -> U+1EEA */ 1385,
	/* U+01AF+0301 -> U+1EE8 */ 1383,
	/* U+01AF+0303 -> U+1EEE */ 1389,
	/* U+01AF+0309 -> U+1EEC */ 1387,
	/* U+01AF+0323 -> U+1EF0 */ 1391,
	/* U+01B0+0300 -> U+1EEB */ 1386,
	/* U+01B0+0301 -> U+1EE9 */ 1384,
	/* U+01B0+0303 -> U+1EEF */ 1390,
	/* U+01B0+0309 -> U+1EED */ 1388,
	/* U+01B0+0323 -> U+1EF1 */ 1392,
	/* U+01B7+030C -> U+01EE */ 224,
	/* U+01EA+0304 -> U+01EC */ 222,
	/* U+01EB+0304 -> U+01ED */ 223,
	/* U+0226+0304 -> U+01E0 */ 212,
	/* U+0227+0304 -> U+01E1 */ 213,
	/* U+0228+0306 -> U+1E1C */ 1183,
	/* U+0229+0306 -> U+1E1D */ 1184,
	/* U+022E+0304 -> U+0230 */ 280,
	/* U+022F+0304 -> U+0231 */ 281,
	/* U+0292+030C -> U+01EF */ 225,
	/* U+0391+0300 -> U+1FBA */ 1572,
	/* U+0391+0301 -> U+0386 */ 420,
	/* U+0391+0304 -> U+1FB9 */ 1571,
	/* U+0391+0306 -> U+1FB8 */ 1570,
	/* U+0391+0313 -> U+1F08 */ 1409,
	/* U+0391+0314 -> U+1F09 */ 1410,
	/* U+0391+0345 -> U+1FBC */ 1574,
	/* U+0395+0300 -> U+1FC8 */ 1585,
	/* U+0395+0301 -> U+0388 */ 422,
	/* U+0395+0313 -> U+1F18 */ 1423,
	/* U+0395+0314 -> U+1F19 */ 1424,
	/* U+0397+0300 -> U+1FCA */ 1587,
	/* U+0397+0301 -> U+0389 */ 423,
	/* U+0397+0313 -> U+1F28 */ 1437,
	/* U+0397+0314 -> U+1F29 */ 1438,
	/* U+0397+0345 -> U+1FCC */ 1589,
	/* U+0399+0300 -> U+1FDA */ 1601,
	/* U+0399+0301 -> U+038A */ 424,
	/* U+0399+0304 -> U+1FD9 */ 1600,
	/* U+0399+0306 -> U+1FD8 */ 1599,
	/* U+0399+0308 -> U+03AA */ 429,
	/* U+0399+0313 -> U+1F38 */ 1453,
	/* U+0399+0314 -> U+1F39 */ 1454,
	/* U+039F+0300 -> U+1FF8 */ 1627,
	/* U+039F+0301 -> U+038C */ 425,
	/* U+039F+0313 -> U+1F48 */ 1467,
	/* U+039F+0314 -> U+1F49 */ 1468,
	/* U+03A1+0314 -> U+1FEC */ 1618,
	/* U+03A5+0300 -> U+1FEA */ 1616,
	/* U+03A5+0301 -> U+038E */ 426,
	/* U+03A5+0304 -> U+1FE9 */ 1615,
	/* U+03A5+0306 -> U+1FE8 */ 1614,
	/* U+03A5+0308 -> U+03AB */ 430,
	/* U+03A5+0314 -> U+1F59 */ 1481,
	/* U+03A9+0300 -> U+1FFA */ 1629,
	/* U+03A9+0301 -> U+038F */ 427,
	/* U+03A9+0313 -> U+1F68 */ 1493,
	/* U+03A9+0314 -> U+1F69 */ 1494,
	/* U+03A9+0345 -> U+1FFC */ 1631,
	/* U+03AC+0345 -> U+1FB4 */ 1567,
	/* U+03AE+0345 -> U+1FC4 */ 1582,
	/* U+03B1+0300 -> U+1F70 */ 1501,
	/* U+03B1+0301 -> U+03AC */ 431,
	/* U+03B1+0304 -> U+1FB1 */ 1564,
	/* U+03B1+0306 -> U+1FB0 */ 1563,
	/* U+03B1+0313 -> U+1F00 */ 1401,
	/* U+03B1+0314 -> U+1F01 */ 1402,
	/* U+03B1+0342 -> U+1FB6 */ 1568,
	/* U+03B1+0345 -> U+1FB3 */ 1566,
	/* U+03B5+0300 -> U+1F72 */ 1503,
	/* U+03B5+0301 -> U+03AD */ 432,
	/* U+03B5+0313 -> U+1F10 */ 1417,
	/* U+03B5+0314 -> U+1F11 */ 1418,
	/* U+03B7+0300 -> U+1F74 */ 1505,
	/* U+03B7+0301 -> U+03AE */ 433,
	/* U+03B7+0313 -> U+1F20 */ 1429,
	/* U+03B7+0314 -> U+1F21 */ 1430,
	/* U+03B7+0342 -> U+1FC6 */ 1583,
	/* U+03B7+0345 -> U+1FC3 */ 1581,
	/* U+03B9+0300 -> U+1F76 */ 1507,
	/* U+03B9+0301 -> U+03AF */ 434,
	/* U+03B9+0304 -> U+1FD1 */ 1594,
	/* U+03B9+0306 -> U+1FD0 */ 1593,
	/* U+03B9+0308 -> U+03CA */ 436,
	/* U+03B9+0313 -> U+1F30 */ 1445,
	/* U+03B9+0314 -> U+1F31 */ 1446,
	/* U+03B9+0342 -> U+1FD6 */ 1597,
	/* U+03BF+0300 -> U+1F78 */ 1509,
	/* U+03BF+0301 -> U+03CC */ 438,
	/* U+03BF+0313 -> U+1F40 */ 1461,
	/* U+03BF+0314 -> U+1F41 */ 1462,
	/* U+03C1+0313 -> U+1FE4 */ 1610,
	/* U+03C1+0314 -> U+1FE5 */ 1611,
	/* U+03C5+0300 -> U+1F7A */ 1511,
	/* U+03C5+0301 -> U+03CD */ 439,
	/* U+03C5+0304 -> U+1FE1 */ 1607,
	/* U+03C5+0306 -> U+1FE0 */ 1606,
	/* U+03C5+0308 -> U+03CB */ 437,
	/* U+03C5+0313 -> U+1F50 */ 1473,
	/* U+03C5+0314 -> U+1F51 */ 1474,
	/* U+03C5+0342 -> U+1FE6 */ 1612,
	/* U+03C9+0300 -> U+1F7C */ 1513,
	/* U+03C9+0301 -> U+03CE */ 440,
	/* U+03C9+0313 -> U+1F60 */ 1485,
	/* U+03C9+0314 -> U+1F61 */ 1486,
	/* U+03C9+0342 -> U+1FF6 */ 1625,
	/* U+03C9+0345 -> U+1FF3 */ 1623,
	/* U+03CA+0300 -> U+1FD2 */ 1595,
	/* U+03CA+0301 -> U+0390 */ 428,
	/* U+03CA+0342 -> U+1FD7 */ 1598,
	/* U+03CB+0300 -> U+1FE2 */ 1608,
	/* U+03CB+0301 -> U+03B0 */ 435,
	/* U+03CB+0342 -> U+1FE7 */ 1613,
	/* U+03CE+0345 -> U+1FF4 */ 1624,
	/* U+03D2+0301 -> U+03D3 */ 444,
	/* U+03D2+0308 -> U+03D4 */ 445,
	/* U+0406+0308 -> U+0407 */ 457,
	/* U+0410+0306 -> U+04D0 */ 479,
	/* U+0410+0308 -> U+04D2 */ 481,
	/* U+0413+0301 -> U+0403 */ 456,
	/* U+0415+0300 -> U+0400 */ 454,
	/* U+0415+0306 -> U+04D6 */ 483,
	/* U+0415+0308 -> U+0401 */ 455,
	/* U+0416+0306 -> U+04C1 */ 477,
	/* U+0416+0308 -> U+04DC */ 487,
	/* U+0417+0308 -> U+04DE */ 489,
	/* U+0418+0300 -> U+040D */ 459,
	/* U+0418+0304 -> U+04E2 */ 491,
	/* U+0418+0306 -> U+0419 */ 461,
	/* U+0418+0308 -> U+04E4 */ 493,
	/* U+041A+0301 -> U+040C */ 458,
	/* U+041E+0308 -> U+04E6 */ 495,
	/* U+0423+0304 -> U+04EE */ 501,
	/* U+0423+0306 -> U+040E */ 460,
	/* U+0423+0308 -> U+04F0 */ 503,
	/* U+0423+030B -> U+04F2 */ 505,
	/* U+0427+0308 -> U+04F4 */ 507,
	/* U+042B+0308 -> U+04F8 */ 509,
	/* U+042D+0308 -> U+04EC */ 499,
	/* U+0430+0306 -> U+04D1 */ 480,
	/* U+0430+0308 -> U+04D3 */ 482,
	/* U+0433+0301 -> U+0453 */ 465,
	/* U+0435+0300 -> U+0450 */ 463,
	/* U+0435+0306 -> U+04D7 */ 484,
	/* U+0435+0308 -> U+0451 */ 464,
	/* U+0436+0306 -> U+04C2 */ 478,
	/* U+0436+0308 -> U+04DD */ 488,
	/* U+0437+0308 -> U+04DF */ 490,
	/* U+0438+0300 -> U+045D */ 468,
	/* U+0438+0304 -> U+04E3 */ 492,
	/* U+0438+0306 -> U+0439 */ 462,
	/* U+0438+0308 -> U+04E5 */ 494,
	/* U+043A+0301 -> U+045C */ 467,
	/* U+043E+0308 -> U+04E7 */ 496,
	/* U+0443+0304 -> U+04EF */ 502,
	/* U+0443+0306 -> U+045E */ 469,
	/* U+0443+0308 -> U+04F1 */ 504,
	/* U+0443+030B -> U+04F3 */ 506,
	/* U+0447+0308 -> U+04F5 */ 508,
	/* U+044B+0308 -> U+04F9 */ 510,
	/* U+044D+0308 -> U+04ED */ 500,
	/* U+0456+0308 -> U+0457 */ 466,
	/* U+0474+030F -> U+0476 */ 470,
	/* U+0475+030F -> U+0477 */ 471,
	/* U+04D8+0308 -> U+04DA */ 485,
	/* U+04D9+0308 -> U+04DB */ 486,
	/* U+04E8+0308 -> U+04EA */ 497,
	/* U+04E9+0308 -> U+04EB */ 498,
	/* U+0627+0653 -> U+0622 */ 574,
	/* U+0627+0654 -> U+0623 */ 575,
	/* U+0627+0655 -> U+0625 */ 577,
	/* U+0648+0654 -> U+0624 */ 576,
	/* U+064A+0654 -> U+0626 */ 578,
	/* U+06C1+0654 -> U+06C2 */ 606,
	/* U+06D2+0654 -> U+06D3 */ 607,
	/* U+06D5+0654 -> U+06C0 */ 605,
	/* U+0928+093C -> U+0929 */ 751,
	/* U+0930+093C -> U+0931 */ 752,
	/* U+0933+093C -> U+0934 */ 753,
	/* U+09C7+09BE -> U+09CB */ 769,
	/* U+09C7+09D7 -> U+09CC */ 770,
	/* U+0B47+0B3E -> U+0B4B */ 788,
	/* U+0B47+0B56 -> U+0B48 */ 787,
	/* U+0B47+0B57 -> U+0B4C */ 789,
	/* U+0B92+0BD7 -> U+0B94 */ 793,
	/* U+0BC6+0BBE -> U+0BCA */ 794,
	/* U+0BC6+0BD7 -> U+0BCC */ 796,
	/* U+0BC7+0BBE -> U+0BCB */ 795,
	/* U+0C46+0C56 -> U+0C48 */ 799,
	/* U+0CBF+0CD5 -> U+0CC0 */ 804,
	/* U+0CC6+0CC2 -> U+0CCA */ 807,
	/* U+0CC6+0CD5 -> U+0CC7 */ 805,
	/* U+0CC6+0CD6 -> U+0CC8 */ 806,
	/* U+0CCA+0CD5 -> U+0CCB */ 808,
	/* U+0D46+0D3E -> U+0D4A */ 812,
	/* U+0D46+0D57 -> U+0D4C */ 814,
	/* U+0D47+0D3E -> U+0D4B */ 813,
	/* U+0DD9+0DCA -> U+0DDA */ 817,
	/* U+0DD9+0DCF -> U+0DDC */ 818,
	/* U+0DD9+0DDF -> U+0DDE */ 820,
	/* U+0DDC+0DCA -> U+0DDD */ 819,
	/* U+1025+102E -> U+1026 */ 878,
	/* U+1B05+1B35 -> U+1B06 */ 938,
	/* U+1B07+1B35 -> U+1B08 */ 939,
	/* U+1B09+1B35 -> U+1B0A */ 940,
	/* U+1B0B+1B35 -> U+1B0C */ 941,
	/* U+1B0D+1B35 -> U+1B0E */ 942,
	/* U+1B11+1B35 -> U+1B12 */ 943,
	/* U+1B3A+1B35 -> U+1B3B */ 945,
	/* U+1B3C+1B35 -> U+1B3D */ 946,
	/* U+1B3E+1B35 -> U+1B40 */ 947,
	/* U+1B3F+1B35 -> U+1B41 */ 948,
	/* U+1B42+1B35 -> U+1B43 */ 949,
	/* U+1E36+0304 -> U+1E38 */ 1211,
	/* U+1E37+0304 -> U+1E39 */ 1212,
	/* U+1E5A+0304 -> U+1E5C */ 1247,
	/* U+1E5B+0304 -> U+1E5D */ 1248,
	/* U+1E62+0307 -> U+1E68 */ 1259,
	/* U+1E63+0307 -> U+1E69 */ 1260,
	/* U+1EA0+0302 -> U+1EAC */ 1323,
	/* U+1EA0+0306 -> U+1EB6 */ 1333,
	/* U+1EA1+0302 -> U+1EAD */ 1324,
	/* U+1EA1+0306 -> U+1EB7 */ 1334,
	/* U+1EB8+0302 -> U+1EC6 */ 1349,
	/* U+1EB9+0302 -> U+1EC7 */ 1350,
	/* U+1ECC+0302 -> U+1ED8 */ 1367,
	/* U+1ECD+0302 -> U+1ED9 */ 1368,
	/* U+1F00+0300 -> U+1F02 */ 1403,
	/* U+1F00+0301 -> U+1F04 */ 1405,
	/* U+1F00+0342 -> U+1F06 */ 1407,
	/* U+1F00+0345 -> U+1F80 */ 1515,
	/* U+1F01+0300 -> U+1F03 */ 1404,
	/* U+1F01+0301 -> U+1F05 */ 1406,
	/* U+1F01+0342 -> U+1F07 */ 1408,
	/* U+1F01+0345 -> U+1F81 */ 1516,
	/* U+1F02+0345 -> U+1F82 */ 1517,
	/* U+1F03+0345 -> U+1F83 */ 1518,
	/* U+1F04+0345 -> U+1F84 */ 1519,
	/* U+1F05+0345 -> U+1F85 */ 1520,
	/* U+1F06+0345 -> U+1F86 */ 1521,
	/* U+1F07+0345 -> U+1F87 */ 1522,
	/* U+1F08+0300 -> U+1F0A */ 1411,
	/* U+1F08+0301 -> U+1F0C */ 1413,
	/* U+1F08+0342 -> U+1F0E */ 1415,
	/* U+1F08+0345 -> U+1F88 */ 1523,
	/* U+1F09+0300 -> U+1F0B */ 1412,
	/* U+1F09+0301 -> U+1F0D */ 1414,
	/* U+1F09+0342 -> U+1F0F */ 1416,
	/* U+1F09+0345 -> U+1F89 */ 1524,
	/* U+1F0A+0345 -> U+1F8A */ 1525,
	/* U+1F0B+0345 -> U+1F8B */ 1526,
	/* U+1F0C+0345 -> U+1F8C */ 1527,
	/* U+1F0D+0345 -> U+1F8D */ 1528,
	/* U+1F0E+0345 -> U+1F8E */ 1529,
	/* U+1F0F+0345 -> U+1F8F */ 1530,
	/* U+1F10+0300 -> U+1F12 */ 1419,
	/* U+1F10+0301 -> U+1F14 */ 1421,
	/* U+1F11+0300 -> U+1F13 */ 1420,
	/* U+1F11+0301 -> U+1F15 */ 1422,
	/* U+1F18+0300 -> U+1F1A */ 1425,
	/* U+1F18+0301 -> U+1F1C */ 1427,
	/* U+1F19+0300 -> U+1F1B */ 1426,
	/* U+1F19+0301 -> U+1F1D */ 1428,
	/* U+1F20+0300 -> U+1F22 */ 1431,
	/* U+1F20+0301 -> U+1F24 */ 1433,
	/* U+1F20+0342 -> U+1F26 */ 1435,
	/* U+1F20+0345 -> U+1F90 */ 1531,
	/* U+1F21+0300 -> U+1F23 */ 1432,
	/* U+1F21+0301 -> U+1F25 */ 1434,
	/* U+1F21+0342 -> U+1F27 */ 1436,
	/* U+1F21+0345 -> U+1F91 */ 1532,
	/* U+1F22+0345 -> U+1F92 */ 1533,
	/* U+1F23+0345 -> U+1F93 */ 1534,
	/* U+1F24+0345 -> U+1F94 */ 1535,
	/* U+1F25+0345 -> U+1F95 */ 1536,
	/* U+1F26+0345 -> U+1F96 */ 1537,
	/* U+1F27+0345 -> U+1F97 */ 1538,
	/* U+1F28+0300 -> U+1F2A */ 1439,
	/* U+1F28+0301 -> U+1F2C */ 1441,
	/* U+1F28+0342 -> U+1F2E */ 1443,
	/* U+1F28+0345 -> U+1F98 */ 1539,
	/* U+1F29+0300 -> U+1F2B */ 1440,
	/* U+1F29+0301 -> U+1F2D */ 1442,
	/* U+1F29+0342 -> U+1F2F */ 1444,
	/* U+1F29+0345 -> U+1F99 */ 1540,
	/* U+1F2A+0345 -> U+1F9A */ 1541,
	/* U+1F2B+0345 -> U+1F9B */ 1542,
	/* U+1F2C+0345 -> U+1F9C */ 1543,
	/* U+1F2D+0345 -> U+1F9D */ 1544,
	/* U+1F2E+0345 -> U+1F9E */ 1545,
	/* U+1F2F+0345 -> U+1F9F */ 1546,
	/* U+1F30+0300 -> U+1F32 */ 1447,
	/* U+1F30+0301 -> U+1F34 */ 1449,
	/* U+1F30+0342 -> U+1F36 */ 1451,
	/* U+1F31+0300 -> U+1F33 */ 1448,
	/* U+1F31+0301 -> U+1F35 */ 1450,
	/* U+1F31+0342 -> U+1F37 */ 1452,
	/* U+1F38+0300 -> U+1F3A */ 1455,
	/* U+1F38+0301 -> U+1F3C */ 1457,
	/* U+1F38+0342 -> U+1F3E */ 1459,
	/* U+1F39+0300 -> U+1F3B */ 1456,
	/* U+1F39+0301 -> U+1F3D */ 1458,
	/* U+1F39+0342 -> U+1F3F */ 1460,
	/* U+1F40+0300 -> U+1F42 */ 1463,
	/* U+1F40+0301 -> U+1F44 */ 1465,
	/* U+1F41+0300 -> U+1F43 */ 1464,
	/* U+1F41+0301 -> U+1F45 */ 1466,
	/* U+1F48+0300 -> U+1F4A */ 1469,
	/* U+1F48+0301 -> U+1F4C */ 1471,
	/* U+1F49+0300 -> U+1F4B */ 1470,
	/* U+1F49+0301 -> U+1F4D */ 1472,
	/* U+1F50+0300 -> U+1F52 */ 1475,
	/* U+1F50+0301 -> U+1F54 */ 1477,
	/* U+1F50+0342 -> U+1F56 */ 1479,
	/* U+1F51+0300 -> U+1F53 */ 1476,
	/* U+1F51+0301 -> U+1F55 */ 1478,
	/* U+1F51+0342 -> U+1F57 */ 1480,
	/* U+1F59+0300 -> U+1F5B */ 1482,
	/* U+1F59+0301 -> U+1F5D */ 1483,
	/* U+1F59+0342 -> U+1F5F */ 1484,
	/* U+1F60+0300 -> U+1F62 */ 1487,
	/* U+1F60+0301 -> U+1F64 */ 1489,
	/* U+1F60+0342 -> U+1F66 */ 1491,
	/* U+1F60+0345 -> U+1FA0 */ 1547,
	/* U+1F61+0300 -> U+1F63 */ 1488,
	/* U+1F61+0301 -> U+1F65 */ 1490,
	/* U+1F61+0342 -> U+1F67 */ 1492,
	/* U+1F61+0345 -> U+1FA1 */ 1548,
	/* U+1F62+0345 -> U+1FA2 */ 1549,
	/* U+1F63+0345 -> U+1FA3 */ 1550,
	/* U+1F64+0345 -> U+1FA4 */ 1551,
	/* U+1F65+0345 -> U+1FA5 */ 1552,
	/* U+1F66+0345 -> U+1FA6 */ 1553,
	/* U+1F67+0345 -> U+1FA7 */ 1554,
	/* U+1F68+0300 -> U+1F6A */ 1495,
	/* U+1F68+0301 -> U+1F6C */ 1497,
	/* U+1F68+0342 -> U+1F6E */ 1499,
	/* U+1F68+0345 -> U+1FA8 */ 1555,
	/* U+1F69+0300 -> U+1F6B */ 1496,
	/* U+1F69+0301 -> U+1F6D */ 1498,
	/* U+1F69+0342 -> U+1F6F */ 1500,
	/* U+1F69+0345 -> U+1FA9 */ 1556,
	/* U+1F6A+0345 -> U+1FAA */ 1557,
	/* U+1F6B+0345 -> U+1FAB */ 1558,
	/* U+1F6C+0345 -> U+1FAC */ 1559,
	/* U+1F6D+0345 -> U+1FAD */ 1560,
	/* U+1F6E+0345 -> U+1FAE */ 1561,
	/* U+1F6F+0345 -> U+1FAF */ 1562,
	/* U+1F70+0345 -> U+1FB2 */ 1565,
	/* U+1F74+0345 -> U+1FC2 */ 1580,
	/* U+1F7C+0345 -> U+1FF2 */ 1622,
	/* U+1FB6+0345 -> U+1FB7 */ 1569,
	/* U+1FBF+0300 -> U+1FCD */ 1590,
	/* U+1FBF+0301 -> U+1FCE */ 1591,
	/* U+1FBF+0342 -> U+1FCF */ 1592,
	/* U+1FC6+0345 -> U+1FC7 */ 1584,
	/* U+1FF6+0345 -> U+1FF7 */ 1626,
	/* U+1FFE+0300 -> U+1FDD */ 1603,
	/* U+1FFE+0301 -> U+1FDE */ 1604,
	/* U+1FFE+0342 -> U+1FDF */ 1605,
	/* U+2190+0338 -> U+219A */ 1836,
	/* U+2192+0338 -> U+219B */ 1837,
	/* U+2194+0338 -> U+21AE */ 1838,
	/* U+21D0+0338 -> U+21CD */ 1839,
	/* U+21D2+0338 -> U+21CF */ 1841,
	/* U+21D4+0338 -> U+21CE */ 1840,
	/* U+2203+0338 -> U+2204 */ 1842,
	/* U+2208+0338 -> U+2209 */ 1843,
	/* U+220B+0338 -> U+220C */ 1844,
	/* U+2223+0338 -> U+2224 */ 1845,
	/* U+2225+0338 -> U+2226 */ 1846,
	/* U+223C+0338 -> U+2241 */ 1851,
	/* U+2243+0338 -> U+2244 */ 1852,
	/* U+2245+0338 -> U+2247 */ 1853,
	/* U+2248+0338 -> U+2249 */ 1854,
	/* U+224D+0338 -> U+226D */ 1857,
	/* U+2261+0338 -> U+2262 */ 1856,
	/* U+2264+0338 -> U+2270 */ 1860,
	/* U+2265+0338 -> U+2271 */ 1861,
	/* U+2272+0338 -> U+2274 */ 1862,
	/* U+2273+0338 -> U+2275 */ 1863,
	/* U+2276+0338 -> U+2278 */ 1864,
	/* U+2277+0338 -> U+2279 */ 1865,
	/* U+227A+0338 -> U+2280 */ 1866,
	/* U+227B+0338 -> U+2281 */ 1867,
	/* U+227C+0338 -> U+22E0 */ 1876,
	/* U+227D+0338 -> U+22E1 */ 1877,
	/* U+2282+0338 -> U+2284 */ 1868,
	/* U+2283+0338 -> U+2285 */ 1869,
	/* U+2286+0338 -> U+2288 */ 1870,
	/* U+2287+0338 -> U+2289 */ 1871,
	/* U+2291+0338 -> U+22E2 */ 1878,
	/* U+2292+0338 -> U+22E3 */ 1879,
	/* U+22A2+0338 -> U+22AC */ 1872,
	/* U+22A8+0338 -> U+22AD */ 1873,
	/* U+22A9+0338 -> U+22AE */ 1874,
	/* U+22AB+0338 -> U+22AF */ 1875,
	/* U+22B2+0338 -> U+22EA */ 1880,
	/* U+22B3+0338 -> U+22EB */ 1881,
	/* U+22B4+0338 -> U+22EC */ 1882,
	/* U+22B5+0338 -> U+22ED */ 1883,
	/* U+3046+3099 -> U+3094 */ 2321,
	/* U+304B+3099 -> U+304C */ 2296,
	/* U+304D+3099 -> U+304E */ 2297,
	/* U+304F+3099 -> U+3050 */ 2298,
	/* U+3051+3099 -> U+3052 */ 2299,
	/* U+3053+3099 -> U+3054 */ 2300,
	/* U+3055+3099 -> U+3056 */ 2301,
	/* U+3057+3099 -> U+3058 */ 2302,
	/* U+3059+3099 -> U+305A */ 2303,
	/* U+305B+3099 -> U+305C */ 2304,
	/* U+305D+3099 -> U+305E */ 2305,
	/* U+305F+3099 -> U+3060 */ 2306,
	/* U+3061+3099 -> U+3062 */ 2307,
	/* U+3064+3099 -> U+3065 */ 2308,
	/* U+3066+3099 -> U+3067 */ 2309,
	/* U+3068+3099 -> U+3069 */ 2310,
	/* U+306F+3099 -> U+3070 */ 2311,
	/* U+306F+309A -> U+3071 */ 2312,
	/* U+3072+3099 -> U+3073 */ 2313,
	/* U+3072+309A -> U+3074 */ 2314,
	/* U+3075+3099 -> U+3076 */ 2315,
	/* U+3075+309A -> U+3077 */ 2316,
	/* U+3078+3099 -> U+3079 */ 2317,
	/* U+3078+309A -> U+307A */ 2318,
	/* U+307B+3099 -> U+307C */ 2319,
	/* U+307B+309A -> U+307D */ 2320,
	/* U+309D+3099 -> U+309E */ 2326,
	/* U+30A6+3099 -> U+30F4 */ 2353,
	/* U+30AB+3099 -> U+30AC */ 2328,
	/* U+30AD+3099 -> U+30AE */ 2329,
	/* U+30AF+3099 -> U+30B0 */ 2330,
	/* U+30B1+3099 -> U+30B2 */ 2331,
	/* U+30B3+3099 -> U+30B4 */ 2332,
	/* U+30B5+3099 -> U+30B6 */ 2333,
	/* U+30B7+3099 -> U+30B8 */ 2334,
	/* U+30B9+3099 -> U+30BA */ 2335,
	/* U+30BB+3099 -> U+30BC */ 2336,
	/* U+30BD+3099 -> U+30BE */ 2337,
	/* U+30BF+3099 -> U+30C0 */ 2338,
	/* U+30C1+3099 -> U+30C2 */ 2339,
	/* U+30C4+3099 -> U+30C5 */ 2340,
	/* U+30C6+3099 -> U+30C7 */ 2341,
	/* U+30C8+3099 -> U+30C9 */ 2342,
	/* U+30CF+3099 -> U+30D0 */ 2343,
	/* U+30CF+309A -> U+30D1 */ 2344,
	/* U+30D2+3099 -> U+30D3 */ 2345,
	/* U+30D2+309A -> U+30D4 */ 2346,
	/* U+30D5+3099 -> U+30D6 */ 2347,
	/* U+30D5+309A -> U+30D7 */ 2348,
	/* U+30D8+3099 -> U+30D9 */ 2349,
	/* U+30D8+309A -> U+30DA */ 2350,
	/* U+30DB+3099 -> U+30DC */ 2351,
	/* U+30DB+309A -> U+30DD */ 2352,
	/* U+30EF+3099 -> U+30F7 */ 2354,
	/* U+30F0+3099 -> U+30F8 */ 2355,
	/* U+30F1+3099 -> U+30F9 */ 2356,
	/* U+30F2+3099 -> U+30FA */ 2357,
	/* U+30FD+3099 -> U+30FE */ 2358,
	/* U+105D2+0307 -> U+105C9 */ 4599,
	/* U+105DA+0307 -> U+105E4 */ 4600,
	/* U+11099+110BA -> U+1109A */ 4697,
	/* U+1109B+110BA -> U+1109C */ 4698,
	/* U+110A5+110BA -> U+110AB */ 4699,
	/* U+11131+11127 -> U+1112E */ 4705,
	/* U+11132+11127 -> U+1112F */ 4706,
	/* U+11347+1133E -> U+1134B */ 4718,
	/* U+11347+11357 -> U+1134C */ 4719,
	/* U+11382+113C9 -> U+11383 */ 4733,
	/* U+11384+113BB -> U+11385 */ 4734,
	/* U+1138B+113C2 -> U+1138E */ 4735,
	/* U+11390+113C9 -> U+11391 */ 4736,
	/* U+113C2+113B8 -> U+113C7 */ 4738,
	/* U+113C2+113C2 -> U+113C5 */ 4737,
	/* U+113C2+113C9 -> U+113C8 */ 4739,
	/* U+114B9+114B0 -> U+114BC */ 4747,
	/* U+114B9+114BA -> U+114BB */ 4746,
	/* U+114B9+114BD -> U+114BE */ 4748,
	/* U+115B8+115AF -> U+115BA */ 4751,
	/* U+115B9+115AF -> U+115BB */ 4752,
	/* U+11935+11930 -> U+11938 */ 4761,
	/* U+1611E+1611E -> U+16121 */ 4776,
	/* U+1611E+1611F -> U+16123 */ 4778,
	/* U+1611E+16120 -> U+16125 */ 4780,
	/* U+1611E+16129 -> U+16122 */ 4777,
	/* U+16121+1611F -> U+16126 */ 4781,
	/* U+16121+16120 -> U+16128 */ 4783,
	/* U+16122+1611F -> U+16127 */ 4782,
	/* U+16129+1611F -> U+16124 */ 4779,
	/* U+16D63+16D67 -> U+16D69 */ 4798,
	/* U+16D67+16D67 -> U+16D68 */ 4797,
	/* U+16D69+16D67 -> U+16D6A */ 4799
};

/* Perfect hash function for recomposition */
static int
Recomp_hash_func(const void *key)
{
	static const int16 h[1923] = {
		-109,  -96,   32767, 0,     -844,  -182,  -292,  32767,
		830,   793,   794,   665,   0,     -9,    32767, 32767,
		32767, 32767, 32767, 428,   32767, 32767, 32767, 502,
		0,     32767, -230,  144,   356,   -76,   0,     243,
		665,   32767, 32767, -1003, 244,   0,     32767, 32767,
		573,   246,   125,   32767, 32767, 32767, 0,     32767,
		32767, 32767, 32767, 0,     245,   32767, 723,   32767,
		0,     889,   32767, 32767, 32767, 0,     32767, 32767,
		0,     173,   157,   1215,  254,   255,   -126,  0,
		0,     504,   459,   -11,   238,   -188,  722,   247,
		260,   32767, -184,  -6,    2102,  -578,  32767, 32767,
		-598,  -670,  260,   19,    32767, -472,  32767, 664,
		511,   0,     32767, 345,   291,   0,     -370,  176,
		32767, 1017,  -139,  -519,  -30,   0,     -24,   -23,
		481,   -253,  -1813, 32767, 0,     935,   32767, 32767,
		-443,  32767, 773,   32767, 32767, 32767, -507,  427,
		0,     32767, 899,   32767, 32767, 277,   0,     32767,
		32767, 0,     842,   854,   0,     32767, 936,   621,
		-195,  32767, 0,     32767, 707,   268,   32767, 32767,
		435,   32767, 32767, 32767, 0,     267,   88,    72,
		32767, 487,   32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 875,   -312,  32767, 483,   875,
		270,   89,    32767, 483,   32767, 32767, 32767, 32767,
		708,   273,   2053,  -63,   -242,  -479,  32767, 352,
		32767, 32767, 0,     560,   544,   32767, 32767, 32767,
		0,     0,     32767, 0,     32767, 32767, 32767, 525,
		274,   32767, 404,   386,   518,   32767, -357,  32767,
		-45,   1154,  276,   32767, 149,   0,     277,   714,
		313,   32767, 32767, 32767, 32767, 32767, 841,   460,
		431,   32767, 32767, -49,   32767, 32767, 32767, 32767,
		32767, 32767, 0,     876,   280,   281,   131,   388,
		283,   32767, 1125,  32767, 695,   712,   32767, 0,
		713,   1732,  0,     32767, 0,     231,   32767, 0,
		32767, -755,  32767, 32767, 32767, 435,   32767, 0,
		951,   952,   32767, 32767, 464,   867,   1298,  0,
		660,   -55,   0,     292,   663,   118,   661,   -722,
		435,   816,   328,   0,     323,   323,   -258,  -684,
		2114,  0,     302,   0,     32767, 32767, 1607,  32767,
		0,     32767, 32767, 0,     810,   32767, -543,  -5,
		515,   32767, 0,     877,   304,   32767, 472,   32767,
		683,   -549,  258,   285,   -904,  32767, 148,   1202,
		1044,  0,     32767, 32767, 659,   1395,  905,   32767,
		32767, 32767, -626,  32767, 32767, 32767, 32767, 672,
		0,     32767, -139,  32767, 32767, 0,     0,     660,
		1,     32767, -955,  -293,  616,   391,   632,   -126,
		32767, 32767, 1610,  -166,  754,   324,   32767, 32767,
		931,   32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 0,     32767, 32767, 302,   391,   32767, 32767,
		516,   32767, 32767, 1131,  670,   544,   308,   286,
		0,     0,     32767, 32767, 531,   -629,  -35,   0,
		6,     -63,   485,   0,     0,     -486,  -58,   0,
		0,     38,    470,   -20,   0,     32767, 0,     0,
		956,   32767, 0,     294,   -759,  0,     32767, 32767,
		-362,  73,    316,   588,   314,   32767, 609,   0,
		318,   32767, 32767, 32767, -759,  1466,  -212,  32767,
		1910,  226,   653,   32767, 219,   32767, 32767, 0,
		0,     32767, 1045,  -6,    -6,    32767, 0,     163,
		0,     0,     -9,    879,   -369,  32767, -18,   321,
		322,   32767, 32767, -449,  1082,  324,   57,    32767,
		-403,  252,   697,   0,     491,   552,   0,     32767,
		32767, 32767, 864,   32767, 0,     32767, 929,   -582,
		32767, 32767, 32767, 1521,  32767, 32767, 32767, 212,
		326,   -542,  332,   333,   334,   -490,  692,   336,
		32767, 337,   338,   31,    0,     714,   348,   34,
		342,   32767, 1602,  32767, 687,   143,   32767, 0,
		32767, 32767, 0,     32767, 196,   -21,   32767, 32767,
		-4,    32767, 32767, 880,   -211,  203,   32767, 1078,
		83,    1661,  32767, 32767, 283,   787,   348,   32767,
		0,     -464,  0,     32767, 725,   -431,  -811,  -322,
		7,     32767, -315,  267,   694,   -2103, 12,    247,
		13,    692,   32767, -1593, 32767, 15,    32767, 32767,
		830,   0,     623,   354,   32767, 32767, -154,  0,
		264,   -712,  32767, 357,   32767, 32767, 220,   -242,
		32767, 921,   905,   32767, -1184, 549,   32767, 19,
		319,   32767, 551,   32767, 1307,  0,     32767, 32767,
		32767, 0,     566,   881,   822,   936,   326,   89,
		-313,  32767, 250,   0,     359,   360,   32767, 32767,
		32767, 32767, -575,  20,    32767, 98,    23,    32767,
		287,   744,   124,   1027,  32767, 0,     564,   0,
		-548,  -497,  982,   32767, 32767, 32767, 32767, 32767,
		35,    316,   -1859, 343,   364,   786,   0,     32767,
		366,   4,     0,     753,   581,   524,   270,   686,
		0,     -382,  32767, -1189, 0,     747,   32767, 363,
		32767, 32767, -1782, 32767, 28,    32767, 677,   452,
		210,   0,     884,   882,   -258,  32767, -1099, -222,
		32767, 32767, 32767, 32767, 373,   671,   32767, 311,
		32767, 370,   32767, -831,  101,   32,    35,    36,
		-1159, 930,   38,    39,    -148,  -148,  32767, 32767,
		-150,  -803,  1185,  675,   32767, -152,  32767, 0,
		633,   467,   -279,  827,   32767, 1273,  -410,  136,
		32767, 527,   842,   397,   32767, 1149,  376,   45,
		2221,  20,    0,     -421,  47,    925,   0,     363,
		368,   -384,  0,     32767, -230,  32767, -532,  32767,
		32767, 32767, 0,     32767, 634,   219,   -6,    397,
		32767, 32767, 692,   385,   361,   483,   526,   32767,
		0,     32767, 628,   728,   2167,  51,    892,   32767,
		-326,  -595,  54,    55,    32767, 825,   0,     0,
		933,   32767, 32767, 32767, 828,   32767, 32767, 883,
		-144,  32767, 32767, 32767, 933,   0,     0,     209,
		1580,  790,   0,     0,     32767, 32767, 32767, 730,
		731,   32767, 58,    57,    457,   557,   32767, 59,
		60,    0,     -1438, 32767, 1016,  32767, 1344,  683,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 558,
		45,    32767, 0,     32767, 0,     0,     843,   0,
		32767, 0,     503,   62,    488,   600,   -395,  -328,
		69,    566,   -355,  1027,  -737,  -72,   -606,  32767,
		74,    32767, 32767, 1144,  32767, -75,   32767, 884,
		-144,  32767, 22,    598,   32767, 792,   32767, 32767,
		32767, 32767, 32767, -336,  32767, 32767, 0,     45,
		0,     32767, 658,   637,   78,    95,    -962,  0,
		0,     32767, 256,   0,     -247,  -201,  32767, 32767,
		447,   0,     0,     0,     32767, 445,   806,   860,
		-39,   74,    32767, -6,    32767, 529,   32767, 700,
		307,   179,   0,     893,   32767, 835,   0,     -29,
		32767, 32767, 32767, 32767, -754,  32767, 32767, 32767,
		-702,  -227,  -55,   0,     517,   -196,  32767, 784,
		177,   0,     -1082, 597,   -166,  797,   32767, 32767,
		613,   32767, 1211,  32767, -283,  126,   32767, 83,
		526,   -1584, 533,   172,   950,   0,     0,     32767,
		32767, -1767, -88,   32767, 87,    -1289, 773,   953,
		1131,  0,     0,     32767, 1374,  0,     32767, 32767,
		32767, 798,   32767, 0,     1547,  158,   613,   32767,
		32767, -822,  32767, 88,    473,   474,   378,   89,
		940,   659,   352,   -270,  0,     -1015, 477,   32767,
		901,   91,    1068,  32767, 0,     0,     32767, 32767,
		0,     32767, 461,   404,   32767, 46,    -65,   32767,
		32767, 815,   822,   32767, 32767, 32767, 406,   925,
		338,   -487,  0,     97,    438,   -464,  32767, 98,
		0,     0,     1113,  0,     -416,  0,     32767, 0,
		-35,   0,     180,   413,   32767, 32767, 0,     -219,
		568,   175,   0,     0,     32767, 503,   0,     32767,
		528,   32767, 32767, -464,  733,   140,   106,   101,
		171,   32767, 109,   110,   597,   170,   32767, 113,
		76,    103,   32767, 115,   559,   116,   32767, -213,
		32767, 0,     597,   823,   32767, 801,   32767, 479,
		803,   631,   723,   32767, 538,   -394,  468,   -200,
		411,   29,    32767, 32767, -1347, 361,   32767, -458,
		655,   32767, 32767, 32767, -791,  0,     32767, 540,
		541,   32767, 32767, -14,   959,   32767, 0,     462,
		32767, 802,   32767, 32767, 846,   734,   32767, 32767,
		735,   32767, 32767, 32767, 32767, 32767, 0,     32767,
		32767, -685,  32767, 32767, 32767, 32767, 32767, 32767,
		0,     44,    32767, 0,     807,   131,   349,   0,
		0,     7,     -94,   423,   0,     529,   32767, 32767,
		32767, 286,   0,     32767, -145,  400,   281,   445,
		32767, 122,   32767, -300,  600,   571,   769,   945,
		518,   0,     461,   32767, -254,  32767, -423,  -534,
		462,   396,   0,     886,   425,   -956,  809,   145,
		573,   810,   0,     401,   0,     -1069, 0,     151,
		1011,  0,     0,     81,    32767, -411,  0,     -687,
		859,   451,   -1447, 132,   32767, 32767, 32767, 32767,
		-154,  32,    32767, 32767, 32767, 32767, 0,     32767,
		32767, 32767, 37,    408,   0,     811,   326,   32767,
		0,     -374,  32767, -184,  741,   -376,  91,    134,
		32767, 486,   135,   -40,   579,   373,   32767, 547,
		32767, 32767, 32767, 32767, -259,  873,   0,     0,
		0,     825,   -373,  0,     32767, 0,     0,     308,
		340,   -373,  32767, 0,     0,     32767, -1259, 32767,
		742,   32767, 643,   139,   144,   349,   -79,   147,
		148,   32767, 149,   732,   425,   -219,  152,   -446,
		556,   143,   32767, 155,   165,   -1314, 0,     888,
		439,   32767, 0,     0,     0,     813,   405,   29,
		32767, 6,     0,     0,     743,   32767, 1902,  158,
		159,   32767, 381,   0,     -102,  196,   0,     769,
		-419,  -596,  0,     782,   162,   32767, 32767, -580,
		32767, 32767, 32767, 32767, 1126,  32767, 32767, 412,
		32767, 814,   824,   32767, 32767, 0,     32767, 32767,
		744,   32767, 32767, 746,   0,     1480,  167,   0,
		1189,  32767, 32767, 168,   169,   32767, 0,     32767,
		906,   32767, 32767, 32767, 32767, 32767, 32767, 601,
		32767, 32767, -278,  0,     32767, 1261,  414,   32767,
		32767, 32767, 32767, 375,   378,   589,   644,   750,
		751,   937,   32767, 590,   32767, 591,   32767, 171,
		172,   32767, 32767, 32767, 32767, 1195,  32767, 32767,
		721,   0,     0,     -505,  -14,   6,     0,     0,
		0,     1058,  -718,  99,    0,     372,   327,   32767,
		729,   -166,  32767, 0,     173,   -939,  175,   592,
		177,   576,   32767, 213,   179,   0,     0,     514,
		620,   32767, 32767, 32767, 32767, 0,     32767, 32767,
		958,   -240,  0,     -840,  32767, 379,   32767, 0,
		0,     752,   673,   -432,  159,   -877,  32767, -416,
		32767, 182,   -211,  0,     0,     594,   32767, 184,
		-1070, 32767, 32767, 32767, 185,   0,     0,     32767,
		710,   32767, 32767, 32767, 32767, 928,   32767, 32767,
		0,     126,   942,   32767, 0,     0,     32767, 867,
		697,   -355,  32767, 625,   0,     596,   32767, 597,
		-243,  583,   32767, 0,     0,     0,     0,     0,
		584,   650,   0,     32767, 515,   32767, 0,     892,
		0,     0,     -271,  274,   32767, 418,   32767, 0,
		32767, 32767, 32767, 440,   -1147, 32767, 0,     32767,
		32767, 651,   652,   564,   32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 947,   -68,   32767, 688,
		32767, 0,     0,     689,   915,   916,   0,     0,
		-204,  225,   0,     0,     0,     0,     32767, -275,
		370,   0,     599,   -402,  32767, 571,   0,     32767,
		1470,  594,   32767, 772,   773,   1458,  0,     907,
		1048,  32767, 128,   4,     32767, 0,     32767, 1880,
		32767, 32767, 0,     0,     684,   32767, 0,     262,
		32767, 32767, 32767, 32767, 757,   32767, 32767, 0,
		196,   32767, -258,  -552,  -998,  0,     950,   774,
		-35,   32767, 0,     32767, 0,     32767, 15,    32767,
		0,     32767, 0,     27,    198,   760,   32767, 32767,
		1204,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		620,   32767, 32767, 760,   761,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     32767, 32767, 0,     32767, 0,
		1195,  918,   32767, 32767, 32767, 32767, 0,     0,
		32767, 32767, 32767, 32767, 903,   32767, 32767, 763,
		764,   0,     32767, 0,     32767, 32767, 0,     32767,
		833,   32767, 32767, 32767, 1132,  32767, 32767, 32767,
		32767, 32767, 32767, 0,     450,   32767, 32767, 420,
		32767, 32767, 32767, 32767, -68,   2,     0,     0,
		1196,  0,     0,     0,     188,   189,   190,   191,
		192,   600,   0,     -632,  -43,   196,   89,    489,
		294,   1248,  32767, 1043,  32767, 492,   32767, 32767,
		519,   0,     32767, 863,   32767, 32767, 32767, 0,
		32767, 765,   493,   467,   0,     32767, 32767, 201,
		32767, 432,   849,   32767, 279,   0,     0,     204,
		834,   32767, 0,     32767, 1670,  32767, 0,     32767,
		0,     32767, 32767, 32767, 919,   929,   32767, 0,
		32767, -363,  0,     32767, 32767, 0,     434,   -56,
		32767, 436,   0,     349,   0,     207,   208,   437,
		32767, 0,     32767, -694,  -408,  32767, 0,     32767,
		210,   206,   0,     653,   32767, 32767, 0,     402,
		1105,  0,     32767, 693,   0,     0,     938,   32767,
		32767, 32767, 438,   541,   131,   440,   871,   32767,
		32767, 0,     32767, 279,   32767, 32767, 287,   212,
		0,     0,     32767, 32767, 367,   32767, 696,   697,
		32767, 0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 0,     -1321, 32767,
		0,     176,   32767, 214,   218,   724,   234,   215,
		222,   32767, 223,   -834,  943,   127,   32767, 496,
		-100,  217,   0,     394,   32767, 229,   32767, 0,
		0,     17,    421,   415,   447,   0,     32767, 686,
		32767, 32767, 1845,  138,   32767, 32767, 872,   230,
		32767, 601,   851,   471,   232,   603,   32767, 778,
		698,   233,   32767, 699,   -439,  32767, 0,     32767,
		32767, 32767, 663,   32767, 32767, 32767, 32767, -298,
		449,   32767, -463,  687,   32767, 32767, 427,   32767,
		0,     0,     0,     0,     0,     236,   193,   826,
		238,   0,     108
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 8;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 17 + c;
	}
	return h[a % 1923] + h[b % 1923];
}

/* Hash lookup information for recomposition */
static const pg_unicode_recompinfo UnicodeRecompInfo =
{
	RecompInverseLookup,
	Recomp_hash_func,
	961
};
