# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementWorkspaceApiOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_api_list_by_service(self, resource_group):
        response = self.client.workspace_api.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_api_get_entity_tag(self, resource_group):
        response = self.client.workspace_api.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_api_get(self, resource_group):
        response = self.client.workspace_api.get(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_api_begin_create_or_update(self, resource_group):
        response = self.client.workspace_api.begin_create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_id="str",
            parameters={
                "apiRevision": "str",
                "apiRevisionDescription": "str",
                "apiType": "str",
                "apiVersion": "str",
                "apiVersionDescription": "str",
                "apiVersionSet": {
                    "description": "str",
                    "id": "str",
                    "name": "str",
                    "versionHeaderName": "str",
                    "versionQueryName": "str",
                    "versioningScheme": "str",
                },
                "apiVersionSetId": "str",
                "authenticationSettings": {
                    "oAuth2": {"authorizationServerId": "str", "scope": "str"},
                    "oAuth2AuthenticationSettings": [{"authorizationServerId": "str", "scope": "str"}],
                    "openid": {"bearerTokenSendingMethods": ["str"], "openidProviderId": "str"},
                    "openidAuthenticationSettings": [{"bearerTokenSendingMethods": ["str"], "openidProviderId": "str"}],
                },
                "contact": {"email": "str", "name": "str", "url": "str"},
                "description": "str",
                "displayName": "str",
                "format": "str",
                "isCurrent": bool,
                "isOnline": bool,
                "license": {"name": "str", "url": "str"},
                "path": "str",
                "protocols": ["str"],
                "provisioningState": "str",
                "serviceUrl": "str",
                "sourceApiId": "str",
                "subscriptionKeyParameterNames": {"header": "str", "query": "str"},
                "subscriptionRequired": bool,
                "termsOfServiceUrl": "str",
                "translateRequiredQueryParameters": "str",
                "type": "str",
                "value": "str",
                "wsdlSelector": {"wsdlEndpointName": "str", "wsdlServiceName": "str"},
            },
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_api_update(self, resource_group):
        response = self.client.workspace_api.update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_id="str",
            if_match="str",
            parameters={
                "apiRevision": "str",
                "apiRevisionDescription": "str",
                "apiVersion": "str",
                "apiVersionDescription": "str",
                "apiVersionSetId": "str",
                "authenticationSettings": {
                    "oAuth2": {"authorizationServerId": "str", "scope": "str"},
                    "oAuth2AuthenticationSettings": [{"authorizationServerId": "str", "scope": "str"}],
                    "openid": {"bearerTokenSendingMethods": ["str"], "openidProviderId": "str"},
                    "openidAuthenticationSettings": [{"bearerTokenSendingMethods": ["str"], "openidProviderId": "str"}],
                },
                "contact": {"email": "str", "name": "str", "url": "str"},
                "description": "str",
                "displayName": "str",
                "isCurrent": bool,
                "isOnline": bool,
                "license": {"name": "str", "url": "str"},
                "path": "str",
                "protocols": ["str"],
                "serviceUrl": "str",
                "subscriptionKeyParameterNames": {"header": "str", "query": "str"},
                "subscriptionRequired": bool,
                "termsOfServiceUrl": "str",
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_api_delete(self, resource_group):
        response = self.client.workspace_api.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
