
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Vrml_Material.hxx>
#include <TopoDS_Shape.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <VrmlAPI.hxx>
#include <VrmlAPI_CafReader.hxx>
#include <VrmlAPI_RepresentationOfShape.hxx>
#include <VrmlAPI_Writer.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <VrmlConverter_Drawer.hxx>

// Module definiiton
void register_VrmlAPI_enums(py::module &main_module) {


py::module m = main_module.def_submodule("VrmlAPI", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<VrmlAPI_RepresentationOfShape>(m, "VrmlAPI_RepresentationOfShape",R"#(Identifies the representation of the shape written to a VRML file. The available options are : - VrmlAPI_ShadedRepresentation : the shape is translated with a shaded representation. - VrmlAPI_WireFrameRepresentation : the shape is translated with a wireframe representation. - VrmlAPI_BothRepresentation : the shape is translated to VRML format with both representations : shaded and wireframe. This is the default option.)#")
        .value("VrmlAPI_ShadedRepresentation",VrmlAPI_RepresentationOfShape::VrmlAPI_ShadedRepresentation)
        .value("VrmlAPI_WireFrameRepresentation",VrmlAPI_RepresentationOfShape::VrmlAPI_WireFrameRepresentation)
        .value("VrmlAPI_BothRepresentation",VrmlAPI_RepresentationOfShape::VrmlAPI_BothRepresentation).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<VrmlAPI , shared_ptr<VrmlAPI>  >(m,"VrmlAPI",R"#(API for writing to VRML 1.0)#");
    py::class_<VrmlAPI_Writer , shared_ptr<VrmlAPI_Writer>  >(m,"VrmlAPI_Writer",R"#(Creates and writes VRML files from Open CASCADE shapes. A VRML file can be written to an existing VRML file or to a new one.)#");
    py::class_<VrmlAPI_CafReader ,opencascade::handle<VrmlAPI_CafReader>  , RWMesh_CafReader >(m,"VrmlAPI_CafReader",R"#(The Vrml mesh reader into XDE document.)#");

};

// user-defined post-inclusion per module

// user-defined post
