<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Semaphore\Tests\Store;

use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RequiresPhpExtension;
use Relay\Relay;

#[RequiresPhpExtension('relay')]
#[Group('integration')]
class RelayStoreTest extends AbstractRedisStoreTestCase
{
    protected function setUp(): void
    {
        try {
            $this->getRedisConnection()->flushDB();
        } catch (\Relay\Exception $e) {
            self::markTestSkipped($e->getMessage());
        }
    }

    public static function setUpBeforeClass(): void
    {
        try {
            new Relay(...explode(':', getenv('REDIS_HOST')));
        } catch (\Relay\Exception $e) {
            self::markTestSkipped($e->getMessage());
        }
    }

    protected function getRedisConnection(): Relay
    {
        return new Relay(...explode(':', getenv('REDIS_HOST')));
    }
}
