/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class CrystalReader
extends AtomSetCollectionReader {
    private boolean isVersion3;
    private boolean isPrimitive;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean isMolecular;
    private boolean haveCharges;
    private boolean addVibrations;
    private boolean isFreqCalc;
    private boolean inputOnly;
    private int atomCount;
    private int[] atomFrag;
    private Point3f ptOriginShift = new Point3f();
    private boolean havePrimitiveMapping;
    private int[] primitiveToIndex;
    int atomIndexLast;
    private Vector vInputCoords;
    private Double energy;
    private float[] nuclearCharges;
    private float[] frequencies;
    private String[] data;

    protected void initializeReader() throws Exception {
        this.doProcessLines = false;
        if (this.filter != null) {
            this.filter = this.filter.toLowerCase();
        }
        this.inputOnly = this.filter != null && this.filter.indexOf("input") >= 0;
        this.addVibrations = !this.inputOnly && (this.filter == null || this.filter.indexOf("novib") < 0);
        this.isPrimitive = !this.inputOnly && (this.filter == null || this.filter.indexOf("conv") < 0);
        this.setFractionalCoordinates(this.readHeader());
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains("FRQFRQ")) {
            this.isFreqCalc = true;
            return true;
        }
        if (!this.isPrimitive) {
            if (this.line.startsWith(" SHIFT OF THE ORIGIN")) {
                this.readShift();
                return true;
            }
            if (this.line.startsWith(" INPUT COORDINATES")) {
                this.readInputCoords();
                if (this.inputOnly) {
                    this.continuing = false;
                }
                return true;
            }
        }
        if (this.line.contains("DIMENSIONALITY OF THE SYSTEM")) {
            if (this.line.indexOf("2") >= 0) {
                this.isSlab = true;
            }
            if (this.line.indexOf("1") >= 0) {
                this.isPolymer = true;
            }
            return true;
        }
        if (this.line.startsWith(" LATTICE PARAMETER")) {
            boolean bl = this.line.contains("- CONVENTIONAL");
            if (bl) {
                if (this.isPrimitive) {
                    return true;
                }
                this.readCellParams();
            } else if (!this.isPrimitive && !this.havePrimitiveMapping) {
                this.readPrimitiveMapping();
                return true;
            }
            if (!this.doGetModel(++this.modelNumber)) {
                return this.checkLastModel();
            }
            if (this.isPrimitive) {
                this.readCellParams();
            } else if (this.modelNumber != 1 && !this.isFreqCalc) {
                this.continuing = false;
                Logger.error("Ignoring structure " + this.modelNumber + " due to FILTER \"conventional\"");
            }
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" ATOMS IN THE ASYMMETRIC UNIT")) {
            if (this.isPrimitive) {
                this.readFractionalCoords();
            }
            return true;
        }
        if (this.line.startsWith(" TOTAL ENERGY")) {
            this.readEnergy();
            this.readLine();
            if (this.line.startsWith(" ********")) {
                this.discardLinesUntilContains("SYMMETRY ALLOWED");
            }
            if (this.line.startsWith(" TTTTTTTT")) {
                this.discardLinesUntilContains("PREDICTED ENERGY CHANGE");
            }
            return true;
        }
        if (this.line.startsWith(" TYPE OF CALCULATION")) {
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.isPrimitive && this.line.contains("VOLUME=") && this.line.contains("- DENSITY")) {
            this.readVolumePrimCell();
            return true;
        }
        if (this.line.startsWith(" MULLIKEN POPULATION ANALYSIS")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" TOTAL ATOMIC CHARGES")) {
            this.readTotalAtomicCharges();
            return true;
        }
        if (this.line.startsWith(" FREQUENCIES COMPUTED ON A FRAGMENT")) {
            this.readFragments();
            return true;
        }
        if (this.addVibrations && this.line.contains("* CALCULATION OF PHONON FREQUENCIES AT THE GAMMA POINT.")) {
            if (this.vInputCoords != null) {
                this.processInputCoords();
            }
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" ATOMIC SPINS SET")) {
            this.readSpins();
            return true;
        }
        if (this.line.startsWith(" TOTAL ATOMIC SPINS  :")) {
            this.readMagneticMoments();
            return true;
        }
        return true;
    }

    private void readShift() {
        String[] stringArray = this.getTokens();
        int n = stringArray.length - 3;
        this.ptOriginShift.set(this.fraction(stringArray[n++]), this.fraction(stringArray[n++]), this.fraction(stringArray[n]));
    }

    private float fraction(String string) {
        String[] stringArray = TextFormat.split(string, '/');
        return stringArray.length == 2 ? this.parseFloat(stringArray[0]) / this.parseFloat(stringArray[1]) : 0.0f;
    }

    private void readVolumePrimCell() {
        String[] stringArray = CrystalReader.getTokens(this.line);
        String string = stringArray[7];
        if (stringArray[9].length() > 7) {
            this.line = TextFormat.simpleReplace(this.line, "DENSITY", "DENSITY ");
        }
        String string2 = stringArray[10];
        this.atomSetCollection.setAtomSetAuxiliaryProperty("volumePrimitive", TextFormat.formatDecimal(this.parseFloat(string), 3));
        this.atomSetCollection.setAtomSetAuxiliaryProperty("densityPrimitive", TextFormat.formatDecimal(this.parseFloat(string2), 3));
    }

    private void readSpins() throws Exception {
        String string = "";
        while (this.readLine() != null && this.line.indexOf("ALPHA") < 0) {
            string = string + this.line;
        }
        string = TextFormat.simpleReplace(string, "-", " -");
        this.setData("spin", string, 2, 3);
    }

    private void readMagneticMoments() throws Exception {
        String string = "";
        while (this.readLine() != null && this.line.indexOf("TTTTTT") < 0) {
            string = string + this.line;
        }
        this.setData("magneticMoment", string, 0, 1);
    }

    private void setData(String string, String string2, int n, int n2) {
        String[] stringArray = new String[this.atomCount];
        String[] stringArray2 = CrystalReader.getTokens(string2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.atomCount) {
            int n5 = this.getAtomIndexFromPrimitiveIndex(n3);
            if (n5 >= 0) {
                stringArray[n4++] = stringArray2[n];
            }
            ++n3;
            n += n2;
        }
        string2 = TextFormat.join(stringArray, '\n', 0);
        this.atomSetCollection.setAtomSetAuxiliaryProperty(string, string2);
    }

    protected void finalizeReader() throws Exception {
        if (this.vInputCoords != null) {
            this.processInputCoords();
        }
        if (this.energy != null) {
            this.setEnergy();
        }
        super.finalizeReader();
    }

    private boolean readHeader() throws Exception {
        this.discardLinesUntilContains("*                                CRYSTAL");
        this.isVersion3 = this.line.contains("CRYSTAL03");
        this.discardLinesUntilContains("EEEEEEEEEE");
        this.atomSetCollection.setCollectionName(this.readLine().trim() + (this.desiredModelNumber == 0 ? " (optimized)" : ""));
        this.readLine();
        String string = this.readLine().trim();
        if (string.indexOf("EXTERNAL FILE") >= 0) {
            string = this.readLine().trim();
            this.isPolymer = string.equals("1D - POLYMER");
            this.isSlab = string.equals("2D - SLAB");
        } else {
            this.isPolymer = string.equals("POLYMER CALCULATION");
            this.isSlab = string.equals("SLAB CALCULATION");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("symmetryType", string);
        if ((this.isPolymer || this.isSlab) && !this.isPrimitive) {
            Logger.error("Cannot use FILTER \"conventional\" with POLYMER or SLAB");
            this.isPrimitive = true;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("unitCellType", this.isPrimitive ? "primitive" : "conventional");
        if (string.indexOf("MOLECULAR") >= 0) {
            this.doProcessLines = true;
            this.isMolecular = true;
            this.readLine();
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("molecularCalculationPointGroup", this.line.substring(this.line.indexOf(" OR ") + 4).trim());
            return false;
        }
        if (!this.isPrimitive) {
            this.discardLines(5);
            this.setSpaceGroupName(this.line.substring(this.line.indexOf(":") + 1).trim());
        }
        return true;
    }

    private void readCellParams() throws Exception {
        this.newAtomSet();
        if (this.isPolymer && !this.isPrimitive) {
            float f = this.parseFloat(this.line.substring(this.line.indexOf("CELL") + 4));
            this.setUnitCell(f, -1.0f, -1.0f, 90.0f, 90.0f, 90.0f);
        } else {
            this.discardLinesUntilContains("GAMMA");
            String[] stringArray = CrystalReader.getTokens(this.readLine());
            if (this.isSlab) {
                if (this.isPrimitive) {
                    this.setUnitCell(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), -1.0f, this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
                } else {
                    this.setUnitCell(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), -1.0f, 90.0f, 90.0f, this.parseFloat(stringArray[2]));
                }
            } else if (this.isPolymer) {
                this.setUnitCell(this.parseFloat(stringArray[0]), -1.0f, -1.0f, this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
            } else {
                this.setUnitCell(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
            }
        }
    }

    private void readPrimitiveMapping() throws Exception {
        int n;
        int n2;
        this.havePrimitiveMapping = true;
        BitSet bitSet = new BitSet();
        int n3 = this.vInputCoords.size();
        int[] nArray = new int[n3];
        this.primitiveToIndex = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = -1;
        }
        this.discardLines(3);
        while (this.readLine() != null && this.line.contains(" NOT IRREDUCIBLE")) {
            bitSet.set(this.parseInt(this.line.substring(21, 25)) - 1);
            this.readLine();
        }
        this.discardLines(3);
        n2 = 0;
        int n4 = 0;
        while (this.readLine() != null && this.line.indexOf("NUMBER") < 0) {
            if (this.line.length() == 0) continue;
            ++n4;
            n = this.parseInt(this.line.substring(4, 8)) - 1;
            if (nArray[n] >= 0) continue;
            nArray[n] = n2++;
        }
        if (bitSet.nextSetBit(0) >= 0) {
            n = n3;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                this.vInputCoords.remove(n);
            }
        }
        this.atomCount = this.vInputCoords.size();
        this.primitiveToIndex = new int[n4];
        for (n = 0; n < n4; ++n) {
            this.primitiveToIndex[n] = -1;
        }
        n = this.vInputCoords.size();
        while (--n >= 0) {
            this.line = (String)this.vInputCoords.get(n);
            int n5 = this.parseInt(this.line.substring(0, 4)) - 1;
            n2 = nArray[n5];
            if (n2 < 0) continue;
            this.primitiveToIndex[n2] = n;
        }
        System.out.println(n4 + " primitive atoms " + this.vInputCoords.size() + " conventionalAtoms");
    }

    private void readFractionalCoords() throws Exception {
        boolean bl;
        if (this.isMolecular) {
            this.newAtomSet();
        }
        this.readLine();
        this.readLine();
        int n = this.atomIndexLast;
        this.atomIndexLast = this.atomSetCollection.getAtomCount();
        boolean bl2 = bl = this.isPrimitive && !this.isMolecular && !this.isPolymer && !this.isSlab;
        while (this.readLine() != null && this.line.length() > 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            int n2 = this.getAtomicNumber(stringArray[2]);
            atom.atomName = this.getAtomName(stringArray[3]);
            float f = this.parseFloat(stringArray[4]);
            float f2 = this.parseFloat(stringArray[5]);
            float f3 = this.parseFloat(stringArray[6]);
            if (this.haveCharges) {
                atom.partialCharge = this.atomSetCollection.getAtom((int)n++).partialCharge;
            }
            if (f < 0.0f && (this.isPolymer || this.isSlab || bl)) {
                f += 1.0f;
            }
            if (f2 < 0.0f && (this.isSlab || bl)) {
                f2 += 1.0f;
            }
            if (f3 < 0.0f && bl) {
                f3 += 1.0f;
            }
            this.setAtomCoord(atom, f, f2, f3);
            atom.elementSymbol = CrystalReader.getElementSymbol(n2);
        }
        this.atomCount = this.atomSetCollection.getAtomCount() - this.atomIndexLast;
    }

    private String getAtomName(String string) {
        String string2 = string;
        if (string2.length() > 1 && Character.isLetter(string2.charAt(1))) {
            string2 = string2.substring(0, 1) + Character.toLowerCase(string2.charAt(1)) + string2.substring(2);
        }
        return string2;
    }

    private int getAtomicNumber(String string) {
        int n;
        for (n = this.parseInt(string); n >= 100; n -= 100) {
        }
        return n;
    }

    private void readInputCoords() throws Exception {
        this.readLine();
        this.readLine();
        this.vInputCoords = new Vector();
        while (this.readLine() != null && this.line.length() > 0) {
            this.vInputCoords.add(this.line);
        }
    }

    private void processInputCoords() throws Exception {
        int n = this.vInputCoords.size();
        for (int i = 0; i < n; ++i) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = CrystalReader.getTokens((String)this.vInputCoords.get(i));
            int n2 = this.getAtomicNumber(stringArray[1]);
            float f = this.parseFloat(stringArray[2]) + this.ptOriginShift.x;
            float f2 = this.parseFloat(stringArray[3]) + this.ptOriginShift.y;
            float f3 = this.parseFloat(stringArray[4]) + this.ptOriginShift.z;
            this.setAtomCoord(atom, f, f2, f3);
            atom.elementSymbol = CrystalReader.getElementSymbol(n2);
        }
        this.vInputCoords = null;
    }

    private void newAtomSet() throws Exception {
        if (this.atomSetCollection.getAtomCount() == 0) {
            return;
        }
        this.applySymmetryAndSetTrajectory();
        this.atomSetCollection.newAtomSet();
    }

    private void readEnergy() {
        this.line = TextFormat.simpleReplace(this.line, "( ", "(");
        String[] stringArray = this.getTokens();
        this.energy = new Double(Double.parseDouble(stringArray[2]));
        this.setEnergy();
    }

    private void setEnergy() {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Energy", this.energy);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Energy", this.energy);
        this.atomSetCollection.setAtomSetName("Energy = " + this.energy + " Hartree");
    }

    private void readPartialCharges() throws Exception {
        if (this.haveCharges) {
            return;
        }
        this.haveCharges = true;
        this.discardLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        int n2 = 0;
        while (this.readLine() != null && this.line.length() > 3) {
            if (this.line.charAt(3) == ' ') continue;
            int n3 = this.getAtomIndexFromPrimitiveIndex(n2);
            if (n3 >= 0) {
                atomArray[n + n3].partialCharge = this.parseFloat(this.line.substring(9, 11)) - this.parseFloat(this.line.substring(12, 18));
            }
            ++n2;
        }
    }

    private void readTotalAtomicCharges() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && !this.line.contains("T")) {
            stringBuffer.append(this.line);
        }
        String[] stringArray = CrystalReader.getTokens(stringBuffer.toString());
        float[] fArray = new float[stringArray.length];
        if (this.nuclearCharges == null) {
            this.nuclearCharges = fArray;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = this.getAtomIndexFromPrimitiveIndex(i);
            if (n2 < 0) continue;
            fArray[i] = this.parseFloat(stringArray[i]);
            atomArray[n + n2].partialCharge = this.nuclearCharges[i] - fArray[i];
        }
    }

    private int getAtomIndexFromPrimitiveIndex(int n) {
        return this.primitiveToIndex == null ? n : this.primitiveToIndex[n];
    }

    private void readFragments() throws Exception {
        int n = this.parseInt(this.line.substring(39, 44));
        if (n < 0) {
            return;
        }
        this.atomFrag = new int[n];
        String string = "";
        while (this.readLine() != null && this.line.indexOf("INFORMATION **** INPFREQ") < 0) {
            string = string + this.line;
        }
        string = TextFormat.simpleReplace(string, "(", " (");
        String[] stringArray = CrystalReader.getTokens(string);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            this.atomFrag[n2] = this.getAtomIndexFromPrimitiveIndex(this.parseInt(stringArray[n3]) - 1);
            ++n2;
            n3 += 5;
        }
    }

    private void readFrequencies() throws Exception {
        Object object;
        String[] stringArray;
        int n;
        int n2;
        this.discardLinesUntilContains(this.isVersion3 ? "MODES          EV" : "MODES         EIGV");
        this.readLine();
        Vector<String[]> vector = new Vector<String[]>();
        int n3 = this.atomCount;
        while (this.readLine() != null && this.line.length() > 0) {
            n2 = this.parseInt(this.line.substring(1, 5));
            n = this.parseInt(this.line.substring(6, 10));
            stringArray = this.line.substring(49, 52).trim();
            object = this.line.substring(59, 69).replace(')', ' ').trim();
            if (object == null) {
                object = "not available";
            }
            String string = this.line.substring(55, 58).trim();
            String string2 = this.line.substring(71, 73).trim();
            String[] stringArray2 = new String[]{stringArray, object, string, string2};
            for (int i = n2; i <= n; ++i) {
                vector.add(stringArray2);
            }
        }
        this.discardLinesUntilContains(this.isVersion3 ? "THE CORRESPONDING MODES" : "NORMAL MODES NORMALIZED TO CLASSICAL AMPLITUDES");
        this.readLine();
        n2 = -1;
        while (this.readLine() != null && this.line.startsWith(" FREQ(CM**-1)")) {
            n = 0;
            stringArray = CrystalReader.getTokens(this.line.substring(15));
            this.frequencies = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                float f;
                this.frequencies[n] = f = this.parseFloat(stringArray[i]);
                ++n;
                if (!Logger.debugging) continue;
                Logger.debug(this.vibrationNumber + 1 + " frequency=" + f);
            }
            object = new boolean[n];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                this.data = (String[])vector.get(this.vibrationNumber);
                object[i] = !this.doGetVibration(++this.vibrationNumber) || this.data == null;
                if (object[i] != false) continue;
                n2 = this.cloneLastAtomSet(this.atomCount);
                if (i == 0) {
                    n4 = this.atomSetCollection.getLastAtomSetAtomIndex();
                }
                this.setFreqValue(i);
            }
            this.readLine();
            this.fillFrequencyData(n4, n3, n2, (boolean[])object, false, 14, 10, this.atomFrag);
            this.readLine();
        }
    }

    private void setFreqValue(int n) {
        String string = ", IR: " + this.data[2] + ", Ram.: " + this.data[3];
        this.atomSetCollection.setAtomSetName(this.data[0] + " " + TextFormat.formatDecimal(this.frequencies[n], 2) + " cm-1 (" + TextFormat.formatDecimal(Float.parseFloat(this.data[1]), 0) + " km/Mole)" + string);
        this.atomSetCollection.setAtomSetProperty("Frequency", this.frequencies[n] + " cm-1");
        this.atomSetCollection.setAtomSetProperty("IRintensity", this.data[1] + " km/Mole");
        this.atomSetCollection.setAtomSetProperty("vibrationalSymmetry", this.data[0]);
        this.atomSetCollection.setAtomSetProperty("IRactivity ", this.data[2]);
        this.atomSetCollection.setAtomSetProperty("Ramanactivity ", this.data[3]);
    }
}

