/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.util.TriangleData;

public class MarchingCubes
extends TriangleData {
    protected VertexDataServer surfaceReader;
    protected VolumeData volumeData;
    protected int contourType;
    protected boolean isContoured;
    protected float cutoff;
    protected boolean isCutoffAbsolute;
    protected boolean isSquared;
    protected boolean isXLowToHigh;
    protected int cubeCountX;
    protected int cubeCountY;
    protected int cubeCountZ;
    protected int nY;
    protected int nZ;
    protected int yzCount;
    protected boolean colorDensity;
    protected float fractionOutside;
    protected boolean integrateSquared = true;
    protected BitSet bsVoxels;
    protected BitSet bsExcludedVertices;
    protected BitSet bsExcludedTriangles;
    protected BitSet bsExcludedPlanes;
    protected StringBuffer edgeData = new StringBuffer();
    protected int mode;
    protected static final int MODE_CUBE = 1;
    protected static final int MODE_BITSET = 2;
    protected static final int MODE_GETXYZ = 3;
    protected final float[] vertexValues = new float[8];
    protected int edgeCount;
    protected final Vector3f[] voxelVertexVectors = new Vector3f[8];
    protected final Vector3f[] edgeVectors = new Vector3f[12];
    protected static int[] yzPlanePts = new int[]{0, 1, 1, 0, 0, 1, 1, 0};
    protected final int[] edgePointIndexes;
    protected int[][][] isoPointIndexPlanes;
    protected float[][] yzPlanes;
    protected int nTriangles;
    protected BitSet bsValues;
    protected final Point3f pt0;
    protected final Point3f pointA;
    protected static final int[] edgeVertexPointersLowToHigh = new int[]{1, 1, 2, 0, 5, 5, 6, 4, 0, 1, 2, 3};
    protected static final int[] edgeVertexPointersHighToLow = new int[]{0, 1, 3, 0, 4, 5, 7, 4, 0, 1, 2, 3};
    protected int[] edgeVertexPointers;
    protected static final int[] edgeVertexPlanesLowToHigh = new int[]{1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0};
    protected static final int[] edgeVertexPlanesHighToLow = new int[]{1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1};
    protected int[] edgeVertexPlanes;
    protected float[] fReturn;
    protected static final Vector3f[] cubeVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
    protected static final int[] edgeTypeTable = new int[]{0, 2, 0, 2, 0, 2, 0, 2, 1, 1, 1, 1};
    protected final int[] linearOffsets;
    protected static final short[] insideMaskTable = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};

    public BitSet getBsVoxels() {
        return this.bsVoxels;
    }

    public MarchingCubes() {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new Vector3f();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BitSet();
        this.pt0 = new Point3f();
        this.pointA = new Point3f();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
    }

    public MarchingCubes(VertexDataServer vertexDataServer, VolumeData volumeData, Parameters parameters, BitSet bitSet) {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new Vector3f();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BitSet();
        this.pt0 = new Point3f();
        this.pointA = new Point3f();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
        this.surfaceReader = vertexDataServer;
        this.bsVoxels = bitSet;
        BitSet[] bitSetArray = parameters.bsExcluded;
        this.bsExcludedVertices = bitSetArray[0] == null ? new BitSet() : bitSetArray[0];
        this.bsExcludedPlanes = bitSetArray[2] == null ? new BitSet() : bitSetArray[2];
        BitSet bitSet2 = this.bsExcludedTriangles = bitSetArray[3] == null ? new BitSet() : bitSetArray[3];
        this.mode = volumeData.voxelData != null ? 1 : (bitSet != null ? 2 : 3);
        this.setParameters(volumeData, parameters);
    }

    protected void setParameters(VolumeData volumeData, Parameters parameters) {
        this.volumeData = volumeData;
        this.colorDensity = parameters.colorDensity;
        this.isContoured = parameters.isContoured && !this.colorDensity;
        this.cutoff = parameters.cutoff;
        this.isCutoffAbsolute = parameters.isCutoffAbsolute;
        this.contourType = parameters.contourType;
        this.isSquared = parameters.isSquared;
        this.isXLowToHigh = parameters.isXLowToHigh;
        this.cubeCountX = volumeData.voxelCounts[0] - 1;
        this.nY = volumeData.voxelCounts[1];
        this.cubeCountY = this.nY - 1;
        this.nZ = volumeData.voxelCounts[2];
        this.cubeCountZ = this.nZ - 1;
        this.yzCount = this.nY * this.nZ;
        if (this.bsVoxels == null) {
            this.bsVoxels = new BitSet();
        }
        this.edgeVertexPointers = this.isXLowToHigh ? edgeVertexPointersLowToHigh : edgeVertexPointersHighToLow;
        this.edgeVertexPlanes = this.isXLowToHigh ? edgeVertexPlanesLowToHigh : edgeVertexPlanesHighToLow;
        this.isoPointIndexPlanes = new int[2][this.yzCount][3];
        this.yzPlanes = this.mode == 3 ? new float[2][this.yzCount] : (float[][])null;
        this.setLinearOffsets();
        this.calcVoxelVertexVectors();
    }

    protected void calcVoxelVertexVectors() {
        int n = 8;
        while (--n >= 0) {
            this.voxelVertexVectors[n] = new Vector3f();
            this.volumeData.transform(cubeVertexVectors[n], this.voxelVertexVectors[n]);
        }
        n = 12;
        while (--n >= 0) {
            this.edgeVectors[n].sub(this.voxelVertexVectors[edgeVertexes[n + n + 1]], this.voxelVertexVectors[edgeVertexes[n + n]]);
        }
    }

    protected int[][] resetIndexPlane(int[][] nArray) {
        for (int i = 0; i < this.yzCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                nArray[i][j] = Integer.MIN_VALUE;
            }
        }
        return nArray;
    }

    public String getEdgeData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        this.edgeCount = 0;
        if (this.isXLowToHigh) {
            n7 = 0;
            n6 = this.cubeCountX;
            n5 = 1;
            n4 = this.yzCount;
            n2 = n3 = this.yzCount - 1 - this.nZ - 1;
        } else {
            n7 = this.cubeCountX - 1;
            n6 = -1;
            n5 = -1;
            n4 = -this.yzCount;
            n2 = n3 = this.cubeCountX * this.yzCount - 1 - this.nZ - 1;
        }
        if (this.cubeCountX < 0 || this.cubeCountY < 0 || this.cubeCountZ < 0) {
            return "";
        }
        int n11 = n = this.cubeCountY * this.cubeCountZ - 1;
        this.resetIndexPlane(this.isoPointIndexPlanes[1]);
        if (this.mode == 3) {
            this.surfaceReader.getPlane(n7);
        }
        float f = 0.0f;
        int n12 = 0;
        for (int i = n7; i != n6; i += n5) {
            Object object;
            if (this.mode == 3) {
                if (i + n5 != n6) {
                    this.surfaceReader.getPlane(i + n5);
                }
                object = this.yzPlanes[0];
                this.yzPlanes[0] = this.yzPlanes[1];
                this.yzPlanes[1] = (float[])object;
            }
            object = this.isoPointIndexPlanes[0];
            this.isoPointIndexPlanes[0] = this.isoPointIndexPlanes[1];
            this.isoPointIndexPlanes[1] = this.resetIndexPlane((int[][])object);
            if (!this.bsExcludedPlanes.get(i) || !this.bsExcludedPlanes.get(i + n5)) {
                int n13 = 0;
                boolean bl = this.cutoff == 0.0f && this.colorDensity;
                int n14 = this.cubeCountY;
                while (--n14 >= 0) {
                    int n15 = this.cubeCountZ;
                    while (--n15 >= 0) {
                        int n16 = 0;
                        int n17 = 8;
                        while (--n17 >= 0) {
                            boolean bl2;
                            Point3i point3i = cubeVertexOffsets[n17];
                            n12 = n2 + this.linearOffsets[n17];
                            switch (this.mode) {
                                case 3: {
                                    f = this.vertexValues[n17] = this.getValue(i + point3i.x, n14 + point3i.y, n15 + point3i.z, n12, this.yzPlanes[yzPlanePts[n17]]);
                                    bl2 = this.bsVoxels.get(n12);
                                    break;
                                }
                                case 2: {
                                    bl2 = this.bsVoxels.get(n12);
                                    this.vertexValues[n17] = this.bsExcludedVertices.get(n12) ? Float.NaN : (bl2 ? 1.0f : 0.0f);
                                    f = this.vertexValues[n17];
                                    break;
                                }
                                default: {
                                    f = this.vertexValues[n17] = this.volumeData.voxelData[i + point3i.x][n14 + point3i.y][n15 + point3i.z];
                                    if (this.isSquared) {
                                        int n18 = n17;
                                        this.vertexValues[n18] = this.vertexValues[n18] * this.vertexValues[n17];
                                    }
                                    boolean bl3 = bl2 = bl ? true : MarchingCubes.isInside(this.vertexValues[n17], this.cutoff, this.isCutoffAbsolute);
                                    if (!bl2) break;
                                    this.bsVoxels.set(n12);
                                }
                            }
                            if (bl2) {
                                n16 |= Pwr2[n17];
                                continue;
                            }
                            this.fractionOutside += this.integrateSquared ? this.vertexValues[n17] * this.vertexValues[n17] : this.vertexValues[n17];
                        }
                        if (!Float.isNaN(f)) {
                            ++n13;
                        }
                        if (n16 == 0) {
                            ++n9;
                        } else {
                            if (this.colorDensity) {
                                this.addVertex(i, n14, n15, n12, f);
                            }
                            if (n16 == 255) {
                                ++n8;
                            } else {
                                ++n10;
                                if (this.processOneCubical(n16, i, n14, n15, n2) && !this.isContoured && !this.colorDensity) {
                                    this.processTriangles(n16);
                                }
                            }
                        }
                        --n2;
                        --n11;
                    }
                    --n2;
                }
                if (n13 == 0) {
                    this.bsExcludedPlanes.set(i);
                }
            }
            n2 = n3 += n4;
            n11 = n;
        }
        return this.edgeData.toString();
    }

    protected void processTriangles(int n) {
        byte[] byArray = triangleTable2[n];
        int n2 = byArray.length;
        while ((n2 -= 4) >= 0) {
            this.addTriangle(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
        }
    }

    protected void addVertex(int n, int n2, int n3, int n4, float f) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        if (this.surfaceReader.addVertexCopy(this.pt0, f, -4) < 0) {
            this.bsExcludedVertices.set(n4);
        }
    }

    protected void addTriangle(int n, int n2, int n3, int n4) {
        if (!this.bsExcludedTriangles.get(this.nTriangles) && this.surfaceReader.addTriangleCheck(this.edgePointIndexes[n], this.edgePointIndexes[n2], this.edgePointIndexes[n3], n4, 0, this.isCutoffAbsolute, 0) < 0) {
            this.bsExcludedTriangles.set(this.nTriangles);
        }
        ++this.nTriangles;
    }

    protected float getValue(int n, int n2, int n3, int n4, float[] fArray) {
        int n5 = n4 % this.yzCount;
        this.bsValues.set(n4);
        float f = this.surfaceReader.getValue(n, n2, n3, n5);
        if (this.isSquared) {
            f *= f;
        }
        fArray[n5] = f;
        if (MarchingCubes.isInside(f, this.cutoff, this.isCutoffAbsolute)) {
            this.bsVoxels.set(n4);
        }
        return f;
    }

    public static boolean isInside(float f, float f2, boolean bl) {
        return f2 > 0.0f && (bl ? Math.abs(f) : f) >= f2 || f2 <= 0.0f && f <= f2;
    }

    protected boolean processOneCubical(int n, int n2, int n3, int n4, int n5) {
        short s = insideMaskTable[n];
        boolean bl = false;
        int n6 = 12;
        while (--n6 >= 0) {
            int n7 = Pwr2[n6];
            if ((s & n7) == 0) continue;
            int n8 = this.edgeVertexPlanes[n6];
            int n9 = (n5 + this.linearOffsets[this.edgeVertexPointers[n6]]) % this.yzCount;
            int n10 = edgeTypeTable[n6];
            this.edgePointIndexes[n6] = this.isoPointIndexPlanes[n8][n9][n10];
            int n11 = this.edgePointIndexes[n6];
            if (n11 != Integer.MIN_VALUE) {
                if (n11 != -1) continue;
                bl = true;
                continue;
            }
            byte by = edgeVertexes[n6 << 1];
            byte by2 = edgeVertexes[(n6 << 1) + 1];
            float f = this.vertexValues[by];
            float f2 = this.vertexValues[by2];
            this.calcVertexPoint(n2, n3, n4, by, this.pointA);
            ++this.edgeCount;
            int n12 = this.surfaceReader.getSurfacePointIndexAndFraction(this.cutoff, this.isCutoffAbsolute, n2, n3, n4, cubeVertexOffsets[by], by, by2, f, f2, this.pointA, this.edgeVectors[n6], n10 == this.contourType, this.fReturn);
            this.isoPointIndexPlanes[n8][n9][n10] = n12;
            this.edgePointIndexes[n6] = n12;
            int n13 = n12;
            this.addEdgeData(n13 < 0 ? Float.NaN : this.fReturn[0]);
            if (!Float.isNaN(this.fReturn[0]) && n13 >= 0) continue;
            bl = true;
        }
        return !bl;
    }

    protected void addEdgeData(float f) {
        char c = JvxlCoder.jvxlFractionAsCharacter(f);
        this.edgeData.append(c);
    }

    public void calcVertexPoint(int n, int n2, int n3, int n4, Point3f point3f) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        point3f.add(this.pt0, this.voxelVertexVectors[n4]);
    }

    protected void setLinearOffsets() {
        this.linearOffsets[0] = 0;
        this.linearOffsets[1] = this.yzCount;
        this.linearOffsets[2] = this.yzCount + 1;
        this.linearOffsets[3] = 1;
        this.linearOffsets[4] = this.nZ;
        this.linearOffsets[5] = this.yzCount + this.nZ;
        this.linearOffsets[6] = this.yzCount + this.nZ + 1;
        this.linearOffsets[7] = this.nZ + 1;
    }

    public int getLinearOffset(int n, int n2, int n3, int n4) {
        return n * this.yzCount + n2 * this.nZ + n3 + this.linearOffsets[n4];
    }
}

