/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class Molecule {
    ModelSet modelSet;
    int moleculeIndex;
    int modelIndex;
    int indexInModel;
    public int firstAtomIndex;
    public int nAtoms;
    int nElements;
    int[] elementCounts = new int[JmolConstants.elementNumberMax];
    int[] altElementCounts = new int[JmolConstants.altElementMax];
    int elementNumberMax;
    int altElementMax;
    String mf;
    public BitSet atomList;

    Molecule(ModelSet modelSet, int n, int n2, BitSet bitSet, int n3, int n4) {
        this.modelSet = modelSet;
        this.firstAtomIndex = n2;
        this.atomList = bitSet;
        this.moleculeIndex = n;
        this.modelIndex = n3;
        this.indexInModel = n4;
        this.getElementAndAtomCount(bitSet);
        this.mf = this.getMolecularFormula();
        if (Logger.debugging) {
            Logger.debug("new Molecule (" + this.mf + ") " + (n4 + 1) + "/" + (n3 + 1));
        }
    }

    void getElementAndAtomCount(BitSet bitSet) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            ++this.nAtoms;
            int n2 = this.modelSet.atoms[n].getAtomicAndIsotopeNumber();
            if (n2 < JmolConstants.elementNumberMax) {
                int n3 = n2;
                this.elementCounts[n3] = this.elementCounts[n3] + 1;
                if (this.elementCounts[n2] == 1) {
                    ++this.nElements;
                }
                this.elementNumberMax = Math.max(this.elementNumberMax, n2);
            } else {
                int n4 = n2 = JmolConstants.altElementIndexFromNumber(n2);
                this.altElementCounts[n4] = this.altElementCounts[n4] + 1;
                if (this.altElementCounts[n2] == 1) {
                    ++this.nElements;
                }
                this.altElementMax = Math.max(this.altElementMax, n2);
            }
            n = bitSet.nextSetBit(n + 1);
        }
    }

    String getMolecularFormula() {
        int n;
        int n2;
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
            n = this.elementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + JmolConstants.elementSymbolFromNumber(n2) + " " + n;
            string2 = " ";
        }
        for (n2 = 1; n2 <= this.altElementMax; ++n2) {
            n = this.altElementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + JmolConstants.elementSymbolFromNumber(JmolConstants.altElementNumberFromIndex(n2)) + " " + n;
            string2 = " ";
        }
        return string;
    }

    Hashtable getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("number", new Integer(this.moleculeIndex + 1));
        hashtable.put("modelNumber", this.modelSet.getModelNumberDotted(this.modelIndex));
        hashtable.put("numberInModel", new Integer(this.indexInModel + 1));
        hashtable.put("nAtoms", new Integer(this.nAtoms));
        hashtable.put("nElements", new Integer(this.nElements));
        hashtable.put("mf", this.mf);
        return hashtable;
    }
}

