/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricsHelper;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class EncodedMetrics {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Map<Long, Map<String, Metric>> buckets;

    public EncodedMetrics(@NotNull Map<Long, Map<String, Metric>> buckets) {
        this.buckets = buckets;
    }

    public byte[] encodeToStatsd() {
        StringBuilder statsd = new StringBuilder();
        for (Map.Entry<Long, Map<String, Metric>> entry : this.buckets.entrySet()) {
            MetricsHelper.encodeMetrics(entry.getKey(), entry.getValue().values(), statsd);
        }
        return statsd.toString().getBytes(UTF8);
    }

    @TestOnly
    Map<Long, Map<String, Metric>> getBuckets() {
        return this.buckets;
    }
}

