/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client.internal;

import java.net.URL;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.websocket.core.client.internal.HttpClientProvider;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlHttpClientProvider
implements HttpClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(XmlHttpClientProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient newHttpClient() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            return null;
        }
        URL resource = contextClassLoader.getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try {
            Thread.currentThread().setContextClassLoader(HttpClient.class.getClassLoader());
            HttpClient httpClient = XmlHttpClientProvider.newHttpClient(resource);
            return httpClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static HttpClient newHttpClient(URL resource) {
        try {
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(resource));
            return (HttpClient)configuration.configure();
        }
        catch (Throwable t2) {
            LOG.warn("Failure to load HttpClient from XML {}", (Object)resource, (Object)t2);
            return null;
        }
    }
}

