/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.codec.video.vp9;

import org.jitsi.rtp.extensions.ByteKt;

public class DePacketizer {
    private static final byte I_BIT = -128;
    private static final byte P_BIT = 64;
    private static final byte L_BIT = 32;
    private static final byte F_BIT = 16;
    private static final byte B_BIT = 8;
    private static final byte E_BIT = 4;
    private static final byte V_BIT = 2;
    private static final byte Z_BIT = 1;
    private static final byte M_BIT = -128;
    private static final byte U_BIT = 16;
    private static final byte D_BIT = 1;
    private static final byte N_BIT = 1;

    public static class VP9PayloadDescriptor {
        private static boolean isValid(byte[] buf, int off, int len) {
            return buf != null && buf.length >= off + len && off > -1 && len > 0;
        }

        public static boolean isStartOfFrame(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 8) != 0;
        }

        public static void setStartOfFrame(byte[] buf, int off, int len, boolean start) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len)) {
                throw new IllegalStateException("Can't set startOfFrame for invalid VP9 packet");
            }
            buf[off] = ByteKt.putBitWithMask(buf[off], (byte)8, start);
        }

        public static boolean isEndOfFrame(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 4) != 0;
        }

        public static void setEndOfFrame(byte[] buf, int off, int len, boolean end) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len)) {
                throw new IllegalStateException("Can't set endOfFrame for invalid VP9 packet");
            }
            buf[off] = ByteKt.putBitWithMask(buf[off], (byte)4, end);
        }

        public static boolean isFlexibleMode(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 0x10) != 0;
        }

        public static boolean hasScalabilityStructure(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 2) != 0;
        }

        public static boolean isUpperLevelReference(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 1) == 0;
        }

        public static void setUpperLevelReference(byte[] buf, int off, int len, boolean ref) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len)) {
                throw new IllegalStateException("Can't set upperLevelReference for invalid VP9 packet");
            }
            buf[off] = ByteKt.putBitWithMask(buf[off], (byte)1, !ref);
        }

        public static boolean hasPictureId(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 0xFFFFFF80) != 0 && len > 1;
        }

        public static boolean hasExtendedPictureId(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.hasPictureId(buf, off, len) && (buf[off + 1] & 0xFFFFFF80) != 0 && len > 2;
        }

        public static int getPictureId(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.hasPictureId(buf, off, len)) {
                return -1;
            }
            if (VP9PayloadDescriptor.hasExtendedPictureId(buf, off, len)) {
                return (buf[off + 1] & 0x7F) << 8 | buf[off + 2] & 0xFF;
            }
            return buf[off + 1] & 0x7F;
        }

        public static boolean setExtendedPictureId(byte[] buf, int off, int len, int val) {
            if (!VP9PayloadDescriptor.hasExtendedPictureId(buf, off, len)) {
                return false;
            }
            buf[off + 1] = (byte)(0x80 | val >> 8 & 0x7F);
            buf[off + 2] = (byte)(val & 0xFF);
            return true;
        }

        public static boolean isInterPicturePredicted(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 0x40) != 0;
        }

        public static void setInterPicturePredicted(byte[] buf, int off, int len, boolean pred) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len)) {
                throw new IllegalStateException("Can't set interPicturePredicted for invalid VP9 packet");
            }
            buf[off] = ByteKt.putBitWithMask(buf[off], (byte)64, pred);
        }

        public static boolean isKeyFrame(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len)) {
                return false;
            }
            if ((buf[off] & 0x40) != 0) {
                return false;
            }
            if (!VP9PayloadDescriptor.hasLayerIndices(buf, off, len)) {
                return true;
            }
            return VP9PayloadDescriptor.getSpatialLayerIndex(buf, off, len) == 0 || !VP9PayloadDescriptor.usesInterLayerDependency(buf, off, len);
        }

        public static boolean hasLayerIndices(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 0x20) != 0;
        }

        private static int getLayerIndexOffset(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.hasLayerIndices(buf, off, len)) {
                return -1;
            }
            int loff = off + 1;
            if ((buf[off] & 0xFFFFFF80) != 0) {
                ++loff;
                if ((buf[off + 1] & 0xFFFFFF80) != 0) {
                    ++loff;
                }
            }
            if (loff >= off + len) {
                return -1;
            }
            return loff;
        }

        public static boolean hasTL0PICIDX(byte[] buf, int off, int len) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (loff < 0 || loff + 1 >= off + len) {
                return false;
            }
            return !VP9PayloadDescriptor.isFlexibleMode(buf, off, len);
        }

        public static int getTL0PICIDX(byte[] buf, int off, int len) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (!VP9PayloadDescriptor.hasTL0PICIDX(buf, off, len)) {
                return -1;
            }
            return buf[loff + 1] & 0xFF;
        }

        public static boolean setTL0PICIDX(byte[] buf, int off, int len, int val) {
            if (!VP9PayloadDescriptor.hasTL0PICIDX(buf, off, len)) {
                return false;
            }
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            buf[loff + 1] = (byte)val;
            return true;
        }

        public static int getTemporalLayerIndex(byte[] buf, int off, int len) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (loff < 0) {
                return -1;
            }
            return (buf[loff] & 0xE0) >> 5;
        }

        public static int getSpatialLayerIndex(byte[] buf, int off, int len) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (loff < 0) {
                return -1;
            }
            return (buf[loff] & 0xE) >> 1;
        }

        public static boolean isSwitchingUpPoint(byte[] buf, int off, int len) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (loff < 0) {
                return false;
            }
            return (buf[loff] & 0x10) != 0;
        }

        public static boolean usesInterLayerDependency(byte[] buf, int off, int len) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (loff < 0) {
                return false;
            }
            return (buf[loff] & 1) != 0;
        }

        public static boolean setLayerIndices(byte[] buf, int off, int len, int sid, int tid, boolean isSwitchingUpPoint, boolean usesInterLayerDependency) {
            int loff = VP9PayloadDescriptor.getLayerIndexOffset(buf, off, len);
            if (loff < 0) {
                return false;
            }
            if (sid < 0 || sid > 8) {
                throw new IllegalArgumentException("Invalid spatial ID " + sid);
            }
            if (tid < 0 || tid > 8) {
                throw new IllegalArgumentException("Invalid spatial ID " + sid);
            }
            buf[loff] = (byte)(tid << 5 | (isSwitchingUpPoint ? 16 : 0) | sid << 1 | (usesInterLayerDependency ? 1 : 0));
            return true;
        }

        public static int getSize(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len)) {
                return -1;
            }
            int pos = off + 1;
            if ((buf[off] & 0xFFFFFF80) != 0) {
                boolean extended = (buf[pos] & 0xFFFFFF80) != 0;
                ++pos;
                if (extended) {
                    ++pos;
                }
            }
            if ((buf[off] & 0x20) != 0) {
                ++pos;
                if ((buf[off] & 0x10) == 0) {
                    ++pos;
                }
            }
            if ((buf[off] & 0x10) != 0 && (buf[off] & 0x40) != 0) {
                for (int i = 0; i < 3; ++i) {
                    int hasNext = buf[pos] & 1;
                    ++pos;
                    if (hasNext == 0) break;
                }
            }
            if ((buf[off] & 2) != 0) {
                int n_s = (buf[pos] & 0xE0) >> 5;
                boolean resPresent = (buf[pos] & 0x10) != 0;
                boolean pgPresent = (buf[pos] & 8) != 0;
                ++pos;
                if (resPresent) {
                    pos += 4 * (n_s + 1);
                }
                if (pgPresent) {
                    int n_g = buf[pos] & 0xFF;
                    ++pos;
                    for (int i = 0; i < n_g; ++i) {
                        int r = (buf[pos] & 0xC) >> 2;
                        pos += r + 1;
                    }
                }
            }
            return pos - off;
        }

        public static int getScalabilityStructureOffset(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.hasScalabilityStructure(buf, off, len)) {
                return -1;
            }
            int pos = off + 1;
            if ((buf[off] & 0xFFFFFF80) != 0) {
                boolean extended = (buf[pos] & 0xFFFFFF80) != 0;
                ++pos;
                if (extended) {
                    ++pos;
                }
            }
            if ((buf[off] & 0x20) != 0) {
                ++pos;
                if ((buf[off] & 0x10) == 0) {
                    ++pos;
                }
            }
            if ((buf[off] & 0x10) != 0 && (buf[off] & 0x40) != 0) {
                while ((buf[++pos] & 1) != 0) {
                }
            }
            return pos;
        }
    }
}

