/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;

public abstract class PropertyLookupParser
implements Serializable {
    private static final int EXPECT_DOLLAR = 0;
    private static final int EXPECT_OPEN_BRACE = 1;
    private static final int EXPECT_CLOSE_BRACE = 2;
    private char markerChar = (char)36;
    private char closingBraceChar = (char)125;
    private char openingBraceChar = (char)123;
    private char escapeChar = (char)92;

    protected PropertyLookupParser() {
    }

    public char getClosingBraceChar() {
        return this.closingBraceChar;
    }

    public void setClosingBraceChar(char c) {
        this.closingBraceChar = c;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c) {
        this.escapeChar = c;
    }

    public char getOpeningBraceChar() {
        return this.openingBraceChar;
    }

    public void setOpeningBraceChar(char c) {
        this.openingBraceChar = c;
    }

    public char getMarkerChar() {
        return this.markerChar;
    }

    public void setMarkerChar(char c) {
        this.markerChar = c;
    }

    public String translateAndLookup(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (bl) {
                bl = false;
                if (n == 2) {
                    stringBuffer2.append(c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (n == 0 && c == this.markerChar) {
                n = 1;
                continue;
            }
            if (n == 1) {
                if (c == this.openingBraceChar) {
                    n = 2;
                    continue;
                }
                stringBuffer.append(this.markerChar);
                n = 0;
            }
            if (n == 2 && c == this.closingBraceChar) {
                String string2 = this.lookupVariable(stringBuffer2.toString());
                if (string2 == null) {
                    stringBuffer.append(this.markerChar);
                    stringBuffer.append(this.openingBraceChar);
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append(this.closingBraceChar);
                } else {
                    stringBuffer.append(string2);
                }
                stringBuffer2.delete(0, stringBuffer2.length());
                n = 0;
                continue;
            }
            if (c == this.escapeChar) {
                bl = true;
                continue;
            }
            if (n == 2) {
                stringBuffer2.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        if (n >= 1) {
            stringBuffer.append(this.markerChar);
            if (n >= 2) {
                stringBuffer.append(this.openingBraceChar);
                stringBuffer.append(stringBuffer2);
            }
        }
        return stringBuffer.toString();
    }

    protected abstract String lookupVariable(String var1);
}

