/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkStyleItemData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_item")
public class NkStyleItem
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DATA;

    public NkStyleItem(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleItem.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum nk_style_item_type")
    public int type() {
        return NkStyleItem.ntype(this.address());
    }

    @NativeType(value="union nk_style_item_data")
    public NkStyleItemData data() {
        return NkStyleItem.ndata(this.address());
    }

    public NkStyleItem type(@NativeType(value="enum nk_style_item_type") int value) {
        NkStyleItem.ntype(this.address(), value);
        return this;
    }

    public NkStyleItem data(@NativeType(value="union nk_style_item_data") NkStyleItemData value) {
        NkStyleItem.ndata(this.address(), value);
        return this;
    }

    public NkStyleItem data(Consumer<NkStyleItemData> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public NkStyleItem set(int type, NkStyleItemData data) {
        this.type(type);
        this.data(data);
        return this;
    }

    public NkStyleItem set(NkStyleItem src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleItem malloc() {
        return (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkStyleItem calloc() {
        return (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkStyleItem create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkStyleItem create(long address) {
        return (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)address);
    }

    @Nullable
    public static NkStyleItem createSafe(long address) {
        return address == 0L ? null : (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkStyleItem.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkStyleItem.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkStyleItem.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleItem.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkStyleItem.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkStyleItem.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkStyleItem.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkStyleItem mallocStack() {
        return NkStyleItem.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleItem callocStack() {
        return NkStyleItem.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleItem mallocStack(MemoryStack stack) {
        return NkStyleItem.malloc(stack);
    }

    @Deprecated
    public static NkStyleItem callocStack(MemoryStack stack) {
        return NkStyleItem.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleItem.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleItem.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleItem.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleItem.calloc(capacity, stack);
    }

    public static NkStyleItem malloc(MemoryStack stack) {
        return (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleItem calloc(MemoryStack stack) {
        return (NkStyleItem)NkStyleItem.wrap(NkStyleItem.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleItem.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleItem.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static NkStyleItemData ndata(long struct) {
        return NkStyleItemData.create(struct + (long)DATA);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ndata(long struct, NkStyleItemData value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DATA), (long)NkStyleItemData.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleItem.__struct((Struct.Member[])new Struct.Member[]{NkStyleItem.__member((int)4), NkStyleItem.__member((int)NkStyleItemData.SIZEOF, (int)NkStyleItemData.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStyleItem, Buffer>
    implements NativeResource {
        private static final NkStyleItem ELEMENT_FACTORY = NkStyleItem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleItem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum nk_style_item_type")
        public int type() {
            return NkStyleItem.ntype(this.address());
        }

        @NativeType(value="union nk_style_item_data")
        public NkStyleItemData data() {
            return NkStyleItem.ndata(this.address());
        }

        public Buffer type(@NativeType(value="enum nk_style_item_type") int value) {
            NkStyleItem.ntype(this.address(), value);
            return this;
        }

        public Buffer data(@NativeType(value="union nk_style_item_data") NkStyleItemData value) {
            NkStyleItem.ndata(this.address(), value);
            return this;
        }

        public Buffer data(Consumer<NkStyleItemData> consumer) {
            consumer.accept(this.data());
            return this;
        }
    }
}

