/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class GranitProtocolDecoder
extends BaseProtocolDecoder {
    private static final int HEADER_LENGTH = 6;

    public GranitProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static void appendChecksum(ByteBuf buffer, int length) {
        buffer.writeByte(42);
        int checksum = Checksum.xor(buffer.nioBuffer(0, length)) & 0xFF;
        String checksumString = String.format("%02X", checksum);
        buffer.writeBytes(checksumString.getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(13);
        buffer.writeByte(10);
    }

    private static void sendResponseCurrent(Channel channel, int deviceId, long time) {
        ByteBuf response = Unpooled.buffer();
        response.writeBytes("BB+UGRC~".getBytes(StandardCharsets.US_ASCII));
        response.writeShortLE(6);
        response.writeInt((int)time);
        response.writeShortLE(deviceId);
        GranitProtocolDecoder.appendChecksum(response, 16);
        channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
    }

    private static void sendResponseArchive(Channel channel, int deviceId, int packNum) {
        ByteBuf response = Unpooled.buffer();
        response.writeBytes("BB+ARCF~".getBytes(StandardCharsets.US_ASCII));
        response.writeShortLE(4);
        response.writeShortLE(packNum);
        response.writeShortLE(deviceId);
        GranitProtocolDecoder.appendChecksum(response, 14);
        channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
    }

    private void decodeStructure(ByteBuf buf, Position position) {
        short flags = buf.readUnsignedByte();
        position.setValid(BitUtil.check(flags, 7));
        if (BitUtil.check(flags, 1)) {
            position.addAlarm("general");
        }
        short satDel = buf.readUnsignedByte();
        position.set("sat", BitUtil.from(satDel, 4));
        int pdop = BitUtil.to(satDel, 4);
        position.set("pdop", pdop);
        short lonDegrees = buf.readUnsignedByte();
        short latDegrees = buf.readUnsignedByte();
        int lonMinutes = buf.readUnsignedShortLE();
        int latMinutes = buf.readUnsignedShortLE();
        double latitude = (double)latDegrees + (double)latMinutes / 60000.0;
        double longitude = (double)lonDegrees + (double)lonMinutes / 60000.0;
        if (position.getValid()) {
            if (!BitUtil.check(flags, 4)) {
                latitude = -latitude;
            }
            if (!BitUtil.check(flags, 5)) {
                longitude = -longitude;
            }
        }
        position.setLongitude(longitude);
        position.setLatitude(latitude);
        position.setSpeed(buf.readUnsignedByte());
        int course = buf.readUnsignedByte();
        if (BitUtil.check(flags, 6)) {
            course |= 0x100;
        }
        position.setCourse(course);
        position.set("distance", buf.readShortLE());
        int analogIn1 = buf.readUnsignedByte();
        int analogIn2 = buf.readUnsignedByte();
        int analogIn3 = buf.readUnsignedByte();
        int analogIn4 = buf.readUnsignedByte();
        short analogInHi = buf.readUnsignedByte();
        analogIn1 = analogInHi << 8 & 0x300 | analogIn1;
        analogIn2 = analogInHi << 6 & 0x300 | analogIn2;
        analogIn3 = analogInHi << 4 & 0x300 | analogIn3;
        analogIn4 = analogInHi << 2 & 0x300 | analogIn4;
        position.set("adc1", analogIn1);
        position.set("adc2", analogIn2);
        position.set("adc3", analogIn3);
        position.set("adc4", analogIn4);
        position.setAltitude(buf.readUnsignedByte() * 10);
        short output = buf.readUnsignedByte();
        for (int i = 0; i < 8; ++i) {
            position.set("io" + (i + 1), BitUtil.check(output, i));
        }
        buf.readUnsignedByte();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int indexTilde = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)126);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession != null && indexTilde == -1) {
            String bufString = buf.toString(StandardCharsets.US_ASCII);
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date());
            this.getLastLocation(position, new Date());
            position.setValid(false);
            position.set("result", bufString);
            return position;
        }
        if (buf.readableBytes() < 6) {
            return null;
        }
        String header = buf.readSlice(6).toString(StandardCharsets.US_ASCII);
        if (header.equals("+RRCB~")) {
            buf.skipBytes(2);
            int deviceId = buf.readUnsignedShortLE();
            deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceId));
            if (deviceSession == null) {
                return null;
            }
            long unixTime = buf.readUnsignedIntLE();
            if (channel != null) {
                GranitProtocolDecoder.sendResponseCurrent(channel, deviceId, unixTime);
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date(unixTime * 1000L));
            this.decodeStructure(buf, position);
            return position;
        }
        if (header.equals("+DDAT~")) {
            buf.skipBytes(2);
            int deviceId = buf.readUnsignedShortLE();
            deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceId));
            if (deviceSession == null) {
                return null;
            }
            byte format = buf.readByte();
            if (format != 4) {
                return null;
            }
            byte nblocks = buf.readByte();
            int packNum = buf.readUnsignedShortLE();
            if (channel != null) {
                GranitProtocolDecoder.sendResponseArchive(channel, deviceId, packNum);
            }
            ArrayList<Position> positions = new ArrayList<Position>();
            while (nblocks > 0) {
                nblocks = (byte)(nblocks - 1);
                long unixTime = buf.readUnsignedIntLE();
                int timeIncrement = buf.getUnsignedShortLE(buf.readerIndex() + 120);
                for (int i = 0; i < 6; ++i) {
                    if (buf.getUnsignedByte(buf.readerIndex()) != 254) {
                        Position position = new Position(this.getProtocolName());
                        position.setDeviceId(deviceSession.getDeviceId());
                        position.setTime(new Date((unixTime + (long)(i * timeIncrement)) * 1000L));
                        this.decodeStructure(buf, position);
                        position.set("archive", true);
                        positions.add(position);
                        continue;
                    }
                    buf.skipBytes(20);
                }
                buf.skipBytes(2);
            }
            return positions;
        }
        return null;
    }
}

