/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RetranslatorProtocolDecoder
extends BaseProtocolDecoder {
    public RetranslatorProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])new byte[]{17}), remoteAddress));
        }
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedInt();
        int idLength = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0) - buf.readerIndex();
        String id = buf.readCharSequence(idLength, StandardCharsets.US_ASCII).toString();
        buf.readByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date(buf.readUnsignedInt() * 1000L));
        buf.readUnsignedInt();
        while (buf.isReadable()) {
            buf.readUnsignedShort();
            int blockEnd = buf.readInt() + buf.readerIndex();
            buf.readUnsignedByte();
            short dataType = buf.readUnsignedByte();
            int nameLength = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0) - buf.readerIndex();
            String name = buf.readCharSequence(nameLength, StandardCharsets.US_ASCII).toString();
            buf.readByte();
            if (name.equals("posinfo")) {
                position.setValid(true);
                position.setLongitude(buf.readDoubleLE());
                position.setLatitude(buf.readDoubleLE());
                position.setAltitude(buf.readDoubleLE());
                position.setSpeed(buf.readShort());
                position.setCourse(buf.readShort());
                position.set("sat", buf.readByte());
            } else {
                switch (dataType) {
                    case 1: {
                        int len = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0) - buf.readerIndex();
                        position.set(name, buf.readCharSequence(len, StandardCharsets.US_ASCII).toString());
                        buf.readByte();
                        break;
                    }
                    case 3: {
                        position.set(name, buf.readInt());
                        break;
                    }
                    case 4: {
                        position.set(name, buf.readDoubleLE());
                        break;
                    }
                    case 5: {
                        position.set(name, buf.readLong());
                    }
                }
            }
            buf.readerIndex(blockEnd);
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        return position;
    }
}

