/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.profile.AbstractProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.sqlobject.SQLColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class ColumnProfileResult
extends AbstractProfileResult<SQLColumn> {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(ColumnValueCount.class);
    private static final Logger logger = Logger.getLogger(ColumnProfileResult.class);
    private int distinctValueCount;
    private Object minValue;
    private Object maxValue;
    private Object avgValue;
    private int minLength;
    private int maxLength;
    private double avgLength;
    private int nullCount;
    private List<ColumnValueCount> topTen = new ArrayList<ColumnValueCount>();

    @Constructor
    public ColumnProfileResult(@ConstructorParameter(propertyName="profiledObject") SQLColumn profiledObject) {
        super(profiledObject);
        this.setName("New Column Profile");
    }

    public ColumnProfileResult(ColumnProfileResult cprToCopy, SQLColumn col) {
        super(cprToCopy, col);
        this.setName("New Column Profile");
        this.avgLength = cprToCopy.avgLength;
        this.avgValue = cprToCopy.avgValue;
        this.distinctValueCount = cprToCopy.distinctValueCount;
        this.maxLength = cprToCopy.maxLength;
        this.minLength = cprToCopy.minLength;
        this.minValue = cprToCopy.minValue;
        this.nullCount = cprToCopy.nullCount;
        this.setParent(cprToCopy.getParent());
        for (int i = 0; i < cprToCopy.getValueCount().size(); ++i) {
            ColumnValueCount cvc = cprToCopy.getValueCount().get(i);
            this.addColumnValueCount(new ColumnValueCount(cvc), i);
        }
    }

    @Accessor
    public double getAvgLength() {
        return this.avgLength;
    }

    @Mutator
    public void setAvgLength(double avgLength) {
        double oldLength = this.avgLength;
        this.avgLength = avgLength;
        this.firePropertyChange("avgLength", oldLength, avgLength);
    }

    @Accessor
    public Object getAvgValue() {
        return this.avgValue;
    }

    @Mutator
    public void setAvgValue(Object avgValue) {
        Object oldVal = this.avgValue;
        this.avgValue = avgValue;
        this.firePropertyChange("avgValue", oldVal, avgValue);
    }

    @Accessor
    public int getDistinctValueCount() {
        return this.distinctValueCount;
    }

    @Mutator
    public void setDistinctValueCount(int distinctValueCount) {
        int oldVal = this.distinctValueCount;
        this.distinctValueCount = distinctValueCount;
        this.firePropertyChange("distinctValueCount", oldVal, distinctValueCount);
    }

    @Accessor
    public int getMaxLength() {
        return this.maxLength;
    }

    @Mutator
    public void setMaxLength(int maxLength) {
        int oldLength = this.maxLength;
        this.maxLength = maxLength;
        this.firePropertyChange("maxLength", oldLength, maxLength);
    }

    @Accessor
    public Object getMaxValue() {
        return this.maxValue;
    }

    @Mutator
    public void setMaxValue(Object maxValue) {
        Object oldVal = this.maxValue;
        this.maxValue = maxValue;
        this.firePropertyChange("maxValue", oldVal, maxValue);
    }

    @Accessor
    public int getMinLength() {
        return this.minLength;
    }

    @Mutator
    public void setMinLength(int minLength) {
        int oldLength = this.minLength;
        this.minLength = minLength;
        this.firePropertyChange("minLength", oldLength, minLength);
    }

    @Accessor
    public Object getMinValue() {
        return this.minValue;
    }

    @Mutator
    public void setMinValue(Object minValue) {
        Object oldVal = this.minValue;
        this.minValue = minValue;
        this.firePropertyChange("minValue", oldVal, this.minValue);
    }

    public String toString() {
        return "[ColumnProfileResult:; distinctValues: " + this.distinctValueCount + "; minLength: " + this.minLength + "; maxLength: " + this.maxLength + "; avgLength: " + this.avgLength + "; minValue: " + this.getMinValue() + "; maxValue: " + this.getMaxValue() + "; avgValue: " + this.avgValue + "; nullCount: " + this.getNullCount() + "]";
    }

    @Accessor
    public int getNullCount() {
        return this.nullCount;
    }

    @Mutator
    public void setNullCount(int nullCount) {
        int oldCount = this.nullCount;
        this.nullCount = nullCount;
        this.firePropertyChange("nullCount", oldCount, nullCount);
    }

    public void addValueCount(Object value, int count) {
        double per = (double)count / (double)this.getParent().getRowCount();
        ColumnValueCount columnValueCount = value == "Other Values" ? new ColumnValueCount(value, count, per, true) : new ColumnValueCount(value, count, per, false);
        if (!this.topTen.contains((Object)columnValueCount)) {
            this.addValueCount(columnValueCount);
            logger.debug((Object)("Added Value Count: Value: " + value + " Count: " + count));
        }
    }

    public void addValueCount(ColumnValueCount value) {
        this.addColumnValueCount(value, this.topTen.size());
    }

    private void addColumnValueCount(ColumnValueCount value, int index) {
        this.topTen.add(value);
        value.setParent(this);
        this.fireChildAdded(ColumnValueCount.class, (SPObject)value, index);
    }

    protected void addChildImpl(SPObject child, int index) {
        if (!(child instanceof ColumnValueCount)) {
            throw new IllegalArgumentException("Cannot add child " + child + " to " + this);
        }
        this.addColumnValueCount((ColumnValueCount)child, index);
    }

    @NonProperty
    public List<ColumnValueCount> getValueCount() {
        return this.topTen;
    }

    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof ColumnValueCount) {
            int index = this.topTen.indexOf(child);
            if (this.topTen.remove(child)) {
                this.fireChildRemoved(ColumnValueCount.class, child, index);
                return true;
            }
        }
        return false;
    }

    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public List<? extends SPObject> getChildren() {
        ArrayList<ColumnValueCount> children = new ArrayList<ColumnValueCount>();
        children.addAll(this.topTen);
        return children;
    }

    @Accessor
    public TableProfileResult getParent() {
        return (TableProfileResult)super.getParent();
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (parent != null && !(parent instanceof TableProfileResult)) {
            throw new IllegalArgumentException("Parent of " + this + " must be of type " + TableProfileResult.class);
        }
        super.setParent(parent);
    }
}

