/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import jogamp.graph.curve.opengl.shader.AttributeNames;

public final class RegionRenderer {
    protected static final boolean DEBUG = Region.DEBUG;
    protected static final boolean DEBUG_ALL_EVENT = Region.DEBUG_ALL_EVENT;
    protected static final boolean DEBUG_INSTANCE = Region.DEBUG_INSTANCE;
    private static final boolean DEBUG_SHADER_MAP = DEBUG;
    public static final GLCallback defaultBlendEnable = new GLCallback(){

        @Override
        public void run(GL gL, RegionRenderer regionRenderer) {
            if (regionRenderer.hintBitsSet(2)) {
                gL.glDepthMask(false);
            }
            gL.glEnable(3042);
            gL.glBlendEquation(32774);
            regionRenderer.setHintBits(1);
        }
    };
    public static final GLCallback defaultBlendDisable = new GLCallback(){

        @Override
        public void run(GL gL, RegionRenderer regionRenderer) {
            regionRenderer.clearHintBits(1);
            gL.glDisable(3042);
            if (regionRenderer.hintBitsSet(2)) {
                gL.glDepthMask(true);
            }
        }
    };
    private final RenderState rs;
    private final GLCallback enableCallback;
    private final GLCallback disableCallback;
    private final Recti viewport = new Recti();
    private boolean initialized;
    private boolean vboSupported = false;
    private static final String SHADER_SRC_SUB = "";
    private static final String SHADER_BIN_SUB = "bin";
    private static final String GLSL_PARAM_COMMENT_START = "\n// JogAmp Graph Parameter Start\n";
    private static final String GLSL_PARAM_COMMENT_END = "// JogAmp Graph Parameter End\n\n";
    private static final String GLSL_USE_COLOR_CHANNEL = "#define USE_COLOR_CHANNEL 1\n";
    private static final String GLSL_USE_COLOR_TEXTURE = "#define USE_COLOR_TEXTURE 1\n";
    private static final String GLSL_USE_FRUSTUM_CLIPPING = "#define USE_FRUSTUM_CLIPPING 1\n";
    private static final String GLSL_DEF_SAMPLE_COUNT = "#define SAMPLE_COUNT ";
    private static final String GLSL_CONST_SAMPLE_COUNT = "const float sample_count = ";
    private static final String GLSL_MAIN_BEGIN = "void main (void)\n{\n";
    private static final String gcuTexture2D = "gcuTexture2D";
    private static final String GLSL_USE_DISCARD = "#define USE_DISCARD 1\n";
    private static final String es2_precision_fp = "\nprecision mediump float;\nprecision mediump int;\nprecision mediump sampler2D;\n";
    private static final boolean UseShaderPrograms0 = true;
    private final LongObjectHashMap shaderPrograms0;
    private final HashMap<ShaderKey, ShaderProgram> shaderPrograms1;

    public static RegionRenderer create() {
        return new RegionRenderer(null, null, null);
    }

    public static RegionRenderer create(GLCallback gLCallback, GLCallback gLCallback2) {
        return new RegionRenderer(gLCallback, gLCallback2);
    }

    public static RegionRenderer create(PMVMatrix4f pMVMatrix4f, GLCallback gLCallback, GLCallback gLCallback2) {
        return new RegionRenderer(pMVMatrix4f, gLCallback, gLCallback2);
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final Recti getViewport(Recti recti) {
        recti.set(this.viewport);
        return recti;
    }

    public final Recti getViewport() {
        return this.viewport;
    }

    public final int getWidth() {
        return this.viewport.width();
    }

    public final int getHeight() {
        return this.viewport.height();
    }

    protected RegionRenderer(GLCallback gLCallback, GLCallback gLCallback2) {
        this(null, gLCallback, gLCallback2);
    }

    protected RegionRenderer(PMVMatrix4f pMVMatrix4f, GLCallback gLCallback, GLCallback gLCallback2) {
        this.rs = new RenderState(pMVMatrix4f);
        this.enableCallback = gLCallback;
        this.disableCallback = gLCallback2;
        this.shaderPrograms0 = new LongObjectHashMap();
        this.shaderPrograms1 = null;
    }

    public final boolean isVBOSupported() {
        return this.vboSupported;
    }

    public final void init(GL2ES2 gL2ES2) throws GLException {
        if (this.initialized) {
            return;
        }
        boolean bl = this.vboSupported = gL2ES2.isFunctionAvailable("glGenBuffers") && gL2ES2.isFunctionAvailable("glBindBuffer") && gL2ES2.isFunctionAvailable("glBufferData") && gL2ES2.isFunctionAvailable("glDrawElements") && gL2ES2.isFunctionAvailable("glVertexAttribPointer") && gL2ES2.isFunctionAvailable("glDeleteBuffers");
        if (DEBUG) {
            System.err.println("TextRendererImpl01: VBO Supported = " + this.isVBOSupported());
        }
        if (!this.vboSupported) {
            throw new GLException("VBO not supported");
        }
        this.rs.attachTo(gL2ES2);
        this.initialized = true;
        this.enable(gL2ES2, false);
    }

    public final void destroy(GL2ES2 gL2ES2) {
        if (!this.initialized) {
            if (DEBUG_INSTANCE) {
                System.err.println("TextRenderer: Not initialized!");
            }
            return;
        }
        Iterator iterator = this.shaderPrograms0.iterator();
        while (iterator.hasNext()) {
            ShaderProgram shaderProgram = (ShaderProgram)((LongObjectHashMap.Entry)iterator.next()).getValue();
            shaderProgram.destroy(gL2ES2);
        }
        this.shaderPrograms0.clear();
        this.rs.detachFrom(gL2ES2);
        this.rs.destroy();
        this.initialized = false;
    }

    public final RenderState getRenderState() {
        return this.rs;
    }

    public final PMVMatrix4f getMatrix() {
        return this.rs.getMatrix();
    }

    public final float getWeight() {
        return this.rs.getWeight();
    }

    public final void setWeight(float f) {
        this.rs.setWeight(f);
    }

    public final Vec4f getColorStatic(Vec4f vec4f) {
        return this.rs.getColorStatic(vec4f);
    }

    public final void setColorStatic(Vec4f vec4f) {
        this.rs.setColorStatic(vec4f);
    }

    public final void setColorStatic(float f, float f2, float f3, float f4) {
        this.rs.setColorStatic(f, f2, f3, f4);
    }

    public final int setAAQuality(int n) {
        return this.rs.setAAQuality(n);
    }

    public final int getAAQuality() {
        return this.rs.getAAQuality();
    }

    public final int setSampleCount(int n) {
        return this.rs.setSampleCount(n);
    }

    public final int getSampleCount() {
        return this.rs.getSampleCount();
    }

    public final void setClipFrustum(Frustum frustum) {
        this.rs.setClipFrustum(frustum);
    }

    public final Frustum getClipFrustum() {
        return this.rs.getClipFrustum();
    }

    public final boolean hintBitsSet(int n) {
        return this.rs.hintBitsSet(n);
    }

    public final void setHintBits(int n) {
        this.rs.setHintBits(n);
    }

    public final void clearHintBits(int n) {
        this.rs.clearHintBits(n);
    }

    public final void enable(GL2ES2 gL2ES2, boolean bl) {
        this.enable(gL2ES2, bl, this.enableCallback, this.disableCallback);
    }

    public final void enable(GL2ES2 gL2ES2, boolean bl, GLCallback gLCallback, GLCallback gLCallback2) {
        if (bl) {
            if (null != gLCallback) {
                gLCallback.run(gL2ES2, this);
            }
        } else {
            ShaderProgram shaderProgram;
            if (null != gLCallback2) {
                gLCallback2.run(gL2ES2, this);
            }
            if (null != (shaderProgram = this.rs.getShaderProgram())) {
                shaderProgram.useProgram(gL2ES2, false);
            }
        }
    }

    public final void reshapeNotify(int n, int n2, int n3, int n4) {
        this.viewport.set(n, n2, n3, n4);
    }

    public final void reshapePerspective(float f, int n, int n2, float f2, float f3) {
        this.reshapeNotify(0, 0, n, n2);
        float f4 = (float)n / (float)n2;
        PMVMatrix4f pMVMatrix4f = this.getMatrix();
        pMVMatrix4f.loadPIdentity();
        pMVMatrix4f.perspectiveP(f, f4, f2, f3);
    }

    public final void reshapeOrtho(int n, int n2, float f, float f2) {
        this.reshapeNotify(0, 0, n, n2);
        PMVMatrix4f pMVMatrix4f = this.getMatrix();
        pMVMatrix4f.loadPIdentity();
        pMVMatrix4f.orthoP(0.0f, n, 0.0f, n2, f, f2);
    }

    private String getVersionedShaderName() {
        return "curverenderer01";
    }

    private final String getFragmentShaderPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGLES()) {
            return es2_precision_fp;
        }
        if (ShaderCode.requiresGL3DefaultPrecision(gL2ES2)) {
            return "\nprecision highp float;\nprecision mediump int;\n/*precision mediump sampler2D;*/\n";
        }
        return null;
    }

    private static String shaderHashToString(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ShaderModeSelector1 shaderModeSelector1) {
        return "ShaderHash[hash 0x" + Integer.toHexString(n) + ", is2Pass " + bl + ", pass1 " + bl2 + ", has[clip " + bl3 + ", colChan " + bl4 + ", colTex " + bl5 + "], " + (Object)((Object)shaderModeSelector1) + "]";
    }

    private static String shaderKeyToString(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ShaderModeSelector1 shaderModeSelector1) {
        return "ShaderKey[key 0x" + Long.toHexString(l) + ", is2Pass " + bl + ", pass1 " + bl2 + ", has[clip " + bl3 + ", colChan " + bl4 + ", colTex " + bl5 + "], " + (Object)((Object)shaderModeSelector1) + "]";
    }

    private static long getShaderKey0(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ShaderModeSelector1 shaderModeSelector1, long l) {
        long l2 = bl ? 1L : 0L;
        l2 |= (bl2 ? 1L : 0L) << 1;
        l2 |= (long)(shaderModeSelector1.ordinal() & 0x1F) << 2;
        l2 |= (bl3 ? 1L : 0L) << 7;
        l2 |= (bl4 ? 1L : 0L) << 8;
        l2 |= (bl5 ? 1L : 0L) << 9;
        return l2 |= (l & 0xFFFFFFL) << 32;
    }

    private static int getShaderKey1(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ShaderModeSelector1 shaderModeSelector1, int n) {
        int n2 = 31 * (bl ? 1 : 0);
        n2 = (n2 << 5) - n2 + (bl2 ? 1 : 0);
        n2 = (n2 << 5) - n2 + shaderModeSelector1.ordinal();
        n2 = (n2 << 5) - n2 + (bl3 ? 1 : 0);
        n2 = (n2 << 5) - n2 + (bl4 ? 1 : 0);
        n2 = (n2 << 5) - n2 + (bl5 ? 1 : 0);
        n2 = (n2 << 5) - n2 + n;
        return n2;
    }

    public final boolean useShaderProgram(GL2ES2 gL2ES2, int n, boolean bl, TextureSequence textureSequence) {
        int n2;
        String string;
        boolean bl2;
        boolean bl3 = Region.isTwoPass(n);
        ShaderModeSelector1 shaderModeSelector1 = bl ? ShaderModeSelector1.selectPass1(n) : ShaderModeSelector1.selectPass2(n, this.getAAQuality(), this.getSampleCount());
        boolean bl4 = null != this.getClipFrustum() && (!bl3 && bl || bl3 && !bl);
        boolean bl5 = bl && Region.hasColorChannel(n);
        boolean bl6 = bl2 = bl && Region.hasColorTexture(n) && null != textureSequence;
        if (bl2) {
            string = textureSequence.setTextureLookupFunctionName(gcuTexture2D);
            n2 = textureSequence.getTextureFragmentShaderHashCode();
        } else {
            string = SHADER_SRC_SUB;
            n2 = 0;
        }
        return this.useShaderProgram0(gL2ES2, n, bl3, bl, shaderModeSelector1, bl4, bl5, bl2, textureSequence, string, n2);
    }

    private final boolean useShaderProgram0(GL2ES2 gL2ES2, int n, boolean bl, boolean bl2, ShaderModeSelector1 shaderModeSelector1, boolean bl3, boolean bl4, boolean bl5, TextureSequence textureSequence, String string, int n2) {
        ShaderProgram shaderProgram;
        long l = RegionRenderer.getShaderKey0(bl, bl2, bl3, bl4, bl5, shaderModeSelector1, n2);
        ShaderProgram shaderProgram2 = (ShaderProgram)this.shaderPrograms0.get(l);
        if (null != shaderProgram2) {
            boolean bl6 = this.rs.setShaderProgram(gL2ES2, shaderProgram2);
            if (DEBUG_SHADER_MAP) {
                if (bl6) {
                    System.err.printf("RegionRenderer.useShaderProgram0.X1: GOT renderModes %s, %s -> sp %d / %d (changed)%n", Region.getRenderModeString(n), RegionRenderer.shaderKeyToString(l, bl, bl2, bl3, bl4, bl5, shaderModeSelector1), shaderProgram2.program(), shaderProgram2.id());
                } else if (DEBUG_ALL_EVENT) {
                    System.err.printf("RegionRenderer.useShaderProgram0.X1: GOT renderModes %s, %s -> sp %d / %d (keep)%n", Region.getRenderModeString(n), RegionRenderer.shaderKeyToString(l, bl, bl2, bl3, bl4, bl5, shaderModeSelector1), shaderProgram2.program(), shaderProgram2.id());
                }
            }
            return bl6;
        }
        shaderProgram2 = this.createShaderProgram(gL2ES2, n, bl, bl2, shaderModeSelector1, bl3, bl4, bl5, textureSequence, string, n2);
        this.rs.setShaderProgram(gL2ES2, shaderProgram2);
        if (DEBUG_SHADER_MAP) {
            System.err.printf("RegionRenderer.useShaderProgram0.X2: NEW renderModes %s, %s -> sp %d / %d (new)%n", Region.getRenderModeString(n), RegionRenderer.shaderKeyToString(l, bl, bl2, bl3, bl4, bl5, shaderModeSelector1), shaderProgram2.program(), shaderProgram2.id());
        }
        if (null != (shaderProgram = (ShaderProgram)this.shaderPrograms0.put(l, (Object)shaderProgram2))) {
            String string2 = String.format((Locale)null, "RegionRenderer.useShaderProgram0: WARNING Shader-HashCode Collision: hash 0x%s: %s, %s -> sp %d / %d (new)%n", Long.toHexString(l), Region.getRenderModeString(n), RegionRenderer.shaderKeyToString(l, bl, bl2, bl3, bl4, bl5, shaderModeSelector1), shaderProgram2.program(), shaderProgram2.id());
            throw new RuntimeException(string2);
        }
        return true;
    }

    private final boolean useShaderProgram1(GL2ES2 gL2ES2, int n, boolean bl, boolean bl2, ShaderModeSelector1 shaderModeSelector1, boolean bl3, boolean bl4, boolean bl5, TextureSequence textureSequence, String string, int n2) {
        ShaderKey shaderKey = new ShaderKey(bl, bl2, shaderModeSelector1, bl3, bl4, bl5, textureSequence, n2);
        ShaderProgram shaderProgram = this.shaderPrograms1.get(shaderKey);
        if (null != shaderProgram) {
            boolean bl6 = this.rs.setShaderProgram(gL2ES2, shaderProgram);
            if (DEBUG_SHADER_MAP) {
                if (bl6) {
                    System.err.printf("RegionRenderer.useShaderProgram1.X1: GOT renderModes %s, %s -> sp %d / %d (changed)%n", Region.getRenderModeString(n), shaderKey, shaderProgram.program(), shaderProgram.id());
                } else if (DEBUG_ALL_EVENT) {
                    System.err.printf("RegionRenderer.useShaderProgram1.X1: GOT renderModes %s, %s -> sp %d / %d (keep)%n", Region.getRenderModeString(n), shaderKey, shaderProgram.program(), shaderProgram.id());
                }
            }
            return bl6;
        }
        shaderProgram = this.createShaderProgram(gL2ES2, n, bl, bl2, shaderModeSelector1, bl3, bl4, bl5, textureSequence, string, n2);
        this.rs.setShaderProgram(gL2ES2, shaderProgram);
        if (DEBUG_SHADER_MAP) {
            System.err.printf("RegionRenderer.useShaderProgram1.X2: NEW renderModes %s, %s -> sp %d / %d (new)%n", Region.getRenderModeString(n), shaderKey, shaderProgram.program(), shaderProgram.id());
        }
        this.shaderPrograms1.put(shaderKey, shaderProgram);
        return true;
    }

    private final ShaderProgram createShaderProgram(GL2ES2 gL2ES2, int n, boolean bl, boolean bl2, ShaderModeSelector1 shaderModeSelector1, boolean bl3, boolean bl4, boolean bl5, TextureSequence textureSequence, String string, int n2) {
        int n3;
        String string2 = this.getVersionedShaderName();
        String string3 = bl ? string2 + "-pass" + (bl2 ? 1 : 2) : string2 + "-single";
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, AttributeNames.class, SHADER_SRC_SUB, SHADER_BIN_SUB, string3, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, AttributeNames.class, SHADER_SRC_SUB, SHADER_BIN_SUB, string2 + "-segment-head", true);
        if (bl5 && 36197 == textureSequence.getTextureTarget() && !gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
            throw new GLException("GL_OES_EGL_image_external requested but not available");
        }
        boolean bl6 = true;
        if (bl5 && 36197 == textureSequence.getTextureTarget() && Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
            bl6 = false;
        }
        int n4 = shaderCode.defaultShaderCustomization(gL2ES2, bl6, true);
        int n5 = n3 = bl6 ? shaderCode2.addGLSLVersion(gL2ES2) : 0;
        if (bl5) {
            n3 = shaderCode2.insertShaderSource(0, n3, textureSequence.getRequiredExtensionsShaderStub());
        }
        if (bl2 && !bl6 || gL2ES2.isGLES2() && !gL2ES2.isGLES3()) {
            n3 = shaderCode2.insertShaderSource(0, n3, ShaderCode.createExtensionDirective("GL_OES_standard_derivatives", "enable"));
        }
        n3 = shaderCode2.addDefaultShaderPrecision(gL2ES2, n3);
        n3 = -1;
        n4 = shaderCode.insertShaderSource(0, n4, GLSL_PARAM_COMMENT_START);
        n3 = shaderCode2.insertShaderSource(0, n3, GLSL_PARAM_COMMENT_START);
        if (!gL2ES2.getContext().hasRendererQuirk(5)) {
            n3 = shaderCode2.insertShaderSource(0, n3, GLSL_USE_DISCARD);
        }
        if (bl3) {
            n4 = shaderCode.insertShaderSource(0, n4, GLSL_USE_FRUSTUM_CLIPPING);
            n3 = shaderCode2.insertShaderSource(0, n3, GLSL_USE_FRUSTUM_CLIPPING);
        }
        if (bl4) {
            n4 = shaderCode.insertShaderSource(0, n4, GLSL_USE_COLOR_CHANNEL);
            n3 = shaderCode2.insertShaderSource(0, n3, GLSL_USE_COLOR_CHANNEL);
        }
        if (bl5) {
            shaderCode.insertShaderSource(0, n4, GLSL_USE_COLOR_TEXTURE);
            n3 = shaderCode2.insertShaderSource(0, n3, GLSL_USE_COLOR_TEXTURE);
        }
        if (!bl2) {
            n3 = shaderCode2.insertShaderSource(0, n3, GLSL_DEF_SAMPLE_COUNT + shaderModeSelector1.sampleCount + "\n");
            n3 = shaderCode2.insertShaderSource(0, n3, GLSL_CONST_SAMPLE_COUNT + shaderModeSelector1.sampleCount + ".0;\n");
        }
        n4 = shaderCode.insertShaderSource(0, n4, GLSL_PARAM_COMMENT_END);
        n3 = shaderCode2.insertShaderSource(0, n3, GLSL_PARAM_COMMENT_END);
        try {
            n3 = shaderCode2.insertShaderSource(0, n3, AttributeNames.class, "uniforms.glsl");
            n3 = shaderCode2.insertShaderSource(0, n3, AttributeNames.class, "varyings.glsl");
            if (bl5 || bl3) {
                n3 = shaderCode2.insertShaderSource(0, n3, AttributeNames.class, "functions.glsl");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read: includes", iOException);
        }
        if (0 > n3) {
            throw new RuntimeException("Failed to read: includes");
        }
        if (bl5) {
            n3 = shaderCode2.insertShaderSource(0, n3, "uniform " + textureSequence.getTextureSampler2DType() + " " + "gcu_ColorTexUnit" + ";\n");
            n3 = shaderCode2.insertShaderSource(0, n3, textureSequence.getTextureLookupFragmentShaderImpl());
        }
        n3 = shaderCode2.insertShaderSource(0, n3, GLSL_MAIN_BEGIN);
        String string4 = bl2 ? "-pass1-" : "-pass2-";
        String string5 = string2 + string4 + shaderModeSelector1.tech + shaderModeSelector1.sub + ".glsl";
        if (DEBUG) {
            System.err.printf("RegionRenderer.createShaderProgram.1: segment %s%n", string5);
        }
        try {
            n3 = shaderCode2.insertShaderSource(0, n3, AttributeNames.class, string5);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read: " + string5, iOException);
        }
        if (0 > n3) {
            throw new RuntimeException("Failed to read: " + string5);
        }
        n3 = shaderCode2.insertShaderSource(0, n3, "}\n");
        if (bl5) {
            shaderCode2.replaceInShaderSource(gcuTexture2D, string);
        }
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.init(gL2ES2)) {
            throw new GLException("RegionRenderer: Couldn't init program: " + shaderProgram);
        }
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("could not link program: " + shaderProgram);
        }
        return shaderProgram;
    }

    private static enum ShaderModeSelector1 {
        PASS1_SIMPLE("curve", "_simple", 0),
        PASS1_WEIGHT("curve", "_weight", 0),
        PASS2_MSAA("msaa", "", 0),
        PASS2_VBAA_QUAL0_SAMPLES1("vbaa", "_flipquad3", 1),
        PASS2_VBAA_QUAL0_SAMPLES2("vbaa", "_flipquad3", 2),
        PASS2_VBAA_QUAL0_SAMPLES4("vbaa", "_flipquad3", 4),
        PASS2_VBAA_QUAL0_SAMPLES8("vbaa", "_flipquad3", 8),
        PASS2_VBAA_QUAL1_SAMPLES1("vbaa", "_bforce_odd", 1),
        PASS2_VBAA_QUAL1_SAMPLES2("vbaa", "_bforce_even", 2),
        PASS2_VBAA_QUAL1_SAMPLES3("vbaa", "_bforce_odd", 3),
        PASS2_VBAA_QUAL1_SAMPLES4("vbaa", "_bforce_even", 4),
        PASS2_VBAA_QUAL1_SAMPLES5("vbaa", "_bforce_odd", 5),
        PASS2_VBAA_QUAL1_SAMPLES6("vbaa", "_bforce_even", 6),
        PASS2_VBAA_QUAL1_SAMPLES7("vbaa", "_bforce_odd", 7),
        PASS2_VBAA_QUAL1_SAMPLES8("vbaa", "_bforce_even", 8);

        public final String tech;
        public final String sub;
        public final int sampleCount;

        private ShaderModeSelector1(String string2, String string3, int n2) {
            this.tech = string2;
            this.sub = string3;
            this.sampleCount = n2;
        }

        public static ShaderModeSelector1 selectPass1(int n) {
            return Region.hasVariableWeight(n) ? PASS1_WEIGHT : PASS1_SIMPLE;
        }

        public static ShaderModeSelector1 selectPass2(int n, int n2, int n3) {
            if (Region.isVBAA(n)) {
                if (0 == n2) {
                    if (n3 < 2) {
                        return PASS2_VBAA_QUAL0_SAMPLES1;
                    }
                    if (n3 < 4) {
                        return PASS2_VBAA_QUAL0_SAMPLES2;
                    }
                    if (n3 < 8) {
                        return PASS2_VBAA_QUAL0_SAMPLES4;
                    }
                    return PASS2_VBAA_QUAL0_SAMPLES8;
                }
                switch (n3) {
                    case 0: 
                    case 1: {
                        return PASS2_VBAA_QUAL1_SAMPLES1;
                    }
                    case 2: {
                        return PASS2_VBAA_QUAL1_SAMPLES2;
                    }
                    case 3: {
                        return PASS2_VBAA_QUAL1_SAMPLES3;
                    }
                    case 4: {
                        return PASS2_VBAA_QUAL1_SAMPLES4;
                    }
                    case 5: {
                        return PASS2_VBAA_QUAL1_SAMPLES5;
                    }
                    case 6: {
                        return PASS2_VBAA_QUAL1_SAMPLES6;
                    }
                    case 7: {
                        return PASS2_VBAA_QUAL1_SAMPLES7;
                    }
                }
                return PASS2_VBAA_QUAL1_SAMPLES8;
            }
            return PASS2_MSAA;
        }
    }

    public static interface GLCallback {
        public void run(GL var1, RegionRenderer var2);
    }

    private static class ShaderKey {
        final boolean isTwoPass;
        final boolean pass1;
        final ShaderModeSelector1 sms;
        final boolean hasFrustumClipping;
        final boolean hasColorChannel;
        final boolean hasColorTexture;
        final String colorTexSeqID;
        final int hashValue;

        ShaderKey(boolean bl, boolean bl2, ShaderModeSelector1 shaderModeSelector1, boolean bl3, boolean bl4, boolean bl5, TextureSequence textureSequence, int n) {
            this.isTwoPass = bl;
            this.pass1 = bl2;
            this.sms = shaderModeSelector1;
            this.hasFrustumClipping = bl3;
            this.hasColorChannel = bl4;
            this.hasColorTexture = bl5;
            this.colorTexSeqID = bl5 ? textureSequence.getTextureFragmentShaderHashID() : RegionRenderer.SHADER_SRC_SUB;
            this.hashValue = RegionRenderer.getShaderKey1(bl, bl2, bl3, bl4, bl5, shaderModeSelector1, n);
        }

        public final int hashCode() {
            return this.hashValue;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ShaderKey)) {
                return false;
            }
            ShaderKey shaderKey = (ShaderKey)object;
            return this.isTwoPass == shaderKey.isTwoPass && this.pass1 == shaderKey.pass1 && this.sms.ordinal() == shaderKey.sms.ordinal() && this.hasFrustumClipping == shaderKey.hasFrustumClipping && this.hasColorChannel == shaderKey.hasColorChannel && this.hasColorTexture == shaderKey.hasColorTexture && this.colorTexSeqID.equals(shaderKey.colorTexSeqID);
        }

        public String toString() {
            return RegionRenderer.shaderHashToString(this.hashValue, this.isTwoPass, this.pass1, this.hasFrustumClipping, this.hasColorChannel, this.hasColorTexture, this.sms);
        }
    }
}

