/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ReplaceOnceStream;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PrimaveraPMFileReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private static final int NAMESPACE_SCOPE = 512;
    private static final String NAMESPACE_REGEX = "xmlns=\\\".*BusinessObjects\\\"";
    private static final String NAMESPACE_REPLACEMENT = "xmlns=\"http://xmlns.oracle.com/Primavera/P6/V17.7/API/BusinessObjects\"";
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            ReplaceOnceStream replaceOnceStream = new ReplaceOnceStream(inputStream, NAMESPACE_REGEX, NAMESPACE_REPLACEMENT, 512, CharsetHelper.UTF8);
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoCalendarUniqueID(false);
            projectConfig.setAutoAssignmentUniqueID(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Primavera");
            this.m_projectFile.getProjectProperties().setFileType("PMXML");
            CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
            customFieldContainer.getCustomField(TaskField.TEXT1).setAlias("WBS Code");
            customFieldContainer.getCustomField(TaskField.TEXT2).setAlias("Task ID");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(replaceOnceStream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            APIBusinessObjects aPIBusinessObjects = (APIBusinessObjects)unmarshaller.unmarshal(sAXSource);
            List<ProjectType> list = aPIBusinessObjects.getProject();
            ProjectType projectType = null;
            for (ProjectType projectType2 : list) {
                if (BooleanHelper.getBoolean(projectType2.isExternal())) continue;
                projectType = projectType2;
                break;
            }
            if (projectType == null) {
                throw new MPXJException("Unable to locate any non-external projects in a list of " + list.size() + " projects");
            }
            this.processProjectUDFs(aPIBusinessObjects);
            this.processProjectProperties(aPIBusinessObjects, projectType);
            this.processCalendars(aPIBusinessObjects);
            this.processResources(aPIBusinessObjects);
            this.processTasks(projectType);
            this.processPredecessors(projectType);
            this.processAssignments(projectType);
            projectConfig.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MPXJException("Failed to parse file", parserConfigurationException);
        }
        catch (JAXBException jAXBException) {
            throw new MPXJException("Failed to parse file", jAXBException);
        }
        catch (SAXException sAXException) {
            throw new MPXJException("Failed to parse file", sAXException);
        }
        finally {
            this.m_projectFile = null;
            this.m_clashMap.clear();
            this.m_calMap.clear();
        }
    }

    private void processProjectUDFs(APIBusinessObjects aPIBusinessObjects) {
        CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
        for (UDFTypeType uDFTypeType : aPIBusinessObjects.getUDFType()) {
            CustomFieldValueItem customFieldValueItem = new CustomFieldValueItem(uDFTypeType.getObjectId());
            customFieldValueItem.setValue(uDFTypeType.getTitle());
            customFieldContainer.registerValue(customFieldValueItem);
        }
    }

    private void processProjectProperties(APIBusinessObjects aPIBusinessObjects, ProjectType projectType) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setCreationDate(projectType.getCreateDate());
        projectProperties.setFinishDate(projectType.getFinishDate());
        projectProperties.setName(projectType.getName());
        projectProperties.setStartDate(projectType.getPlannedStartDate());
        projectProperties.setStatusDate(projectType.getDataDate());
        projectProperties.setProjectTitle(projectType.getId());
        List<GlobalPreferencesType> list = aPIBusinessObjects.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType globalPreferencesType = list.get(0);
            projectProperties.setCreationDate(globalPreferencesType.getCreateDate());
            projectProperties.setLastSaved(globalPreferencesType.getLastUpdateDate());
            projectProperties.setMinutesPerDay((int)(NumberHelper.getDouble(globalPreferencesType.getHoursPerDay()) * 60.0));
            projectProperties.setMinutesPerWeek((int)(NumberHelper.getDouble(globalPreferencesType.getHoursPerWeek()) * 60.0));
            projectProperties.setWeekStartDay(Day.getInstance(NumberHelper.getInt(globalPreferencesType.getStartDayOfWeek())));
            List<CurrencyType> list2 = aPIBusinessObjects.getCurrency();
            for (CurrencyType currencyType : list2) {
                if (!currencyType.getObjectId().equals(globalPreferencesType.getBaseCurrencyObjectId())) continue;
                projectProperties.setCurrencySymbol(currencyType.getSymbol());
                break;
            }
        }
    }

    private void processCalendars(APIBusinessObjects aPIBusinessObjects) {
        for (CalendarType calendarType : aPIBusinessObjects.getCalendar()) {
            Object object;
            List<WorkTimeType> list;
            Object object2;
            ProjectCalendar projectCalendar = this.m_projectFile.addCalendar();
            Integer n = calendarType.getObjectId();
            this.m_calMap.put(n, projectCalendar);
            projectCalendar.setName(calendarType.getName());
            projectCalendar.setUniqueID(n);
            CalendarType.StandardWorkWeek standardWorkWeek = calendarType.getStandardWorkWeek();
            if (standardWorkWeek != null) {
                object2 = standardWorkWeek.getStandardWorkHours().iterator();
                while (object2.hasNext()) {
                    CalendarType.StandardWorkWeek.StandardWorkHours standardWorkHours = (CalendarType.StandardWorkWeek.StandardWorkHours)object2.next();
                    Day day = DAY_MAP.get(standardWorkHours.getDayOfWeek());
                    list = standardWorkHours.getWorkTime();
                    if (list.isEmpty() || list.get(0) == null) {
                        projectCalendar.setWorkingDay(day, false);
                        continue;
                    }
                    projectCalendar.setWorkingDay(day, true);
                    object = projectCalendar.addCalendarHours(day);
                    for (WorkTimeType workTimeType : list) {
                        if (workTimeType == null) continue;
                        ((ProjectCalendarDateRanges)object).addRange(new DateRange(workTimeType.getStart(), this.getEndTime(workTimeType.getFinish())));
                    }
                }
            }
            if ((object2 = calendarType.getHolidayOrExceptions()) == null) continue;
            for (CalendarType.HolidayOrExceptions.HolidayOrException holidayOrException : ((CalendarType.HolidayOrExceptions)object2).getHolidayOrException()) {
                list = DateHelper.getDayStartDate(holidayOrException.getDate());
                object = DateHelper.getDayEndDate(holidayOrException.getDate());
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException((Date)((Object)list), (Date)object);
                List<WorkTimeType> list2 = holidayOrException.getWorkTime();
                for (WorkTimeType workTimeType : list2) {
                    if (workTimeType == null) continue;
                    projectCalendarException.addRange(new DateRange(workTimeType.getStart(), this.getEndTime(workTimeType.getFinish())));
                }
            }
        }
    }

    private void processResources(APIBusinessObjects aPIBusinessObjects) {
        List<net.sf.mpxj.primavera.schema.ResourceType> list = aPIBusinessObjects.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType resourceType : list) {
            ProjectCalendar projectCalendar;
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(resourceType.getObjectId());
            resource.setName(resourceType.getName());
            resource.setCode(resourceType.getEmployeeId());
            resource.setEmailAddress(resourceType.getEmailAddress());
            resource.setGUID(DatatypeConverter.parseUUID(resourceType.getGUID()));
            resource.setNotes(resourceType.getResourceNotes());
            resource.setCreationDate(resourceType.getCreateDate());
            resource.setType(RESOURCE_TYPE_MAP.get(resourceType.getResourceType()));
            resource.setMaxUnits(this.reversePercentage(resourceType.getMaxUnitsPerTime()));
            resource.setParentID(resourceType.getParentObjectId());
            Integer n = resourceType.getCalendarObjectId();
            if (n != null && (projectCalendar = this.m_calMap.get(n)) != null) {
                if (!projectCalendar.isDerived()) {
                    var8_8 = this.m_projectFile.addCalendar();
                    var8_8.setParent(projectCalendar);
                    var8_8.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    var8_8.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    var8_8.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    var8_8.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    var8_8.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    var8_8.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    var8_8.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(var8_8);
                } else if (projectCalendar.getResource() == null) {
                    resource.setResourceCalendar(projectCalendar);
                } else {
                    var8_8 = this.m_projectFile.addCalendar();
                    var8_8.copy(projectCalendar);
                    resource.setResourceCalendar(var8_8);
                }
            }
            this.readUDFTypes(resource, resourceType.getUDF());
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks(ProjectType projectType) {
        Comparable<Integer> comparable;
        List<WBSType> list = projectType.getWBS();
        List<ActivityType> list2 = projectType.getActivity();
        HashSet<Comparable<Integer>> hashSet = new HashSet<Comparable<Integer>>();
        for (WBSType object2 : list) {
            Task task = this.m_projectFile.addTask();
            comparable = object2.getObjectId();
            hashSet.add(comparable);
            task.setUniqueID((Integer)comparable);
            task.setName(object2.getName());
            task.setBaselineCost(object2.getSummaryBaselineTotalCost());
            task.setGUID(DatatypeConverter.parseUUID(object2.getGUID()));
            task.setRemainingCost(object2.getSummaryRemainingTotalCost());
            task.setRemainingDuration(this.getDuration(object2.getSummaryRemainingDuration()));
            task.setStart(object2.getAnticipatedStartDate());
            task.setFinish(object2.getAnticipatedFinishDate());
            task.setText(1, object2.getCode());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType wBSType : list) {
            Task task = this.m_projectFile.getTaskByUniqueID(wBSType.getObjectId());
            comparable = this.m_projectFile.getTaskByUniqueID(wBSType.getParentObjectId());
            if (comparable == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            ((Task)comparable).getChildTasks().add(task);
        }
        int n = 1;
        this.m_clashMap.clear();
        for (ActivityType activityType : list2) {
            Comparable<Integer> comparable2;
            comparable = activityType.getObjectId();
            if (hashSet.contains(comparable)) {
                while (hashSet.contains(n)) {
                    ++n;
                }
                comparable2 = n;
                this.m_clashMap.put((Integer)comparable, (Integer)comparable2);
                comparable = comparable2;
            }
            hashSet.add(comparable);
            Integer n2 = activityType.getWBSObjectId();
            Task task = this.m_projectFile.getTaskByUniqueID(n2);
            comparable2 = task == null ? this.m_projectFile.addTask() : task.addTask();
            ((Task)comparable2).setUniqueID((Integer)comparable);
            ((Task)comparable2).setGUID(DatatypeConverter.parseUUID(activityType.getGUID()));
            ((Task)comparable2).setPercentageComplete(this.reversePercentage(activityType.getPercentComplete()));
            ((Task)comparable2).setName(activityType.getName());
            ((Task)comparable2).setRemainingDuration(this.getDuration(activityType.getRemainingDuration()));
            ((Task)comparable2).setActualWork(this.getDuration(this.zeroIsNull(activityType.getActualDuration())));
            ((Task)comparable2).setRemainingWork(this.getDuration(activityType.getRemainingTotalUnits()));
            ((Task)comparable2).setBaselineDuration(this.getDuration(activityType.getPlannedDuration()));
            ((Task)comparable2).setActualDuration(this.getDuration(activityType.getActualDuration()));
            ((Task)comparable2).setDuration(this.getDuration(activityType.getAtCompletionDuration()));
            ((Task)comparable2).setActualCost(NumberHelper.DOUBLE_ZERO);
            ((Task)comparable2).setRemainingCost(NumberHelper.DOUBLE_ZERO);
            ((Task)comparable2).setBaselineCost(NumberHelper.DOUBLE_ZERO);
            ((Task)comparable2).setConstraintDate(activityType.getPrimaryConstraintDate());
            ((Task)comparable2).setConstraintType(CONSTRAINT_TYPE_MAP.get(activityType.getPrimaryConstraintType()));
            ((Task)comparable2).setActualStart(activityType.getActualStartDate());
            ((Task)comparable2).setActualFinish(activityType.getActualFinishDate());
            ((Task)comparable2).setLateStart(activityType.getRemainingLateStartDate());
            ((Task)comparable2).setLateFinish(activityType.getRemainingLateFinishDate());
            ((Task)comparable2).setEarlyStart(activityType.getRemainingEarlyStartDate());
            ((Task)comparable2).setEarlyFinish(activityType.getRemainingEarlyFinishDate());
            ((Task)comparable2).setBaselineStart(activityType.getPlannedStartDate());
            ((Task)comparable2).setBaselineFinish(activityType.getPlannedFinishDate());
            ((Task)comparable2).setPriority(PRIORITY_MAP.get(activityType.getLevelingPriority()));
            ((Task)comparable2).setCreateDate(activityType.getCreateDate());
            ((Task)comparable2).setText(1, activityType.getId());
            ((Task)comparable2).setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(activityType.getType())));
            ((Task)comparable2).setCritical(((Task)comparable2).getEarlyStart() != null && ((Task)comparable2).getLateStart() != null && ((Task)comparable2).getLateStart().compareTo(((Task)comparable2).getEarlyStart()) <= 0);
            Integer n3 = activityType.getCalendarObjectId();
            ProjectCalendar projectCalendar = this.m_calMap.get(n3);
            ((Task)comparable2).setCalendar(projectCalendar);
            ((Task)comparable2).setStart(activityType.getStartDate());
            ((Task)comparable2).setFinish(activityType.getFinishDate());
            this.populateField((FieldContainer)((Object)comparable2), TaskField.START, TaskField.START, TaskField.ACTUAL_START, TaskField.BASELINE_START);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.FINISH, TaskField.FINISH, TaskField.ACTUAL_FINISH);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.WORK, TaskField.ACTUAL_WORK, TaskField.BASELINE_WORK);
            if (((Task)comparable2).getFinish() == null) {
                Duration duration = ((Task)comparable2).getRemainingDuration();
                if (duration != null && duration.getDuration() == 0.0) {
                    duration = null;
                }
                if (((Task)comparable2).getActualStart() == null || duration == null) {
                    ((Task)comparable2).setFinish(((Task)comparable2).getBaselineFinish());
                } else {
                    Date date;
                    ProjectCalendar projectCalendar2 = ((Task)comparable2).getEffectiveCalendar();
                    Date date2 = projectCalendar2.getDate(((Task)comparable2).getBaselineStart(), duration, false);
                    if (DateHelper.compare(date2, date = projectCalendar2.getNextWorkStart(date2)) == 0) {
                        date2 = projectCalendar2.getPreviousWorkFinish(date2);
                    }
                    ((Task)comparable2).setFinish(date2);
                }
            }
            this.readUDFTypes((ProjectEntityWithUniqueID)((Object)comparable2), activityType.getUDF());
            this.m_eventManager.fireTaskReadEvent((Task)comparable2);
        }
        this.sortActivities(TaskField.TEXT1, this.m_projectFile);
        this.updateStructure();
        this.updateDates();
    }

    private void sortActivities(final FieldType fieldType, ChildTaskContainer childTaskContainer) {
        List<Task> list = childTaskContainer.getChildTasks();
        if (!list.isEmpty()) {
            for (Task task : list) {
                this.sortActivities(fieldType, task);
                Collections.sort(list, new Comparator<Task>(){

                    @Override
                    public int compare(Task task, Task task2) {
                        boolean bl;
                        boolean bl2 = !task.getChildTasks().isEmpty();
                        boolean bl3 = bl = !task2.getChildTasks().isEmpty();
                        if (bl2 && bl) {
                            return task.getID().compareTo(task2.getID());
                        }
                        if (!bl2 && !bl) {
                            String string = (String)task.getCurrentValue(fieldType);
                            String string2 = (String)task2.getCurrentValue(fieldType);
                            if (string == null || string2 == null) {
                                return string == null && string2 == null ? 0 : (string == null ? 1 : -1);
                            }
                            return string.compareTo(string2);
                        }
                        return bl2 ? 1 : -1;
                    }
                });
            }
        }
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateDates(Task task) {
        if (task.getSummary()) {
            void var12_17;
            int n = 0;
            Date date = task.getActualStart();
            Date date2 = task.getActualFinish();
            Date date3 = task.getEarlyStart();
            Date date4 = task.getEarlyFinish();
            Date date5 = task.getLateStart();
            Date date6 = task.getLateFinish();
            Date date7 = task.getBaselineStart();
            Date date8 = task.getBaselineFinish();
            for (Task comparable2 : task.getChildTasks()) {
                this.updateDates(comparable2);
                date = DateHelper.min(date, comparable2.getActualStart());
                date2 = DateHelper.max(date2, comparable2.getActualFinish());
                date3 = DateHelper.min(date3, comparable2.getEarlyStart());
                date4 = DateHelper.max(date4, comparable2.getEarlyFinish());
                date5 = DateHelper.min(date5, comparable2.getLateStart());
                date6 = DateHelper.max(date6, comparable2.getLateFinish());
                date7 = DateHelper.min(date7, comparable2.getBaselineStart());
                date8 = DateHelper.max(date8, comparable2.getBaselineFinish());
                if (comparable2.getActualFinish() == null) continue;
                ++n;
            }
            task.setActualStart(date);
            task.setEarlyStart(date3);
            task.setEarlyFinish(date4);
            task.setLateStart(date5);
            task.setLateFinish(date6);
            task.setBaselineStart(date7);
            task.setBaselineFinish(date8);
            if (n == task.getChildTasks().size()) {
                task.setActualFinish(date2);
            }
            Object object = null;
            if (date7 != null && date8 != null) {
                object = this.m_projectFile.getDefaultCalendar().getWork(date7, date8, TimeUnit.HOURS);
                task.setBaselineDuration((Duration)object);
            }
            Object var12_13 = null;
            if (task.getActualFinish() == null) {
                Date date9;
                Date date10 = task.getEarlyStart();
                if (date10 == null) {
                    date10 = date7;
                }
                if ((date9 = task.getEarlyFinish()) == null) {
                    date9 = date8;
                }
                if (date10 != null && date9 != null) {
                    Duration duration = this.m_projectFile.getDefaultCalendar().getWork(date10, date9, TimeUnit.HOURS);
                }
            } else {
                Duration duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            task.setRemainingDuration((Duration)var12_17);
            if (object != null && var12_17 != null && ((Duration)object).getDuration() != 0.0) {
                double d = (((Duration)object).getDuration() - var12_17.getDuration()) / ((Duration)object).getDuration() * 100.0;
                task.setPercentageComplete(d);
            }
        }
    }

    private void populateField(FieldContainer fieldContainer, FieldType fieldType, FieldType ... fieldTypeArray) {
        for (FieldType fieldType2 : fieldTypeArray) {
            Object object = fieldContainer.getCachedValue(fieldType2);
            if (object == null) continue;
            fieldContainer.set(fieldType, object);
            break;
        }
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        task.setSummary(task.getChildTasks().size() != 0);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    private void processPredecessors(ProjectType projectType) {
        for (RelationshipType relationshipType : projectType.getRelationship()) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(relationshipType.getSuccessorActivityObjectId()));
            Task task2 = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(relationshipType.getPredecessorActivityObjectId()));
            if (task == null || task2 == null) continue;
            RelationType relationType = RELATION_TYPE_MAP.get(relationshipType.getType());
            Duration duration = this.getDuration(relationshipType.getLag());
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void processAssignments(ProjectType projectType) {
        List<ResourceAssignmentType> list = projectType.getResourceAssignment();
        for (ResourceAssignmentType resourceAssignmentType : list) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(resourceAssignmentType.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(resourceAssignmentType.getResourceObjectId());
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUniqueID(resourceAssignmentType.getObjectId());
            resourceAssignment.setRemainingWork(this.getDuration(resourceAssignmentType.getRemainingUnits()));
            resourceAssignment.setBaselineWork(this.getDuration(resourceAssignmentType.getPlannedUnits()));
            resourceAssignment.setActualWork(this.getDuration(resourceAssignmentType.getActualUnits()));
            resourceAssignment.setRemainingCost(resourceAssignmentType.getRemainingCost());
            resourceAssignment.setBaselineCost(resourceAssignmentType.getPlannedCost());
            resourceAssignment.setActualCost(resourceAssignmentType.getActualCost());
            resourceAssignment.setActualStart(resourceAssignmentType.getActualStartDate());
            resourceAssignment.setActualFinish(resourceAssignmentType.getActualFinishDate());
            resourceAssignment.setBaselineStart(resourceAssignmentType.getPlannedStartDate());
            resourceAssignment.setBaselineFinish(resourceAssignmentType.getPlannedFinishDate());
            resourceAssignment.setGUID(DatatypeConverter.parseUUID(resourceAssignmentType.getGUID()));
            task.setActualCost(NumberHelper.getDouble(task.getActualCost()) + NumberHelper.getDouble(resourceAssignment.getActualCost()));
            task.setRemainingCost(NumberHelper.getDouble(task.getRemainingCost()) + NumberHelper.getDouble(resourceAssignment.getRemainingCost()));
            task.setBaselineCost(NumberHelper.getDouble(task.getBaselineCost()) + NumberHelper.getDouble(resourceAssignment.getBaselineCost()));
            this.populateField(resourceAssignment, AssignmentField.WORK, AssignmentField.ACTUAL_WORK, AssignmentField.BASELINE_WORK);
            this.populateField(resourceAssignment, AssignmentField.COST, AssignmentField.ACTUAL_COST, AssignmentField.BASELINE_COST);
            this.populateField(resourceAssignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.BASELINE_START);
            this.populateField(resourceAssignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.BASELINE_FINISH);
            this.readUDFTypes(resourceAssignment, resourceAssignmentType.getUDF());
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private Double zeroIsNull(Double d) {
        if (d != null && d == 0.0) {
            d = null;
        }
        return d;
    }

    private Duration getDuration(Double d) {
        Duration duration = null;
        if (d != null) {
            duration = Duration.getInstance(NumberHelper.getDouble(d), TimeUnit.HOURS);
        }
        return duration;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() + 60000L);
    }

    private Number reversePercentage(Double d) {
        return d == null ? null : NumberHelper.getDouble(d * 100.0);
    }

    private void readUDFTypes(ProjectEntityWithUniqueID projectEntityWithUniqueID, List<UDFAssignmentType> list) {
        CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
        for (UDFAssignmentType uDFAssignmentType : list) {
            customFieldContainer.registerAliasValue((String)customFieldContainer.getCustomFieldValueItemByUniqueID(uDFAssignmentType.getTypeObjectId()).getValue(), projectEntityWithUniqueID.getUniqueID(), uDFAssignmentType);
        }
    }

    private Integer mapTaskID(Integer n) {
        Integer n2 = this.m_clashMap.get(n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.primavera.schema", PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.MATERIAL);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("Task Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Resource Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Level of Effort", Boolean.FALSE);
        MILESTONE_MAP.put("Start Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("Finish Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("WBS Summary", Boolean.FALSE);
    }
}

