<?php

declare(strict_types=1);

/*
 * Copyright (c) 2023-2024 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace fkooman\Radius;

class ServerInfo
{
    private const DEFAULT_MAX_TRIES = 3;
    private const DEFAULT_CONNECTION_TIMEOUT = 3;
    private string $serverUri;
    private string $sharedSecret;
    private int $maxTries;
    private int $connectionTimeout;

    public function __construct(string $serverUri, string $sharedSecret, int $maxTries = self::DEFAULT_MAX_TRIES, int $connectionTimeout = self::DEFAULT_CONNECTION_TIMEOUT)
    {
        $this->serverUri = $serverUri;
        $this->sharedSecret = Utils::requireLengthRange($sharedSecret, 1, null);
        $this->maxTries = Utils::requireRange($maxTries, 1, null);
        $this->connectionTimeout = Utils::requireRange($connectionTimeout, 1, null);
    }

    public function serverUri(): string
    {
        return $this->serverUri;
    }

    public function sharedSecret(): string
    {
        return $this->sharedSecret;
    }

    public function maxTries(): int
    {
        return $this->maxTries;
    }

    public function connectionTimeout(): int
    {
        return $this->connectionTimeout;
    }
}
