<?php
/**
 * Dialect
 *
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Model;

use \ArrayAccess;
use \InfluxDB2\ObjectSerializer;

/**
 * Dialect Class Doc Comment
 *
 * @category Class
 * @description Options for tabular data output. Default output is [annotated CSV](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/annotated-csv/#csv-response-format) with headers.  For more information about tabular data **dialect**, see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-metadata-20151217/#dialect-descriptions).
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Dialect implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Dialect';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'header' => 'bool',
        'delimiter' => 'string',
        'annotations' => 'string[]',
        'comment_prefix' => 'string',
        'date_time_format' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'header' => null,
        'delimiter' => null,
        'annotations' => null,
        'comment_prefix' => null,
        'date_time_format' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'header' => 'header',
        'delimiter' => 'delimiter',
        'annotations' => 'annotations',
        'comment_prefix' => 'commentPrefix',
        'date_time_format' => 'dateTimeFormat'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'header' => 'setHeader',
        'delimiter' => 'setDelimiter',
        'annotations' => 'setAnnotations',
        'comment_prefix' => 'setCommentPrefix',
        'date_time_format' => 'setDateTimeFormat'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'header' => 'getHeader',
        'delimiter' => 'getDelimiter',
        'annotations' => 'getAnnotations',
        'comment_prefix' => 'getCommentPrefix',
        'date_time_format' => 'getDateTimeFormat'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const ANNOTATIONS_GROUP = 'group';
    const ANNOTATIONS_DATATYPE = 'datatype';
    const ANNOTATIONS__DEFAULT = 'default';
    const DATE_TIME_FORMAT_RFC3339 = 'RFC3339';
    const DATE_TIME_FORMAT_RFC3339_NANO = 'RFC3339Nano';



    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAnnotationsAllowableValues()
    {
        return [
            self::ANNOTATIONS_GROUP,
            self::ANNOTATIONS_DATATYPE,
            self::ANNOTATIONS__DEFAULT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDateTimeFormatAllowableValues()
    {
        return [
            self::DATE_TIME_FORMAT_RFC3339,
            self::DATE_TIME_FORMAT_RFC3339_NANO,
        ];
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->container['header'] = isset($data['header']) ? $data['header'] : true;
        $this->container['delimiter'] = isset($data['delimiter']) ? $data['delimiter'] : ',';
        $this->container['annotations'] = isset($data['annotations']) ? $data['annotations'] : null;
        $this->container['comment_prefix'] = isset($data['comment_prefix']) ? $data['comment_prefix'] : '#';
        $this->container['date_time_format'] = isset($data['date_time_format']) ? $data['date_time_format'] : 'RFC3339';
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['delimiter']) && (mb_strlen($this->container['delimiter']) > 1)) {
            $invalidProperties[] = "invalid value for 'delimiter', the character length must be smaller than or equal to 1.";
        }

        if (!is_null($this->container['delimiter']) && (mb_strlen($this->container['delimiter']) < 1)) {
            $invalidProperties[] = "invalid value for 'delimiter', the character length must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['comment_prefix']) && (mb_strlen($this->container['comment_prefix']) > 1)) {
            $invalidProperties[] = "invalid value for 'comment_prefix', the character length must be smaller than or equal to 1.";
        }

        if (!is_null($this->container['comment_prefix']) && (mb_strlen($this->container['comment_prefix']) < 0)) {
            $invalidProperties[] = "invalid value for 'comment_prefix', the character length must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getDateTimeFormatAllowableValues();
        if (!is_null($this->container['date_time_format']) && !in_array($this->container['date_time_format'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'date_time_format', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets header
     *
     * @return bool|null
     */
    public function getHeader()
    {
        return $this->container['header'];
    }

    /**
     * Sets header
     *
     * @param bool|null $header If true, the results contain a header row.
     *
     * @return $this
     */
    public function setHeader($header)
    {
        $this->container['header'] = $header;

        return $this;
    }

    /**
     * Gets delimiter
     *
     * @return string|null
     */
    public function getDelimiter()
    {
        return $this->container['delimiter'];
    }

    /**
     * Sets delimiter
     *
     * @param string|null $delimiter The separator used between cells. Default is a comma (`,`).
     *
     * @return $this
     */
    public function setDelimiter($delimiter)
    {
        if (!is_null($delimiter) && (mb_strlen($delimiter) > 1)) {
            throw new \InvalidArgumentException('invalid length for $delimiter when calling Dialect., must be smaller than or equal to 1.');
        }
        if (!is_null($delimiter) && (mb_strlen($delimiter) < 1)) {
            throw new \InvalidArgumentException('invalid length for $delimiter when calling Dialect., must be bigger than or equal to 1.');
        }

        $this->container['delimiter'] = $delimiter;

        return $this;
    }

    /**
     * Gets annotations
     *
     * @return string[]|null
     */
    public function getAnnotations()
    {
        return $this->container['annotations'];
    }

    /**
     * Sets annotations
     *
     * @param string[]|null $annotations Annotation rows to include in the results. An _annotation_ is metadata associated with an object (column) in the data model.  #### Related guides  - See [Annotated CSV annotations](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/annotated-csv/#annotations) for examples and more information.  For more information about **annotations** in tabular data, see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-data-model-20151217/#columns).
     *
     * @return $this
     */
    public function setAnnotations($annotations)
    {
        $allowedValues = $this->getAnnotationsAllowableValues();
        if (!is_null($annotations) && array_diff($annotations, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'annotations', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['annotations'] = $annotations;

        return $this;
    }

    /**
     * Gets comment_prefix
     *
     * @return string|null
     */
    public function getCommentPrefix()
    {
        return $this->container['comment_prefix'];
    }

    /**
     * Sets comment_prefix
     *
     * @param string|null $comment_prefix The character prefixed to comment strings. Default is a number sign (`#`).
     *
     * @return $this
     */
    public function setCommentPrefix($comment_prefix)
    {
        if (!is_null($comment_prefix) && (mb_strlen($comment_prefix) > 1)) {
            throw new \InvalidArgumentException('invalid length for $comment_prefix when calling Dialect., must be smaller than or equal to 1.');
        }
        if (!is_null($comment_prefix) && (mb_strlen($comment_prefix) < 0)) {
            throw new \InvalidArgumentException('invalid length for $comment_prefix when calling Dialect., must be bigger than or equal to 0.');
        }

        $this->container['comment_prefix'] = $comment_prefix;

        return $this;
    }

    /**
     * Gets date_time_format
     *
     * @return string|null
     */
    public function getDateTimeFormat()
    {
        return $this->container['date_time_format'];
    }

    /**
     * Sets date_time_format
     *
     * @param string|null $date_time_format The format for timestamps in results. Default is [`RFC3339` date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp). To include nanoseconds in timestamps, use `RFC3339Nano`.  #### Example formatted date/time values  | Format      | Value                       | |:------------|:----------------------------| | `RFC3339`    | `"2006-01-02T15:04:05Z07:00"` | | `RFC3339Nano` | `"2006-01-02T15:04:05.999999999Z07:00"` |
     *
     * @return $this
     */
    public function setDateTimeFormat($date_time_format)
    {
        $allowedValues = $this->getDateTimeFormatAllowableValues();
        if (!is_null($date_time_format) && !in_array($date_time_format, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'date_time_format', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['date_time_format'] = $date_time_format;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


