/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.GroupItemStateChangedEvent;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.items.events.ItemStateUpdatedEvent;
import org.openhab.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GroupStateTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    public static final String UPDATE_MODULE_TYPE_ID = "core.GroupStateUpdateTrigger";
    public static final String CHANGE_MODULE_TYPE_ID = "core.GroupStateChangeTrigger";
    public static final String CFG_GROUPNAME = "groupName";
    public static final String CFG_STATE = "state";
    public static final String CFG_PREVIOUS_STATE = "previousState";
    private final Logger logger = LoggerFactory.getLogger(GroupStateTriggerHandler.class);
    private final String groupName;
    private final @Nullable String state;
    private final String previousState;
    private final String ruleUID;
    private final Set<String> types;
    private final ItemRegistry itemRegistry;
    private final ServiceRegistration<?> eventSubscriberRegistration;

    public GroupStateTriggerHandler(Trigger module, String ruleUID, BundleContext bundleContext, ItemRegistry itemRegistry) {
        super(module);
        this.groupName = (String)ConfigParser.valueAsOrElse((Object)module.getConfiguration().get(CFG_GROUPNAME), String.class, (Object)"");
        if (this.groupName.isBlank()) {
            this.logger.warn("GroupStateTrigger {} of rule {} has no groupName configured and will not work.", (Object)module.getId(), (Object)ruleUID);
        }
        this.state = (String)module.getConfiguration().get(CFG_STATE);
        this.previousState = (String)module.getConfiguration().get(CFG_PREVIOUS_STATE);
        this.types = UPDATE_MODULE_TYPE_ID.equals(module.getTypeUID()) ? Set.of(ItemStateUpdatedEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE) : Set.of(ItemStateChangedEvent.TYPE, GroupItemStateChangedEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE);
        this.ruleUID = ruleUID;
        this.itemRegistry = itemRegistry;
        this.eventSubscriberRegistration = bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        if (itemRegistry.get((Object)this.groupName) == null) {
            this.logger.warn("Group '{}' needed for rule '{}' is missing. Trigger '{}' will not work.", new Object[]{this.groupName, ruleUID, module.getId()});
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void receive(Event event) {
        void iscEvent;
        Event event2;
        void cb;
        ModuleHandlerCallback moduleHandlerCallback;
        Event event3 = event;
        if (event3 instanceof ItemAddedEvent) {
            void addedEvent;
            ItemAddedEvent itemAddedEvent = (ItemAddedEvent)event3;
            ItemAddedEvent cfr_ignored_0 = (ItemAddedEvent)event3;
            if (this.groupName.equals(addedEvent.getItem().name)) {
                this.logger.info("Group '{}' needed for rule '{}' added. Trigger '{}' will now work.", new Object[]{this.groupName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        } else {
            Event event4 = event;
            if (event4 instanceof ItemRemovedEvent) {
                void removedEvent;
                ItemRemovedEvent itemRemovedEvent = (ItemRemovedEvent)event4;
                ItemRemovedEvent cfr_ignored_1 = (ItemRemovedEvent)event4;
                if (this.groupName.equals(removedEvent.getItem().name)) {
                    this.logger.warn("Group '{}' needed for rule '{}' removed. Trigger '{}' will no longer work.", new Object[]{this.groupName, this.ruleUID, ((Trigger)this.module).getId()});
                    return;
                }
            }
        }
        if (!((moduleHandlerCallback = this.callback) instanceof TriggerHandlerCallback)) return;
        TriggerHandlerCallback triggerHandlerCallback = (TriggerHandlerCallback)moduleHandlerCallback;
        TriggerHandlerCallback cfr_ignored_2 = (TriggerHandlerCallback)moduleHandlerCallback;
        this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
        Event event5 = event;
        if (event5 instanceof ItemStateUpdatedEvent) {
            ItemStateUpdatedEvent itemStateUpdatedEvent = (ItemStateUpdatedEvent)event5;
            ItemStateUpdatedEvent cfr_ignored_3 = (ItemStateUpdatedEvent)event5;
            if (UPDATE_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) {
                void isEvent;
                String itemName = isEvent.getItemName();
                Item item = (Item)this.itemRegistry.get((Object)itemName);
                Item group = (Item)this.itemRegistry.get((Object)this.groupName);
                if (item == null) return;
                if (!item.getGroupNames().contains(this.groupName)) return;
                State state = isEvent.getItemState();
                if (this.state != null) {
                    if (!state.toFullString().equals(this.state)) return;
                }
                HashMap<String, Object> values = new HashMap<String, Object>();
                if (group != null) {
                    values.put("triggeringGroup", group);
                }
                values.put("triggeringItem", item);
                values.put(CFG_STATE, state);
                values.put("event", event);
                cb.triggered((Trigger)this.module, values);
                return;
            }
        }
        if (!((event2 = event) instanceof ItemStateChangedEvent)) return;
        ItemStateChangedEvent itemName = (ItemStateChangedEvent)event2;
        ItemStateChangedEvent cfr_ignored_4 = (ItemStateChangedEvent)event2;
        if (!CHANGE_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) return;
        String itemName2 = iscEvent.getItemName();
        Item item = (Item)this.itemRegistry.get((Object)itemName2);
        Item group = (Item)this.itemRegistry.get((Object)this.groupName);
        if (item == null) return;
        if (!item.getGroupNames().contains(this.groupName)) return;
        State state = iscEvent.getItemState();
        State oldState = iscEvent.getOldItemState();
        if (!this.stateMatches(this.state, state)) return;
        if (!this.stateMatches(this.previousState, oldState)) return;
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (group != null) {
            values.put("triggeringGroup", group);
        }
        values.put("triggeringItem", item);
        values.put("oldState", oldState);
        values.put("newState", state);
        values.put("event", event);
        cb.triggered((Trigger)this.module, values);
    }

    private boolean stateMatches(@Nullable String requiredState, State state) {
        if (requiredState == null) {
            return true;
        }
        String reqState = requiredState.trim();
        return reqState.isEmpty() || reqState.equals(state.toFullString());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventSubscriberRegistration.unregister();
    }
}

