/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.events.annotated.AbstractMethodAnnotationScanner;
import org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.eclipse.jetty.websocket.common.util.ReflectUtils;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdBinary;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdOnClose;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdOnError;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdOnOpen;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdPong;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdText;
import org.eclipse.jetty.websocket.jsr356.annotations.OnCloseCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnErrorCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageBinaryCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageBinaryStreamCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessagePongCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageTextCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageTextStreamCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnOpenCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.Param;

public class AnnotatedEndpointScanner<T extends Annotation, C extends EndpointConfig>
extends AbstractMethodAnnotationScanner<AnnotatedEndpointMetadata<T, C>> {
    private static final Logger LOG = Log.getLogger(AnnotatedEndpointScanner.class);
    private final LinkedList<IJsrParamId> paramsOnOpen;
    private final LinkedList<IJsrParamId> paramsOnClose;
    private final LinkedList<IJsrParamId> paramsOnError;
    private final LinkedList<IJsrParamId> paramsOnMessage;
    private final AnnotatedEndpointMetadata<T, C> metadata;

    public AnnotatedEndpointScanner(AnnotatedEndpointMetadata<T, C> metadata) {
        this.metadata = metadata;
        this.paramsOnOpen = new LinkedList();
        this.paramsOnClose = new LinkedList();
        this.paramsOnError = new LinkedList();
        this.paramsOnMessage = new LinkedList();
        metadata.customizeParamsOnOpen(this.paramsOnOpen);
        this.paramsOnOpen.add(JsrParamIdOnOpen.INSTANCE);
        metadata.customizeParamsOnClose(this.paramsOnClose);
        this.paramsOnClose.add(JsrParamIdOnClose.INSTANCE);
        metadata.customizeParamsOnError(this.paramsOnError);
        this.paramsOnError.add(JsrParamIdOnError.INSTANCE);
        metadata.customizeParamsOnMessage(this.paramsOnMessage);
        this.paramsOnMessage.add(JsrParamIdText.INSTANCE);
        this.paramsOnMessage.add(JsrParamIdBinary.INSTANCE);
        this.paramsOnMessage.add(JsrParamIdPong.INSTANCE);
    }

    private void assertNotDuplicate(JsrCallable callable, Class<? extends Annotation> methodAnnotationClass, Class<?> pojo, Method method) {
        if (callable != null) {
            StringBuilder err = new StringBuilder();
            err.append("Encountered duplicate method annotations @");
            err.append(methodAnnotationClass.getSimpleName());
            err.append(" on ");
            err.append(ReflectUtils.toString(pojo, (Method)callable.getMethod()));
            err.append(" and ");
            err.append(ReflectUtils.toString(pojo, (Method)method));
            throw new InvalidSignatureException(err.toString());
        }
    }

    public void onMethodAnnotation(AnnotatedEndpointMetadata<T, C> metadata, Class<?> pojo, Method method, Annotation annotation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onMethodAnnotation({}, {}, {}, {})", new Object[]{metadata, pojo, method, annotation});
        }
        if (this.isAnnotation(annotation, OnOpen.class)) {
            this.assertIsPublicNonStatic(method);
            this.assertIsReturn(method, Void.TYPE);
            this.assertNotDuplicate(metadata.onOpen, OnOpen.class, pojo, method);
            OnOpenCallable onopen = new OnOpenCallable(pojo, method);
            this.visitMethod(onopen, pojo, method, this.paramsOnOpen, OnOpen.class);
            metadata.onOpen = onopen;
            return;
        }
        if (this.isAnnotation(annotation, OnClose.class)) {
            this.assertIsPublicNonStatic(method);
            this.assertIsReturn(method, Void.TYPE);
            this.assertNotDuplicate(metadata.onClose, OnClose.class, pojo, method);
            OnCloseCallable onclose = new OnCloseCallable(pojo, method);
            this.visitMethod(onclose, pojo, method, this.paramsOnClose, OnClose.class);
            metadata.onClose = onclose;
            return;
        }
        if (this.isAnnotation(annotation, OnError.class)) {
            this.assertIsPublicNonStatic(method);
            this.assertIsReturn(method, Void.TYPE);
            this.assertNotDuplicate(metadata.onError, OnError.class, pojo, method);
            OnErrorCallable onerror = new OnErrorCallable(pojo, method);
            this.visitMethod(onerror, pojo, method, this.paramsOnError, OnError.class);
            metadata.onError = onerror;
            return;
        }
        if (this.isAnnotation(annotation, OnMessage.class)) {
            this.assertIsPublicNonStatic(method);
            OnMessageCallable onmessage = new OnMessageCallable(pojo, method);
            this.visitMethod(onmessage, pojo, method, this.paramsOnMessage, OnMessage.class);
            OnMessage messageAnno = (OnMessage)annotation;
            Param param = onmessage.getMessageObjectParam();
            switch (param.role) {
                case MESSAGE_BINARY: {
                    metadata.onBinary = new OnMessageBinaryCallable(onmessage);
                    metadata.setMaxBinaryMessageSize(messageAnno.maxMessageSize());
                    break;
                }
                case MESSAGE_BINARY_STREAM: {
                    metadata.onBinaryStream = new OnMessageBinaryStreamCallable(onmessage);
                    metadata.setMaxBinaryMessageSize(messageAnno.maxMessageSize());
                    break;
                }
                case MESSAGE_TEXT: {
                    metadata.onText = new OnMessageTextCallable(onmessage);
                    metadata.setMaxTextMessageSize(messageAnno.maxMessageSize());
                    break;
                }
                case MESSAGE_TEXT_STREAM: {
                    metadata.onTextStream = new OnMessageTextStreamCallable(onmessage);
                    metadata.setMaxTextMessageSize(messageAnno.maxMessageSize());
                    break;
                }
                case MESSAGE_PONG: {
                    metadata.onPong = new OnMessagePongCallable(onmessage);
                    break;
                }
                default: {
                    StringBuilder err = new StringBuilder();
                    err.append("An unrecognized message type <");
                    err.append(param.type);
                    err.append(">: does not meet specified type categories of [TEXT, BINARY, DECODER, or PONG]");
                    throw new InvalidSignatureException(err.toString());
                }
            }
        }
    }

    public AnnotatedEndpointMetadata<T, C> scan() {
        this.scanMethodAnnotations(this.metadata, this.metadata.getEndpointClass());
        return this.metadata;
    }

    private void visitMethod(JsrCallable callable, Class<?> pojo, Method method, LinkedList<IJsrParamId> paramIds, Class<? extends Annotation> methodAnnotationClass) {
        for (Param param : callable.getParams()) {
            if (this.visitParam(callable, param, paramIds)) continue;
            StringBuilder err = new StringBuilder();
            err.append("Encountered unknown parameter type <");
            err.append(param.type.getName());
            err.append("> on @");
            err.append(methodAnnotationClass.getSimpleName());
            err.append(" annotated method: ");
            err.append(ReflectUtils.toString(pojo, (Method)method));
            throw new InvalidSignatureException(err.toString());
        }
    }

    private boolean visitParam(JsrCallable callable, Param param, List<IJsrParamId> paramIds) {
        for (IJsrParamId paramId : paramIds) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}.process()", new Object[]{paramId});
            }
            if (!paramId.process(param, callable)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Identified: {}", new Object[]{param});
            }
            return true;
        }
        return false;
    }
}

