/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.events.system;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.AbstractEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.openhab.core.events.system.StartlevelEvent;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
@NonNullByDefault
public class SystemEventFactory
extends AbstractEventFactory {
    static final String SYSTEM_STARTLEVEL_TOPIC = "openhab/system/startlevel";

    public SystemEventFactory() {
        super(Set.of(StartlevelEvent.TYPE));
    }

    public static StartlevelEvent createStartlevelEvent(Integer startlevel) {
        SystemEventPayloadBean bean = new SystemEventPayloadBean(startlevel);
        String payload = SystemEventFactory.serializePayload(bean);
        return new StartlevelEvent(SYSTEM_STARTLEVEL_TOPIC, payload, null, startlevel);
    }

    @Override
    protected Event createEventByType(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        return this.createStartlevelEvent(topic, payload, source);
    }

    public StartlevelEvent createStartlevelEvent(String topic, String payload, @Nullable String source) {
        SystemEventPayloadBean bean = SystemEventFactory.deserializePayload(payload, SystemEventPayloadBean.class);
        return new StartlevelEvent(topic, payload, source, bean.getStartlevel());
    }

    public static class SystemEventPayloadBean {
        @NonNullByDefault(value={})
        private Integer startlevel;

        protected SystemEventPayloadBean() {
        }

        public SystemEventPayloadBean(Integer startlevel) {
            this.startlevel = startlevel;
        }

        public Integer getStartlevel() {
            return this.startlevel;
        }
    }
}

