/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import javax.activation.DataHandler;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.impl.MetadataMap;

public class AttachmentBuilder {
    private MultivaluedMap<String, String> headers = new MetadataMap<String, String>(false, true);
    private Object object;
    private DataHandler dataHandler;
    private ContentDisposition contentDisposition;

    public AttachmentBuilder id(String id) {
        this.headers.putSingle((Object)"Content-Id", (Object)id);
        return this;
    }

    public AttachmentBuilder mediaType(String mediaType) {
        this.headers.putSingle((Object)"Content-Type", (Object)mediaType);
        return this;
    }

    public AttachmentBuilder object(Object theObject) {
        this.object = theObject;
        return this;
    }

    public AttachmentBuilder dataHandler(DataHandler newDataHandler) {
        this.dataHandler = newDataHandler;
        return this;
    }

    public AttachmentBuilder header(String key, String value) {
        this.headers.putSingle((Object)key, (Object)value);
        return this;
    }

    public AttachmentBuilder headers(MultivaluedMap<String, String> allHeaders) {
        this.headers = allHeaders;
        this.contentDisposition = null;
        return this;
    }

    public AttachmentBuilder contentDisposition(ContentDisposition newContentDisposition) {
        this.contentDisposition = newContentDisposition;
        return this;
    }

    public Attachment build() {
        if (this.contentDisposition != null) {
            this.headers.putSingle((Object)"Content-Disposition", (Object)this.contentDisposition.toString());
        }
        return new Attachment(this.headers, this.dataHandler, this.object);
    }
}

