/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.types.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.MetricPrefix;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.library.unit.UnitInitializer;
import org.openhab.core.library.unit.CurrencyUnits;
import org.openhab.core.library.unit.ImperialUnits;
import org.openhab.core.library.unit.SIUnits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

@NonNullByDefault
public class UnitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitUtils.class);
    public static final String UNIT_PLACEHOLDER = "%unit%";
    public static final String UNIT_PERCENT_FORMAT_STRING = "%%";
    private static final String JAVAX_MEASURE_QUANTITY_PREFIX = "javax.measure.quantity.";
    private static final String SI_DIMENSION_PREFIX = "si.uom.quantity.";
    private static final String FRAMEWORK_DIMENSION_PREFIX = "org.openhab.core.library.dimension.";
    private static final Collection<Class<? extends SystemOfUnits>> ALL_SYSTEM_OF_UNITS = List.of(SIUnits.class, ImperialUnits.class, org.openhab.core.library.unit.Units.class, Units.class, CurrencyUnits.class);

    static {
        UnitInitializer.init();
    }

    public static @Nullable Class<? extends Quantity<?>> parseDimension(@Nullable String dimension) {
        if (dimension == null || dimension.isBlank()) {
            return null;
        }
        try {
            return UnitUtils.dimensionClass(FRAMEWORK_DIMENSION_PREFIX, dimension);
        }
        catch (ClassNotFoundException e1) {
            try {
                return UnitUtils.dimensionClass(JAVAX_MEASURE_QUANTITY_PREFIX, dimension);
            }
            catch (ClassNotFoundException e2) {
                try {
                    return UnitUtils.dimensionClass(SI_DIMENSION_PREFIX, dimension);
                }
                catch (ClassNotFoundException e3) {
                    throw new IllegalArgumentException("Error creating a dimension Class instance for name '" + dimension + "'.");
                }
            }
        }
    }

    public static @Nullable String getDimensionName(Unit<?> unit) {
        String compatibleDimension = null;
        for (Class<? extends SystemOfUnits> system : ALL_SYSTEM_OF_UNITS) {
            Field[] fieldArray = system.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType().isAssignableFrom(Unit.class) && Modifier.isStatic(field.getModifiers())) {
                    Type genericType = field.getGenericType();
                    if (genericType instanceof ParameterizedType) {
                        ParameterizedType type = (ParameterizedType)genericType;
                        Type typeParam = type.getActualTypeArguments()[0];
                        if (!(typeParam instanceof WildcardType)) {
                            String dimension = ((Class)typeParam).getSimpleName();
                            try {
                                Unit systemUnit = (Unit)field.get(null);
                                if (systemUnit == null) {
                                    LOGGER.warn("Unit field points to a null value: {}", (Object)field);
                                } else {
                                    if (systemUnit.equals(unit)) {
                                        return dimension;
                                    }
                                    if (compatibleDimension == null && systemUnit.isCompatible(unit)) {
                                        compatibleDimension = dimension;
                                    }
                                }
                            }
                            catch (IllegalAccessException | IllegalArgumentException e) {
                                LOGGER.error("The unit field '{}' seems to be not accessible", (Object)field, (Object)e);
                            }
                        }
                    } else {
                        LOGGER.warn("There is a unit field defined which has no generic type parametrization: {}", (Object)field);
                    }
                }
                ++n2;
            }
        }
        return compatibleDimension == null ? null : compatibleDimension;
    }

    public static @Nullable Unit<?> parseUnit(@Nullable String pattern) {
        if (pattern == null || pattern.isBlank()) {
            return null;
        }
        String unitSymbol = pattern;
        int lastBlankIndex = pattern.lastIndexOf(" ");
        if (lastBlankIndex >= 0) {
            unitSymbol = pattern.substring(lastBlankIndex).trim();
        }
        if (!UNIT_PLACEHOLDER.equals(unitSymbol)) {
            if (UNIT_PERCENT_FORMAT_STRING.equals(unitSymbol)) {
                return org.openhab.core.library.unit.Units.PERCENT;
            }
            try {
                Quantity quantity = Quantities.getQuantity((CharSequence)("1 " + unitSymbol));
                return quantity.getUnit();
            }
            catch (IllegalArgumentException | MeasurementParseException e) {
                LOGGER.debug("Unknown unit from pattern: {}", (Object)unitSymbol);
            }
        }
        return null;
    }

    public static boolean isDifferentMeasurementSystem(Unit<? extends Quantity<?>> thisUnit, Unit<?> thatUnit) {
        boolean differentSystems;
        Set siUnits = SIUnits.getInstance().getUnits();
        Set usUnits = ImperialUnits.getInstance().getUnits();
        boolean bl = differentSystems = siUnits.contains(thisUnit) && usUnits.contains(thatUnit) || siUnits.contains(thatUnit) && usUnits.contains(thisUnit);
        if (!differentSystems) {
            TransformedUnit unit;
            TransformedUnit unit2;
            if (thisUnit instanceof TransformedUnit && UnitUtils.isMetricConversion((unit2 = (TransformedUnit)thisUnit).getConverter())) {
                return UnitUtils.isDifferentMeasurementSystem(unit2.getParentUnit(), thatUnit);
            }
            if (thatUnit instanceof TransformedUnit && UnitUtils.isMetricConversion((unit = (TransformedUnit)thatUnit).getConverter())) {
                return UnitUtils.isDifferentMeasurementSystem(thisUnit, unit.getParentUnit());
            }
        }
        if (!differentSystems) {
            Set siSymbols = siUnits.stream().map(Unit::getSymbol).collect(Collectors.toSet());
            Set usSymbols = usUnits.stream().map(Unit::getSymbol).collect(Collectors.toSet());
            differentSystems = siSymbols.contains(thisUnit.getSymbol()) && usSymbols.contains(thatUnit.getSymbol()) || siSymbols.contains(thatUnit.getSymbol()) && usSymbols.contains(thisUnit.getSymbol());
        }
        return differentSystems;
    }

    private static boolean isMetricConversion(UnitConverter converter) {
        MetricPrefix[] metricPrefixArray = MetricPrefix.values();
        int n = metricPrefixArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetricPrefix mp = metricPrefixArray[n2];
            if (MultiplyConverter.ofPrefix((Prefix)mp).equals(converter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Class<? extends Quantity<?>> dimensionClass(String prefix, String name) throws ClassNotFoundException {
        return Class.forName(prefix + name);
    }
}

